--
-- PostgreSQL database dump
--

-- Dumped from database version 12.17
-- Dumped by pg_dump version 16.1 (Debian 16.1-1.pgdg110+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: mdc_bus_stops; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdc_bus_stops (
    objectid integer NOT NULL,
    stopid integer,
    main_st character varying(24),
    cross_st character varying(23),
    direction character varying(2),
    stop_cornr character varying(1),
    accessible character varying(1),
    benches integer,
    shelters integer,
    trash_can integer,
    updte_date character varying(15),
    lat double precision,
    lon double precision,
    point_x double precision,
    point_y double precision,
    globalid character varying(38),
    geom public.geometry(Point,4326),
    geom_local public.geometry(Point,2236)
);


ALTER TABLE public.mdc_bus_stops OWNER TO postgres;

--
-- Name: mdc_bus_stops_objectid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdc_bus_stops_objectid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mdc_bus_stops_objectid_seq OWNER TO postgres;

--
-- Name: mdc_bus_stops_objectid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdc_bus_stops_objectid_seq OWNED BY public.mdc_bus_stops.objectid;


--
-- Name: mdc_bus_stops objectid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdc_bus_stops ALTER COLUMN objectid SET DEFAULT nextval('public.mdc_bus_stops_objectid_seq'::regclass);


--
-- Data for Name: mdc_bus_stops; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdc_bus_stops (objectid, stopid, main_st, cross_st, direction, stop_cornr, accessible, benches, shelters, trash_can, updte_date, lat, lon, point_x, point_y, globalid, geom, geom_local) FROM stdin;
252	10488	NW 186 St	73 Ave	E	N	\N	\N	\N	\N	 	25.94144	-80.32	879625.381817296	584985.671581022	03f18d84-d33d-4666-be90-f93af7226ea3	0101000020E610000016497AFD7A1454C0EF1C335302F13940	0101000020BC080000F76615F510D82A41964936C536DA2141
790	10391	NW 59 AV	NW 186 ST	\N	\N	\N	\N	\N	\N	 	25.93746	-80.29935	886420.591679074	583575.929645605	4f5a446a-6b97-45b5-9a3d-73fdbebd9976	0101000020E6100000E4934A98281354C0A80D33B0FDEF3940	0101000020BC080000EA2B8061270D2B4161F21B4933CF2141
836	9955	NW 83 ST	NW 1 AV	E	N	N	0	0	1	 	25.85103	-80.19915	919540.933864664	552348.651248842	57c81cb1-dabd-411a-928a-9155489d494f	0101000020E61000001C04ADFBBE0C54C0EE93C236DDD93940	0101000020BC08000001D20E15E80F2C41C7C09EB63CDB2041
1438	2810	ALTON RD	63 ST	S	F	N	0	0	0	8/30/2002	25.84299	-80.12825	942879.59721072	549575.106573485	6303faa2-a607-42be-a8d2-2ab648429f5c	0101000020E6100000A24DA84A350854C0F709B65ECED73940	0101000020BC0800001998B46B3DC62C41D88D689F91C52041
1634	10675	E 32 ST	E 3 AV	\N	\N	\N	\N	\N	\N	 	25.85148	-80.27587	894309.552579008	552366.161045857	7d29a766-a956-4259-b43e-3f4b781f5631	0101000020E6100000C353FFE5A71154C00CC940C5FAD93940	0101000020BC0800005C567D4EC94A2B41394284BB5FDB2041
1	2288	HIALEAH DR	E 7 AV	W	F	N	0	0	0	10/19/2016 14:1	25.82323	-80.26736	897165.209587567	542113.033901915	0fbc6b22-f8a6-45cb-95d2-6ad481242c95	0101000020E61000005CBEA67C1C1154C02691393FBFD23940	0101000020BC0800000113489F18612B41C2021779458B2041
2	2815	ALTON RD	56 ST	S	F	Y	0	0	0	8/30/2002	25.83481	-80.12942	942515.434509572	546601.89177388	3c2bf5a7-b2a3-4b4a-94d1-106c01c5361c	0101000020E6100000F7886969480854C06F1A7CBEB6D53940	0101000020BC08000086B2561865C32C41D04F173157AE2041
3	5684	W DIXIE HY	NE 195 ST	S	N	N	1	0	0	11/12/2002	25.95589	-80.14746	936296.501126174	590570.064967521	5ea64f4e-d291-4eb8-bef9-3c5bf47d5ac7	0101000020E6100000E3EC1BEE6F0954C0222EDF62B5F43940	0101000020BC08000045439539CF922C41BE25728FD7052241
4	10273	NW 82 AV	NW 56 ST	S	N	N	0	0	0	1/7/2006	25.82455	-80.32981	876618.485277712	542485.789427981	39eb1ab8-c95d-493b-9771-987424e2494b	0101000020E6100000B99198B71B1554C0EA0F943616D33940	0101000020BC080000D403CB2993C02A41F9A000FC2E8E2041
5	8499	HAMMOND DR	FLAGLER DR	S	N	N	1	0	0	11/8/2016 14:18	25.81573	-80.30145	885967.201510672	539327.872516841	23076d8f-e506-44d1-a1e2-02bc55a1eb98	0101000020E6100000DF008BEF4A1354C09287F50DD4D03940	0101000020BC080000EF3DD1999C092B41DA27282683752041
6	4024	SW 152 AV	SW 46 LN	S	F	N	0	0	0	10/13/2016 12:3	25.7217	-80.43909	840830.789795317	504934.015126102	1408274c-e264-4fb1-b4dc-8878096be06b	0101000020E61000009A55DE201A1C54C054E0C770C1B83940	0101000020BC080000907E34C1FBA8294193682DD59ED11E41
7	3007	US 1	SW 268 ST	NE	N	Y	0	0	0	10/4/2016 16:56	25.51739	-80.42844	844662.99898437	430694.119937539	c7f2ac6f-4b7d-4fc9-8a44-76e85a787e23	0101000020E61000005DB2315C6B1B54C07BA13EF973843940	0101000020BC080000000FE92CECC62941612B2B2D9F491A41
8	3078	SW 102 AV	SW 110 ST	SW	N	N	0	0	0	9/29/2016 13:14	25.66724	-80.35932	867188.898510348	485261.253595829	e3362b67-5f7a-46c3-b5e8-4952b1c3800c	0101000020E610000041E98535FF1654C01A5B809CD0AA3940	0101000020BC0800001E4350FCE7762A415C4E53C43B9E1D41
9	2084	PALM AV	W 23 ST	S	N	Y	1	0	0	9/22/2016 13:23	25.84309	-80.28222	892239.808393121	549304.508734375	cabeb63e-ebc1-47d3-ab39-1b4c3dab3584	0101000020E6100000DCE8AAD60F1254C0CC89D0CAD4D73940	0101000020BC080000EA4356D19D3A2B41B053146D74C32041
10	6357	NW 47 AV	NW 181 TE	N	F	Y	1	0	1	8/31/2016	25.93858	-80.27729	893668.128999721	584023.859572947	18821517-5ea9-4c63-bbac-888a93af64bd	0101000020E61000006BD5EB29BF1154C0A09ACA5947F03940	0101000020BC08000053698875C6452B41E7774625B3D22141
11	7809	NW 20 ST	NW 13 AV	W	F	Y	0	0	0	10/29/2002	25.795	-80.21776	913544.159486655	531948.872793905	6d844e98-4a59-4cab-b007-af03e9d79012	0101000020E6100000658F23C2EF0D54C08804C29F85CB3940	0101000020BC080000DEDFC5870EE12B41AA065125DD3B2041
12	10678	E 32 ST	E 2 AV	\N	\N	\N	\N	\N	\N	 	25.85125	-80.27804	893595.681636654	552279.72320684	a40bb1bc-da11-4de4-98c3-92dd7f5ff3bb	0101000020E6100000A834077CCB1154C079D8D2E4EBD93940	0101000020BC0800007D8B9C9035452B41F0D46CDBB2DA2041
13	5823	NW 82 AV	NW 186 ST	S	N	Y	1	0	0	10/27/2016 13:1	25.94271	-80.33442	874887.835196089	585425.859027192	1ac763ce-9941-47a3-9f70-fc65a7537f1a	0101000020E61000002AAC3711671554C05197791456F13940	0101000020BC08000041E5A8DC0DB32A41A41F1D25A7DD2141
14	7402	SW 27 AV	SHIPPING AV	S	N	N	0	0	0	11/16/2016 13:1	25.73388	-80.23764	907131.074532587	509694.495741069	14687e39-98e5-4e92-a553-765dec778335	0101000020E6100000CBA71C7D350F54C06338B8DDDFBB3940	0101000020BC0800008879865BF4AE2B414EC4BCC2001C1F41
15	6619	NW 215 ST	NW 27 AV	E	M	N	1	1	1	10/28/2016 13:5	25.97172	-80.24396	904552.715830378	596131.188387044	04eb2162-5212-4554-bbb0-fa8dad964b93	0101000020E6100000B564570D9D0F54C0D3E2E136C3F83940	0101000020BC0800002F0364A3CF9A2B412EDD31CF49312241
16	5634	NW 119 ST	NW 7 AV	W	F	N	1	0	1	9/30/2016 16:10	25.88383	-80.21145	915426.039223291	564248.569030143	4d32897e-e9da-4693-8e2f-140a912dc664	0101000020E6100000BB987868880D54C0DCB5034143E23940	0101000020BC08000061FC5A4AC2EF2B41EBB8168E34382141
17	9294	SW 56 ST	SW 67 AV	W	N	N	1	0	0	10/12/2016 10:5	25.7185	-80.30197	885981.334654149	503986.571147107	93084019-411d-49e2-a79b-927250526629	0101000020E610000046C5BC8D531354C0DE867DCAEFB73940	0101000020BC080000C3E010DEB8092B41D3D9510ED1C21E41
18	5963	NW 199 ST	NW 52 AV	W	F	N	1	1	0	12/2/2002	25.95383	-80.28694	890465.948733311	589548.307184458	b038b4d8-be03-425b-b9c7-4d014fc32e0f	0101000020E6100000F4915A4D5D1254C0CDA311942EF43940	0101000020BC0800000D73E118C22C2B4128A71F0BDCFD2141
19	4722	NW 7 AV	NW 91 ST	N	F	Y	1	1	1	9/21/2016 14:03	25.85834	-80.20943	916145.655553047	554987.695483595	56153908-dbbd-4c1c-9bcc-940bc3879f41	0101000020E610000003762954670D54C0D20FAABDBCDB3940	0101000020BC0800002C9A218661F52B41BC0E8FCDDAEF2041
20	8017	NW 5 ST	NW 6 AV	E	F	Y	1	1	1	9/6/2012 15:29	25.7786	-80.2036	918240.38008073	526013.774129018	11263f88-4d59-4e55-b718-187ce4de2520	0101000020E610000092C830B6070D54C0A42DAF7052C73940	0101000020BC080000149171F9BE052C4127AB07F27E0D2041
21	7483	NW 37 AV	NW 4 TE	S	F	Y	1	1	0	42619.54306	25.77668	-80.25573	901086.637437239	525216.321654707	859b33ce-6443-402c-9cad-7201f932a44d	0101000020E6100000774BE0F05D1054C03767F8BDD4C63940	0101000020BC0800000CD8E57ABB7F2B41A67F510A44072041
22	9308	SW 72 ST	SW 58 AV	W	N	Y	1	1	1	9/22/2016 14:50	25.70444	-80.28719	890875.160530504	498901.250599712	9e525c10-e2f7-4161-ba3a-5cf10e3d38eb	0101000020E61000008B80E865611254C02DBA712856B43940	0101000020BC08000092DA6E85F42F2B416C57D0C45B731E41
23	3186	SW 112 AV	SW 159 ST	N	F	N	1	0	1	11/17/2016 15:0	25.62174	-80.37409	862404.734205149	468702.023586608	18405791-e5b1-4b2f-ab2c-bd910245464c	0101000020E6100000415ADA11F11754C0C0704AEB2A9F3940	0101000020BC080000BC8DA0A787512A418AE94AD47E9B1C41
24	6406	NW 167 ST	NW 15 AV	E	F	N	1	1	1	10/17/2016 13:4	25.92668	-80.22475	910960.71218349	579796.541535996	31800f36-a08d-454f-bc91-ae21675ddf90	0101000020E610000066EEED54620E54C0C5EF55573BED3940	0101000020BC080000376E5CA2DFCC2B41FD2BF081ACB12141
25	5345	W FLAGLER ST	SW 92 AV	E	F	N	1	1	1	9/8/2012 12:24	25.76918	-80.34392	872077.621317696	522336.139104277	fe885c3b-f70b-43f0-96d1-1ce62b8422e4	0101000020E61000006FE60AE1021654C042A7C638E9C43940	0101000020BC0800002B45F26E199D2A41EFF9955887E11F41
26	6582	NW 203 TE	NW 43 AV	W	F	N	0	0	0	8/31/2016	25.95871	-80.27239	895238.124877404	591348.724832259	96d2070d-8a10-468e-8317-a0ed01dab570	0101000020E6100000C26CA2DD6E1154C0E4EEAF756EF53940	0101000020BC080000BB6E89730A522B41E3394AE1EC0B2241
27	4632	SW 56 ST	SW 72 AV	W	N	N	2	0	0	10/12/2016 11:1	25.71816	-80.31015	883289.750460401	503848.844709374	c1571730-ef46-4796-9b0b-6ebc029c58c6	0101000020E6100000DDC99286D91354C07F683A82D9B73940	0101000020BC08000040A17CB2B1F42A41D78C8226AAC01E41
28	2584	E LUCY ST	#451	W	N	N	0	0	0	10/21/2016 13:3	25.46251	-80.47212	830331.240604814	410688.974268831	c43d6aa3-bfe8-4d32-8328-37147ad1f432	0101000020E6100000E7DBBD4A371E54C0BC6F5B5B67763940	0101000020BC0800000BA1CDA6F4562941AF1783920A111941
29	4105	SW 34 ST	SW 123 CT	W	N	Y	1	0	1	10/13/2016 14:1	25.73696	-80.39504	855307.002002988	510544.36903315	0b4f4604-a44d-44c5-a51a-f3d104da4e5d	0101000020E61000007BC74F76481954C067D72C85A9BC3940	0101000020BC080000764FA82F141A2A419843124148291F41
30	9979	NW 84 AV	NW 74 ST	N	N	N	0	0	0	10/31/2016 15:4	25.83991	-80.33411	875177.038692441	548061.758573771	641b5e7e-4bac-4f11-a7b2-8fccc0b94042	0101000020E6100000B00F551A621554C00E4B73E904D73940	0101000020BC080000B620FC4450B52A411C20E5ECBEB92041
31	6628	BISCAYNE BD	E FLAGLER ST	S	N	Y	1	0	1	11/20/2002	25.77465	-80.18787	923423.073731832	524611.482671827	6e36ff4b-e611-4d4a-827b-f085e449304c	0101000020E61000009C5E521F060C54C01F4D8FE64FC63940	0101000020BC0800000C2B415D3C2E2C41F6FEAF5C8A022041
32	7120	NW 12 AV	NW 46 ST	S	N	Y	1	1	1	9/26/2016 14:23	25.81756	-80.21609	914045.800844498	540151.238333277	6ef0476b-a958-4d7d-84f5-93ec55249952	0101000020E610000013911159D40D54C0B8F44AFC4BD13940	0101000020BC08000026873DD0F9E42B4109E880E1F17B2041
33	6844	NE 1 AV	NE 16 ST	N	N	N	1	0	0	9/6/2016 14:52	25.79049	-80.19225	921945.686944395	530357.758536585	e43d13af-9a9f-4df2-a39d-c40de40ee65d	0101000020E61000003FDAC5EA4D0C54C03F860E995DCA3940	0101000020BC080000135EF796B1222C411F029FEA6E2F2041
34	90	NE 2 AV	NE 37 ST	S	M	Y	1	0	0	11/1/2016 13:07	25.81123	-80.19142	922175.456834625	537897.420326531	04dfa868-3cb9-49d8-b215-7e3170e11c36	0101000020E6100000B601C02B400C54C0D6AAD4BFACCF3940	0101000020BC08000089C92E217D242C4132416D3E566A2041
35	8843	NW 17 AV	NW 119 ST	N	F	N	0	0	0	8/18/2016	25.88358	-80.22666	910427.644025207	564125.047006749	ebefee2d-bf5d-488f-b074-530f5d62dbd5	0101000020E6100000A9BEAF82810E54C0E99A795832E23940	0101000020BC0800009E387D7FB5C82B41AF3FA9823D372141
36	8429	NE 2 AV	NE 107 ST	S	M	Y	0	0	1	11/4/2016 10:41	25.87287	-80.19391	921218.199556563	560296.686884426	e1c3af20-ddb2-464f-8916-978fb5b8baa0	0101000020E610000024D7F6FF680C54C028CCB16374DF3940	0101000020BC0800002948499D021D2C41582DDEC954192141
37	8234	SW 22 ST	SW 18 AV	E	F	Y	1	0	1	9/14/2016 13:37	25.75073	-80.22366	911697.327210758	515844.600597464	d1f4a040-92fa-4646-a39d-6186676cb6e7	0101000020E6100000BCE1BA70500E54C029EF8EF32FC03940	0101000020BC080000AFBF6BDDA0D22B418549D22F197C1F41
38	8137	BEACOM BD	SW 4 ST	NE	F	N	0	0	0	9/8/2016 12:38	25.76874	-80.23461	908054.039204556	522370.236140117	b875c4f0-c88f-4c31-8519-0ea581717a65	0101000020E61000001724F4E4030F54C0EB05D662CCC43940	0101000020BC080000EB8990492AB62B418F3949BC0FE21F41
39	6835	BRICKELL AV	SE 8 ST	N	N	Y	1	0	0	9/13/2002	25.7655	-80.19069	922515.44858687	521280.414812319	1ce004a3-5cf1-4494-aa77-c15912ef641d	0101000020E6100000FDA84253340C54C04D5DC44FF8C33940	0101000020BC080000D341111D25272C41881D0F7308D11F41
40	3103	FAIRWAY HEIGHTS BD	SW 106 AV	S	F	Y	0	0	1	8/17/2016	25.62271	-80.36541	865262.183867674	469067.807967149	8dacbd40-cfa5-4f24-b27b-ada5bb456842	0101000020E61000004ADCDDE7621754C0C07E6D6C6A9F3940	0101000020BC0800005ABB2E8EDA672A41EF95BFF735A11C41
41	2597	CRANDON BD	# 951 US.POST OFFICE	NW	N	N	1	1	1	11/14/2016 11:1	25.68537	-80.16116	932418.495409172	492216.624867275	7b7b1c05-5f40-48f0-9359-10b3d90599c3	0101000020E6100000F241018E500A54C0CE2E1DE974AF3940	0101000020BC080000C2265E3683742C41D94E7542E90A1E41
42	2090	PALM AV	W 11 ST	S	N	Y	0	0	0	9/22/2016 14:01	25.83189	-80.28177	892410.378241841	545235.598516852	3869873f-6427-43ba-94ed-d5a028f9b9bf	0101000020E6100000FE400973081254C0391145FCF6D43940	0101000020BC08000046A8FFF4F23B2B412D6D879AAAA32041
43	5635	NW 119 ST	NW 17 AV	W	F	Y	1	0	0	9/30/2016 16:12	25.88321	-80.22715	910263.705071285	563990.683069021	d815a843-202c-4758-a762-677d49468c7b	0101000020E6100000D1C507B8890E54C028153E4B1AE23940	0101000020BC0800002F51B29E6DC72B4137BB62C830362141
44	3676	SW 216 ST	# 10465	W	N	N	1	0	0	10/4/2016 15:09	25.56673	-80.36	867142.665990938	448729.381455593	32d50493-7eea-4417-b4af-7bb5f7f64677	0101000020E610000061B9DC480A1754C03FE24F8515913940	0101000020BC08000023D753858B762A41840CC53D6C631B41
45	3523	SW 152 ST	SW 112 AV	E	N	N	1	1	1	11/18/2016 16:1	25.62754	-80.37554	861916.027155805	470807.04986722	388853b9-d9ac-45a0-85d9-708d8e207abc	0101000020E610000048FE2DE0081854C0D40C9FE5A6A03940	0101000020BC08000071557A3DB64D2A4167FDE0EF62BC1C41
46	1441	96 ST	ABBOTT AV	W	N	Y	1	1	1	10/31/2016 11:1	25.88712	-80.1244	944038.630972009	565622.59482941	c48316c8-a9c1-4316-9eed-d327639e123d	0101000020E6100000412EC93AF60754C039CE1B471AE33940	0101000020BC080000B102077D4BCF2C410091859BF0422141
47	4821	NW 22 AV	NW 71 ST	S	N	Y	1	0	0	10/17/2016 11:0	25.83955	-80.23347	908277.68772687	548109.440917328	1e8a0321-70b3-45a7-a3bc-54404f7587e6	0101000020E610000005506D4CF10E54C055A3CEFDECD63940	0101000020BC080000E2CF8495E9B72B414C61404A1EBA2041
48	8790	W DIXIE HY	NE 135 ST	SW	F	Y	1	0	0	9/30/2016 12:48	25.8994	-80.17922	925988.284501679	569972.826980151	2449dace-b362-4426-a549-c15f1d2123fa	0101000020E610000031C79F51780B54C01B5E56A63FE63940	0101000020BC0800005B7158C946422C416958CB12ED642141
49	5720	NE 18 AV RD	NE 185 ST	NW	N	N	2	0	0	11/13/2002	25.94566	-80.16457	930696.652405377	586815.798860766	edaab5bc-f2b2-4d98-a7a5-4620a731edf2	0101000020E610000050A87253880A54C038DDAC0417F23940	0101000020BC080000D0C355860F672C41C2B9AB0683E82141
50	1498	PONCE DE LEON BD	S ALHAMBRA CR	S	F	Y	0	0	0	10/12/2016 15:3	25.71232	-80.28072	892990.016213752	501779.400012068	4029498b-de26-4986-abf0-150b2fa5f156	0101000020E6100000400FC064F71154C08087620A5BB63940	0101000020BC0800002EEDD13B7A402B4119FE9C5E54A01E41
51	8791	W DIXIE HY	NE 133 ST	SW	F	Y	1	0	1	9/30/2016 12:52	25.89773	-80.18063	925530.843846165	569362.215309292	4972bbe5-2d9a-4977-8335-b6e17a0bece4	0101000020E610000003153C4E8F0B54C09BF2D212D2E53940	0101000020BC080000A6AEBAE7B33E2C41AEFC86D927602141
52	2349	W 29 ST	W 12 AV	E	N	Y	1	0	0	10/3/2016	25.8479	-80.3076	883885.383802194	551010.183443666	a4d52c43-9de9-486e-b297-2e4fecd4bede	0101000020E61000009281C68CAF1354C099C1E56910D93940	0101000020BC0800001C9EDEF658F92A412E97E0C6C7D02041
53	1426	HALLANDALE BEACH BD	NE 10 AV	W	F	Y	1	1	1	11/3/2016 12:58	25.98589	-80.13906	938982.631243508	601494.683564126	a9258d71-0409-4546-ada0-462a884da475	0101000020E61000000DBC4E6BE60854C031EF22DC63FC3940	0101000020BC080000A297897CCBA72C41BCBC92CD305B2241
54	9881	ENGLISH AV	NE 6 ST	S	N	N	0	0	0	10/21/2016 14:0	25.47549	-80.47533	829254.545570213	415402.957599126	43f1593e-2bde-46b0-b3d6-61b514d5c0c5	0101000020E610000019C0E1D56B1E54C0B4B03C25BA793940	0101000020BC080000DDA4BE428B4E29417C37A882B25A1941
55	7199	NW 14 AV	NW 16 ST	N	F	Y	1	1	0	2/22/2017	25.79047	-80.219	913149.553938091	530297.425332449	6873d44b-2368-46b8-aee7-4e66455fbfbb	0101000020E610000029B4F0E4030E54C0C0E682495CCA3940	0101000020BC080000D9FBB651F9DD2B412CEC1540F62E2041
56	2079	PALM AV	W 34 ST	S	F	Y	1	0	0	9/22/2016 12:58	25.85256	-80.28262	892091.755543873	552746.5500395	68b3b68e-b4d0-427b-8422-3a920eea05d7	0101000020E610000046CC0847161254C009F9A58C41DA3940	0101000020BC080000FF4720B675392B41E39FCF8258DE2041
57	1790	NW 87 AV	NW 25 ST	S	N	Y	1	0	1	11/9/2016 16:27	25.79757	-80.3372	874242.530091323	532666.949471802	5855569b-3329-4636-bdfc-2f49f364e25f	0101000020E610000098E93484941554C064F863FC2DCC3940	0101000020BC0800003C5D6C4003AE2A41E81DA94C79412041
58	8047	W FLAGLER ST	NW 39 AV	W	F	Y	1	0	1	9/8/2012 11:49	25.77186	-80.25977	899768.6112216	523458.038105935	68aa8f9d-a165-448d-9bde-d67184156161	0101000020E6100000D80BE60CA01054C02103150E99C53940	0101000020BC080000DD2F5F6D6F752B416BE789F10EF31F41
59	2294	E 3 ST	E 1 AV	E	F	Y	1	0	0	9/22/2016 14:21	25.82445	-80.27913	893291.284929287	542535.432380669	dce2174a-fa3e-44d0-b477-9d4d5ba6783f	0101000020E6100000A2406E4FDD1154C0B61936440FD33940	0101000020BC080000A65A62C5D4422B41C34B2E45928E2041
60	9944	NW 84 AV	NW 58 ST	N	F	N	0	0	0	10/31/2016 15:2	25.82662	-80.33373	875325.851051267	543230.517570049	00812d4b-abe6-46a7-869e-99d5a9ebcdc7	0101000020E6100000A756E2E85B1554C055C016AD9DD33940	0101000020BC0800006FDFE9E479B62A41D996DD7000942041
61	9031	NW 135 ST	NW 28 AV	E	F	Y	0	0	0	11/25/2002	25.89712	-80.24542	904230.21349407	569012.696347892	9eb4f2f2-2590-40fa-9a51-9c8b4e5897e5	0101000020E6100000EC4870ECB40F54C07DD4B218AAE53940	0101000020BC080000C1CD2FA24A982B419062D4CF6C5D2141
62	9384	NW 62 AV	NW 39 TE	S	F	N	1	0	0	11/8/2016 14:30	25.81015	-80.29731	887342.959575541	537306.289252356	060ba8e1-8a51-47cb-8576-a130bc6bddce	0101000020E610000049E55EF5061354C06314823B66CF3940	0101000020BC08000048601D1E5C142B41EF6033FBB7652041
63	148	#N/A	#N/A	N	N	N	0	0	0	8/18/2016	25.94829	-80.23758	906698.785004731	587626.441916719	411e748b-d660-47b0-861d-93befd1d2546	0101000020E6100000357F7D81340F54C0EFD20293C3F23940	0101000020BC080000B89920C793AB2B41C641E54FD8EE2141
64	1359	BISCAYNE BD	NE 191 ST	N	F	Y	1	0	1	11/8/2016	25.95263	-80.14656	936600.941111874	589388.14967487	9f4ec0a1-a959-4343-ae70-8bfd2701de0e	0101000020E61000007418A622610954C085E074EFDFF33940	0101000020BC080000BD9FE71A30952C4107F090BA9BFC2141
65	6160	NW 12 AV	NW 186 ST	S	F	N	0	0	0	11/20/2002	25.94437	-80.2214	912022.249107815	586230.358447023	e248afb3-64ae-4292-95dd-cac87f10a04c	0101000020E6100000D3FAC8822B0E54C02681EF36C2F13940	0101000020BC0800009EE85BB52AD52B416F8C1B25F0E32141
66	6895	S MIAMI AV	MERCY WY	NE	F	Y	1	0	0	10/14/2016 16:5	25.74308	-80.21646	914081.818482164	513078.104817666	12c2aabd-ff7b-43e7-b8c2-2bc1e5c20721	0101000020E6100000CC77E592DA0D54C08F25D5993ABE3940	0101000020BC0800002E5B5ED941E52B418D617B33DF501F41
67	8269	SW 40 ST	SW 37 AV	E	N	Y	1	0	0	8/22/2002	25.73497	-80.2545	901578.117445115	510058.953653283	e1cc6b78-cd32-49eb-b9a1-2922cff55ee5	0101000020E6100000A6F84BBD491054C02E5FE24C27BC3940	0101000020BC0800000485BD7092832B413B39D097B2211F41
68	6794	NE 2 AV	NE 31 ST	N	N	Y	1	1	1	11/4/2016 10:42	25.80636	-80.19103	922312.660975851	536129.921889707	722d2db8-cd06-4aa1-adb6-539e6d0986d7	0101000020E610000016FF22E1390C54C08419A9EA6DCE3940	0101000020BC080000BE36AC898F252C417EAA1B3F875C2041
69	2774	WASHINGTON AV	2 ST	S	N	Y	1	0	0	11/2/2016 13:50	25.77132	-80.13498	940836.923747841	523512.636113212	54fa7ff3-79ee-4d91-b204-f102c3736819	0101000020E6100000B2978492A30854C04700FCCB75C53940	0101000020BC0800002D3AC11248B62C41004C2556E9F31F41
70	4198	SW 56 ST	SW 147 AV	E	N	N	1	1	1	10/12/2016 16:2	25.71382	-80.43133	843397.615073435	502082.754076459	59d27239-5e7a-4651-9a65-4fbf5032f45e	0101000020E61000009DE840019B1B54C09D812B58BDB63940	0101000020BC0800001B581E6809BD2941F34122C911A51E41
71	5010	NW 72 AV	NW 36 ST	S	F	N	1	0	1	10/20/2016 11:0	25.80869	-80.31338	882053.561999585	536749.514443673	c82d8aa2-8a72-4ea3-9618-71a54e545ccd	0101000020E61000009662F7820E1454C01D40A5E006CF3940	0101000020BC080000C2ACD75109EB2A415C4C5C6E5E612041
72	1666	SW 24 ST	MADRID ST	W	N	N	0	0	0	9/14/2016 14:27	25.7487	-80.28159	892634.874151397	514999.442819431	bcedb914-f436-435c-99ae-fd2ae4126cf5	0101000020E6100000C65BDB7B051254C00F2D550BABBF3940	0101000020BC080000BD6210F3B33D2B41F989EC8DE46E1F41
73	4651	SW 72 ST	SW 72 AV	W	F	N	1	1	1	9/26/2016 12:19	25.70344	-80.31031	883263.688852236	498499.557154767	753948ec-76f8-4b98-965e-51113b7283db	0101000020E610000056846F36DC1354C0A380E40315B43940	0101000020BC080000DF860C937DF42A416996B0FE146D1E41
74	3909	SW 122 AV	SW 34 ST	S	N	Y	1	0	0	10/13/2016 14:1	25.73717	-80.39195	856326.145976048	510626.471238717	fef24264-e5f8-4644-94b4-e1f35098e0bf	0101000020E61000005B078CB8151954C0C98EB47AB7BC3940	0101000020BC08000079EF95790A222A418ADC8EA9902A1F41
75	2691	INDIAN CREEK DR	29 ST	S	F	N	0	1	1	10/11/2016 12:5	25.80545	-80.12642	943577.063337449	535935.080759317	71175cd8-cef5-4f47-964c-2cc73835c073	0101000020E6100000E14A2910170854C0D079694732CE3940	0101000020BC08000006DF8A5AB0CB2C41CB0D7390015B2041
76	7004	SW 3 AV	SW 15 RD	NE	N	N	1	0	0	9/14/2016 14:19	25.76123	-80.19945	919643.445138115	519708.273637742	b5c46850-7a8a-44e6-b2b8-7b06599b3f23	0101000020E61000008BC867C4C30C54C0B4B59803E0C23940	0101000020BC0800009C9BF01AB5102C41BA1AE6E177B81F41
77	5873	NE 186 ST	W DIXIE HY	W	F	N	2	0	2	10/27/2016 12:0	25.94759	-80.14914	935763.084854089	587549.235383846	647d5f1f-c6dd-4444-a0d0-785ff929827d	0101000020E6100000DB621F818B0954C070B3285F95F23940	0101000020BC080000C6116864A48E2C4193F643E63DEE2141
78	4142	SW 40 ST	SW 93 AV	E	N	N	1	0	1	10/13/2016 11:1	25.73273	-80.34586	871507.514517937	509084.209538378	fe3e2776-0722-4533-825a-2b88dee44c48	0101000020E6100000D78F6F88221654C025CE874D94BB3940	0101000020BC080000800F2038A5982A41524E3A9D77121F41
79	6239	W BUNCHE PARK DR	NW 22 CT	E	F	N	0	0	0	10/31/2016 16:2	25.9225	-80.23718	906888.761663087	578253.279904865	91582632-d814-4264-9a9e-106382892233	0101000020E61000006D4C6CC12D0F54C01801916629EC3940	0101000020BC080000A9561DBB0FAD2B41A252D4FB9DA52141
80	364	5 ST	LENOX AV	W	F	Y	1	0	1	11/2/2016 14:00	25.77453	-80.13983	939234.147426628	524665.6606654	a962b267-f2b0-4c7f-bc41-eb22899956ab	0101000020E6100000F86951FCF20854C021A1DD9347C63940	0101000020BC08000091430085C2A92C41B444D3B7F6022041
81	5619	NW 119 ST	NW 17 AV	E	F	Y	1	0	0	9/30/2016 12:15	25.883	-80.22601	910640.945440408	563917.665161654	27270c7b-eef1-430f-ad07-dac176d897f5	0101000020E610000075FE5BF1760E54C02E025CBA0CE23940	0101000020BC080000CADFBF1960CA2B41E3813CBF9E352141
82	4319	SW 88 ST	SW 142 AV	W	F	N	2	0	0	10/3/2002	25.6852	-80.42553	845355.467407227	491689.763375483	2e9789ec-fc47-41a3-9cea-f5a8d90fa186	0101000020E6100000B1EF88D43B1B54C07994ADD569AF3940	0101000020BC080000D72BAF1C55CC29414B01F0CFAD021E41
83	7992	NW 7 ST	NW 35 AV	E	N	Y	1	1	1	9/6/2012 12:58	25.77894	-80.25285	902031.729729496	526041.671354957	5f189367-2e56-41c6-aaa8-9e353137eef2	0101000020E61000009FE91CA82E1054C0313C5C9768C73940	0101000020BC080000139B44AA1D872B41874862BDB60D2041
84	9295	SW 64 ST	SW 60 AV	W	F	N	1	0	1	9/22/2016 11:51	25.71146	-80.29193	889301.99470365	501444.340983294	65c917bb-bd2f-4102-bc5a-15b15d1293dd	0101000020E610000005AA22FEAE1254C0BD7F863822B63940	0101000020BC08000051AE5730AA232B41D284EC21189B1E41
85	2442	W 68 ST	W 12 AV	W	F	Y	1	0	0	10/3/2016	25.88425	-80.30801	883678.619428199	564221.427728221	72abf56d-a4a9-4597-b086-da0611963e45	0101000020E61000005082CE61B61354C05B86DBA55EE23940	0101000020BC080000E053686FBBF72A416EB08845FE372141
86	640	PARKING LOT 	RAMP	W	N	Y	2	0	1	11/3/2016 14:02	25.92621	-80.15238	934746.345722117	579771.537353374	9c3e5f6f-e748-424e-a3e2-d63a613fa5d1	0101000020E6100000B42E08B4C00954C07672F4461CED3940	0101000020BC080000FC5EC1E9B2862C41DBC8CF7F7AB12141
87	8866	NE 123 ST	# 2185	W	M	N	0	0	0	10/31/2016 11:2	25.88962	-80.1544	934173.761237796	566469.529849797	08c91d18-5c0f-40a9-b78a-873ae1437575	0101000020E610000065AB3885E10954C07C515CA4BEE33940	0101000020BC080000F2567BBE39822C4178FE507A8E492141
88	8570	NE 19 AV	NE 175 ST	S	N	N	1	0	0	11/11/2002	25.93726	-80.16266	931343.836154636	583767.693736844	40564f8e-012f-4b7a-b93b-e966f5efa49e	0101000020E6100000D1125308690A54C06C345DB6F0EF3940	0101000020BC080000073973E41D6C2C4139137FD0B2D02141
89	2316	W 18 ST	# 660	E	M	N	0	0	0	10/19/2016 16:5	25.83794	-80.29521	887976.099379975	547410.263472214	650d8e5e-29b7-4089-99e2-a29c6c4fd330	0101000020E6100000DA6178BBE41254C088C6AC6983D63940	0101000020BC080000C506C2654E192B41375250EFA7B42041
90	307	SOUTH MIAMI STA	5949 SW 72 ST	NE	T	Y	1	1	1	42639.63125	25.70529	-80.28894	890297.907710548	499207.451409675	e01aaa6e-9b13-44e1-a2c0-3f7d64ed133d	0101000020E610000042898C097E1254C0A5B1DCED8DB43940	0101000020BC08000062510A04722B2B418E86AC9224781E41
91	2299	E 9 ST	E 6 AV	E	F	Y	1	0	0	10/18/2016 15:1	25.83027	-80.26929	896516.435988624	544667.936313853	8b404184-fd0d-484f-9fe2-0eb4178952c3	0101000020E61000005DB577173C1154C05BC8128E8CD43940	0101000020BC08000055062A13075C2B4159BD77473B9F2041
92	8965	NW 27 AV	# 14851	N	M	N	1	1	1	9/19/2016 12:38	25.90958	-80.24394	904690.017410755	573541.791306265	a6ec8d6c-f325-489d-8aa8-dc65084a0144	0101000020E6100000C9F940B59C0F54C046AA6C37DAE83940	0101000020BC080000D442E33DE29B2B41B0E00201CF802141
93	9169	SW 88 ST	US 1	W	N	Y	0	0	0	10/10/2016 15:5	25.68894	-80.3076	884183.670967702	493233.734695785	998e2b5c-39da-4d46-a632-a46a1a1755f7	0101000020E61000002C70DDCFAF1354C09A2C67AD5EB03940	0101000020BC080000846CFA89ADFB2A41280EF2B2CD1A1E41
94	10493	Airport Station	(Lower level)	T	T	Y	1	0	0	11/10/2016 14:4	25.79812	-80.25876	900049.930198301	533002.300503515	e1d1c1d8-ce00-42df-be70-d9af0621aca7	0101000020E6100000724E185F8F1054C0470439A351CC3940	0101000020BC0800003F9ABD10A2772B4108BA6D0018442041
95	5861	NE 183 ST	NE 1 AV	E	N	N	1	0	0	10/27/2016 16:5	25.94263	-80.19928	919297.238856312	585644.301820271	6543224f-98fa-4912-9455-1b3a9d78cd37	0101000020E6100000F42D96FFC00C54C0939A01A450F13940	0101000020BC0800002ED621B1000E2C41B39502085CDF2141
96	5558	NW 22 AV	NW 135 ST	S	F	Y	1	0	1	8/22/2016	25.89695	-80.23561	907454.984295379	568970.665601037	f263526c-f677-4ccc-ac4c-a09018cb707a	0101000020E61000003849B03A140F54C054D3E6269FE53940	0101000020BC0800005F83502D7CB12B413932FFBF185D2141
97	4742	NW 14 AV	NW 101 ST	N	N	N	0	0	0	8/18/2016	25.86713	-80.22196	912007.409923628	558156.180674262	22d6c764-9db9-4ce0-88e0-90a8eabdaa97	0101000020E61000001EF8078E340E54C0EAD48D79FCDD3940	0101000020BC080000B267DB070DD52B4192A26CC69B082141
98	8065	W FLAGLER ST	NW 64 AV	W	N	Y	1	1	1	9/6/2012 12:40	25.77067	-80.29981	886596.777017292	522953.150306985	7de9fd39-bba2-45ad-b0af-672c3d6a997f	0101000020E6100000023221EB2F1354C0EF5566004BC53940	0101000020BC080000690598C0870E2B41A5DE75642BEB1F41
99	7436	NW 27 AV	NW 35 ST	N	N	Y	1	0	0	9/16/2016 10:29	25.8079	-80.24002	906191.081975393	536595.035453953	72f11afc-06b0-4c92-a374-21194a611ad3	0101000020E61000008E62588C5C0F54C084D6AC1AD3CE3940	0101000020BC080000812F1F5F9CA72B41D8083D7929602041
100	1701	SW 40 ST	SAN AMARO DR	W	F	N	0	0	0	10/13/2016 11:4	25.7342	-80.28258	892337.669384547	509726.765022196	b5198965-209a-4e60-a2a9-09d03c74d2e5	0101000020E6100000CECD37B4151254C09CEB13A4F4BB3940	0101000020BC0800007A5D3E8A613B2B41FBBB55D6811C1F41
101	5177	NW 71 ST	NW 17 AV	W	F	Y	1	0	0	11/8/2016 14:21	25.8392	-80.22574	910822.584225994	547997.137669444	165fa50a-230c-403f-8abe-2fd526c3d3f0	0101000020E61000005A007A91720E54C0AC56C70DD6D63940	0101000020BC0800006FD5E360CBCB2B41F225F6AE3DB92041
102	7946	NW 7 ST	NW 24 AV	W	N	N	1	1	1	9/6/2012 13:48	25.77967	-80.2353	907807.840217542	526342.698328294	8b31ed8a-01e2-4c69-ae31-f485c4c14728	0101000020E61000007DEBB1000F0F54C0EDFB2DE498C73940	0101000020BC080000C23A93E33DB42B41A68F41CB10102041
103	9392	NW 37 ST	NW 59 AV	E	N	N	0	0	0	11/8/2016 14:38	25.80804	-80.29343	888619.943211962	536546.924667478	0cbdd902-e03a-4a5e-88a6-a9336741798e	0101000020E6100000C8E89A91C71254C0DB762215DCCE3940	0101000020BC0800004A39CC15561E2B41B6F57D40C95F2041
104	4875	NW 27 AV	NW 68 ST	S	F	Y	1	0	1	9/19/2016 12:40	25.83584	-80.24148	905652.182124659	546746.792035617	3672a4f4-4731-4e48-996d-36c3b4a16980	0101000020E6100000E3D40878740F54C0B64FA40CFAD53940	0101000020BC080000ED36609266A32B41F182DAFD78AF2041
105	1443	96 ST	BAY HARBOR TE	W	N	Y	1	1	1	10/31/2016 12:5	25.88686	-80.1311	941836.05105162	565513.809644498	bae50ed4-3a94-4913-9bf1-2daddfdc5841	0101000020E610000045FFD204640854C0ACFBCE4D09E33940	0101000020BC08000013D5E25316BE2C41D005790917422141
106	7658	NW 62 ST	NW 14 AV	E	N	Y	1	1	1	10/18/2016 15:3	25.83179	-80.22098	912403.836936444	545315.266693622	f9ac1212-734e-42a3-bfe7-0a63c8a31339	0101000020E61000006650C698240E54C05AF440D3F0D43940	0101000020BC080000009487E225D82B41FAFAC7F049A42041
107	3960	SW 137 AV	SW 8 ST	S	F	Y	2	0	0	11/29/2016 13:1	25.76001	-80.41704	848030.098886691	518891.953382924	43cc963e-9e3d-446e-9e85-65e12dc02eaa	0101000020E6100000A6D7AACBB01A54C058C0889590C23940	0101000020BC080000C68E68603AE129417AF0A799B6AB1F41
108	2260	W 24 AV	W 52 ST	S	N	Y	0	0	0	10/19/2016 16:3	25.8702	-80.33112	876105.089008849	559074.254580095	7955e1e9-61a2-479b-8d53-2bac1d2e1b43	0101000020E6100000BAAEF914311554C09B7293ABC5DE3940	0101000020BC08000032A2CE5E90BC2A41539F4FECC70F2141
109	7713	NW 46 ST	NW 18 AV	E	N	Y	0	0	0	8/18/2016	25.81699	-80.22814	910078.915711135	539921.688546076	38222e0a-d93b-4483-aafe-f690f5ef3f13	0101000020E61000007A5CC6F8990E54C09F2B98D326D13940	0101000020BC080000FEB19C0AFCC52B41328FFBC7267A2041
110	4251	SW 72 ST	SW 128 CT	W	F	Y	1	0	1	9/26/2016 12:19	25.70052	-80.40162	853204.579027325	497290.973979861	7225043e-64dd-4c52-802a-7049bf97c2a2	0101000020E6100000A572B216B41954C09A87D08455B33940	0101000020BC08000017FDEB56A7092A41289DE0A8325A1E41
111	3645	CARIBBEAN BD	BLUE WATER RD	E	F	Y	0	0	0	10/21/2002	25.5766	-80.35471	868867.811483793	452323.238434546	17ebab18-db40-4eb4-bd0f-d096ad0d04f3	0101000020E61000004FC0C4ADB31654C040AB96089C933940	0101000020BC080000E43B11D005842A41C45723AC939B1B41
112	6200	E BUNCHE PARK DR	NW 20 AV RD	S	N	N	0	0	0	10/31/2016 16:2	25.91799	-80.23463	907733.521506913	576618.5282555	333556e8-83f1-4aaf-b929-1ba8228f9528	0101000020E61000007DA5B01F040F54C004BF83C401EB3940	0101000020BC0800008FF34C40A9B32B41394CAB7AD8982141
113	1328	W FLAGLER ST	NW 37 AV	W	F	Y	1	1	0	9/8/2012 11:44	25.77194	-80.25585	901057.852061905	523495.468139544	ff67ba40-3ac3-4da5-a53b-0599c4240432	0101000020E6100000E7469CDB5F1054C06480987E9EC53940	0101000020BC08000058FACFE8817F2B41DF30F0A9A4F31F41
114	7860	NW 17 ST	NW 4 AV	E	F	Y	0	0	0	9/27/2016 11:29	25.7916	-80.20145	918921.888517406	530743.869642951	edd1b8e3-a544-4be2-a76c-264808676d31	0101000020E61000005684E25AE40C54C0BC371A8AA6CA3940	0101000020BC08000012F8BBFD110B2C4132FE882373322041
115	208	NW 27 AV	NW 36 ST	N	F	Y	1	0	0	9/16/2016 10:31	25.80956	-80.24009	906168.195222951	537196.822936937	489ba905-5181-4701-be35-6e1ba10ec82f	0101000020E6100000B4ABCE835D0F54C01F61BDA13FCF3940	0101000020BC080000BF9427996EA72B4171DE660CDD642041
116	3306	SW 137 AV	SW 160 ST	N	F	N	1	0	1	11/18/2016 16:1	25.61978	-80.41445	849109.001934025	467928.137359731	610ed18a-7fb5-4790-82b3-0254ccce65a6	0101000020E6100000F0670354861A54C000775F56AA9E3940	0101000020BC080000F011F42EA8E92941724D9748678F1C41
117	8324	NW 67 AV	BULL RUN RD	S	F	Y	1	1	0	10/10/2016 12:5	25.9155	-80.30911	883256.468730479	575577.861992672	811026dd-f122-454c-a6d6-8c89fabe3db4	0101000020E6100000FB33EE6FC81354C0C9A1FCA55EEA3940	0101000020BC080000172931226FF42A4152657225B7902141
118	7126	NW 12 AV	NW 30 ST	S	N	Y	0	0	0	9/26/2016 14:46	25.80511	-80.21564	914219.163026351	535628.032121785	a382beb0-2bf9-4228-be1a-5701f54a7a48	0101000020E6100000E13B990ECD0D54C0BD923A421CCE3940	0101000020BC0800000890B68954E62B41802E5F779B582041
119	6921	NW 2 AV	NW 54 ST	S	N	Y	1	1	0	11/4/2016 14:31	25.82576	-80.20016	919266.621134236	543161.763773657	9bed90fd-0ef5-4bfb-89ec-6573b56f7233	0101000020E6100000D71BC26ECF0C54C03E54651E65D33940	0101000020BC080000A04FD574C30D2C413D5502EF76932041
120	3874	SW 112 AV	SW 61 TE	S	F	N	1	1	1	10/27/2016 19:5	25.71005	-80.37474	862038.186666567	500796.405587524	ff95e5a2-c4c0-4fe9-8f62-7b32c732bb9a	0101000020E61000009DD68CC0FB1754C0868E4635C6B53940	0101000020BC080000AF32318FAA4E2A4189E9E163F8901E41
121	2324	W 19 ST	OKEECHOBEE RD	W	N	N	0	0	0	10/4/2002	25.83901	-80.30192	885767.988010574	547789.943531543	05606130-45f2-45c9-b612-8efc75a752fc	0101000020E61000006273AD9E521354C041B7BEFEC9D63940	0101000020BC08000046AA5A2C0E082B41488A974B9FB72041
122	4432	SW 67 AV	SW 56 ST	S	F	Y	1	1	1	10/10/2016 15:0	25.71802	-80.30236	885853.839830771	503813.613127008	419b6b77-02ce-419e-a3b4-fa8a8cbe8b61	0101000020E61000007D1184F1591354C0294216BAD0B73940	0101000020BC0800003369A3E0B9082B4123344E391DC01E41
123	4483	SW 87 AV	SW 30 ST	S	N	N	1	0	1	11/9/2016 17:05	25.7425	-80.33583	874789.243882798	512652.037430823	7b692346-aef9-4afc-bb54-ee111ab88cde	0101000020E610000094E8EA507E1554C0C67BC4A714BE3940	0101000020BC080000CECC01AE48B22A41F271EDED364A1F41
124	10297	SW 162 AV	SW 47 ST	S	F	N	1	0	1	10/12/2016 13:5	25.71992	-80.45554	835417.949581515	504265.852079175	d88a16e7-a432-4261-a924-f6e2a620641f	0101000020E61000007758FFA0271D54C05F426A0C4DB83940	0101000020BC0800008DB55812B27E29410781D42D2EC71E41
125	5817	NW 68 AV	#18100	S	N	N	1	1	0	12/4/2002	25.93763	-80.31203	882254.445489772	583614.547694609	944e65c4-1bed-4927-a908-72762b800138	0101000020E6100000A6184F47F81354C01B09FFA108F03940	0101000020BC080000FF3210169BEC2A41D186998580CF2141
126	6702	BISCAYNE BD	NE 35 ST	S	N	Y	2	2	1	11/8/2016	25.80958	-80.18961	922772.979892116	537302.07703764	ee3b91b8-213b-49c5-8b37-ada34836a50a	0101000020E61000008ADD0699220C54C0ADD6F9BE40CF3940	0101000020BC080000A1D31F2D28292C410D7F9C8EAF652041
127	2647	COLLINS AV	# 5875	N	N	Y	1	1	1	10/11/2016 11:4	25.84101	-80.12115	945219.001957871	548872.065656506	7db560b3-96f7-4f29-baef-21228fdb7d3d	0101000020E610000001597BFFC00754C043EB22CE4CD73940	0101000020BC0800004CC23D3B84D82C41D7034D8A13C02041
128	4404	SW 57 AV	SW 74 ST	N	N	N	1	1	1	11/30/2016 11:4	25.70228	-80.28522	891531.045677945	498122.609417632	100681e7-7fa0-4cae-85a3-121e57a46de0	0101000020E6100000523360F9401254C070C2DD1FC9B33940	0101000020BC080000469FB24A14352B41A1CFEA3331671E41
129	6865	N MIAMI AV	NE 82 TE	N	F	Y	1	1	1	11/3/2016 16:40	25.85086	-80.19693	920276.354963504	552293.164840557	dc5fb932-f5a4-400e-8c71-51b2583ab9a6	0101000020E610000014AC675D9A0C54C089838266D2D93940	0101000020BC0800001F76B7ECA6152C4104FD92BDCDDA2041
130	8621	NE 12 AV	NE 154 ST	N	N	N	0	0	1	11/4/2016 12:29	25.91694	-80.17558	927142.220163424	576356.019250028	4b5ac0c6-ddea-4dad-b3c9-6b609400a1c0	0101000020E6100000DE61E9CF3C0B54C0CDA89137BDEA3940	0101000020BC080000CAE38BA84A4B2C41C6953076CB962141
131	5174	NW 71 ST	NW 13 AV	E	F	Y	1	0	0	9/26/2016 13:31	25.83927	-80.21882	913098.193816904	548036.408227392	8f153531-f39e-424d-b74e-09b1a0be7876	0101000020E6100000AEF91335010E54C00206F7B4DAD63940	0101000020BC080000D90D4A9992DD2B4179F796398CB92041
132	1615	SW 57 AV	BRESCIA AV	N	N	N	0	0	0	11/30/2016 13:0	25.71149	-80.28558	891392.758571927	501467.595853187	55e580df-d459-4f8a-bbc6-039ba431754d	0101000020E610000070D44BF4461254C0B8E22E6224B63940	0101000020BC0800006FBCC1B7FF332B411F791E27759B1E41
133	7566	NW 57 AV	OP # 815	S	F	Y	0	0	0	11/22/2002	25.77948	-80.28853	890290.433957636	526174.035934351	49d0de25-3a5a-43b6-90c4-5e3b8730450e	0101000020E6100000A948252C771254C07923632D8CC73940	0101000020BC08000065936411632B2B41AA2F0678BF0E2041
134	7973	NW 7 ST	NW 60 AV	E	F	Y	0	1	0	11/22/2002	25.77774	-80.29325	888736.631662082	525533.957191519	c221edcb-92d3-44e3-acfa-d80f3cb5e6bc	0101000020E6100000184498B3C41254C093D493461AC73940	0101000020BC080000C8E66E763F1F2B41A78AA44FBF092041
135	2020	E 4 AV	E 45 ST	N	N	Y	0	0	0	10/3/2002	25.86335	-80.27453	894725.433013733	556683.661944419	cedf3dd3-07de-4c24-88c0-e34f79caf015	0101000020E6100000731D36FE911154C0553E6BD004DD3940	0101000020BC0800006BA66711094E2B41635597BC1AFD2041
136	7401	SW 27 AV	BIRD RD	S	F	N	0	0	0	9/3/2002	25.7352	-80.23772	907100.976465028	510174.47182709	38fd43b8-c816-462b-85cf-677f9542240f	0101000020E610000033053ED9360F54C0B2D36C7036BC3940	0101000020BC0800002BB25529B8AE2B41F94F43AA80231F41
137	2519	NW 6 AV	NW 6 ST	N	N	N	0	0	0	10/4/2016 13:54	25.47516	-80.48555	825882.071354456	415270.593711682	db092a83-3c4b-4ef0-8d30-b7813e3ef7ba	0101000020E6100000FE4D7558131F54C00FA451A6A4793940	0101000020BC080000E1F38A4F32342941F20E340EA1581941
138	4589	SW 24 ST	SW 65 AV	E	N	Y	1	0	1	9/14/2016 12:42	25.74795	-80.30214	885872.381828602	514689.07502313	6fe1649c-1bff-4c2e-bdda-0b0cf42393f3	0101000020E6100000C7B1A228561354C006D84BA179BF3940	0101000020BC080000C6120DF6DE082B41976300150B6A1F41
139	8784	W DIXIE HY	NE 141 ST	NE	F	Y	1	0	0	9/30/2016 14:05	25.90566	-80.17272	928109.495809402	572261.592366487	46602c27-64f7-4519-af88-319bf7c485be	0101000020E6100000F1136BE30D0B54C0D8AEBFE7D9E73940	0101000020BC08000055E6D435D9522C411FDC149BCE762141
140	1438	COLLINS AV	# 10225	N	F	Y	2	1	1	10/11/2016 12:4	25.89644	-80.12427	944062.706997938	569010.508024283	3c9b44a4-d999-4187-850d-1de805e09e41	0101000020E6100000B28731E7F30754C077DFCB127DE53940	0101000020BC080000A1C702A47BCF2C41D5C97F6F685D2141
141	7364	NW 22 AV	NW 23 ST	N	F	Y	1	0	0	10/17/2016 16:3	25.79846	-80.23154	909004.013330501	533178.316565581	86f32f01-b9fa-4cfa-930b-3723b2ce6496	0101000020E610000066BCE276D10E54C03A93D31D68CC3940	0101000020BC080000F41F683C96BD2B41C707B40878452041
142	2796	ALTON RD	39 ST	N	N	Y	0	0	0	8/22/2002	25.81204	-80.13564	940521.257438082	538309.197056897	f54587c2-0180-4802-8403-ca61bbc483a1	0101000020E610000058B08A73AE0854C0FEECF7F6E1CF3940	0101000020BC0800008ED975BDD0B32C41399451CC8D6D2041
143	5378	COLLINS AV	HAULOVER PIER	NE	N	N	1	1	1	10/11/2016 12:5	25.90387	-80.12393	944151.499165684	571714.399934269	1de45908-518f-41fc-af75-63c3a167d8d9	0101000020E610000038CE0A94EE0754C02D94FA7664E73940	0101000020BC08000054D5A2392DD02C41B0DA7A3888722141
144	8701	NE 171 ST	NE 21 AV	W	N	N	1	0	1	9/8/2016	25.93361	-80.15805	932866.115594491	582449.616631418	8eaa8ff2-9d9a-468f-b446-77dd15e1ed67	0101000020E6100000C5055B911D0A54C095142D4F01EF3940	0101000020BC0800007E77B57302782C41EE7ED2A866C62141
145	6101	NW 2 AV	NW 191 ST	N	F	Y	1	0	0	9/21/2016 14:04	25.95011	-80.2053	917300.098162591	588349.573667452	2eb6d985-6885-4783-9e15-a43071e92fcc	0101000020E61000008A5CAABE230D54C0CF7982963AF33940	0101000020BC080000F883D56866FE2B41CFD780937EF42141
146	7993	NW 7 ST	NW 34 AV	E	N	Y	1	1	1	9/6/2012 13:02	25.77901	-80.25112	902598.900522124	526073.606675811	178d3e88-17b0-47fa-bad0-61e79c3e03b4	0101000020E61000005D102169121054C06B99C6C46DC73940	0101000020BC080000504BDC018C8B2B416F3E499CF60D2041
147	7722	NW 36 ST	NW 7 AV	W	F	Y	1	1	1	11/7/2016 12:09	25.81015	-80.2084	916590.516241413	537471.991672531	a792c058-7d85-4bfb-b61e-350693478050	0101000020E6100000EA12A36B560D54C041F9C32A66CF3940	0101000020BC080000AF9DD33EDBF82B41FE02FB6203672041
148	6804	NE 2 AV	NE 56 ST	N	F	N	1	0	1	11/4/2016 11:04	25.82755	-80.19187	921987.333533134	543830.848372288	ade3c0c9-be09-44d1-9984-b9b7fb22686b	0101000020E6100000382153B9470C54C0841380C1DAD33940	0101000020BC08000093E413E204232C41A5F3661AB1982041
149	5787	NW 47 AV	NW 183 ST	S	F	Y	1	0	1	9/1/2016 11:44	25.93905	-80.27752	893590.285684049	584194.266373061	8ba902ac-4e27-4a5a-a1c5-24c503c2e64e	0101000020E610000053CC63FFC21154C04715172766F03940	0101000020BC0800001CDBADC52A452B41AA77ACF507D42141
150	8559	BISCAYNE BD	NE 135 ST	S	N	Y	2	0	0	9/8/2016	25.90088	-80.1604	932170.958819732	570548.106672972	f93d197d-505a-4f7b-9f83-3d919d815752	0101000020E610000084A66205440A54C08BF1BE50A0E63940	0101000020BC080000C710692394722C41969A1CA26B692141
151	5977	NE 203 ST	NE 22 AV	W	N	N	1	1	1	10/28/2016 12:5	25.96318	-80.15726	933056.566930607	593200.766737476	6889ebed-3973-44ca-a9a2-29ee2d643c7e	0101000020E6100000ADF5DA9F100A54C02D74AF7893F63940	0101000020BC0800002CCFD15A7F792C41BD420AF7641A2241
152	6985	NW 3 AV	NW 14 ST	S	F	Y	1	1	0	9/27/2016 11:38	25.78776	-80.19996	919414.715311773	529352.913145989	0fe05d19-ec99-4854-8d91-ee72ddd8ced5	0101000020E6100000DF87DC3CCC0C54C0DCCF7735ABC93940	0101000020BC080000642537A5EB0E2C419F0EAB3995272041
153	7054	NW 7 AV	NW 10 ST	N	F	Y	0	0	0	9/21/2016 11:29	25.78361	-80.20669	917208.593047258	527829.308558807	2675412e-c409-4411-8d93-b824bd28172f	0101000020E6100000984DEC883A0D54C028771CE89AC83940	0101000020BC08000073A85766AFFD2B410167DE03AE1B2041
154	3843	SW 107 AV	SW 88 ST	N	F	Y	1	1	1	10/27/2016 12:1	25.68795	-80.36578	865025.965505846	492778.851424895	60af08b3-c591-452f-88d4-ff49708f957a	0101000020E610000092392800691754C01D1948FE1DB03940	0101000020BC0800003A774E1E02662A41DD94762AB2131E41
155	2897	VENETIAN WY	E ISLAND AV	W	F	N	1	1	1	11/14/2016 14:2	25.79152	-80.14778	936577.519922346	530826.553904355	bfe75a92-1887-4df1-aa73-fa8b99b7b079	0101000020E6100000D0DC3C41750954C083FE467EA1CA3940	0101000020BC08000041BB5A4301952C41F98CEF8118332041
156	4032	SW 152 AV	# 7510	S	F	Y	1	1	1	9/26/2016 15:37	25.69581	-80.43852	841057.468807403	495524.310852602	ad382379-3fff-4e75-b7e4-eb7fc21673bd	0101000020E61000001040B2D6101C54C015BEFC9420B23940	0101000020BC080000DD63E11CC1AA2941DF429D01983E1E41
157	1706	GRAND AV	LINCOLN DR	E	N	Y	0	0	0	42690.70694	25.72736	-80.25977	899858.419801123	507282.154799566	ca7b22e4-04ce-4bda-9e67-3a537b38dcb0	0101000020E610000040BE7919A01054C09A1EE75F34BA3940	0101000020BC0800002ED56D0B23762B410702F2644FF61E41
158	7278	NW 17 AV	NW 49 ST	N	F	N	1	0	0	8/18/2016	25.82001	-80.22427	911348.879073568	541025.413730256	9da7f7d1-4cc1-42ed-a47b-dfb88ea50964	0101000020E61000008E5ADF665A0E54C00479B27BECD13940	0101000020BC0800003980ECF7E7CF2B4173AF713BC6822041
159	1350	BISCAYNE BD	NE 183 ST	S	N	Y	1	1	0	9/8/2016	25.94573	-80.14769	936243.648846067	586876.99033463	622945b7-dc7b-499a-a371-1889ba936167	0101000020E6100000DDEC92C3730954C0CBA5149B1BF23940	0101000020BC0800007947328565922C41E11DB368FDE82141
160	3780	SW 288 ST	US 1	W	F	N	1	0	0	10/4/2016 13:19	25.49937	-80.44691	838594.710621063	424117.673115924	564d9b8e-0a60-45c5-b7ba-3671e76193a9	0101000020E61000008B1D8A2F9A1C54C02D7F99C0D67F3940	0101000020BC08000039756D98839729413BE8B661DDE21941
161	7940	NW 7 ST	NW 15 AV	W	N	Y	0	0	0	9/6/2012 13:47	25.78016	-80.21972	912929.229921434	526551.198553443	00c2a39f-6a13-476d-9f20-3fdb937863d0	0101000020E6100000C7CD23F80F0E54C0E2EACE11B9C73940	0101000020BC080000E431D5AB40DC2B41B00E72CBB1112041
162	8268	SW 40 ST	SW 39 AV	E	F	Y	0	0	0	10/13/2016 13:4	25.73488	-80.25765	900539.661837015	510022.203429185	e7d74b3f-1b9a-4acc-997e-3ccfb3b9cc2d	0101000020E6100000397D536E7D1054C0AE8CCFBA21BC3940	0101000020BC080000E0457187757B2B4139A087971F211F41
163	2617	HARBOR DR	CYPRESS DR	NE	N	N	0	0	0	11/14/2016 16:3	25.69689	-80.16966	929594.437370818	496384.249061972	2c1af0f1-efa2-46ea-a17e-7bc4aada6a50	0101000020E6100000B431A1BCDB0A54C05128CD8E67B23940	0101000020BC080000B4E23718735E2C41ED13A8C2074C1E41
164	4556	SW 8 ST	SW 71 CT	E	N	Y	1	0	0	9/8/2016 14:28	25.76277	-80.31119	882862.67880236	520060.600972943	3ad16777-963c-4130-86f3-bd6fa9e0cd43	0101000020E61000000889A790EA1354C052163F0145C33940	0101000020BC0800008CE8D38D5BF12A412AC92431F9BD1F41
165	3519	SW 152 ST	SW 129 AV	E	N	N	2	1	0	11/18/2016 16:1	25.62651	-80.40017	853803.01942192	470395.560547769	5160211f-da7e-491c-8a93-1f706c6af205	0101000020E61000004B2188619C1954C096FDD97563A03940	0101000020BC0800005FC16D38540E2A41854CC6FAF4B51C41
166	10387	NW 75 PL	NW 186 ST	N	N	Y	0	0	0	11/11/2016 12:1	25.94183	-80.32225	878884.901053593	585125.043727681	34bd7d84-5eec-48cd-b09a-4edbe52a703a	0101000020E6100000726BDADE9F1454C0266B69251CF13940	0101000020BC0800003078F3FE47D22A41BAAEA8834DDB2141
167	4968	NW 57 AV	NW 11 ST	N	N	N	2	0	0	11/8/2016 11:40	25.78172	-80.28831	890357.44108329	526989.303670183	d9b99611-11e0-42e9-a301-d41fad5108c6	0101000020E6100000B497FB9D731254C0AB8FEB1B1FC83940	0101000020BC080000F4750115E92B2B41EFE04C011E152041
168	7164	NW 12 AV	NW 7 ST	N	N	Y	0	0	0	10/18/2016 13:3	25.77988	-80.21473	914573.918540224	526458.107236892	4afe428a-3ada-4fd3-80ac-59fa18d5271a	0101000020E61000008274641DBE0D54C0C373DB85A6C73940	0101000020BC080000237A8E0C1AE92B4176ACAC9CF7102041
169	575	NE 199 ST	NE 2 AV	W	N	Y	1	0	1	11/1/2016 16:59	25.95772	-80.19752	919842.017955333	591131.229193047	94a57bc1-69d2-4481-a6f6-844da2b74d66	0101000020E61000002EA49B29A40C54C00E9026512DF53940	0101000020BC0800001A141B4042122C41795178E3390A2241
170	5368	SW 8 ST	SW 102 AV	W	F	N	2	0	0	9/8/2016 11:28	25.76169	-80.3613	866372.661289535	519584.658389799	1981bdfa-a802-41c4-a5c6-cd2e6aac266c	0101000020E61000006F5F188D1F1754C0487C0F29FEC23940	0101000020BC08000073229D8287702A4120CCBE6B89B61F41
171	542	NW 25 ST	NW 89 PL	E	F	Y	1	0	0	11/8/2016 11:26	25.79679	-80.34192	872685.684096042	532375.996662721	21bef5df-6698-41bf-b2ad-804cdba1fed9	0101000020E610000011136F1CE21554C03E8AF0EEFACB3940	0101000020BC080000B7662F8FD9A12A410255C864333F2041
172	3828	SW 107 AV	SW 20 ST	S	F	Y	2	0	0	9/8/2016 11:56	25.74937	-80.36804	864175.496381834	515098.354002379	ac220170-10e9-4d78-8f8f-ecffd4f7199c	0101000020E61000001718E7FE8D1754C066E25D26D7BF3940	0101000020BC080000DB41022E5D5F2A411628B93270701F41
173	35	BISCAYNE BD	NE 163 ST	S	F	Y	1	0	1	9/8/2016	25.92541	-80.15426	934133.271526702	579476.055982575	c23a8a3c-d0ad-4fcf-b53e-42f154bb2916	0101000020E61000006673935BDF0954C0B592A1B7E7EC3940	0101000020BC080000F059C4C3E8812C4106404C892BAF2141
174	9890	SW 92 AV	OLD CUTLER RD	N	N	N	0	0	0	1/8/2004	25.57607	-80.33984	873774.011629403	452157.643958591	fd925fbd-b968-40c6-99f3-ef5d7cdfbee8	0101000020E6100000604150DEBF1554C04910E4D279933940	0101000020BC0800006DB018375AAA2A41C475774BFD981B41
175	4039	SW 10 ST	SW 122 AV	W	F	N	0	0	0	10/13/2016 14:2	25.75879	-80.39339	855814.980617177	518482.924008936	f090d2b0-12a1-4ca9-9994-3c717ca06066	0101000020E6100000BD33EE5C2D1954C0DB08C47F40C23940	0101000020BC0800001730D2240C1E2A417A114D7B52A51F41
176	7666	NW 62 ST	NW 3 AV	E	N	Y	1	1	0	10/18/2016 15:5	25.83236	-80.20244	918503.040308747	545556.837100685	dd1609f1-1045-48e3-8d59-13e81749946a	0101000020E6100000F16431BDF40C54C094469AC915D53940	0101000020BC08000017F45E4BCC072C411EB1D6142DA62041
177	1433	HALLANDALE BEACH BD	DIPLOMAT PY	E	F	Y	1	1	1	11/3/2016 16:08	25.98588	-80.12718	942888.015160982	601516.940075845	6d895a1b-7eff-4a24-9ea0-9ffc98316274	0101000020E6100000C42268A5230854C0EE0E5D3463FC3940	0101000020BC08000091A6A0414EC62C414730E4505D5B2241
178	6752	NE 2 AV	NE 77 ST	S	N	N	1	1	1	11/4/2016 10:58	25.84573	-80.19282	921635.591084473	550434.275837593	c87cfa17-2a88-42eb-b2cd-3eb3aee613f5	0101000020E61000007E742439570C54C0C165F0BD81D83940	0101000020BC08000078FCC76545202C41BE8524F647CC2041
179	6266	NW 27 AV	NW 165 TE	S	F	N	1	0	1	42674.45972	25.92488	-80.2447	904408.805057272	579101.462574169	4d40ff18-88b6-4104-a5ea-8a613d2e4b5a	0101000020E610000066878920A90F54C0C3FAE6EAC4EC3940	0101000020BC080000145F17D1AF992B41BFE86E593EAC2141
180	7659	NW 62 ST	NW 13 AV	E	N	Y	1	1	1	9/26/2016 13:52	25.83186	-80.21883	913110.57928317	545343.085855015	5940c369-50c7-40dc-8ea7-186369c3b545	0101000020E61000002C083663010E54C06DEDC315F5D43940	0101000020BC080000C803B55EABDD2B4127542F9481A42041
181	9459	W PALM DR	SW 5 AV	E	N	N	0	0	0	8/17/2016	25.44766	-80.48349	826600.410470154	405278.313194573	de7fbee8-5f9e-4e39-b0df-cf74ebd16000	0101000020E6100000DAB52F98F11E54C0CE64F8579A723940	0101000020BC0800000F653EFDCE392941860039EC7FBC1841
182	173	NW 22 AV	NW 78 ST	N	F	N	2	0	1	10/17/2016 17:3	25.8458	-80.23342	908284.160479624	550383.411404282	ec6d002d-3897-4d1c-b197-b47af4eb9ada	0101000020E61000002882C450F00E54C05D4B17FC86D83940	0101000020BC08000075079187F6B72B41C18A833BE2CB2041
183	8851	NW 17 AV	NW 135 ST	N	F	Y	0	0	0	10/31/2016 12:2	25.89818	-80.22733	910177.079902507	569431.881221719	9b5554fe-beeb-4f08-848d-fd0426278942	0101000020E6100000A1804A708C0E54C03084026FEFE53940	0101000020BC080000C481905EC0C62B41F4837B2EB3602141
184	7360	NW 22 AV	NW 13 ST	N	N	Y	0	0	0	9/6/2016 11:58	25.78577	-80.23121	909137.876925405	528566.562318914	ab720b2c-7afb-45ee-a4dd-207924022b71	0101000020E6100000DCF9BC23CC0E54C07895E57628C93940	0101000020BC08000079BD86F6A1BE2B41B195DA8570212041
185	1989	E 8 AV	E 5 ST	S	N	Y	1	1	1	2/15/2017 14:37	25.827	-80.26544	897789.795630809	543489.732956	3597db2d-ede9-45a4-ab5b-614fde18edec	0101000020E6100000BA9E31FFFC1054C09EE392D7B6D33940	0101000020BC080000F5F283CBF9652B41A8963CDF06962041
186	7804	NW 20 ST	NW 7 AV	W	F	Y	0	0	0	8/31/2016	25.79531	-80.20754	916904.278052907	532080.555299222	23b7fe0b-dd7e-4dce-9510-8c2e0403e28c	0101000020E610000039828069480D54C0C5B85FBE99CB3940	0101000020BC0800007DAD05C54EFB2B4109AADE82E43C2041
187	408	SW 117 AV	SW 88 ST	NE	F	N	0	1	0	10/7/2002	25.68633	-80.38458	858838.056585368	492158.975360103	12ba5ac0-8392-4d86-b5cb-e7285b8223fd	0101000020E6100000AAEFB4FC9C1854C047544B7FB3AF3940	0101000020BC0800004F201A4CAA352A41ADBA43A9020A1E41
188	5276	BLUE LAGOON DR	# 5835	W	N	N	1	0	0	11/8/2016 12:14	25.78325	-80.29333	888700.229488879	527534.676902719	cab4ab16-0d51-46a8-aa0f-9474a8cf60eb	0101000020E6100000AFE5C0FAC51254C0DCA32A0D83C83940	0101000020BC080000B0A086A8F61E2B413A3D64C060192041
189	1226	NE 54 ST	NE 1 AV	E	N	N	1	0	1	10/19/2016 14:4	25.82524	-80.19399	921297.419852916	542985.514776029	488c93db-0532-46c9-8c06-823fb3cd6256	0101000020E6100000E9B8E4576A0C54C05444061B43D33940	0101000020BC080000C926160EA11D2C41EA83896F16922041
190	662	COLLINS AV	# 9700 (BAL HARBOUR)	S	F	Y	2	2	1	10/11/2016 14:5	25.88805	-80.12395	944184.971559305	565963.800513737	658549b3-c924-4701-bb91-2a46a10fe38d	0101000020E6100000AF01F5D2EE0754C08712959E57E33940	0101000020BC0800009DFB882B70D02C411D70E2049B452141
191	8941	NE 135 ST	NE 12 AV	W	N	N	1	0	0	11/14/2002	25.90004	-80.17441	927566.15407943	570212.817979679	619a981c-35b0-4b44-97db-f40a7808a951	0101000020E6100000C5732E9C290B54C06C10572269E63940	0101000020BC080000762ECA869A4E2C410597590ECD662141
192	312	SW 37 AV	W FLAGLER ST	N	N	Y	1	1	0	9/22/2016 15:44	25.77132	-80.25537	901215.784826145	523269.551908076	9235e9c5-1ffb-4a5a-b279-71f1727a0823	0101000020E6100000EFF31E0F581054C0A6339E9975C53940	0101000020BC080000056174C6BD802B41ABF5E0FF1CF01F41
193	1218	SW 26 ST	OP # 11995	NE	F	N	1	0	1	9/14/2016 13:03	25.74545	-80.38971	857049.270178232	513641.10333997	cb3f1652-ddde-47d0-bd0e-d75b663f98fa	0101000020E610000044817F09F11854C0D282FA71D6BE3940	0101000020BC080000696542B9B0272A41A10DB631AB591F41
194	521	NW 199 ST	NW 2 AV	W	F	N	1	0	1	9/21/2016 14:18	25.95717	-80.20683	916783.418087315	590913.394309573	76ea2e4c-56da-4441-a8bd-4af6d0289c39	0101000020E6100000A361FBBA3C0D54C08C1C3C6709F53940	0101000020BC0800009222800C5DFA2B419448FF3786082241
195	2245	W 16 AV	W 34 PL	S	N	Y	1	0	0	10/3/2016	25.85309	-80.3146	881570.385833114	552882.661339916	a2dd8e8b-2a56-44b9-95e4-ca76a1c37ee6	0101000020E61000001AC6A862221454C04BEDC93764DA3940	0101000020BC08000001EF8BF742E72A411BC5CABB68DF2041
196	2913	41 ST	PINETREE DR	E	F	Y	1	0	0	11/10/2016 12:1	25.81353	-80.12606	943670.419733793	538871.233642764	4a29b61b-140f-4dee-b456-7a9dc0f4c2b4	0101000020E61000009BB48371110854C0472F3F8C43D03940	0101000020BC0800003D6504116BCC2C41087610DFF1712041
197	2848	WEST AV	9 ST	S	N	Y	0	1	1	8/21/2002	25.77941	-80.1422	938443.290117331	526435.040011287	1d467181-f2e4-49a1-9305-b34578ff6668	0101000020E6100000B67E6EC8190954C0BD46408687C73940	0101000020BC080000EA71F5CD94A32C41BECC377AC9102041
198	3616	QUAIL ROOST DR	# 11855(SAINT ANNES	SW	N	Y	0	0	1	11/17/2016 17:4	25.58927	-80.38322	859450.924453843	456883.449444875	07bd84ab-2355-4c32-8df5-0bd71e7e1fb5	0101000020E610000068290DAC861854C08B91F25FDA963940	0101000020BC080000649DAA08743A2A415DA73C85D4E21B41
199	1356	BISCAYNE BB	NE 186 ST	N	N	Y	1	0	1	11/8/2016	25.94688	-80.1469	936499.218850236	587297.398953646	6d9bfe65-3bc0-4bd4-b617-d39ae3c890ef	0101000020E6100000D10ADAE2660954C074F4711A67F23940	0101000020BC080000E1EE13A964942C41E7D8003A46EC2141
200	3784	SW 288 ST	US 1	E	N	N	1	1	1	10/4/2016 15:55	25.49924	-80.44675	838646.026142921	424072.092161879	efd97943-8bf9-4568-9343-6fcf64258d64	0101000020E6100000135F6BA5971C54C05E16AF7ECE7F3940	0101000020BC0800001AFF143AEA972941A0A9F60E27E21941
201	9234	SW 57 AV	SW 68 ST	S	N	N	2	0	0	12/1/2016 14:04	25.70819	-80.28566	891370.917418975	500270.209500104	551a6ec5-b380-46b1-88af-0befba5143f7	0101000020E61000002FDB015D481254C0BBAD05824CB53940	0101000020BC0800007C511509D4332B41B624369BBF881E41
202	2271	W 28 AV	W 60 ST	N	F	N	1	0	1	10/19/2016 14:2	25.87791	-80.33923	873424.552049898	561862.700149007	6d0c9d97-2483-44d9-8897-ebab0cfc18f5	0101000020E6100000628998F0B51554C084FB27E3BEE03940	0101000020BC080000DD6E844B9FA72A41F068C4D090252141
203	4151	SW 42 ST	SW 127 AV	W	F	Y	1	1	1	10/13/2016 11:1	25.72972	-80.4001	853657.204087645	507907.913698204	4346a123-a7ff-4c0e-93f9-1a4a166ae3fb	0101000020E61000008792292B9B1954C00096887FCFBA3940	0101000020BC080000B1B7F996300D2A416630FD6D16001F41
204	1551	SW 42 AV	SAN LORENZO AV	N	N	Y	0	0	0	10/12/2016 12:0	25.73197	-80.26181	899178.081263334	508956.132722065	8c4f3635-c21c-440d-8cd5-39bbd7577d4f	0101000020E61000009F54787DC11054C0B8068FE362BB3940	0101000020BC08000064E0F45DD2702B41BE60E44E77101F41
205	1931	SE 8 AV	SE 4 PL	N	F	Y	1	0	0	2/14/2017 13:09	25.81894	-80.26491	897979.866142757	540558.628225885	5c7b0909-17b7-48fd-b7c1-a55a36a9a96e	0101000020E6100000E9D09A58F41054C029E8BA29A6D13940	0101000020BC08000060C290EF75672B418B3D28A9207F2041
206	8428	NE 2 AV	NE 109 ST	S	N	N	0	0	1	11/4/2016 10:40	25.8754	-80.19402	921174.73244714	561217.128266029	710f5f4c-5de4-42a5-af40-96b42d54af66	0101000020E610000009B74FE26A0C54C0239C62641AE03940	0101000020BC08000035782DAEAB1C2C41B701FBAB85202141
207	3552	SW 168 ST	SW 110 CT	E	F	N	1	1	1	11/17/2016 13:5	25.61288	-80.37167	863216.435944743	465482.716737732	78704e30-4eec-450a-b60c-0d0400386859	0101000020E610000001743878C91754C0E7ABE8BEE59C3940	0101000020BC080000E5A0F10EDF572A411127789931691C41
208	3032	SW 85 AV	SW 210 ST	N	F	N	1	1	1	10/4/2016 11:56	25.57283	-80.32639	878211.590338338	451002.334587201	317b84f0-c3ab-4a41-9b5f-35e7abee8550	0101000020E61000004BAE129AE31454C01ABCB17CA5923940	0101000020BC08000066880A6005CD2A416493280EF0861B41
209	8018	NW 5 ST	NW 3 AV	E	N	N	1	1	1	9/7/2016 15:37	25.77869	-80.20039	919294.880879119	526055.055871345	b464184c-83d8-41ff-a1fe-99efba0df736	0101000020E6100000DCF67033D30C54C0FC324EBB58C73940	0101000020BC080000B992EDF9FB0D2C413C566382D10D2041
210	7209	NW 17 AV	NW 62 ST	S	F	Y	1	0	0	8/22/2016	25.83132	-80.22496	911094.700455222	545135.603677161	33f824ae-c1fb-454d-a10b-4a05d0931893	0101000020E6100000039FB1DA650E54C084379CD3D1D43940	0101000020BC0800001AAA6A9CEBCD2B413EBB389DE2A22041
211	7366	NW 22 AV	NW 28 ST	N	F	Y	1	0	0	10/17/2016 16:3	25.80217	-80.23168	908947.777917694	534526.129471235	fbffef55-c5fe-4b7c-8cb6-13cd46f8eaa8	0101000020E6100000CA1E73DFD30E54C0781189305BCD3940	0101000020BC0800000F12CCC325BD2B412E2A26A9FF4F2041
212	7923	NW 13 TE	NW NORTH RIVER DR	SW	N	N	0	0	0	11/10/2016 16:5	25.78644	-80.2207	912593.230595395	528831.490948036	87e8eb02-a1b7-43d6-b93a-d6ad88cfb163	0101000020E61000001BBF8F06200E54C0525AF99154C93940	0101000020BC080000AAA40EACA0D92B41916F706182232041
213	161	SW 17 AV	SW 10 ST	S	F	Y	0	0	0	8/22/2016	25.76364	-80.22254	912037.314685494	520541.27228009	0be83abd-fcf2-48e4-88e6-be67d43d307b	0101000020E610000099FCB0233E0E54C06031206A7EC33940	0101000020BC080000D0A911D748D52B41589DCAE07BC51F41
214	3624	SW 192 ST	SW 113 PL	W	N	N	0	0	0	11/15/2016 15:3	25.58851	-80.37602	861824.325589553	456618.685877293	b677f7dd-9964-46f9-8dd0-f532be82e416	0101000020E61000002316A3C1101854C040EA0CA2A8963940	0101000020BC0800004CEF52D6FE4C2A4187448E77B1DE1B41
215	219	E 4 AV	E 49 ST	S	F	N	1	0	0	10/3/2002	25.8666	-80.27472	894657.752054501	557863.137609772	dde91b00-9037-4ab4-9159-93f762e5d9cd	0101000020E6100000A1D05A0A951154C0FCA5448BD9DD3940	0101000020BC08000099E7A7B4814D2B41EBD451B051062141
216	4590	SW 24 ST	SW 63 AV	E	N	Y	0	0	1	9/14/2016 12:47	25.74807	-80.29769	887335.263077602	514743.728071883	fca58c42-7517-481f-9264-7338d8953ab8	0101000020E6100000DFB5F2540D1354C07516901582BF3940	0101000020BC0800009BDF93B94C142B411A0CE3B1E56A1F41
217	4752	NW 17 AV	NW 76 TE	N	N	Y	1	1	1	8/18/2016	25.84405	-80.22523	910980.935242612	549759.499634951	968a9603-5b55-4bbf-a0b0-c7590be903d4	0101000020E61000002678CB296A0E54C0C31233A413D83940	0101000020BC0800004F47B01408CD2B4189549A6802C72041
218	5935	NE 195 ST	OP # 800	W	F	N	1	1	1	11/1/2016 16:53	25.95457	-80.18442	924152.98898381	590014.335129291	d8f7cd1c-beab-4e87-b26b-7f4b7225f344	0101000020E6100000A6479990CD0B54C00DA50A245FF43940	0101000020BC080000ADC4CB31F0332C41E3BEB11980012241
219	7708	NE 54 ST	NE 2 AV	E	N	N	0	0	0	10/19/2016 14:4	25.82529	-80.19203	921942.06225821	543007.281135462	9fc3906b-1566-4b0d-aa10-40054d4769a7	0101000020E610000034CD0D3B4A0C54C09D8D1C5146D33940	0101000020BC080000446A2D57AA222C41A0D9E3F741922041
220	6653	SE 2 ST	SE 1 AV	W	F	Y	1	0	0	11/22/2002	25.77259	-80.19224	921990.508703381	523853.542875089	df7e8f55-651f-4fd0-bdeb-c5cfd38e9040	0101000020E6100000D9AFDAAB4D0C54C0C48AB4D4C8C53940	0101000020BC0800002E3BA93B0B232C41B251C6F63CF91F41
221	8722	BISCAYNE BD	NE 121 ST	N	N	N	1	1	1	10/8/2016	25.88743	-80.16421	930947.597729672	565652.454991952	87a20e2e-594d-4d16-9c9a-905bc4bf8337	0101000020E61000008BACD98A820A54C09062770D2FE33940	0101000020BC080000612B756A05692C41A5CBC8532C432141
222	7329	SW 22 AV	SW 25 ST	S	F	N	0	0	0	10/17/2016 13:2	25.74548	-80.23002	909613.697536618	513924.498795986	e87c5679-0ecd-43ef-9aac-a67d770faa05	0101000020E6100000236F48B5B80E54C01F85EBF3D7BE3940	0101000020BC080000D774D99A59C22B41F0B610C7185E1F41
223	4364	CRANDON BD	AT FIRE STATION	SW	F	N	1	1	1	11/14/2016 13:3	25.70262	-80.16062	932560.801864542	498486.45778472	a8cb3ea1-09d3-4262-ba59-e6757764af46	0101000020E610000016D28D7E470A54C00894D735DFB33940	0101000020BC08000091EC44D39F752C410EA01C99E06C1E41
224	8099	W FLAGLER ST	SW 32 AV	E	F	Y	1	0	1	9/8/2012 12:08	25.77197	-80.24703	903959.465375978	523521.765325263	5d2c777c-3486-4726-8937-c889a9523374	0101000020E6100000EF3D6B66CF0F54C035299443A0C53940	0101000020BC080000C6BD3B232D962B41A7404ADA0DF41F41
225	7298	NW 22 AV	NW 32 ST	S	F	N	0	0	0	10/17/2016 11:4	25.80531	-80.23198	908842.402474109	535668.654435679	63ead0f6-4a50-47c5-8675-47f6ecc8fcea	0101000020E6100000282DBEC9D80E54C04F82E34C29CE3940	0101000020BC080000FBBE950353BC2B4103F309B6EC582041
226	5710	NE 19 AV	NE 185 ST	S	F	N	1	0	0	11/4/2016 11:29	25.94562	-80.16299	931213.671724912	586804.197185233	7ec9af4f-e52c-4756-9555-a6c7a2222ff7	0101000020E6100000805FCE8D6E0A54C0107CCE5414F23940	0101000020BC080000E0FF2D90196B2C41A270A9D26BE82141
227	10394	BAY RD	N BAY RD	N	N	Y	0	0	0	11/10/2016 15:2	25.79503	-80.14368	937917.681558438	532109.630035505	4d82e0b2-5c5f-4b4a-b4f1-c2fd4b1ba8f4	0101000020E6100000279CFA1C320954C05E40344387CB3940	0101000020BC08000019463796799F2C41C40110A91E3D2041
228	112	NORTHSIDE STA	3150 NW 79 ST	W	T	N	0	1	0	11/8/2016 14:36	25.84536	-80.24913	903119.767272867	550193.301199563	55989854-dd56-4f66-ad2f-de24d1966c39	0101000020E6100000159D55A0F10F54C0B18354156AD83940	0101000020BC080000D23A91BD9D8F2B41D072FD0266CA2041
229	6286	NW 32 AV	NW 167 ST	S	F	Y	1	1	1	9/1/2016 11:28	25.92544	-80.25276	901760.804723799	579291.285997026	6bc77b2a-0cd7-473b-9182-c14ebd8200f7	0101000020E610000028B947112D1054C03C053DE1E9EC3940	0101000020BC08000089918FD0FF842B41AAE5FAFEB9AD2141
230	7245	SW 17 AV	SW 21 ST	S	N	Y	0	0	0	8/22/2016	25.75256	-80.22215	912188.130051114	516512.655322745	493cf66b-dbcc-4a7a-8045-810492774d48	0101000020E61000007BE7AFD0370E54C08539DDE1A7C03940	0101000020BC080000D62CA97876D62B4120FACF6789861F41
231	6707	BISCAYNE BD	NE 26 ST	S	N	Y	1	0	1	11/8/2016	25.80208	-80.18929	922894.715866517	534577.79964897	ba50d63a-97dc-487f-95f4-55513cb2b2d4	0101000020E6100000885B0C5F1D0C54C020E8276C55CD3940	0101000020BC080000077AD6A51B2A2C4121952F0067502041
232	3048	SW 97 AV	# 9000	S	F	Y	1	0	0	9/29/2016 12:28	25.68445	-80.3517	869671.093323082	491528.903473653	8e3efbfc-4000-4135-bf27-0b3de9bff972	0101000020E61000008D862C37821654C0E2143A8D38AF3940	0101000020BC08000003364A604C8A2A4146B1485F2A001E41
233	8758	NE 12 AV	NE 141 ST	S	N	N	0	0	0	11/4/2016 13:11	25.90549	-80.17511	927325.204729032	572193.76804778	094d61d1-b2c5-4001-befe-049d5595cdca	0101000020E6100000318A39FF340B54C06C4A4791CEE73940	0101000020BC08000024A1BBA0B84C2C415A76F9F446762141
234	6310	NW 37 AV	NW 207 DR	N	N	N	1	0	1	9/19/2016 16:44	25.96093	-80.26213	898603.843898967	592173.410512045	9e0a547e-0135-42af-a215-a1c0977faf9f	0101000020E6100000ADD7A4D0C61054C0AA19CCC0FFF53940	0101000020BC0800001A5B22E4556C2B41B6517B405E122241
235	574	NE 10 AV	NE 199 ST	S	N	N	1	1	1	11/1/2016 16:52	25.95919	-80.18229	924842.417040877	591696.871782444	15be2af0-719d-4c86-b1ed-37f94c808ecb	0101000020E6100000DC57BBAAAA0B54C04E3673B88DF53940	0101000020BC080000A7C80E0D53392C41A970932CA50E2241
236	5938	NE 195 ST	# 661	W	F	N	1	1	1	11/1/2016 16:55	25.95514	-80.18996	922331.616948549	590208.760900907	cb56c3ea-e8b0-49b1-9528-d69325d51640	0101000020E6100000FD86DC50280C54C0B407EE3B84F43940	0101000020BC08000035B8FF72B5252C415898AEF304032241
237	8524	WESTWARD DR	CHIPPEWA ST	W	F	N	1	1	1	11/8/2016 14:09	25.82087	-80.2988	886827.391715679	541199.613171719	0d8f0b63-c999-4c95-93c8-8f3b30238896	0101000020E61000004C6D9B991F1354C0C66B88B624D23940	0101000020BC08000032F435FB54102B41E01E8EA122842041
238	2605	CRANDON BD	OCEAN LA DR	NE	F	Y	4	1	1	11/14/2016 16:4	25.69986	-80.16174	932200.012545891	497479.508991659	96428224-0a09-485d-ad8f-0768164a1771	0101000020E6100000A89B34C3590A54C075999C112AB33940	0101000020BC0800000B95273FCE722C419D355BCD245D1E41
239	9581	NW 41 ST	NW 97 AV	W	F	Y	1	0	2	11/8/2016 15:27	25.81176	-80.35372	868778.755242731	537798.138006717	c8956235-a163-4e1e-9dad-b7a96e9bdfef	0101000020E6100000ABB2E053A31654C0E236B312D0CF3940	0101000020BC0800006D8709B353832A410F60C8AD8F692041
240	4377	SW 42 AV	SW 10 ST	N	M	Y	0	0	1	2/13/2017 14:42	25.7626	-80.2631	898691.525801338	520086.957540557	3306f9e8-4eb7-4854-b6c9-6621c5798e02	0101000020E61000002C3EEF9BD61054C0579893523AC33940	0101000020BC08000082376C41056D2B418C2E589E62BE1F41
241	505	NW 12 AV	NW 183 ST	S	N	Y	0	0	0	10/26/2016 12:0	25.94227	-80.22133	912049.116523314	585470.10470628	d1495587-2b69-42f2-a912-fd91a3bc2d1a	0101000020E6100000CEC792652A0E54C09FBDFD1C39F13940	0101000020BC0800006889817160D52B41C92D0AA3FFDD2141
242	7733	NW 36 ST	NW 22 AV	W	N	Y	1	1	0	11/7/2016 12:49	25.80944	-80.23179	908896.153660286	537169.77184014	323dd517-5b30-4201-a161-06fd10448c3b	0101000020E6100000F14BD2ACD50E54C0981A08E637CF3940	0101000020BC08000084FB4884BEBC2B41E0DB4EF2A6642041
243	5839	NW 173 DR	NW 52 AV	W	N	N	0	0	1	10/26/2016 13:5	25.93133	-80.28481	891209.526980139	581374.401929684	f53e22c1-0683-423c-adf7-3ec2542446ec	0101000020E6100000935410743A1254C09C9962156CEE3940	0101000020BC080000F0F3084191322B41DD4D923A00BE2141
244	8284	GRAND AV	BROOKER ST	E	N	N	1	0	0	42690.70833	25.7274	-80.25616	901048.475446247	507303.384394445	c445352b-a844-4a1c-9a5e-5a0544ff2724	0101000020E610000006B10FDF641054C0C350FFFE36BA3940	0101000020BC080000C93711286F7F2B4175593850A4F61E41
245	5931	NE 195 ST	# 750	E	N	N	0	0	0	11/14/2002	25.95542	-80.18705	923287.516935058	590317.918166257	af08f92d-b23e-450c-8393-404971ae62a9	0101000020E61000001D833C9FF80B54C080B9AAD896F43940	0101000020BC080000320F01402D2D2C41E32A2744DF032241
246	7393	SW 27 AV	SW 20 ST	S	F	Y	1	0	0	9/19/2016 15:18	25.75235	-80.23843	906829.931437444	516407.592892215	2f80aa13-f0f6-4dd9-95bc-1123f9b05650	0101000020E61000003186F98B420F54C0CE5216949AC03940	0101000020BC0800003D6541129AAC2B41B5F4FF27E5841F41
247	673	COLLINS AV	163 ST	S	M	Y	1	0	1	10/11/2016 14:0	25.92902	-80.12243	944586.695135534	580859.551559158	efbe9571-757b-473e-84ce-3c0754a2773d	0101000020E610000074EAA5D6D50754C0066ED8C2D4ED3940	0101000020BC080000E74EFA9D93D32C41B5A03D87FAB92141
248	8915	NW 125 ST	NW 10 AV	W	F	N	0	0	0	10/31/2016 12:5	25.88908	-80.21511	914212.908804018	566146.680720687	61b26e7c-ad2e-416e-94ef-7eaaf55baac4	0101000020E61000009B8DA74AC40D54C0112431CB9AE33940	0101000020BC080000F3EC7D0748E62B41102E66C708472141
249	359	5 ST	LENOX AV	E	N	Y	1	1	1	11/2/2016 12:34	25.77417	-80.13973	939266.912458543	524536.83742366	31cd330f-bac9-4426-8150-a476297c3208	0101000020E6100000CE5D7865F10854C0A5CAF44F30C63940	0101000020BC080000C83CAE0C04AA2C419DCF4412F5012041
250	2311	E 9 ST	E 4 AV	W	F	Y	1	0	0	10/18/2016 15:4	25.83021	-80.27425	894885.999906152	544639.642726317	9f973971-26c1-4e3a-961a-db01f7ab7944	0101000020E6100000D5BDA24E8D1154C076AEE21489D43940	0101000020BC080000579DB7334A4F2B41C59315B1029F2041
251	9153	SW 67 AV	SW 115 ST	N	N	N	1	0	0	11/30/2016 16:1	25.66396	-80.30221	886008.633846503	484162.124218337	9c10c6f9-807d-48ab-bc09-8ebcc3d2867c	0101000020E61000001A5C6467571354C00CE28F42F9A93940	0101000020BC080000658E3B77EF092B41682B9E3F0F8D1D41
253	2661	HARDING AV	87 ST	S	N	N	1	1	1	10/11/2016 15:2	25.87216	-80.1223	944765.428359792	560192.149329491	70d74f86-1d9e-4ea5-bf2d-36e42042b8e1	0101000020E61000008CB7BDD2D30754C077EA525146DF3940	0101000020BC080000257D6F15F9D42C4109309EB683182141
254	7553	SW 42 AV	POINCIANA AV	N	N	N	0	0	0	42657.58889	25.71984	-80.26131	899371.314804949	504547.569367513	dc411d6c-ef67-4397-8519-a5b6f8278900	0101000020E61000001F51FC19B91054C0C4EB4DCE47B83940	0101000020BC080000B06B89D554722B41B112B70C95CB1E41
255	6660	NE 1 ST	NE 2 AV	W	N	Y	0	0	1	11/20/2002	25.77527	-80.19005	922704.588300139	524832.781394549	1a74c290-7692-4cd5-9c40-3f7a684e7f7e	0101000020E6100000D816B6D2290C54C08C62349978C63940	0101000020BC0800002C32A7649F282C41079AA2F544042041
256	6638	NE 1 AV	NE 6 ST	N	N	Y	1	0	0	9/6/2016 14:21	25.77984	-80.19208	922026.340332285	526490.087786123	dad860bb-ba0f-41b8-a0e8-3b5c0943eb98	0101000020E61000000F4827154B0C54C093BFE529A4C73940	0101000020BC080000AD1C9AE552232C411F00CB9237112041
257	7546	NW 42 AV	NW 7 ST	S	F	N	1	1	1	2/16/2017 9:54	25.77809	-80.26414	898317.151552394	525712.900391176	015133d0-5e5c-4625-ab08-b32983b8def2	0101000020E6100000FA2166AEE71054C04476101531C73940	0101000020BC080000F944DB81186A2B41C8629A32250B2041
258	4145	SW 40 ST	SW 89 AV	E	N	Y	1	0	0	10/13/2016 11:2	25.73286	-80.33993	873462.741278563	509142.287173934	3e34c3f9-4e92-43fa-a9e4-dddd7c66ac50	0101000020E6100000C7F54236C11554C0F4E3EC049DBB3940	0101000020BC0800006E4A86ACEBA72A41EC3C0AED5F131F41
259	7127	NW 12 AV	NW 29 ST	S	F	Y	0	0	0	9/26/2016 14:50	25.80309	-80.21555	914250.844401523	534894.354800068	6ed6f8e6-d1f5-45b2-bbba-ced440bf5fa5	0101000020E610000068D578B2CB0D54C0073E06F197CD3940	0101000020BC080000A48B9FE693E62B4142C0941CE0522041
260	5103	NW 95 ST	NW 10 AV	W	N	N	1	0	1	10/14/2016 15:4	25.86178	-80.21334	914852.660757698	556227.40659941	f2371500-4b24-41a5-8428-aba5f5fb7815	0101000020E61000000248B45FA70D54C00FA314A99DDC3940	0101000020BC080000CCAB9C8847EB2B4144CEC5398AF92041
261	10382	NW 173 DR	NW 72 AV	W	N	Y	0	0	0	11/11/2016 11:5	25.92881	-80.3177	880406.443566605	580400.094812706	58fc2bc3-a1d1-43ab-8a56-fb0c193bd883	0101000020E6100000764BCA3D551454C08F143CCDC6ED3940	0101000020BC0800002D2AF2142BDE2A41C6CB459D63B62141
262	8756	NE 12 AV	NE 146 ST	S	F	N	0	0	0	11/4/2016 13:06	25.9096	-80.17533	927241.851226084	573686.092150509	3a9374a1-9e24-4fad-9bdc-fb88687b7ac5	0101000020E6100000298EF2AE380B54C0E63155B9DBE83940	0101000020BC0800008F39A0EB114C2C416A412A9BEF812141
263	6959	NW 2 AV	NW 32 ST	N	F	Y	1	1	0	11/3/2016 16:13	25.80677	-80.19919	919625.731278732	536263.970172383	0c3211a5-9c8c-41b8-a1a1-cfc541b79c43	0101000020E6100000D9F470A3BF0C54C005FE6A0C89CE3940	0101000020BC080000E7AA6EAD91102C41FE70C657935D2041
264	8629	NE 10 AV	NE 181 ST	S	F	N	0	0	0	11/1/2016 12:59	25.94169	-80.18073	925395.805068392	585338.16039221	f240cb59-32f4-4f35-9e60-f22b77166ae1	0101000020E6100000C08F070F910B54C0AB65C4A412F13940	0101000020BC080000640BC2D3A53D2C4163D77CBFF7DC2141
265	2551	NE 8 ST	NE 1 RD	W	N	Y	0	0	0	8/17/2016	25.47731	-80.46784	831726.844741814	416073.508439995	fcaaf54c-3dc8-4f4d-9d64-8b9f1be95931	0101000020E610000091D934ECF01D54C084A23B4A317A3940	0101000020BC0800006FDB36DCDB612941FCB928B72C651941
266	9954	NW 83 ST	NW 1 AV	W	F	N	0	0	1	11/2/2016 11:12	25.85111	-80.19932	919486.490728397	552377.397937879	e2d0c24c-063b-40e4-93f2-633a455baac7	0101000020E61000003B3ABDAFC10C54C0AA6EEB74E2D93940	0101000020BC080000E6D423327B0F2C418E88D63476DB2041
267	4569	SW 24 ST	SW 63 AV	W	N	\N	0	0	0	9/14/2016 14:54	25.74826	-80.29732	887456.036801048	514811.613470919	7e4863d8-74f9-44d3-8831-7ad1154d4376	0101000020E61000006C6B724D071354C003D05A358EBF3940	0101000020BC08000087B0A2453E152B41B1029F3CF56B1F41
268	9469	HIALEAH DR	E 3 AV	W	F	N	1	0	0	9/23/2016 13:17	25.82293	-80.27564	894440.729520433	541989.264474913	e3ef2b87-95aa-4dbd-a3a0-b404245735cb	0101000020E6100000D34F4636A41154C0A0FAD6A6ABD23940	0101000020BC080000300239A9CF4B2B41632522EF4D8A2041
269	3626	SW 197 ST	SW 113 AV	E	N	N	1	1	1	11/15/2016 15:2	25.58337	-80.37517	862112.615019836	454753.693560019	7d763003-76a1-4f23-9174-00c35675eb8e	0101000020E6100000BE53DDDC021854C07BCE061B58953940	0101000020BC0800002A09926A3F4F2A418810CC7E8DC11B41
270	2493	WASHINGTON AV	NE 6 ST	S	F	N	0	1	1	8/17/2016	25.47507	-80.47639	828903.8080847	415246.386718467	c8bf0112-59fb-48c7-acf3-359ae6dde069	0101000020E61000007533D1487D1E54C0D35D61299E793940	0101000020BC080000971617C9CD4B29413AEC513A40581941
271	2429	W 65 ST	W 1 AV	W	N	Y	1	0	0	9/23/2016 11:35	25.88151	-80.28462	891372.742846217	563264.20882193	51fe9a4c-bf4d-493c-9a03-9eee3171bae4	0101000020E6100000C129FA3D371254C02724D79EAAE13940	0101000020BC080000451095AFD7332B417F6E59D583302141
272	8860	NE 123 ST	BISCAYNE BD	E	F	N	2	0	1	10/31/2016 16:5	25.88933	-80.16268	931450.502902899	566346.653415836	10247420-582b-41b7-a8b9-980962f3b3cc	0101000020E6100000A7CA0943690A54C0FF0AF6A2ABE33940	0101000020BC08000021C8F039F36C2C417FD185B998482141
273	8500	HAMMOND DR	GLENDALE DR	S	N	N	0	0	0	11/8/2016 14:20	25.81364	-80.3014	885987.354997355	538568.319910251	33b80d20-5dca-4501-9199-5c4a6a736a77	0101000020E61000006C3805224A1354C077438D154BD03940	0101000020BC080000A93268E8C4092B41F6BC090B946F2041
274	286	NW 36 ST	NW 32 AV	W	N	Y	1	1	0	11/7/2016 13:17	25.80894	-80.24797	903572.060322952	536956.552452475	ee4cc2bb-7ae4-472b-ae05-178eea0dde5f	0101000020E6100000A875D9DDDE0F54C0B980DDFF16CF3940	0101000020BC0800007632C25326932B412CBBF181FC622041
275	3733	SW 268 ST	SW 142 AV	W	N	N	1	1	1	10/4/2016 17:11	25.51807	-80.42051	847272.545638431	430953.285125658	36873855-d09e-40ce-881a-d15022942c2c	0101000020E6100000436213AAE91A54C062E54CABA0843940	0101000020BC08000078D819454FDB2941623E62D6AB4D1A41
276	2332	W 21 ST	PALM AV	W	F	N	1	0	0	10/19/2016 11:3	25.8409	-80.28246	892164.55982738	548508.084812425	00c6c2cf-dc1a-431f-b2dd-110d4a3008b0	0101000020E6100000EB44B0CD131254C0AD2DB54445D73940	0101000020BC0800000D940452073A2B412FFDFF933BBD2041
277	6181	NW 15 AV	NW 163 ST	N	N	N	0	0	0	10/17/2016 13:5	25.92183	-80.22496	910901.137167934	578032.195686676	b1f39faa-a853-4746-b72a-54901809436e	0101000020E6100000507150D2650E54C091407D4BFDEB3940	0101000020BC0800002399F27B68CC2B412206A7D0E3A32141
278	3740	SW 268 ST	SW 139 AV	E	F	N	2	1	0	8/17/2016	25.51795	-80.41654	848582.331043031	430915.397713035	f61c3e49-c97f-4dd7-8339-98154a9118fd	0101000020E6100000C69D7D9AA81A54C0DF0509CE98843940	0101000020BC080000B2EE60D78AE5294108E49E49144D1A41
279	2498	KROME AV	NW 11 ST	S	N	Y	0	0	1	10/4/2016 15:05	25.4809	-80.47756	828510.497866705	417363.725055739	2cd4947f-f0ea-482f-a3e1-f1d856eac961	0101000020E6100000CD6E9267901E54C0FDA3913C1C7B3940	0101000020BC0800005A943F2ABB482941BCA0219555791941
280	2571	W MOWRY DR	NW 5 AV	W	N	N	0	0	0	8/17/2016	25.46982	-80.48436	826285.471462846	413330.635333009	d215c774-7cff-4f64-b142-1096c0c68131	0101000020E610000061024BAFFF1E54C0BF68648E46783940	0101000020BC080000F8A7671C59372941B4B62A38513A1941
281	5134	NW 79 ST	NW 17 AV	E	F	Y	1	0	1	10/20/2016 12:2	25.84642	-80.22469	911155.085178189	550625.248212121	48fc9445-d389-4e93-a7f3-258573f06127	0101000020E61000006064E63B610E54C073AF308DAFD83940	0101000020BC080000CB6A806164CE2B41291DEBE7C5CD2041
282	2380	W 49 ST	W 8 AV	E	M	N	1	0	1	10/14/2016 12:1	25.86653	-80.29704	887319.905811511	557798.154815555	4cf32d67-b4f7-4ac3-9b9f-e389ef4a9a19	0101000020E6100000130346A6021354C0187B9F05D5DD3940	0101000020BC080000625C90022E142B41B42801B9CF052141
283	2003	E 4 AV	E 11 ST	N	N	Y	0	0	0	10/19/2016 14:3	25.83187	-80.27358	895103.71866782	545243.125109591	1064b093-f186-4e75-b10e-4ddb8a10dacb	0101000020E6100000F836104C821154C0E7ADBBACF5D43940	0101000020BC08000039DEB3A3FD502B418ADC33A8B9A32041
284	268	SW 275 ST	SW 140 AV	E	N	N	0	0	0	10/23/2002	25.51125	-80.41892	847808.398895826	428476.893761225	771920eb-6009-4298-a74a-0d92c5e3d371	0101000020E6100000EFB7BD94CF1A54C0CE13A9B6E1823940	0101000020BC0800005F1C14FA7EDF2941F014C644FA261A41
285	8412	NE 6 AV	NE 103 ST	S	N	N	0	0	0	11/7/2002	25.87018	-80.18565	923938.356508255	559338.24064739	7434f3f1-be3c-41de-b39d-09bf6af100db	0101000020E610000098AC2BC4E10B54C08590678EC4DE3940	0101000020BC0800001C6C0EEE42322C418A5141E5D7112141
286	9631	NW 10 AV	NW 62 ST	N	N	Y	0	0	0	9/23/2016 13:52	25.83197	-80.21247	915203.687981583	545395.191395164	a9c6b7d7-8334-4199-8557-267a54358e60	0101000020E6100000C47AA81E990D54C04CD67B3AFCD43940	0101000020BC08000000FF8E9605EE2B41CC333BCAE9A42041
287	3425	SW 170 AV	SW 298 ST	N	N	N	0	0	0	10/4/2016 14:55	25.48989	-80.46712	831942.780033581	420645.790330917	fd335eb4-5f0f-48fc-b157-5ccc6ec2d523	0101000020E6100000AE8F3F4AE51D54C0426D1B9A697D3940	0101000020BC08000070F025BB8B6329418661D1D89DAC1941
288	5746	NE 6 AV	NE 177 ST	N	F	Y	1	0	0	10/26/2016 14:3	25.93787	-80.18854	922836.134302579	583934.785907321	46ad3bbf-75f0-411e-9b38-20590cd03077	0101000020E61000007B938719110C54C08DBF1C7E18F03940	0101000020BC08000007FDF27BA6292C419B35A0FF00D22141
289	4107	SW 40 ST	SW 88 CT	W	F	Y	1	0	1	10/13/2016 12:3	25.73318	-80.33843	873949.715370361	509259.5812691	dbab6da2-7713-448d-8615-89a2e6ece84a	0101000020E61000004EFD7EF2A81554C0D87B85BAB1BB3940	0101000020BC08000068045C9FB9AB2A41FBE1181A35151F41
290	7685	NW 54 ST	NW 10 AV	W	F	Y	1	0	1	10/19/2016 13:0	25.82489	-80.21242	915233.566826776	542823.012184687	ff44a583-1bc5-4c04-b577-a4be96ed7689	0101000020E6100000266E1B66980D54C0E9CB166E2CD33940	0101000020BC080000C86E875841EE2B4196E10C6ED1902041
291	3223	SW 117 AV	SW 192 ST	N	N	Y	1	0	0	11/17/2016 17:4	25.58765	-80.38049	860351.816672817	456300.302342437	c5d15e57-1702-4447-bd95-4b9fa0f13edd	0101000020E6100000B4D891065A1854C0E888F87770963940	0101000020BC080000D58893D17D412A412B5187EEB7D91B41
292	3170	SW 112 AV	SW 232 ST	S	N	N	0	0	1	10/4/2016 14:52	25.55185	-80.37217	863154.634233799	443303.937559627	7d4c8ec8-672e-49c8-a3a6-3dd6cf62248a	0101000020E61000000A4088C2D11754C0A85C25AC468D3940	0101000020BC080000A6B4807463572A418C74AC75A60E1B41
293	5657	NE 135 ST	NE 2 CT	E	N	Y	1	0	0	10/18/2002	25.899	-80.19388	921167.418157268	569794.626557462	12180a4f-ad4d-4e25-bef5-3893852f15a6	0101000020E61000006F35809F680C54C02BD93BE924E63940	0101000020BC0800001040390D9D1C2C41C28246AC88632141
294	7761	NW 36 ST	NW 7 AV	E	N	Y	1	0	1	11/7/2016 12:32	25.80995	-80.20808	916696.886080179	537400.662437901	2a255524-7d2f-4d34-9802-60f961408047	0101000020E6100000B7F91125510D54C0C9C4DC3059CF3940	0101000020BC0800003E8235FCAFF92B412D1C46BA74662041
295	5854	NW 183 ST	NW 57 AV	E	N	Y	1	0	0	12/4/2002	25.93926	-80.29633	887410.876112327	584236.59239389	3532deb6-d3e3-484a-9fc7-93a37475be0d	0101000020E610000089B9B60CF71254C0F32285D973F03940	0101000020BC080000C2A845F3E3142B41EA30769C5CD42141
296	6507	NW 183 ST	NW 5 AV	E	N	N	0	0	0	9/20/2016 12:21	25.94224	-80.20935	915988.136197533	585483.163691603	32838075-aff9-49e5-bf2c-b2cf15571539	0101000020E61000009394A104660D54C0F016743637F13940	0101000020BC08000017120B7C26F42B41E7914DC119DE2141
297	4954	NW 32 AV	NW 41 ST	S	N	Y	0	0	0	9/1/2016 13:58	25.81268	-80.24859	903363.284512952	538314.038568765	67468de0-7d74-4b01-a450-0968860b25b1	0101000020E6100000E1A091E0E80F54C0D3A01BF90BD03940	0101000020BC080000EF218FC684912B419A2AFA7A976D2041
298	5840	NW 173 DR	NW 53 CT	W	N	N	0	0	1	10/26/2016 14:0	25.93134	-80.28759	890302.087843943	581372.729360506	0c88571c-7e7f-441d-a974-1de71be7d51d	0101000020E6100000CE558AB0671254C0037363AC6CEE3940	0101000020BC080000404B0E607A2B2B4105A34FE2FCBD2141
299	2403	W 49 ST	W 6 AV	W	F	N	1	0	0	10/14/2016 16:0	25.86678	-80.29525	887905.736673817	557891.437110335	096e445e-a9ac-4170-879a-95df744fe6f7	0101000020E6100000AEE0D36FE51254C02B306246E5DD3940	0101000020BC080000A3F2FBABC1182B41FDD38B498A062141
300	2094	PALM AV	W 6 ST	S	F	Y	1	1	1	9/22/2016 14:13	25.82695	-80.28156	892486.967303619	543439.356724933	73ae590d-48f5-4bfb-99ab-74db78c29fac	0101000020E6100000C73E971F051254C04CE17B0AB3D33940	0101000020BC0800003C84A5228C3C2B4149418D1EA2952041
301	8165	SW 8 ST	SW 64 AV	W	F	Y	1	1	0	9/8/2016 10:46	25.76327	-80.30032	886438.934143659	520262.98939167	913fd708-ff37-4778-a83e-767ddbbc574f	0101000020E6100000F03AC07C381354C05C1FC01966C33940	0101000020BC080000347405114C0D2B4129BDD6BE22C11F41
302	1718	MILLER RD	SAN AMARO DR	E	N	N	0	0	0	10/12/2016 17:2	25.71905	-80.2824	892424.555355605	504221.386297062	6da932ed-43e7-47bb-88e0-aac503c13fab	0101000020E61000008A329ADE121254C029C5C1E613B83940	0101000020BC0800006102C34F0F3C2B41D45D50517CC61E41
303	6843	NE 1 AV	NE 14 ST	N	F	Y	0	0	0	9/6/2016 14:48	25.78877	-80.19219	921969.267282445	529732.351966351	a78c94c9-b65f-47bf-8cde-2ef94b69cef1	0101000020E6100000640C1DEF4C0C54C0789678CFECC93940	0101000020BC080000E2301EC0E0222C4100C0701A8C2A2041
304	5063	NW 103 ST	NW 33 AV	E	F	Y	0	0	0	10/14/2016 13:1	25.86757	-80.25321	901732.977384817	558256.095813885	a52706a2-4b0a-4409-931f-eeaa626b2b39	0101000020E61000009B57846C341054C01149BB3E19DE3940	0101000020BC0800005CD91029C8842B419AE1EB9A63092141
305	3568	HIBISCUS ST	HOMESTEAD AV	NW	N	Y	1	0	1	11/17/2016 10:0	25.60514	-80.35336	869264.223399516	462698.26919353	2549899e-f857-4843-b758-3ab1548558e6	0101000020E61000004C164C769D1654C0F626756EEA9A3940	0101000020BC080000798CDDA21E872A41C5D86BCEAF3D1C41
306	6457	NW 175 ST	NW 22 AV	W	N	Y	1	0	1	10/26/2016 12:4	25.93409	-80.23667	907027.258115456	582465.052276589	c49e903d-a0fd-4d67-9d25-2c23a1e1c0aa	0101000020E61000002A0A0CA1250F54C0611DA6A220EF3940	0101000020BC08000004215AB924AE2B411B34CA8785C62141
307	2257	W 24 AV	W 60 ST	N	N	Y	0	0	0	10/19/2016 14:1	25.87614	-80.33122	876061.541507404	561232.341795221	15ddca6c-eac1-4205-9cf3-6973d317661b	0101000020E610000074D635B4321554C03BA0B3D24AE03940	0101000020BC0800003627924639BC2A416AD02219A4202141
308	5101	NW 95 ST	NW 7 AV	W	F	N	1	0	1	10/14/2016 15:4	25.86192	-80.21018	915894.487798251	556284.910105117	9a2b4383-b4ab-491e-9be4-5a774525d717	0101000020E6100000BF1DF473730D54C01552ABE6A6DC3940	0101000020BC08000048DC20306BF32B41EF359D3BFDF92041
309	9199	COLLINS AV	175 TE(#17555)	N	F	N	1	1	1	10/11/2016 13:2	25.93919	-80.12131	944932.986778818	584556.073739007	e9418f63-c8ee-42af-8094-f7657200e1e6	0101000020E61000001F724757C30754C0C568BCCD6EF03940	0101000020BC080000B3414B3348D62C4157172793DBD62141
310	9742	SW 216 ST	SW 92 AV	W	N	N	0	0	0	12/12/2016 15:3	25.56503	-80.34137	873287.612359416	448140.830789104	0f1c4e84-d72e-49cc-8137-87f8599d0a8d	0101000020E6100000F654C308D91554C0B31579FAA5903940	0101000020BC0800004A8FAA6A8DA62A4157BD87093A5A1B41
311	5395	BISCAYNE BD	APPROX # 11200	S	N	N	1	1	1	10/8/2016	25.88008	-80.1673	929951.237534303	562974.11786814	3f352235-0198-4332-9410-720d99134d51	0101000020E61000003439B309B50A54C000811C4C4DE13940	0101000020BC080000F8A3D3B13C612C4181EFCFA63F2E2141
312	5228	NW 54 ST	NW 22 AV	E	F	Y	1	1	1	10/19/2016 13:1	25.8241	-80.23209	908766.685080729	542496.893717207	3a1354bf-c299-4210-bf02-85bfb102ebfc	0101000020E610000072C3EC92DA0E54C0D20B8686F8D23940	0101000020BC08000030274294BBBB2B41F7515F31458E2041
313	5456	N MIAMI AV	NE 154 ST	N	N	Y	0	0	1	11/3/2016 17:16	25.9157	-80.19972	919211.781321853	575853.240389146	3e9a3c5b-3c25-407e-8a1e-59598ef0caad	0101000020E6100000F4EB773DC80C54C08326936D6BEA3940	0101000020BC0800003EB7E0C6550D2C41844233E7DD922141
314	4649	SW 56 ST	SW 67 AV	E	N	Y	1	1	1	10/12/2016 17:2	25.71827	-80.30262	885767.432563365	503902.933504291	6f2b67db-c4d8-4209-9898-1548067d42d3	0101000020E610000012CF3A385E1354C01FC510EAE0B73940	0101000020BC08000041D113100D082B4148B85B8182C11E41
315	1972	E 8 AV	E 41 ST	S	F	Y	1	0	0	2/15/2017 12:39	25.85952	-80.26677	897285.040057234	555307.207337432	a9144d20-f97f-4510-87c4-72f8afbc35a3	0101000020E6100000991968DA121154C0FF98C3120ADC3940	0101000020BC080000E68D764808622B41D8E1A0D359F22041
316	6773	NE 2 AV	NE 31 ST	S	F	Y	1	0	1	11/4/2016 11:24	25.80622	-80.19122	922250.126615573	536079.740536943	32f112d0-2f7c-48b5-8ded-68caede73ac6	0101000020E610000029773F023D0C54C049992EF064CE3940	0101000020BC080000778C1A7812252C4137CB39E2225C2041
317	8920	NW 125 ST	NW 16 AV	W	N	N	1	0	0	10/31/2016 12:5	25.88866	-80.22478	911031.231773607	565978.010778196	e025abab-c3ab-4473-ac8a-abf634c27ec8	0101000020E6100000839587E3620E54C01FD5FBCA7FE33940	0101000020BC080000928566AC6CCD2B41B11E7770B7452141
318	1732	INGRAHAM HY	BRIGHTON PL	W	N	N	0	0	0	8/29/2002	25.70731	-80.25946	900002.671454005	499994.988868251	aa9e71f4-e519-4261-9a29-fa0a1ef28413	0101000020E6100000340A76F49A1054C02899DA4F12B53940	0101000020BC08000054E1508C43772B41A35209B972841E41
319	10225	NW 41 ST	# 10783	W	N	N	1	0	2	11/8/2016 15:38	25.81179	-80.37131	862990.888837192	537778.456996135	e07f2a26-75d2-486a-ac34-a1ed37916622	0101000020E610000056614A92C31754C0CE389394D1CF3940	0101000020BC0800007AC0A3F61B562A412BD9265168692041
320	9940	NW 7 AV	NW 84 ST	S	F	N	1	1	1	9/20/2016 11:27	25.85188	-80.20947	916150.5741859	552639.98827894	1b79e69c-eac7-465d-bc33-f4ed54167d1c	0101000020E610000061C19AC9670D54C035749B7115DA3940	0101000020BC080000DEAA6F5C6BF52B41AB072C6383DD2041
321	7732	NW 36 ST	NW 20 CT	W	F	Y	1	1	0	11/7/2016 12:46	25.80948	-80.22995	909500.119339246	537185.660272285	dbc83265-888d-40d5-892a-d0dda05a8ecb	0101000020E6100000EB201598B70E54C0B0BC76203ACF3940	0101000020BC080000D1CAAC7276C12B41F4EA36B9C6642041
322	8655	NE 163 ST	NE 35 AV	SW	N	N	2	0	1	11/3/2016 13:12	25.92917	-80.13435	940666.935954954	580887.636806808	fb53259d-2770-4812-abce-fdc29747bc6c	0101000020E61000001DCBBB37990854C0108EA786DEED3940	0101000020BC08000064CDD818F4B42C418CF5E6B232BA2141
323	4495	SW 87 AV	SW 53 ST	S	N	Y	1	0	1	11/9/2016 17:09	25.71995	-80.33519	875042.843087301	504458.958616503	0d2f68ca-ba88-4fbe-a598-c7ae71001fa0	0101000020E6100000743196BF731554C0A11955254FB83940	0101000020BC0800000688DFE043B42A41CDC0189B32CA1E41
324	6623	NW 215 ST	# 400 (OP BC 62 AV)	E	N	N	0	0	0	10/28/2016 16:3	25.97241	-80.21048	915550.983204119	596444.41739697	0c7efb4a-dc3c-4269-9e3a-cad25344b1a0	0101000020E6100000D9030184780D54C04749C0F9EFF83940	0101000020BC080000F7D2A52DBCF02B41105B9E44BC332241
325	3588	SW 184 ST	SW 115 AV	W	N	Y	1	0	0	11/17/2016 11:4	25.59777	-80.37855	860976.308233418	459982.858642019	0e21055b-613e-417c-9816-2464cd66b6fa	0101000020E6100000D8FB42203A1854C0EA318DF407993940	0101000020BC0800006FA841CD5E462A41EC97192942131C41
326	6319	NW 37 AV	NW 196 LA	S	F	Y	0	0	0	11/10/2016 13:4	25.95199	-80.262	898666.18923106	588924.944886401	67d12600-3a5f-4b7c-b06b-4e174a16f9d7	0101000020E610000047969A9EC41054C0E61BFCFDB5F33940	0101000020BC08000045A00D95D26C2B4151F59351FDF82141
327	6785	NE 2 AV	NE 10 ST	S	F	Y	1	0	0	11/1/2016 14:02	25.78353	-80.19068	922479.477561478	527833.02376464	f2390c37-6ca0-42cc-beac-eee1099bf153	0101000020E61000000688BC1C340C54C02F507ECB95C83940	0101000020BC080000BC83EB2BDD262C41507A1272B51B2041
328	3079	SW 102 AV	SW 112 ST	S	N	Y	1	1	1	9/29/2016 13:17	25.66549	-80.35936	867183.092420053	484623.713554971	55d7889c-1221-4466-823a-319d2f34820e	0101000020E6100000D9A6C5A6FF1654C0E1773EA95DAA3940	0101000020BC0800002F1CA05FDC762A410811FD9A45941D41
329	2207	W 12 AV	W 55 ST	S	F	Y	1	0	0	10/10/2016 14:3	25.8722	-80.30715	883981.210711975	559842.046047688	e876b9c0-8392-4f8b-b84c-e84dd50078e3	0101000020E61000006DADA474A81354C0B2FC01BE48DF3940	0101000020BC080000A1B3399E18FA2A41897C8981C7152141
330	3966	SW 137 AV	SW 34 ST	S	F	Y	1	0	0	11/29/2016 13:4	25.73556	-80.41609	848381.457743384	510005.774961449	62177802-8a4c-4901-a0df-03fde8e437f4	0101000020E6100000D2687643A11A54C0607B27084EBC3940	0101000020BC080000EC7F2D18F9E32941933C60E0DD201F41
1406	11208	US 1	33000 Blk	N	F	\N	\N	\N	\N	 	25.45846	-80.47502	829380.877351299	409212.545140319	70697bfe-1ac9-4f5b-9899-f3dcf660c928	0101000020E6100000E2C7D6C5661E54C04B7911CE5D753940	0101000020BC08000023B9B0EC874F2941DE1BE0DAF8F91841
331	9795	SW 146 ST	SW 107 AV	W	N	N	1	0	0	11/17/2016 12:3	25.63399	-80.3663	864947.661854651	473166.487135604	c5e6761b-5686-435a-b916-f85b4643c1ef	0101000020E6100000A654C591711754C0389240BC4DA23940	0101000020BC080000787CE88265652A417F5732B040E11C41
332	1029	SW 132 AV	SW 6 ST	N	F	N	1	0	1	1/5/2017 10:41	25.76208	-80.40974	850429.686936431	519652.454841793	c9e518b7-5d61-4af5-9c08-41d7b45e6c4b	0101000020E6100000D6E00B2D391A54C0BF70EDC817C33940	0101000020BC080000DD36AE8DF9F32941BDC8279B98B71F41
333	3035	SW 87 AV	SW 193 TE	S	N	Y	1	0	1	10/4/2016 16:26	25.58746	-80.332	876339.813953672	456309.19534789	918a61bf-0600-4e4a-bc42-184620b3cb1f	0101000020E610000015B2994D3F1554C0CCF5151564963940	0101000020BC080000306049D265BE2A4142770F81DBD91B41
334	7569	NW 57 AV	W FLAGLER ST	S	N	Y	1	0	0	12/1/2016 11:28	25.77096	-80.28822	890406.534816321	523079.69501999	3507b5b3-4f38-4d84-ab01-f504ae3b7322	0101000020E6100000D0277639721254C0A4865B235EC53940	0101000020BC0800009DC70F454B2C2B41B38F339225ED1F41
335	110	W FLAGLER ST	NW 107 AV	W	F	Y	2	0	1	9/28/2016 11:58	25.76861	-80.36975	863579.878514558	522086.036889717	8a28ecd9-9808-437d-b776-0a0f2eaf0dd8	0101000020E61000001830C7FAA91754C03A39A29AC3C43940	0101000020BC080000529994F1B55A2A41092EEDEF9EDD1F41
336	5006	NW 72 AV	NW 50 ST	S	M	N	0	0	1	10/10/2016 16:5	25.81911	-80.31369	881934.792541023	540533.732931048	15177a35-a3cc-4109-b361-d82ad890d248	0101000020E6100000CB077371131454C07E46D64DB1D13940	0101000020BC0800009D8ADEC71BEA2A41B629D3DEEE7E2041
337	4297	SW 88 ST	SW 93 CT	W	F	N	1	1	1	9/29/2016 12:07	25.68777	-80.34512	871835.105077773	492747.360021479	4a7c2b3a-4ff1-4d85-bb04-69a9190a6321	0101000020E61000003BFEE442161654C07ABCEE5312B03940	0101000020BC08000034E5B466349B2A41F61D3F3334131E41
338	5687	W DIXIE HY	NE 189 ST	S	F	N	0	0	0	11/12/2002	25.95001	-80.14893	935826.696266133	588430.756585874	6c1870c8-786a-4c4e-8796-c6950503f1a8	0101000020E610000083FB1F0C880954C0DF60243B34F33940	0101000020BC0800001EA76D9D238F2C41A9402FF120F52141
339	8918	NW 125 ST	NW 13 AV	NW	N	N	0	0	0	10/31/2016 12:5	25.88917	-80.22061	912402.467504315	566168.60264308	8a83edf3-2f37-4a9e-b9dd-15bf3be43314	0101000020E6100000D3CE7F801E0E54C0495B24B1A0E33940	0101000020BC080000C789522523D82B417F97689F34472141
340	83	SW 8 ST	SW 42 AV	W	N	N	0	0	0	9/8/2016 13:31	25.76453	-80.26301	898714.260639284	520788.952858053	1442a2b0-1d85-4e20-aa0f-662f26660df4	0101000020E61000003FF33148D51054C0EBA765DFB8C33940	0101000020BC080000958EBAB9326D2B41F533D4995AC91F41
341	10271	OLD CUTLER RD	LUGO AV	N	N	N	0	0	0	7/26/2006	25.65256	-80.28562	891499.603151362	480050.456266046	29d4f25a-4f81-4eaf-aaac-36e016bbe217	0101000020E61000002FA48965471254C0AFFCB09B0EA73940	0101000020BC080000A2744268D5342B411EA06892D04C1D41
342	584	N MIAMI AV	NE 183 ST	N	F	N	1	1	1	10/26/2016 12:3	25.94319	-80.20105	918712.690806564	585842.467770837	fb0d62f4-2163-448d-8989-2fbb3c491cae	0101000020E610000031EB7A14DE0C54C0E0625D0375F13940	0101000020BC08000092FC67986F092C417B3DFD5CE8E02141
343	7577	NW 57 AV	NW 5 ST	N	N	Y	1	0	0	11/30/2016 15:2	25.77601	-80.28819	890406.165063355	524914.864917465	06b941e1-882b-4493-8bb8-5156fadc7332	0101000020E61000009545D4BF711254C049B68807A9C63940	0101000020BC08000099DCB0874A2C2B4180085020E9042041
344	2347	E 25 ST	E 5 AV	W	N	Y	1	0	0	10/20/2016 13:5	25.84489	-80.27195	895613.336700484	549979.140256539	535affc8-8dab-4db9-b142-6870138a07a5	0101000020E6100000544E8A9B671154C03191B3154BD83940	0101000020BC0800000EAE41E0F8542B4142B390B0B9C82041
345	2821	ALTON RD	47 ST	SW	F	Y	1	0	0	8/30/2002	25.82242	-80.13587	940423.106330857	542081.920491956	37c726e7-aa07-416f-ba01-8ec32f1361f1	0101000020E6100000C398E01AB20854C045034B4B8AD23940	0101000020BC0800004C1EFF6F0CB32C41714A303F078B2041
346	1414	NW 215 ST	SW 59 TE	W	F	N	0	0	1	10/28/2016 11:5	25.97288	-80.20483	917405.246206217	596626.487896509	e288af11-2f26-410d-860b-8a56ba6ae581	0101000020E6100000C5A0C3FE1B0D54C0889008C70EF93940	0101000020BC080000B80093B438FF2B4144CCA56828352241
347	231	NW 47 AV	NW 199 ST	S	N	N	1	1	1	8/31/2016	25.95519	-80.27832	893300.638899311	590057.813058294	60ef42f2-73ee-47ec-9047-f30c9957b4b0	0101000020E6100000100588D3CF1154C0F40A4FA487F43940	0101000020BC080000C90E8F7AE7422B41AB44360ED7012241
348	6416	NW 167 ST	NW 44 AV	W	F	N	0	0	0	8/31/2016	25.92573	-80.27314	895057.901821703	579357.904624164	7c72d806-3564-4087-ac6d-0d4addad1b1f	0101000020E61000000F2C8E2B7B1154C038684CB0FCEC3940	0101000020BC080000CC295801A2502B411F85D03B3FAE2141
349	9888	ALTON RD	DADE BD	S	F	N	0	0	0	 	25.79291	-80.14142	938665.686021272	531343.184096314	10ab3651-bd42-4642-a664-3472d697e73c	0101000020E610000090B43C1E0D0954C04656F531FCCA3940	0101000020BC080000AD29A09851A52C413CE4ABC421372041
350	230	BUSWAY	SW 200 ST	SW	F	Y	6	1	2	9/29/2016 13:19	25.57951	-80.36943	864011.591522183	453359.007703692	060ca557-756f-4b7a-905c-43c435c572cc	0101000020E6100000D38D5BCDA41754C0EF2C68015B943940	0101000020BC080000BE71BD5E155E2A41BB9D44C0C2AB1B41
351	6571	NW 199 ST	NW 7 AV	W	F	Y	0	0	0	10/26/2016 14:5	25.95681	-80.21493	914124.282641388	590765.780471206	30b13cb9-4b5e-4abf-bcb4-5eb6538966fc	0101000020E61000009B96E15BC10D54C0BB60E0ADF1F43940	0101000020BC0800000E42E2C696E52B412AE5B3FD5E072241
352	6339	NW 42 AV	NW 200 ST	N	F	N	1	0	1	8/31/2016	25.95555	-80.27004	896019.321179554	590205.195282102	4fd52064-059c-4633-862f-8f0711637073	0101000020E6100000BFD8753B481154C02CC0387F9FF43940	0101000020BC0800005F8E3AD824582B41C1F6EBD1FD022241
353	9356	SW 112 AV	SW 2 ST	N	F	N	1	0	0	10/27/2016 19:2	25.76676	-80.3768	861261.887043584	521403.692828953	2486f1ff-8564-48ce-bbd3-f230b6e8972b	0101000020E61000003F8136891D1854C0D1661B8F4AC43940	0101000020BC080000EAB1A2F599482A41E646508FF5D21F41
354	3643	CARIBBEAN BD	SW 103 AV	E	N	N	1	0	0	12/12/2016 14:1	25.57634	-80.36129	866701.597000349	452218.260296121	cc8cac8f-7b4e-494e-9c28-7b1beb40a0b4	0101000020E61000006F90EF5E1F1754C0AF6083FE8A933940	0101000020BC080000DE26F96119732A413F3497C2EF991B41
355	5313	FOUNTAINEBLEAU BD	NW 9 ST CR	E	N	N	1	0	0	9/6/2012 12:55	25.77495	-80.36412	865421.601493903	524401.443046443	85aab1e1-2c81-46fd-8f26-a06275745e5a	0101000020E6100000091CD7BC4D1754C07181E27E63C63940	0101000020BC0800006417F96319692A41FC2C2D48E6002041
356	2222	W 16 AV	OP # 3000	N	N	Y	1	0	0	10/3/2016	25.84886	-80.31427	881685.95250633	551345.404891998	63ae78d1-dc07-4d8e-8278-03bf4ad5d06b	0101000020E6100000FDE71F071D1454C0D6B35CEF4ED93940	0101000020BC08000004A9A1192AE82A412741353866D32041
357	6652	SE 2 ST	SE 2 AV	W	F	Y	0	0	1	11/22/2002	25.77264	-80.19089	922438.967783831	523873.378127635	ee7f03f5-df87-44a3-8c79-0e20b93ed619	0101000020E61000009A400457370C54C01EB23DE9CBC53940	0101000020BC0800009CB7C5268C262C411AAE094E8CF91F41
358	7552	SW 42 AV	VENTURA AV	N	N	N	0	0	0	42690.70069	25.71812	-80.26122	899403.131991051	503921.849155173	41b5644d-435b-41d6-b771-2f03af010a94	0101000020E61000005F4A46B1B71054C0961AF2F3D6B73940	0101000020BC080000D05EFB7794722B4116031F2BCEC11E41
359	1388	AVENTURA BD	# 2845	W	F	Y	1	0	1	12/13/2002	25.96058	-80.1445	937256.346612092	592282.932246372	e5d1e8c9-c660-4d0d-bdd8-7a1a6e3bdd92	0101000020E610000056D3EF833F0954C0D432EB13E9F53940	0101000020BC080000A1C796EA4E9A2C410799AE4B39132241
360	9166	SW 77 AV	SW 128 ST	N	N	N	1	0	0	11/30/2016 16:0	25.65162	-80.31796	880843.129053377	479651.487909265	31c1b58f-53b9-406b-8926-0b870324e8bf	0101000020E6100000FE2C177C591454C0E45CC5CED0A63940	0101000020BC080000989F137494E12A41ED6FB5B294461D41
361	4165	SW 47 ST	SW 135 CT	W	N	N	0	0	0	9/26/2016 13:18	25.72154	-80.41277	849498.365646139	504915.370153517	bf5118c7-ba5b-428c-a3df-744c4a90d881	0101000020E6100000198097CD6A1A54C0F8614E48B7B83940	0101000020BC080000CA3F23E9B2EC294115C8AB4054D11E41
362	6883	S BAYSHORE DR	PAN AMERICAN DR	SW	N	Y	0	0	0	9/18/2002	25.72994	-80.2364	907546.58747891	508264.808658853	34057a10-72e5-4d0c-a9ba-aa419f34c2b7	0101000020E6100000DD1DC238210F54C08E9979A7DDBA3940	0101000020BC0800005AE43D6233B22B41A572D502AA051F41
363	2121	W 2 CT	OP # 7575	S	N	N	0	0	0	9/23/2016 12:08	25.89145	-80.28874	889998.524118677	566870.074972115	743a7299-00c0-4761-ac68-1fbd0b6d4ea5	0101000020E61000002E6C83BE7A1254C03B9C2C1D36E43940	0101000020BC0800004990723F1B292B4156774F91AF4C2141
364	8774	W DIXIE HY	GRIFFING BD	NE	M	Y	1	0	0	9/30/2016 13:12	25.88719	-80.19019	922406.996733189	565510.938932292	3385e560-e355-4432-8ee1-2ab2308962fe	0101000020E6100000E226832A2C0C54C0A7D05C311FE33940	0101000020BC0800003BF08C354C262C41B7578E4B11422141
365	6697	BISCAYNE BD	# 4870	S	M	Y	1	1	1	11/8/2016	25.82034	-80.18771	923372.605660114	541218.304442056	2f1c30d2-0ed0-4a01-a6eb-2aad560ba1c7	0101000020E6100000A8E4A088030C54C07EBAF72C02D23940	0101000020BC080000CC78926DD72D2C41B2858E0348842041
366	3125	SW 107 AV	SW 183 ST	N	N	N	0	0	1	11/17/2016 17:5	25.59914	-80.3644	865636.726071779	460502.15812581	aeced7ee-c476-44fa-827f-96efe68917b2	0101000020E61000007D683A53521754C07FFACA9B61993940	0101000020BC0800009369EAA3C76A2A41C3B2F75B5F1B1C41
367	1165	NW 5 ST	NW 4 AV	E	N	Y	1	1	0	9/27/2016 12:04	25.77866	-80.20136	918976.398584116	526041.49258022	a0efbbca-82f2-43e5-b4ae-790a312f1193	0101000020E6100000FA54880FE30C54C0153F6CA256C73940	0101000020BC0800007344ED027F0B2C416964DA61B60D2041
368	9871	E PALM DR	SW 172 AV	E	F	N	0	0	0	10/20/2004	25.44773	-80.46867	831491.267440293	405322.971527532	bdb19201-1753-4d79-a588-f5a875f593f1	0101000020E6100000FC7632C0FE1D54C0F78F62EE9E723940	0101000020BC080000F76D9EB404602941C7465E8E32BD1841
369	5346	W FLAGLER ST	FONTAINEBLEAU BD	E	N	N	1	1	1	9/8/2012 12:28	25.76937	-80.3393	873602.33315083	522413.905676395	3333947a-4254-44c0-a8f9-8bef64cd5446	0101000020E6100000028EA1F4B61554C09ADAC6DEF5C43940	0101000020BC080000B8399BDB02A92A411AB5AF69BEE21F41
370	9458	NW 158 ST	NW 59 AV	E	F	N	1	1	1	10/26/2016 12:2	25.91691	-80.29666	887346.362145748	576112.116530836	c27c4052-f0d9-485e-8073-1e68f439af9e	0101000020E610000020AAA370FC1254C0DA96E10DBBEA3940	0101000020BC080000915F21EC62142B4105CDD7A7E3942141
371	6872	S MIAMI AV	OP # 3605	SW	M	N	0	0	0	9/18/2002	25.74398	-80.21551	914394.569857817	513407.092676356	9ec04223-286d-44a9-87c5-61cb1cc040ed	0101000020E6100000CCA323E9CA0D54C05EED4E9575BE3940	0101000020BC0800005DC21A5AB3E72B416596E72603561F41
372	4804	NW 22 AV	NW 99 TE	N	N	N	0	0	1	10/17/2016 11:2	25.86484	-80.23407	908027.743339833	557300.048819438	a170fcf6-644c-427d-b3c4-550f9ea6be04	0101000020E61000007BCC6D14FB0E54C0DC02ED5466DD3940	0101000020BC0800009FA1FEB1F5B52B4150FCBE82EB012141
373	8710	NE 171 ST	NE 18 AV	E	F	N	1	0	1	11/8/2016	25.93313	-80.16414	930868.013593383	582261.982161216	ded1497e-bd0c-4da2-85c9-0aaf3eecfba0	0101000020E61000003FDD4F3B810A54C0DA2355C9E1EE3940	0101000020BC080000D388413F66682C417AEAF563EFC42141
374	9047	OPA LOCKA BD	# 2525	W	N	Y	0	0	0	11/27/2002	25.89811	-80.24117	905623.042093452	569379.12474525	cf77d5ec-e106-469a-a390-e70e3d8e38c4	0101000020E610000082CAFF676F0F54C0AD4F09B7EAE53940	0101000020BC0800004FC0A14A2CA32B41A2CE24AB49602141
375	61	NE 1ST AVE	NE 4TH ST	\N	\N	\N	0	0	0	 	25.77813	-80.19198	922061.751003914	525867.662199773	7d3d2aec-ba0c-4da8-8d55-be580ab2b13b	0101000020E610000098C08082490C54C08ED681E633C73940	0101000020BC080000C2FFBBB799232C41C0EFC5B85A0C2041
376	330	SW 40 ST	SW 107 AV	E	F	N	2	0	1	10/13/2016 10:4	25.73222	-80.36708	864521.073429391	508864.408195652	55970991-2a6f-4afe-ae68-b3211dce2f3a	0101000020E6100000C49A90487E1754C0FB4F60D072BB3940	0101000020BC0800007B5B725510622A4139BAB768080F1F41
377	2947	77 ST	TATUM WATERWAY DR	E	F	N	0	0	0	8/29/2002	25.86197	-80.12615	943524.425310254	556478.076716281	86838127-7a67-403e-85a3-edc77ed6ea87	0101000020E6100000C0C49EE2120854C0E462932DAADC3940	0101000020BC080000376DCD1347CB2C4103070C917FFB2041
378	237	NW 32 AV	NW 34 ST	S	F	N	1	1	1	9/1/2016 14:06	25.80638	-80.24839	903440.515956029	536024.572048277	5d9aea18-1889-4513-ae80-e377d455aac5	0101000020E6100000C3FAADAEE50F54C0C74CA2186FCE3940	0101000020BC08000072EFF13C1F922B412663E88BB45B2041
379	8226	SW 22 ST	SW 31 AV	E	F	Y	0	0	1	9/14/2016 11:54	25.7501	-80.24305	905315.584387604	515580.327811211	1b092f48-3d29-4425-b3b5-bbc1a20903a4	0101000020E61000000874B2288E0F54C04A7FCAFD06C03940	0101000020BC0800009AEA4860C5A02B41CF625F18F8771F41
380	9027	NW 135 ST	# 3680	E	N	N	0	0	0	2/15/2017 10:38	25.8966	-80.25885	899816.791580513	568797.070483625	6abfd642-dce5-44fc-a551-00688c679a15	0101000020E6100000D42391ED901054C004336DC187E53940	0101000020BC08000093409BC9CF752B41F5253E8FBD5B2141
381	3279	SW 127 AV	SW 272 ST	N	N	N	1	1	1	10/4/2016 12:58	25.5144	-80.39607	855342.960887805	429653.871046424	4fd809e1-426d-4b2c-ac2b-6530aef67695	0101000020E610000000EDBA06591954C0DC70CDE3AF833940	0101000020BC080000C375CE1A5C1A2A415D60D62D5E391A41
382	6427	NW 173 DR	NW 42 CT	W	F	Y	1	0	1	10/26/2016 13:3	25.9328	-80.26991	896107.497511718	581933.55465629	38b03682-3fcf-482a-b3c3-f7e0ec59dece	0101000020E6100000EDE09522461154C0E58E4107CCEE3940	0101000020BC080000DD759832D5582B41E899F9885EC22141
383	4681	KINGS CREEK DR	# 7915	NW	N	N	1	1	1	10/31/2016 10:3	25.69355	-80.32251	879266.818879511	494883.830841616	dc15d50e-bb7f-4396-88c3-b948d680eba6	0101000020E61000009775CBFFA31454C0A3A262CC8CB13940	0101000020BC080000EB4111D543D52A410327CD1596341E41
384	10247	SW 107 AV	SW 26 TE	N	F	N	1	0	1	10/27/2016 19:1	25.74483	-80.36764	864317.712632075	513447.086636662	56040f4a-08c2-4e62-acab-94b00ac93d8a	0101000020E610000022F89F4F871754C0C4CDE549ADBE3940	0101000020BC0800002ABBC09C79602A4121DA8620A3561F41
385	9098	SW 87 AV	SW 184 ST	S	N	N	1	0	0	11/11/2016 16:2	25.59944	-80.33214	876268.773702566	460663.815908998	b95592b8-107d-42e2-a039-d075a64aae12	0101000020E6100000F1268EBE411554C00D1ABF5575993940	0101000020BC08000069438FBDD7BD2A41A710C5FDE51D1C41
386	8453	NW 2 AV	NW 93 ST	N	F	N	0	0	0	11/3/2016 17:08	25.86051	-80.20145	918768.154569212	555790.864535019	d76392af-58cd-485e-bbe4-10349dbb486b	0101000020E61000001537DC6FE40C54C08AC91EB14ADC3940	0101000020BC0800002048F385DE092C413D162C2421F62041
387	10173	SW 47 ST	SW 157 AV	W	F	N	0	0	1	10/12/2016 13:4	25.72075	-80.44775	837981.096012626	504578.16872146	446725f5-5f7a-4080-8416-33df4866b1ac	0101000020E61000007A7B8E03A81C54C07306877183B83940	0101000020BC080000A6778F5DB892294106BF6D720FCC1E41
388	2340	E 25 ST	E 10 AV	E	F	Y	0	0	0	10/20/2016 11:2	25.8453	-80.26122	899138.601359036	550148.566060148	bb4e95dc-14ae-414d-8a45-7b1d304ee1d7	0101000020E610000065F064F4B71054C023AEEB1566D83940	0101000020BC0800008FD4386883702B412531948A0CCA2041
389	7943	NW 7 ST	NW 19 CT	W	N	N	0	0	1	9/6/2012 13:48	25.77992	-80.22712	910494.579250958	526447.066921599	e6908a87-e337-43c0-8ac6-7581397e4d23	0101000020E610000053ECFE35890E54C05C95D4E1A8C73940	0101000020BC08000065C7665E3BC92B41723EF287E1102041
390	2860	HAWTHORNE AV	STILLWATER DR	S	N	N	1	0	0	8/28/2002	25.86895	-80.12872	942663.076592084	559011.339018226	daa0ec16-7123-4ccd-b6e9-504dad7bbca0	0101000020E61000006E3B98F53C0854C0B18571F273DE3940	0101000020BC080000992720618CC42C413D3D9F174A0F2141
391	7250	SW 17 AV	SW 16 ST	N	F	Y	1	1	0	8/18/2016	25.75814	-80.22219	912164.64092467	518541.444932885	b88cebc6-b8e4-45fd-b0dd-2ee09f756c58	0101000020E61000003A0A7D63380E54C09D6150B415C23940	0101000020BC080000CEE8337E47D62B415B582C913CA61F41
392	9117	SW 152 ST	SW 84 CT	W	F	N	0	0	0	11/30/2016 13:3	25.62927	-80.33051	876750.884957846	471506.113455094	d87cb700-d622-4e70-8712-3c74d68c3804	0101000020E61000004F3E080E271554C0678E8FE117A13940	0101000020BC0800003BB39CF69BC12A417B5A48314FC71C41
393	3636	CARIBBEAN BD	BAHAMA DR	SW	F	N	1	0	0	10/21/2002	25.58145	-80.34611	871699.877963766	454103.144354239	fa5c2536-650e-4969-9c02-5ca332b27d9e	0101000020E61000006F823F7B261654C071141879DA943940	0101000020BC0800005E6E6DF2259A2A4198F5364C63B71B41
394	4600	SW 40 ST	SW 64 AV	W	F	Y	1	0	0	10/13/2016 11:5	25.73371	-80.29896	886948.261871807	509520.787080936	7a0f5d78-c2ee-410d-b999-0260469fd22f	0101000020E61000005ACFC5F9211354C0079292B9D4BB3940	0101000020BC08000041B3E3B846112B41BC3504ED49191F41
395	3285	SW 132 AV	#28600 PINE ISLE MHP	S	F	N	1	0	1	10/4/2016 12:26	25.5013	-80.40424	852664.534502432	424880.950175323	03fcaea4-c8f7-47db-b493-e371c6f8f896	0101000020E61000009BED4E25DF1954C0E540FD6E55803940	0101000020BC080000ED2921406F052A4116B0BB7DCAEE1941
396	5841	NW 173 DR	NW 54 CT	W	N	N	0	0	1	10/26/2016 14:0	25.93071	-80.29021	889436.989196621	581139.041523062	2893af3c-7fa3-474d-b02c-6e03914343d4	0101000020E61000005AEDBBE0921254C06403BD6243EE3940	0101000020BC080000ADA85A2DB8242B41C740138229BC2141
397	3218	SW 117 AV	SW 208 ST	SE	N	N	0	0	0	10/18/2002	25.57442	-80.37946	860714.453435302	451493.110504411	a97b78c3-1202-434b-b502-4d6be0281f18	0101000020E61000009D750B1E491854C0FCEE905C0D933940	0101000020BC080000311CA91753442A41FCBDC8289B8E1B41
398	5522	NW 17 AV	NW 103 ST	N	F	Y	1	0	0	8/18/2016	25.86896	-80.22604	910659.528074581	558813.751537934	5fc0a9ec-473f-406c-abb9-0156b19dd9c6	0101000020E6100000482A2884770E54C0912DA17874DE3940	0101000020BC0800007D0F254485CA2B41C00DB4EABE0D2141
399	8579	NE 19 AV	NE 173 ST	N	F	Y	0	0	0	11/11/2002	25.93536	-80.16228	931474.788652614	583076.806986086	af2c3f56-d62d-4a15-bf07-883bd5221629	0101000020E61000007B8B83B9620A54C0C64750FF73EF3940	0101000020BC080000E3BA3CCC236D2C41A3295F0A4DCB2141
400	2921	71 ST	BIARRITZ DR	E	F	N	1	1	1	10/20/2016 11:5	25.85119	-80.14159	938474.769694697	552528.904184215	cec4e58e-a62f-40f7-9a92-cf7a1ec4a1a2	0101000020E6100000DB2E54BD0F0954C09E329328E8D93940	0101000020BC0800006EAF81C3D3A32C415C243638A5DC2041
401	4201	SW 56 ST	SW 142 AV	E	N	N	1	1	1	9/26/2016 14:39	25.71409	-80.42343	845997.627221406	502190.708921261	88121604-f68d-45c0-9221-e5d5f42a2a1b	0101000020E6100000416CA29A191B54C04B79EBC6CEB63940	0101000020BC0800007B0E896E59D129414C06FE9AC1A61E41
402	7684	NW 54 ST	NW 9 AV	W	N	Y	1	1	1	10/19/2016 13:0	25.82494	-80.21091	915730.177707467	542844.526548482	f7bad280-f146-4d2f-b6db-375c4b19d89f	0101000020E6100000879CB4A87F0D54C032ADBDC52FD33940	0101000020BC080000A7026E9122F22B414C7A8375FC902041
403	6769	NE 2 AV	NE 42 ST	S	N	Y	1	0	0	9/25/2002	25.81517	-80.19154	922123.868055385	539332.495875716	31576026-fb9b-4b8f-a8cc-bf9831b9a8d9	0101000020E61000001315034D420C54C04D49138DAFD03940	0101000020BC080000410EAEF315242C417F8A50658C752041
404	8477	EAST DR	LABARON DR	N	N	N	1	0	0	9/23/2016 12:39	25.81132	-80.27278	895406.838475656	537776.458958805	fdbee0cd-a381-4f43-bbbc-22cb64594daf	0101000020E610000056E66441751154C05A6E2F1BB3CF3940	0101000020BC0800001CB016E15B532B41D1E21C5264692041
405	9789	SW 26 ST	SW 152 AV	W	F	N	1	1	1	9/14/2016 16:27	25.74285	-80.44072	840263.205656867	512620.230372354	fe3342d9-86dd-4b3a-b2b3-bdb30f676ac7	0101000020E61000001F079EC0341C54C0338617CA2BBE3940	0101000020BC080000C0DA05968CA42941350779B3B7491F41
406	3558	SW 168 ST	SW 103 AV	E	F	Y	1	1	1	11/17/2016 14:2	25.6134	-80.35945	867244.370198969	465693.177886531	e5ac3536-55c2-4f8e-b2c8-be83706febfa	0101000020E61000005709A428011754C0B5A9B937089D3940	0101000020BC080000176DD7ED56772A4129AE8D717B6C1C41
407	9208	PARKING LOT	\N	S	F	Y	1	1	1	11/3/2016 14:59	25.94686	-80.12111	944975.06118143	587346.548797533	25ca96b2-6dac-4e71-9ecc-194ae6821e56	0101000020E6100000B74C544FC00754C063F5AFDB65F23940	0101000020BC080000CFE775599CD62C410DE1BF86A8EC2141
408	4806	NW 22 AV	NW 102 ST	S	F	N	1	0	0	10/17/2016 15:5	25.86723	-80.23445	907902.969641633	558169.859395251	d0d8d500-0162-4ef9-a25e-e045d003d83b	0101000020E6100000D4DF270B010F54C015CD5D4A03DE3940	0101000020BC080000861BD725FCB42B41E4B6D021B7082141
409	9891	SW 112 AV	SW 238 ST	S	N	N	1	0	1	10/4/2016 15:01	25.54714	-80.37221	863153.173275542	441589.877044298	f0305635-adb8-48f2-a074-33c6774fdabe	0101000020E610000044222A3CD21754C0CD34C69A118C3940	0101000020BC080000E4168B8860572A41CF2E3237DEF31A41
410	5745	NE 6 AV	NE 175 ST	N	F	N	1	0	0	10/26/2016 13:2	25.93627	-80.18849	922857.155620482	583353.333642274	e355ec82-9329-4cc8-9643-3bb7e1a5732a	0101000020E610000013A6393B100C54C0913E90A2AFEF3940	0101000020BC080000782BF986D0292C41ED2C111876CD2141
411	1966	E 8 AV	E 55 ST	S	N	N	1	0	0	2/15/2017 11:57	25.87303	-80.26709	897153.064919934	560215.978014715	0984c341-f6e3-48b0-8225-c07afd43187c	0101000020E6100000D80D3110181154C0832AB1447FDF3940	0101000020BC0800006DA7495500612B4196DBEC5EB3182141
412	8363	MIAMI LAKES DR E	NW 67 AV	W	N	N	1	0	0	10/10/2016 15:2	25.90884	-80.30803	883623.919452645	573157.584383644	7c851683-5131-4d6a-9933-d10c174def0f	0101000020E6100000DD1147C2B61354C07BD397EAA9E83940	0101000020BC080000B215F9084EF72A41779AF196CE7D2141
413	5182	NW 71 ST	NW 22 AV	W	N	N	1	0	1	11/8/2016 14:30	25.83937	-80.23279	908506.67281989	548043.896385446	a56dad3c-b3c8-4109-bf24-e953e0b25e3e	0101000020E61000009A3962E9E50E54C05DD3CBEEE0D63940	0101000020BC080000967C088EB3B92B4189D072339BB92041
414	9278	SW 67 AV	SW 60 ST	N	F	N	0	0	0	10/10/2016 12:0	25.7152	-80.3021	885950.468270373	502787.325524136	e83dedc6-dceb-463d-b02c-8db024d34a26	0101000020E6100000AF92B167551354C09290739617B73940	0101000020BC080000B0F859227B092B416ADAB11214B01E41
415	7919	MAC ARTHUR CY	JAPANESE GARDENS	W	F	N	2	2	1	10/11/2016 14:2	25.78455	-80.17475	927719.910295833	528236.292968661	13d77e9d-1c5e-4423-a5f2-a0eefb09529c	0101000020E6100000573212152F0B54C0CB2646A4D8C83940	0101000020BC0800009BCE050ACE4F2C4176A00FFCDB1E2041
416	7078	NW 7 AV	NW 60 ST	N	N	Y	1	1	0	9/21/2016 13:21	25.83034	-80.2083	916579.563489258	544812.795939244	88ef9e84-339f-4e5e-b2b4-6327b0aa5723	0101000020E6100000A3CF03C4540D54C045877FBB91D43940	0101000020BC080000159E1157C5F82B41E701ABFF5CA02041
417	6686	BISCAYNE BD	NE 72 ST	S	N	N	1	0	0	10/8/2016	25.84142	-80.18445	924397.528863225	548885.799230263	267e2ac7-9f04-4712-9038-0db45b2490b6	0101000020E6100000D4F7311FCE0B54C0E69C717A67D73940	0101000020BC0800009FBB4D46D9352C411BA6E7012FC02041
418	1343	BISCAYNE BD	# 21280	S	N	Y	1	0	1	11/3/2016 13:16	25.9725	-80.1431	937689.319157593	596616.076815464	d6291c55-51e2-4845-81f5-e89aee68d579	0101000020E6100000BFF72183280954C0712AEECEF5F83940	0101000020BC080000BEB0A0DCB09D2C4107933B9613352241
419	5595	EAST RD	NW 115 ST	S	N	Y	0	0	0	9/30/2016 16:07	25.87941	-80.24466	904513.830437019	562577.432003088	f0b68a81-f2f1-45c1-8959-7a15ba358c68	0101000020E61000008A29B4A2A80F54C0BD42EC8421E13940	0101000020BC080000B8BA20DE819A2B418E16AF47262B2141
420	8705	NE 171 ST	NE 16 AV	W	F	N	0	0	1	9/8/2016	25.93321	-80.16866	929380.644167818	582283.051034965	19dc9421-998f-47cc-9ef2-3415c50730ce	0101000020E61000004B968B5ECB0A54C0D8979C4AE7EE3940	0101000020BC080000A760E581C75C2C41326E318719C52141
421	8662	NE 163 ST	NE 23 AV	W	F	Y	1	0	0	10/8/2016	25.92627	-80.15498	933894.261460785	579789.66097302	e272178c-f6c2-4043-a784-72674f38120d	0101000020E6100000B4C2AB2BEB0954C03AE3798920ED3940	0101000020BC080000E8497DBE0A802C417E152DBF9EB12141
422	4254	SW 72 ST	SW 135 CT	W	N	N	1	0	0	10/7/2002	25.70012	-80.41244	849640.328265224	497131.409660213	e8c976f5-19cf-4636-b96a-7d46616aae3c	0101000020E6100000D6383F76651A54C0E6D3CDA13BB33940	0101000020BC0800000A15F8D5CEED2941217B0567B4571E41
423	1669	ANDALUSIA AV	GALIANO ST	E	F	Y	1	0	0	8/26/2002	25.74871	-80.25631	900953.77779901	515049.918439694	fd5d09d6-86e2-4b9a-9085-980ddfe2745b	0101000020E61000007E6F2E69671054C0417FACD4ABBF3940	0101000020BC080000D1D1D6C2B17E2B41C2F51275AE6F1F41
424	3262	SW 122 AV	SW 191 TE	N	N	N	1	1	2	11/29/2016 12:3	25.58839	-80.38889	857581.598138634	456557.864156395	ef28a68b-e8bd-4b72-9237-a6c29b86c59e	0101000020E6100000905CEEAAE31854C0B14A373AA1963940	0101000020BC08000026463B61D92B2A418922ED2DBEDD1B41
425	6936	NW 2 AV	NW 22 LN	S	N	Y	0	0	0	11/4/2016 14:38	25.79901	-80.19911	919671.2075596	533440.360328972	17ae4cb4-31f9-4489-baca-90d3a03edebf	0101000020E6100000F4DBBC3ABE0C54C0DBF12FE68BCC3940	0101000020BC08000075EA28A1EC102C41E380181F84472041
426	10280	NW 33 ST	NW 112 AV	W	N	N	1	0	0	11/8/2016 10:43	25.8043	-80.37564	861577.647898886	535051.535917804	c9bc71b5-9995-4848-863a-c70cfc7ecd00	0101000020E61000003E4299980A1854C052C7D61BE7CD3940	0101000020BC080000E562387B114B2A414B431C791A542041
427	5520	NW 7 AV	NW 105 ST	S	F	Y	1	1	0	9/21/2016 13:45	25.8705	-80.21012	915891.84178111	559403.946529455	e33228f6-7fb5-4a9c-9f2d-689ef6664172	0101000020E610000050556EA6720D54C098150144D9DE3940	0101000020BC0800004FB06DE565F32B410973B34E5B122141
428	4097	SW 26 ST	SW 127 AV	E	N	N	1	1	1	9/27/2016 11:32	25.7439	-80.40064	853452.730445873	513060.153682306	6b6ff97a-5e02-4757-95b1-df9362fcadfa	0101000020E61000000C59082EA41954C09519F5AA70BE3940	0101000020BC0800007DD568A4970B2A413FB0366597501F41
429	4195	SW 56 ST	SW 140 AV	W	F	N	1	1	1	10/12/2016 13:1	25.71444	-80.41935	847341.723977659	502325.626607776	4a56e994-5955-49ff-b4b1-31da8b14fd03	0101000020E61000006DE316B1D61A54C0ADCDD30AE6B63940	0101000020BC08000046DF56A0D9DB294115CCAB46DDA81E41
430	2859	HAWTHORN	83 ST	N	F	Y	0	0	0	8/26/2003	25.86838	-80.12854	942721.993185677	558805.267286271	d27786fd-76a8-4834-8c2a-46c337b9b22d	0101000020E6100000877B98173A0854C0FE22FEB84EDE3940	0101000020BC0800007761523602C52C41E942D5F2AD0D2141
431	7976	NW 7 ST	NW 57 AV	E	F	Y	1	0	1	11/8/2016 13:50	25.77791	-80.28726	890707.498130247	525606.001650915	a94fc543-a7d8-4560-badd-a91b317130e6	0101000020E6100000BC4AB58F621254C00FA5EC5925C73940	0101000020BC0800008D454E32A52E2B41E80664664F0A2041
432	4966	NW 42 AV	NW 27 ST	S	N	N	1	1	1	11/1/2002	25.80057	-80.26462	898115.21195766	533882.328603059	a677fc82-d4f1-49a8-a607-2aa5703ec90e	0101000020E610000018DEB276EF1054C0FBE72E44F2CC3940	0101000020BC080000837ABDA084682B418262E40EF84A2041
433	9134	SW 57 AV	SW 97 ST	N	N	N	1	0	1	11/30/2016 11:0	25.68094	-80.2845	891812.430956043	490368.076366439	15c9f7d3-e064-4be6-8ad3-32b45c36e484	0101000020E61000007FA31C10351254C0E983C3A652AE3940	0101000020BC080000861F1B1047372B415431271007EE1D41
434	8783	W DIXIE HY	NE 139 ST	NE	N	Y	1	0	0	9/30/2016 14:02	25.90318	-80.17522	927292.673953671	571354.995459363	62cae8c1-031b-4d7e-b100-f7222d0d31a0	0101000020E6100000156A92E1360B54C0EFD93B6037E73940	0101000020BC0800002172F190774C2C4103B93A69B96F2141
435	10165	SW 136 ST	SW 92 AV	E	F	Y	2	0	0	11/15/2016 12:4	25.64659	-80.34224	872852.398965005	477784.280345224	33c5c735-da6d-4fbe-bb04-12e6f1740b40	0101000020E61000000635995AE71554C05D4A756C87A53940	0101000020BC0800006DAB3EFD26A32A41FDB0D7DD67291D41
436	6488	NW 183 ST	NW 34 CT	E	N	N	1	1	1	11/10/2016 13:5	25.94032	-80.25891	899703.607417263	584687.5002857	3ca18885-e048-4728-a254-caf744b7496c	0101000020E610000009EE5D17921054C0CB94B7ECB8F03940	0101000020BC080000CD234E6BED742B41734B616DE2D72141
437	5090	NW 95 ST	# 1260	E	M	N	0	0	1	10/14/2016 14:1	25.86144	-80.21788	913358.094233442	556096.350749254	699917b3-fb66-4501-a3a6-f8fef902a721	0101000020E6100000FA1435DFF10D54C09E68EFA387DC3940	0101000020BC0800002D325D669ADF2B41CF2E351D84F82041
438	3700	OLD CUTLER RD	SW 222 ST	SW	F	N	1	1	1	10/4/2016 14:18	25.56083	-80.35649	868310.820472166	446590.633427702	e555827e-5a81-4ea5-b1af-771af230e2e5	0101000020E6100000DAF876BED01654C0F385B5DB928F3940	0101000020BC080000D5787BD4AB7F2A41212D1B3F01421B41
439	3648	CARIBBEAN BD	BAHAMA DR	NE	N	Y	1	0	1	10/4/2016 15:54	25.58138	-80.34599	871736.261454318	454077.881570995	9cc63b9d-2ff9-48a6-bd14-4b3f40e1cdff	0101000020E61000004855E0AD241654C09106B2E2D5943940	0101000020BC08000039AAB3B66E9A2A413BB7473FFEB61B41
440	3501	SW 152 ST	SW 92 AV	W	F	Y	2	1	3	11/17/2016 11:4	25.62901	-80.34279	872707.201101828	471394.270165309	079035d5-8a75-4833-886e-3676d8f25570	0101000020E6100000B5ECEF26F01554C02E12B45D07A13940	0101000020BC0800007B4AEB9704A22A41367793D18FC51C41
441	6743	BISCAYNE BD	NE 70 ST	N	N	Y	0	0	0	9/8/2016	25.83947	-80.18421	924482.18184844	548177.529686779	1d33d90f-1ae5-4dc8-b5d5-96c4c8a7da39	0101000020E61000003480C91FCA0B54C085FFDBAEE7D63940	0101000020BC08000086769B9482362C415C74BD77A6BA2041
442	8057	W FLAGLER ST	NW 55 AV	W	F	Y	1	1	0	9/8/2012 12:30	25.77101	-80.28468	891576.06527175	523103.110988438	a6767ff3-5156-4749-aaaa-26b87a5a4105	0101000020E61000003776E6FE371254C0FE7FE03761C53940	0101000020BC08000038D1CB546E352B41BA07193C83ED1F41
443	6692	BISCAYNE BD	NE 60 ST	S	N	N	1	1	1	11/8/2016	25.83107	-80.18457	924383.3605561	545124.739180095	665be996-7ee1-48bf-ad75-b279176295e6	0101000020E6100000045358FDCF0B54C093C28C60C1D43940	0101000020BC080000C05113F0BC352C4133F5A2E2CCA22041
444	5027	NW 79 AV	W FLAGLER ST	N	F	N	2	0	1	9/8/2012 12:52	25.7705	-80.32439	878506.173746634	522847.671888649	0bbe97f3-e44e-4646-9cc5-c161ce7c24a1	0101000020E61000002FD61FB8C21454C0810527993FC53940	0101000020BC080000A8C1A18A52CF2A41B05D497A85E91F41
445	564	NE 199 ST	NE 2 AV	E	F	N	1	0	0	10/28/2016 16:5	25.95748	-80.19718	919952.949443616	591046.125999935	9e55edb2-7240-4dcb-9c96-6c9de83156cf	0101000020E610000039DC52A89E0C54C0C1D4BCD91DF53940	0101000020BC0800001EF4021D20132C41793ABCAE8F092241
446	93	NE 6 AV	NE 125 ST	N	N	Y	2	2	2	9/30/2016 13:31	25.88994	-80.18636	923660.367258288	566518.644215517	fbb78acc-1c48-4238-bb80-5da17933dfdd	0101000020E610000065ED2166ED0B54C051D77F7BD3E33940	0101000020BC0800005B005FF316302C41616CC5B4F0492141
447	5530	NW 17 AV	NW 131 ST	S	N	N	0	0	0	10/31/2016 16:3	25.89427	-80.22728	910199.916457113	568010.794764586	f9cc7948-a204-4e94-9bfe-7f6e681b6e10	0101000020E61000000274BDB78B0E54C08E8D1230EFE43940	0101000020BC08000045CFE90AEEC62B4127F61C0299552141
448	9790	SW 26 ST	SW 149 AV	W	N	N	1	1	1	9/14/2016 16:23	25.74301	-80.43576	841893.348352496	512684.599029414	3a52d5a4-eecb-4727-9ab5-229a3a0e89b4	0101000020E6100000AF2C3A9AE31B54C04DD5E22436BE3940	0101000020BC08000082BC39DF48B129419570FC2CB94A1F41
449	5803	NW 57 AV	NW 170 TE	N	N	Y	1	0	0	10/26/2016 12:5	25.9277	-80.29317	888471.383163303	580038.656570673	0f1b7849-0ecc-4d2e-b51f-a5c81a134032	0101000020E6100000C49D184FC31254C018D3F8EC7DED3940	0101000020BC080000B65E10F72C1D2B41AF32E1BC90B32141
450	8585	NE 18 AV	NE 186 ST	N	F	N	1	0	0	12/13/2002	25.94745	-80.16503	930541.992250539	587465.825770035	a740e1c3-64c7-43b4-918c-8010b361a5df	0101000020E61000008E2770D48F0A54C07C93A9648CF23940	0101000020BC0800004A4D4434DA652C41F912771497ED2141
451	6550	NW 191 ST	NW 27 AV	W	F	N	1	1	1	9/19/2016 17:34	25.94827	-80.24642	903792.924689725	587600.533481143	d529f21a-3549-4b8a-898a-31ae237c8ee9	0101000020E61000005DE5B763C50F54C04E5FA2EFC1F23940	0101000020BC0800002EB9430EE0942B41CB0EE67EA4EE2141
452	4524	SW 87 AV	SW 25 ST	N	N	Y	2	0	1	10/31/2016 12:1	25.74633	-80.33554	874881.317466579	514043.853833035	f87c4374-cbcc-48cb-8221-5a80d5d3c517	0101000020E610000082556D62791554C02234F6860FBF3940	0101000020BC0800000551CDD300B32A4177D14E32F65F1F41
453	7646	NW 62 ST	NW 5 CT	W	N	Y	1	1	0	10/18/2016 14:0	25.83247	-80.20519	917598.225802146	545591.70446568	57974647-090c-4ec4-a7f5-3369f861bcf5	0101000020E6100000D26987CB210D54C0DAA4DF0F1DD53940	0101000020BC080000A4E348AABA002C41ABF9F9D072A62041
454	6604	NW 210 ST	NW 8 PL	E	F	N	1	0	0	10/28/2016 16:3	25.9694	-80.21652	913571.471385729	595338.780165985	aa312f9b-e183-4c67-955a-f8fe65dcee12	0101000020E61000003C0F948EDB0D54C0CC1115C72AF83940	0101000020BC080000CF0C6F2745E12B41A19A36FE182B2241
455	6383	NW 159 ST	NW 38 PL	W	N	N	1	0	1	8/31/2016	25.91893	-80.26366	898187.595346794	576906.246135011	7c6a4acd-5f28-4ea3-951a-fcb0a2d4fb8b	0101000020E610000015868AD9DF1054C0BBD9A5803FEB3940	0101000020BC08000069E4DD6415692B4106B552EA179B2141
456	1823	NW 36 ST	OP # 9100	W	N	N	1	0	0	11/8/2016 15:21	25.81115	-80.34459	871783.17963336	537588.374343611	fab8f94d-bea3-47fb-90af-230fd05d41d0	0101000020E61000000DFF10C20D1654C022C26192A7CF3940	0101000020BC080000D201A78CCC9A2A41393DCA26EC672041
457	11201	SW 184 St	97 Ave	E	F	\N	\N	\N	\N	 	25.59869	-80.3479	871073.123348944	460366.088468209	d81fdb18-a881-4de4-a28e-c84a8a551f39	0101000020E6100000DC468E1A441654C0BCDC615044993940	0101000020BC0800005E6EE66F40952A41B0A1B2143F191C41
458	7885	VENETIAN WY	VENETIAN CT	E	N	N	1	0	0	11/14/2016 9:03	25.7902	-80.17251	928443.464324832	530294.147816494	edd565d9-01f7-44be-b2da-ff54c1c9031e	0101000020E61000001D43366A0A0B54C025D5C7DA4ACA3940	0101000020BC0800001B6DE62575552C41F8C5F4B1EF2E2041
459	5353	W FLAGLER ST	OP SW 98 CT	W	N	N	1	1	1	9/8/2012 11:39	25.76902	-80.35591	868136.561271377	522260.724218898	c8789eea-6b79-441d-8edd-5681b62dd29c	0101000020E610000002A20A18C71654C045A21521DFC43940	0101000020BC080000AD6D9B4F4F7E2A41E9A2C3AF59E01F41
460	1219	SW 26 ST	#11875	W	N	N	2	0	1	9/14/2016 15:04	25.74635	-80.38752	857768.29860203	513971.190267019	4fe0c4e4-0e26-4eac-86c2-4082a892fe65	0101000020E610000066512A2CCD1854C04672B65C11BF3940	0101000020BC0800008194CDC74E2D2A41956ADF8AD35E1F41
461	2601	CRANDON BD	GALEN DR	N	F	N	1	1	1	11/14/2016 11:2	25.69156	-80.16345	931651.717082322	494460.246045887	4c20f92d-2a35-474d-8f00-329da5707234	0101000020E610000032F0FDFD750A54C0E1C601510AB13940	0101000020BC0800009FCDCEA7856E2C41C29C3CBFF72D1E41
462	6620	NW 215 ST	1700 BLK	E	N	N	0	0	0	10/28/2016 13:5	25.97193	-80.23465	907610.056160521	596224.934225477	26450f81-04db-46ee-9695-9cd7df6c706b	0101000020E6100000F450F290040F54C0860854E9D0F83940	0101000020BC0800009FFBF351B2B22B414092164D05322241
463	509	NW 2 AV	NW 183 ST	S	F	N	2	0	2	9/20/2016 12:29	25.94172	-80.20528	917325.175880633	585300.425271511	897fbfe2-ee76-495b-88dc-62898041581b	0101000020E6100000416DC76A230D54C0D60468CE14F13940	0101000020BC0800009C159E9098FE2B41740E2647ACDC2141
464	3211	SW 117 AV	SW 187 TE	S	N	N	1	1	1	11/17/2016 12:2	25.59436	-80.38098	860179.265833896	458737.199020006	f8d78411-fd60-429d-b5a1-5f9246d95f91	0101000020E610000097439609621854C05FDEC70428983940	0101000020BC080000890075B724402A4172044F85CBFF1B41
465	2196	W 12 AV	W 84 ST	S	F	Y	1	0	0	10/10/2016 13:5	25.89772	-80.30827	883565.677762005	569117.226605892	af49dc00-57ae-496a-bc45-d06d02f43590	0101000020E6100000ED6D4CB9BA1354C0C28CCA7BD1E53940	0101000020BC08000049DD3E8DD9F62A41AC0E52DF3D5E2141
466	2633	C0LLINS AV	# 4441(FONTAINEBLEAU)	N	N	Y	1	0	1	10/11/2016 15:3	25.8181	-80.12299	944669.329828147	540541.933420271	b3f47880-29a4-4d5e-a32d-ccbce65feb6f	0101000020E610000014B2FF24DF0754C0B4045D926FD13940	0101000020BC080000F18BFEE238D42C41AE8C8F45FF7E2041
467	6631	BISCAYNE BD	NE 4 ST	N	N	Y	1	0	1	9/8/2016	25.77804	-80.18793	923395.742143635	525842.060864225	13d27011-4dc7-474f-a27e-482c30296f20	0101000020E61000007A2CFB1A070C54C038FC36CE2DC73940	0101000020BC0800001A517FB3052E2C41EB66C884270C2041
468	8522	WESTWARD DR	SHADOW WY	W	N	N	0	0	0	11/8/2016 14:04	25.82088	-80.29341	888600.149665136	541212.734243833	1e881590-fb80-40e2-a89e-fb07dd37bcf7	0101000020E610000087277F4EC71254C002E64B5E25D23940	0101000020BC0800006D3F8F7F2E1E2B41BD287CDF3C842041
469	5960	NE 199 ST	CALIFORNIA DR	W	F	N	1	0	0	11/1/2016 16:57	25.95795	-80.19371	921090.787075248	591223.596478187	a426004d-a7cc-4e23-85de-e67d2345212d	0101000020E6100000EF4CDCDE650C54C0C2DE3D963CF53940	0101000020BC08000088E00DCA031C2C4173DA859FF20A2241
470	7952	NW 7 ST	NW 32 PL	W	N	Y	0	0	1	9/6/2012 13:49	25.77927	-80.24883	903350.983967829	526169.484475382	a4fd11be-0619-4168-8eef-ba3a83afc27c	0101000020E61000008A46C1F0EC0F54C0A961A4487EC73940	0101000020BC08000086A5AB2C6C912B416BDBCA5DB60E2041
471	4877	NW 27 AV	NW 60 ST	S	F	Y	1	0	0	9/19/2016 12:55	25.82921	-80.24119	905763.450970061	544337.56719698	7db60131-aa18-4fcb-b0dd-426b9cb58474	0101000020E61000008DF4849E6F0F54C0674AAD8B47D43940	0101000020BC080000343C001C45A42B419D0D7C8AA69C2041
472	2688	INDIAN CREEK DR	35 ST	S	N	N	1	0	1	10/11/2016 12:4	25.80918	-80.12454	944181.320327397	537295.635108113	95cea67c-1004-4e3a-b081-d2bca474851a	0101000020E610000092DDF985F80754C00736FFDB26CF3940	0101000020BC080000699729DE68D02C410DEB6BACA2652041
473	3420	SW 167 AV	SW 280 ST	N	N	N	1	1	1	10/4/2016 15:21	25.50639	-80.46132	833832.053131111	426650.626053274	f604d1fc-0461-48c6-82f8-e911c71c022b	0101000020E6100000D9F2153F861D54C05C470503A3813940	0101000020BC0800007F0C35474E722941F0C53232710A1A41
474	5510	NW 7 AV	NW 143 ST	S	F	Y	1	0	0	9/21/2016 12:38	25.90517	-80.21175	915281.473550878	572001.195255592	7d9c8ea6-6f3f-4041-bb6f-934875aab930	0101000020E61000008A8B604A8D0D54C0E3D7E533B9E73940	0101000020BC080000A360B328A1EE2B41B2989BCFC5742141
475	360	Lincoln Rd	James Ave	E	F	Y	1	1	0	10/11/2016 14:2	25.79061	-80.13108	942074.198507395	530531.341198906	3cf12a76-8a47-442a-8697-dbbb91f204ae	0101000020E610000083A6BAAC630854C0B42E3BCA65CA3940	0101000020BC080000D133929FF2BF2C41C2E0FC14CA302041
476	500	NW 12 AV	NW 183 ST	N	F	Y	1	0	1	10/26/2016 14:5	25.94229	-80.22117	912102.309305765	585478.054143429	308c4e0d-7d24-44f2-89a4-482e2724a37d	0101000020E6100000F53118BE270E54C0A2D44D7D3AF13940	0101000020BC080000C06A2BD4CAD52B41DECA17890FDE2141
477	3844	SW 107 AV	SW 84 ST	N	N	Y	2	0	0	10/27/2016 12:1	25.6902	-80.36585	865003.930732679	493596.172616974	e518f81a-e46b-443d-bb03-67044d84f29a	0101000020E6100000AE54D7E6691754C04F6E3E62B1B03940	0101000020BC0800005C66860CD6652A419B875E7377201E41
478	7326	SW 22 AV	SW 21 ST	S	F	Y	1	1	1	10/17/2016 15:5	25.7519	-80.23026	909522.722266339	516257.483252779	98d3baa5-a497-4b8a-a2e0-67b0cc226a15	0101000020E6100000D1F3F18EBC0E54C04BEEABB17CC03940	0101000020BC080000CD3687A7A3C12B419C3AA0B78C821F41
479	9008	NW 32 AV	NW 131 ST	S	N	N	1	0	0	9/1/2016 12:45	25.89362	-80.25173	902161.06344169	567728.658531927	d8ed3d70-7c18-4b96-b5c1-06d9a7b485f1	0101000020E61000008589AB671C1054C0AC206DB8C4E43940	0101000020BC08000065350A5520882B413B1034BC64532141
480	7962	NW 7 ST	NW 47 AV	W	F	Y	1	0	1	9/7/2016 13:50	25.7788	-80.27225	895644.899311859	525956.122671805	51565f57-6ff7-48a6-9934-c5165a39a985	0101000020E6100000EDCA61A76C1154C02F1BE19C5FC73940	0101000020BC080000F84E490038552B41A43A7CA40B0D2041
481	8717	NE 185 ST	NE 19 AV	W	F	N	0	0	0	10/27/2016 12:3	25.94617	-80.16391	930911.380936187	587001.459574789	32bb1bbf-3ff9-4249-a510-28f2a8451dd0	0101000020E6100000E954CA8F7D0A54C07A74B73E38F23940	0101000020BC08000058975EFBBC682C41A5B2E958F6E92141
482	6358	NW 47 AV	NW 185 ST	N	F	N	1	1	1	8/31/2016	25.94261	-80.27754	893578.547191117	585488.1961817	945f7d0e-b147-4c45-a076-7d67f897e4ff	0101000020E6100000137B1B3AC31154C06BE7FC754FF13940	0101000020BC080000EEFDA74B13452B411FC2D1D123DE2141
483	3981	SW 137 AV	SW 76 ST	S	F	N	1	1	1	11/29/2016 14:4	25.69494	-80.41538	848681.54215489	495242.255641006	9f7cf41e-6f38-447c-a49b-6487278fbb20	0101000020E6100000AD7EEB94951A54C04C7925C3E7B13940	0101000020BC080000E8005D4351E629417E82FDC82F3A1E41
484	8241	SW 22 ST	SW 14 AV	W	F	Y	1	0	1	8/18/2016	25.75106	-80.21863	913351.959089428	515974.320480712	fee39f4c-83d8-415c-8ee1-f29886626d19	0101000020E6100000558A900BFE0D54C074B7099445C03940	0101000020BC080000D8FD3C218EDF2B41EE140C11207E1F41
485	5207	NW 62 ST	NW 27 AV	W	F	Y	0	0	0	10/18/2016 15:0	25.83129	-80.24157	905635.418690179	545091.047627009	70510bff-cc08-44c7-a8dc-4eba0eb8fe5c	0101000020E6100000079294C7750F54C030746888CFD43940	0101000020BC080000596F6B0B45A32B41290D858089A22041
486	6423	NW 173 DR	NW 46 AV	E	F	N	1	0	1	10/26/2016 13:2	25.931	-80.27577	894186.516115867	581269.352583297	d77b80ae-cb1a-4a31-a378-c9c4095eb818	0101000020E6100000B8867014A61154C044C6CC3156EE3940	0101000020BC0800001162D33BD3492B417A6863212EBD2141
487	164	SW 22 AV	CORAL WAY	S	N	Y	2	1	1	10/17/2016 15:5	25.7508	-80.23022	909538.540811524	515859.569365032	14aa8a2b-204f-4757-be1a-437da95ffe6c	0101000020E6100000667EFBE2BB0E54C0D5749DEE34C03940	0101000020BC080000B4CC894AC3C12B41D7FAA30F557C1F41
488	4705	SW 88 ST	SW 79 AV	E	F	N	1	0	0	9/29/2016	25.68823	-80.3232	879048.507682756	492949.075487286	a59ad9d6-c9d8-4352-b5be-a710077cda0f	0101000020E61000008379725AAF1454C0C1BF952530B03940	0101000020BC08000014FEB5358FD32A41F7F0F20F5B161E41
489	3215	SW 117 AV	OP # 19331	S	M	N	1	1	0	11/17/2016 13:0	25.58723	-80.38063	860306.388639744	456146.7114392	aa185afc-1f41-401a-baf0-057cc4ae244b	0101000020E6100000B563C6515C1854C09047FACF54963940	0101000020BC0800001F4657F622412A41EEBC809151D71B41
490	8925	NW 135 ST	NW 8 AV	E	N	N	0	0	0	11/12/2002	25.89814	-80.21352	914712.957984701	569443.93593584	584e067f-0519-489f-bd67-7a6aa7dad2ea	0101000020E6100000A1DF7563AA0D54C03D1526BFECE53940	0101000020BC080000D9B1A62030EA2B41C82A8C4ACB602141
491	3176	SW 112 AV	OP # 22790	N	N	N	0	0	0	10/4/2016 13:55	25.55599	-80.37201	863202.258830979	444807.050044909	12080ce6-1b74-40be-8872-f85599b019d8	0101000020E6100000267C460ACF1754C02EB9F4A9558E3940	0101000020BC08000010C746B4C2572A41240940E922261B41
492	10289	NW 5 ST	NW 2 AV	E	F	N	1	1	0	10/21/2016 13:1	25.77877	-80.19747	920255.624704968	526090.33991611	c482f0f7-9fa1-47fb-a5df-1b385dda95f0	0101000020E61000000B00125CA30C54C0C428420A5EC73940	0101000020BC0800001667EF767D152C4177BDC813180E2041
493	2616	HARBOR DR	HARBOR CT	N	F	N	0	0	0	9/30/2002	25.69469	-80.17208	928802.183077201	495580.351701625	1b43795e-96f9-4b2e-a88d-346e55fb8377	0101000020E6100000EC3C0B67030B54C0F7327782D7B13940	0101000020BC080000CE51E59542582C41E4848A2B783F1E41
494	5074	NW 103 ST	NW 12 AV	W	F	Y	0	0	1	8/22/2016	25.86903	-80.21847	913148.97288873	558853.213388622	cdfb4b53-b582-4709-b324-27ddca44197f	0101000020E6100000068C1279FB0D54C0BA537DED78DE3940	0101000020BC080000C4F73728F8DD2B4158A435D70D0E2141
495	8049	W FLAGLER ST	NW 43 AV	W	N	N	1	1	1	9/8/2012 12:03	25.77173	-80.26549	897886.43621099	523398.800007164	f5c83f9d-1321-48f1-8c95-1e9dd80493a0	0101000020E6100000C05D52C4FD1054C08E5BF04590C53940	0101000020BC0800003C9F7A13BB662B41222BFEFD21F21F41
496	4659	SW 72 ST	SW 86 AV	W	N	N	1	1	0	9/16/2002	25.70249	-80.33291	875823.92848872	498114.604184143	8a4bc92e-18f1-48b1-97cb-7c35640a5a47	0101000020E6100000E8038A794E1554C04E5E657ED6B33940	0101000020BC080000D0FBAE0C5EBA2A4140D68E2E11671E41
497	7941	NW 7 ST	NW 17 AV	W	F	Y	1	1	0	9/6/2012 13:48	25.78006	-80.22321	911781.634787071	526505.524123237	e6ec8575-aef5-46dc-ab96-3ff9d557580e	0101000020E6100000EC67E01D490E54C00D8BA30EB2C73940	0101000020BC0800009EE7EB7A49D32B41871F087256112041
498	4123	SW 40 ST	SW 115 BLK	W	N	Y	2	0	1	10/13/2016 13:1	25.73225	-80.38086	859984.584481075	508856.33533977	c1088976-3b00-44db-a85b-b06e52046f58	0101000020E6100000D0F5160E601854C00FD3203D75BB3940	0101000020BC080000660E965A9F3E2A41F50EF31DE80E1F41
499	5856	NW 183 ST	NW 55 AV	E	F	N	1	1	1	10/27/2016 14:4	25.93927	-80.29108	889139.152805146	584248.093044706	7a37ebd5-13f5-46c4-8445-87a9db39f66a	0101000020E61000001F87DDE2A01254C0ACF2303E74F03940	0101000020BC0800004B51188164222B41D218D29C73D42141
500	5364	WALSH BD	SW 4 ST	NE	N	N	0	0	1	9/27/2016 12:59	25.76426	-80.38815	857531.054266933	520478.277647197	6f02fffb-ce33-4bc2-9339-a0aa08a17a3e	0101000020E61000005B50627AD71854C0223C9DD9A6C33940	0101000020BC080000A8A2B04A742B2A41DD56F4E57FC41F41
501	4342	SW 88 ST	SW 112 AV	E	F	N	1	0	0	10/9/2002	25.68651	-80.37598	861668.983046114	492240.215018436	9c32171e-afa4-491f-9e7e-7163feb83a1d	0101000020E6100000EC374322101854C05EEAA0C0BFAF3940	0101000020BC080000229DD126C84B2A41CF3F9A9E470B1E41
502	6975	NW 2 AV	NW 67 ST	N	F	N	0	0	0	11/3/2016 16:33	25.83653	-80.20047	919144.118416227	547077.907829538	a0747d49-1791-4274-8f14-707056648b33	0101000020E6100000352A0D59D40C54C00932BA5527D63940	0101000020BC0800003FAB7473CE0C2C41193651390FB22041
503	2433	W 68 ST	W 17 CT	E	M	N	1	0	0	10/3/2016	25.88401	-80.31734	880608.546838988	564116.660823286	d53b5983-2e66-419f-894e-8b4771df51d6	0101000020E61000007E0F6C644F1454C0F50A35A84EE23940	0101000020BC080000B68ADA49BFDF2A4130B3E8BC2C372141
504	6906	NW 1 PL	NW 13 ST	S	N	N	0	0	0	11/4/2016 14:44	25.78716	-80.19801	920058.711750206	529135.833809108	0853b33c-6b8a-45a4-8377-8dfc0911af29	0101000020E61000007C6A623DAC0C54C0E01CE95C83C93940	0101000020BC080000F88D7FA3F3132C41BB6EFF10E3252041
505	4220	SW 56 ST	SW 95 CT	E	N	Y	1	1	1	10/12/2016 17:1	25.71608	-80.34943	870360.758656126	503028.660353638	76a73672-3862-42bd-80f3-71785ebc4fb0	0101000020E6100000C939E1165D1654C0EB23B57451B73940	0101000020BC080000BD3A15B5AF8F2A41A08A4869D9B31E41
506	301	NW 42 AV	NW 36 ST	S	F	N	1	1	0	9/22/2016 15:13	25.80762	-80.26465	898088.71599355	536445.775592133	d3051a5e-a489-4c5e-91d9-0aa140589ee2	0101000020E6100000691CE311F01054C0B4D7EC7DC0CE3940	0101000020BC08000038D4C7A24F682B41CF6716F4FE5E2041
507	10179	SW 56 ST	SW 154 CT	E	N	N	1	0	1	10/12/2016 14:1	25.71342	-80.44362	839354.026706528	501920.145176418	4598f604-40d0-45d5-8cbf-8adcdf0aa820	0101000020E6100000F389E73F641C54C0B86D4321A3B63940	0101000020BC080000D173533A729D2941B3D6745987A21E41
508	7643	NW 62 ST	NW 1 AV	W	F	Y	0	0	0	10/18/2016 13:5	25.83268	-80.19814	919919.70312896	545683.222350642	3a77a6a4-32c3-4270-bbc6-cd2c73f6ae7b	0101000020E610000011CFED23AE0C54C03F156E052BD53940	0101000020BC080000EFF6F89EDD122C41E4AA16DA29A72041
509	4391	SW 57 AV	SW 54 TE	S	N	N	1	0	0	12/1/2016 13:31	25.72062	-80.28607	891213.466566522	504786.921885818	9184a2eb-62ef-41e5-bbe9-f340f4d8cdca	0101000020E610000018CD81FB4E1254C062BE160E7BB83940	0101000020BC080000019A3C2299322B4137DCC17552CF1E41
510	1834	NW 25 ST	NW 97 AV	W	N	N	0	0	0	11/8/2016 13:51	25.79694	-80.35255	869190.172033239	532412.095321454	6ec6ebab-1e82-453c-966f-fcefa36256ac	0101000020E61000000ED78928901654C072E9319104CC3940	0101000020BC080000C41079888A862A4131574B977B3F2041
511	5844	NW 186 ST	NW 82 AV	E	F	N	1	1	1	10/27/2016 13:1	25.94224	-80.3337	875121.699921142	585255.850224189	5581ec6b-2d7e-473a-9755-e63634a903d1	0101000020E6100000F9E674735B1554C03836663637F13940	0101000020BC080000A3496397E1B42A41C20C9B2053DC2141
512	5580	NW 27 AV	# 12501	N	M	N	1	0	1	9/19/2016 11:53	25.88843	-80.2431	905010.815662708	565858.534964405	116f1a60-2d62-49dd-b6ef-823eb51faeee	0101000020E6100000C00ED7ED8E0F54C01069A89670E33940	0101000020BC080000FA559BD6639E2B419B31C67CC8442141
513	4844	NW 27 AV	NW 62 ST	N	N	Y	1	0	0	9/16/2016 10:56	25.83055	-80.24097	905832.684099156	544823.938285723	183ffca3-7eaa-4912-818c-378e698d7787	0101000020E61000001D31F7076C0F54C05139D22A9FD43940	0101000020BC080000074B6A93CFA42B413A078C4873A02041
514	2528	SW 14 AV	W MOWRY DR	N	N	Y	1	1	1	42647.36389	25.46925	-80.49355	823251.996868711	413111.473352171	cc551f54-b45f-4a97-8cb1-6db375c79eba	0101000020E6100000EEDF515E961F54C02BEA992221783940	0101000020BC080000B2D50B29A61F2941C2515992E4361941
515	8504	NW 36 ST	FORREST DR	W	N	Y	1	0	0	9/23/2016 12:33	25.80835	-80.27009	896296.490531567	536702.225819714	5c4535e4-2590-4426-a0e7-a4ff6ba868b5	0101000020E61000006EE67D3F491154C04089A187F0CE3940	0101000020BC0800003D0E082F4F5A2B41BB14B0DAFF602041
516	9270	SW 67 AV	SW 74 ST	N	F	Y	0	0	1	10/10/2016 11:4	25.70226	-80.30125	886253.907255914	498084.198764935	ab64515d-e6c2-47a7-bf59-8da5ff2c3559	0101000020E6100000C0E24F8B471354C04FA91A4AC7B33940	0101000020BC08000099F82403DA0B2B416BAEA98F97661E41
517	9935	SW 88 ST	SW 162 AV	W	F	N	1	0	0	9/26/2016 14:53	25.68424	-80.45436	835860.01630123	491297.343571439	469d6c74-49e7-471f-b6e7-e5a6e5b25426	0101000020E61000003705B74B141D54C0E0E589542AAF3940	0101000020BC08000002DC7834268229412A40DD218CFC1D41
518	6667	NW 3 ST	NW 2 AV	E	F	Y	0	0	0	9/9/2016 13:25	25.77689	-80.19697	920423.353029195	525406.565028369	9c43207d-566b-432f-ad4e-aa14310db275	0101000020E6100000023080379B0C54C05CDCF691E2C63940	0101000020BC080000F1B3DEEBCC162C412811E786C0082041
519	10318	BAPTIST WAY	975	N	N	Y	1	0	1	8/16/2016	25.47777	-80.4302	844138.60077199	416293.491954304	6ad017bf-2b94-41e6-a04b-b4cd7eae9cac	0101000020E610000037947879881B54C05AC7DFB24F7A3940	0101000020BC080000AE07E660D3C22941695F28A69C681941
520	7750	NW 36 ST	NW 23 AV	E	N	Y	0	0	0	11/7/2016 11:28	25.8092	-80.23424	908088.980419502	537076.741855524	31033f20-592b-4762-bfc6-f82b9c07a6f4	0101000020E610000023ECD7E5FD0E54C04F892AF927CF3940	0101000020BC08000067027C2B70B62B4109DCF8E2EC632041
521	10174	SW 47 ST	SW 159 PL	W	N	N	0	0	1	10/12/2016 13:5	25.72059	-80.45264	836371.385030523	504514.765271865	542c048d-68aa-437b-be5c-1dd92c70e7e6	0101000020E6100000B7DEB421F81C54C0856B433879B83940	0101000020BC080000987F51F124862941FED815D511CB1E41
522	1456	NE 6 AV	NE 114 ST	NW	N	N	0	0	0	11/19/2002	25.87978	-80.1858	923867.069293872	562826.175227672	43df0e1c-aaa8-43a8-ab56-e4569f15de09	0101000020E61000001646823DE40B54C003DB638139E13940	0101000020BC0800001581F55AB4312C4105932EC4172D2141
523	10527	NE 2 AV	NE 1 ST	W	N	N	0	0	0	11/8/2016	25.77583	-80.19032	922615.798459865	525035.784956902	186feb65-2d2f-467c-b45f-c540d224ee87	0101000020E61000002C87662E2E0C54C0B93C734C9DC63940	0101000020BC080000062B2DD0ED272C41E4A778F7DA052041
524	2383	W 49 ST	W 3 LA	E	N	Y	0	0	0	10/14/2016 12:3	25.86658	-80.29011	889596.995420754	557828.941499263	685acff4-db93-4681-9b52-4e113a3ab16d	0101000020E6100000B7A9B630911254C098A5455DD8DD3940	0101000020BC08000036209830F8252B414608D44B0D062141
525	7656	NW 62 ST	NW 17 AV	E	N	Y	1	1	0	10/18/2016 15:3	25.83161	-80.2251	911050.343560886	545238.570631199	02b15194-d4df-498e-a3be-f249224c8f89	0101000020E6100000B55B8908680E54C0E2B55770E4D43940	0101000020BC0800007B2FAAE592CD2B4164CD5F8CB0A32041
526	3469	SW 107 ST	SW 109 CT	NE	N	N	1	1	1	9/29/2016 13:52	25.66996	-80.3721	862976.996492345	486230.397003815	30c047d4-cfe1-4ac8-a1ec-3f9c8bf3656b	0101000020E61000004083627BD01754C00581150083AB3940	0101000020BC0800000DF4EC2D00562A41CE665D5760AD1D41
527	7567	NW 57 AV	NW 5 ST	S	N	Y	1	0	0	12/1/2016 11:20	25.77634	-80.2884	890336.745925497	525032.982118703	dd45ce97-3d50-4e11-b8f6-71d9e127ccf2	0101000020E61000006291702C751254C0B8CEEA64BEC63940	0101000020BC0800006C6F1AB1BF2B2B4194D05B5CD5052041
528	4758	NW 17 AV	NW 93 TE	N	N	Y	0	0	0	8/18/2016	25.8595	-80.22572	910787.007486343	555374.508730583	f9d31ca5-d6ab-4c63-827d-1e7938541854	0101000020E6100000F3D9D02C720E54C0630A073D08DC3940	0101000020BC080000C90C963984CB2B4160D8026EE0F22041
529	57	NW 7 ST	NW 42 AV	E	F	Y	1	1	1	9/7/2016 12:38	25.77862	-80.26333	898580.975137226	525908.83373332	a9101baf-6219-41b8-8a68-60eae4a2cd3d	0101000020E610000069DEFB7DDA1054C0D09DE12454C73940	0101000020BC080000E7B98627286C2B41A6E28C10AD0C2041
530	4832	NW 22 AV	NW 46 ST	S	F	Y	1	0	0	8/18/2016	25.81644	-80.2325	908647.079369031	539710.490155913	fcc8aa68-4cfd-4487-8942-2a6b4b0295ff	0101000020E610000050A82B57E10E54C0C1E1E74102D13940	0101000020BC0800003B552F5ECCBA2B4111395F6280782041
531	9192	COLLINS AV	#15800	N	N	N	0	0	1	10/11/2016 13:0	25.92154	-80.1223	944647.964044906	578140.65842285	43e817dd-57bd-4e9e-aed2-cb85f6fe6367	0101000020E61000004F4931B1D30754C05EB1757CEAEB3940	0101000020BC080000ACC7A7270ED42C410AACA3BDBCA42141
532	7177	NW 12 AV	NW 46 ST	N	F	Y	1	1	1	11/8/2016 14:03	25.81762	-80.21588	914111.461812705	540174.165407538	1aea75be-d92f-4718-82ab-7e262ba10495	0101000020E610000034383412D10D54C018F27A0C50D13940	0101000020BC08000020D0AC227DE52B41DC2630BC1F7C2041
533	4781	NW 22 AV	NW 48 ST	N	F	Y	1	0	0	10/17/2016 17:2	25.81922	-80.23233	908697.436225496	540721.619711414	91f74b43-531e-474b-9902-90bfec68f08f	0101000020E61000009528F189DE0E54C07F235F83B8D13940	0101000020BC080000B6CDE11431BB2B41E65EF5A466802041
534	8772	NE 12 AV	W DIXIE HWY	N	N	N	0	0	0	11/4/2016 12:08	25.90334	-80.1749	927400.47524846	571412.01434838	db967aa6-6086-41db-8e20-c0434dff9547	0101000020E61000009082A47D310B54C068A9B58841E73940	0101000020BC0800009891382B4F4D2C419C0CF2722B702141
535	611	NW 27 AV	NW 199 ST	N	F	Y	1	1	1	9/19/2016 18:22	25.9564	-80.24586	903958.595972143	590559.163105153	7de01e10-d718-42d5-8450-80a0b5ec2ee0	0101000020E61000002ECCAF47BC0F54C06B88E033D7F43940	0101000020BC080000E09FE5652B962B411C859BC1C1052241
536	156	Golden Glades P&R	(West lot)	T	T	N	2	1	2	9/20/2016 13:13	25.9208	-80.21507	914155.735987555	577676.084202252	bfa01cf1-79bb-4a75-abf8-e7b49cafef64	0101000020E6100000EDCAAAB3C30D54C033889E98B9EB3940	0101000020BC080000FD00ECAED5E52B4152B873971BA12141
537	8878	NW 125 ST	NW 11 AV	SE	N	N	1	0	0	10/31/2016 16:4	25.88857	-80.21717	913533.104011364	565959.423551992	8cdffc44-8265-4c84-9952-cb64c866daba	0101000020E61000002A2B1039E60D54C08B2578C379E33940	0101000020BC08000045F1456BF8E02B412717BA4392452141
538	7840	NW 20 ST	NW 2 AV	E	N	N	1	0	1	9/1/2016 13:52	25.79531	-80.19901	919712.599573612	532099.367283396	6ef89a12-a866-4be3-be8b-e75f914f7a33	0101000020E6100000C0A11C93BC0C54C0B59E42129ACB3940	0101000020BC080000C9CAE2693F112C416BC686220A3D2041
539	3549	SW 168 ST	SW 147 AV	W	N	N	0	0	0	11/29/2016 12:3	25.61118	-80.4297	844096.091006964	464781.290958062	972b934c-0e66-4f9c-9651-4de149a0028e	0101000020E610000015E4F13F801B54C088E1D1DB769C3940	0101000020BC080000C8C4D55B7EC229417E32F6E43B5E1C41
540	8799	NE 6 AV	W DIXIE HY	N	F	N	1	1	1	11/1/2016 11:05	25.89098	-80.18641	923643.570673108	566894.385632038	406aee6e-55c5-47dc-b258-c96f3bcc03c1	0101000020E61000001603AE1EEE0B54C051EE283F17E43940	0101000020BC08000055F9965BF52F2C41367C8330E04C2141
541	5770	N MIAMI AV	NE 188 ST	N	F	N	0	0	0	10/26/2016 12:5	25.94756	-80.20125	918639.239486825	587431.917699479	9e74d6c2-a7ff-42ca-b3b2-6eae134fd766	0101000020E610000086032D42E10C54C0AD42EFAA93F23940	0101000020BC080000E32746B1DC082C4106F18D4353ED2141
542	4956	NW 32 AV	NW 30 ST	S	N	N	0	0	1	9/1/2016 14:09	25.80347	-80.24831	903473.203866966	534967.403530672	3fd94a2c-feb2-4669-817b-bb434f3a49fc	0101000020E6100000D6AFF05AE40F54C0A5BEB273B0CD3940	0101000020BC080000F977449D60922B41C88A7C3572532041
543	8876	NW 125 ST	NW 13 AV	SE	N	N	1	0	1	10/31/2016 16:3	25.88839	-80.2212	912208.181821134	565886.839748949	8aee970a-6973-4796-87b1-d4a5430ead79	0101000020E610000083BD4E44280E54C0F54F23196EE33940	0101000020BC0800008B9302939ED62B41EFFFD21801452141
544	9555	NW 41 ST	NW 107 AV	E	F	N	1	1	1	11/8/2016 11:21	25.81151	-80.36873	863840.814340051	537680.755090326	a97e8ddf-ffd2-48a1-a067-d420758fb92c	0101000020E6100000FB449844991754C0CB6EF33ABFCF3940	0101000020BC0800006E18A4D0BF5C2A412FFCB8E9A4682041
545	5686	W DIXIE HY	NE 190 ST	S	N	Y	1	0	0	11/1/2016 12:06	25.95131	-80.14902	935794.052325483	588902.722154424	44c49018-b1c0-40fc-939c-8964d9d7cb13	0101000020E610000061399C85890954C0DF38C15C89F33940	0101000020BC0800007939C753E28E2C41FCCBB5DFD0F82141
546	499	NW 27 AV	NW 175 ST	S	F	N	1	1	1	9/19/2016 10:02	25.9331	-80.24506	904269.971625209	582089.952360712	75ffb1e7-bee9-46d6-a328-9936e86aa249	0101000020E61000002ED26F30AF0F54C0B3D1C1E2DFEE3940	0101000020BC08000018C94A269A982B419587905497C32141
547	2372	E 32 ST	E 4 AV	E	N	Y	1	0	0	10/20/2016 10:5	25.85135	-80.2748	894660.391781185	552321.934426852	65171bf7-bc60-4c64-a2c3-f28108680aa6	0101000020E6100000A752DE6E961154C0BB9C8E72F2D93940	0101000020BC08000078123CFC864D2B412493934707DB2041
548	7957	NW 7 ST	NW 38 CT	W	F	Y	1	1	0	9/7/2016 13:49	25.77895	-80.25868	900111.85105047	526035.550678991	69be6d6d-c0d6-4d9d-b91f-23379e5ee959	0101000020E6100000A28DB03D8E1054C071827A7169C73940	0101000020BC0800008A5621E81D782B418A4C9A7FAA0D2041
549	7842	NW 20 ST	NW MIAMI CT	E	N	N	0	0	0	9/1/2016 14:00	25.7954	-80.19604	920688.660909876	532136.939355485	729e15e6-6103-47a2-9cdc-237a155c8a1d	0101000020E61000000EFE9AF68B0C54C0DF65E2C59FCB3940	0101000020BC080000EBCA7189DF182C41C3968247553D2041
550	7895	NW 14 ST	NW 13 AV	E	N	N	2	1	0	8/31/2016	25.78747	-80.21641	914002.672664806	529214.600752339	b1621cc6-727a-499a-a735-d210654f7317	0101000020E6100000D393FCBCD90D54C057EC482398C93940	0101000020BC0800006B22B48EA3E42B4177EA9E9980262041
551	8438	N MIAMI AV	NE 100 ST	N	F	N	0	0	0	11/3/2016 17:11	25.86717	-80.19758	920024.406374484	558217.873434521	b01c4578-d230-4258-8f05-4d657946bf10	0101000020E6100000B171DE1CA50C54C01F164EE6FEDD3940	0101000020BC08000058320607AF132C4199211C2917092141
552	3254	SW 122 AV	SW 191 TE	S	F	Y	0	0	1	11/29/2016 14:0	25.58826	-80.38905	857531.064457469	456508.928250886	3d5aaa06-c8bc-4545-a1be-8fedd759b350	0101000020E6100000649FD930E61854C064AF0F7298963940	0101000020BC0800004B8A1250742B2A418B44756FFADC1B41
553	3319	SW 139 AV	SW 180 ST	S	N	N	0	1	1	10/31/2002	25.6007	-80.41776	848047.794692464	460988.377300061	3a9dead6-5086-474a-89ad-c9fb0eb3548f	0101000020E61000005254BE9BBC1A54C0A21E3DD8C7993940	0101000020BC080000133DB0C45DE129419021713CF8221C41
554	6787	NE 2 AV	NE 19 ST	N	N	Y	1	1	1	11/4/2016 10:26	25.79459	-80.19066	922461.68821663	531851.928447634	d0728cd7-202b-43cd-866d-6125c53bf1ca	0101000020E6100000E401A9C4330C54C0A1103B6D6ACB3940	0101000020BC080000D2A5BC97B9262C4115F4E6411B3B2041
555	10138	NW 54 ST	NW 32 CT	\N	\N	\N	\N	\N	\N	 	25.82356	-80.25021	902808.117293045	542265.145478763	805f21d3-7980-4341-b5e0-4ef1508a5f9f	0101000020E6100000CB082767031054C0D0697EF0D4D23940	0101000020BC08000094C7BF702E8D2B4167D354B2758C2041
556	6246	NW 27 AV	NW 163 ST	N	N	N	0	0	0	10/31/2016 12:5	25.92255	-80.24436	904523.788416564	578256.299260534	dcc79ac7-7071-40a5-9ea0-a4a7b4a3bbfd	0101000020E6100000314D72A3A30F54C03F624C6A2CEC3940	0101000020BC080000D11B98C8959A2B413C84A305A4A52141
557	5620	NW 119 ST	NW 14 AV	E	N	Y	1	0	0	9/30/2016 12:17	25.88311	-80.2231	911595.194559813	563963.650025837	a2546163-e76b-4b12-9004-27640838679c	0101000020E6100000A8564A61470E54C0D1FDA10014E23940	0101000020BC08000067017799D4D12B412EB375B7FA352141
558	7501	INGRAHAM HY	HARDEE RD	SW	F	N	0	0	0	9/22/2016 13:23	25.71275	-80.25406	901769.259158704	501984.397963293	fe6f3391-5b7d-4143-ad4e-f157c61330d3	0101000020E6100000C74C687F421054C02FBC993877B63940	0101000020BC080000642477B910852B41E546B15C88A31E41
559	8595	NE 15 AV	NE 159 ST	N	F	N	0	0	0	9/30/2016 15:06	25.92246	-80.16982	929022.854893137	578371.444347434	0400c125-d79b-4832-ba2b-aa972164ac36	0101000020E6100000743AB670DE0A54C062769D7326EC3940	0101000020BC080000A557CDEDFB592C4108541D508AA62141
560	172	NW 22 AV	NW 36 ST	N	F	Y	1	1	0	10/17/2016 16:3	25.80967	-80.23194	908845.664578449	537251.986896478	1672aad5-33f6-4926-928c-48ae08daf66f	0101000020E6100000286A5B2AD80E54C0C9A076C646CF3940	0101000020BC080000FC15D28959BC2B414E5C6A604B652041
561	5855	NW 183 ST	NW 57 AV	E	F	N	1	0	0	12/4/2002	25.93924	-80.29267	888611.417002961	584235.789228544	d8af39b1-c21f-4726-b862-3b2569e6e858	0101000020E610000033E0EA32BB1254C04507FA8972F03940	0101000020BC0800004B454708451E2B41D1CC47015BD42141
562	9304	SW 72 ST	SW 64 CT	E	N	N	1	0	0	9/26/2016 14:52	25.70382	-80.29804	887304.941258546	498658.235023446	01e2f315-1ba5-4b1b-947b-3c0238121e97	0101000020E6100000143F5719131354C0B525ADC92DB43940	0101000020BC080000715BC21410142B41B5C5DBB48F6F1E41
563	1389	AVENTURA BD	BISCAYNE BD	W	N	Y	0	0	0	12/13/2002	25.95999	-80.14652	936592.689481251	592064.864490241	8a175df1-2f4f-4f89-a3ce-489c6d0facc2	0101000020E610000007C435AD600954C095EDE78AC2F53940	0101000020BC08000047AF139A1F952C41D990012985112241
564	7412	SW 27 AV	SW 24 TE	N	N	Y	1	1	1	9/16/2016 10:33	25.74614	-80.23796	906999.997043263	514148.485870607	3133a1c8-a174-4a42-b3ed-b2ea36f325f2	0101000020E610000071A54ABB3A0F54C07807521303BF3940	0101000020BC0800007C37DF33EEAD2B41C416C5B998611F41
565	8422	NE 2 AV	NE 100 ST	N	F	Y	1	0	1	11/4/2016 12:55	25.86736	-80.19351	921362.356412284	558295.132115275	fa503476-b994-4278-b578-316cf0adf3dc	0101000020E61000007A850C6E620C54C024BFFC590BDE3940	0101000020BC0800004536ACED221E2C41D8EA97ADB1092141
566	8192	SW 8 ST	SW 9 AV	E	N	Y	1	0	1	9/8/2016	25.76587	-80.20907	916465.437393222	521375.629849508	9ee14013-17fb-493d-a795-faabca1aa5c6	0101000020E610000069BE9776610D54C03D9DE21910C43940	0101000020BC0800007D9C7B16E1F72B4186AA074F85D21F41
567	7970	NW 7 ST	NW 58 AV	W	N	Y	1	1	1	9/6/2012 12:14	25.77805	-80.28987	889848.647163186	525652.976947293	f7ae4d5a-9bec-40ee-83dd-138476360694	0101000020E6100000C52DA64E8D1254C049424BA82EC73940	0101000020BC0800007E2B7A7EEF272B415EC4BB59AD0A2041
568	10601	NE 123	Biscayne Blvd	W	F	\N	\N	\N	\N	 	25.88946	-80.16439	930885.690401986	566389.94269409	9adab124-c4af-493b-9e99-9bb053f3ceea	0101000020E610000085CCA964850A54C017AE3817B4E33940	0101000020BC080000B475C69989682C41A424B34DEF482141
569	7035	NW 7 AV	NW 34 ST	S	F	Y	0	0	0	9/20/2016 12:28	25.80791	-80.20754	916876.368686385	536661.696101323	60f6e928-755c-44fb-947e-21b0e6940a1a	0101000020E6100000F006B36D480D54C0330475C2D3CE3940	0101000020BC08000072FA52F316FB2B41394274CBAE602041
570	7817	NW 20 ST	NW 23 AV	W	F	N	0	0	0	8/31/2016	25.79456	-80.23387	908242.67203293	531755.58779636	9c9d1eb2-34c4-41fc-803a-1de78506c82b	0101000020E6100000F0EE5DC9F70E54C09C4E1C6568CB3940	0101000020BC080000B4D38E8DA3B72B41735B5E935A3A2041
571	9136	SW 57 AV	SW 91 ST	N	N	N	1	0	1	11/30/2016 11:1	25.68625	-80.28465	891748.630893245	492298.11060822	bc1c1a9b-84d9-4b7c-b0a4-95330cfd7a06	0101000020E6100000684296B7371254C0034896B6AEAF3940	0101000020BC080000A3068076C7362B417F8EDF332F0C1E41
572	6438	NW 175 ST	NW 29 PL	E	N	N	1	0	1	10/26/2016 13:5	25.93345	-80.24988	902688.419363271	582208.086923614	fcd80484-6651-4d7a-b5b7-6629bcf74a6d	0101000020E610000046780AFFFD0F54C097A4C7D2F6EE3940	0101000020BC08000093145E0B3F8C2B41EFD86D9983C42141
573	1817	NW 36 ST	NW 79 AV	E	N	Y	1	0	0	11/11/2016 12:1	25.80917	-80.32551	878062.963673756	536900.071900629	83a97b53-c7a7-4614-bfad-44e24182b98e	0101000020E610000096AE4E33D51454C0689DB4BE25CF3940	0101000020BC0800003376E61EDCCB2A419EF3CE8B8B622041
574	10539	NE 36 St	2 Ave	E	N	\N	\N	\N	\N	 	25.81048	-80.19148	922156.067135032	537626.143306956	6e047094-4862-4426-9cb2-fa4412ca9422	0101000020E6100000A1FD2F38410C54C02B0A06DC7BCF3940	0101000020BC0800001D06A95956242C41961B8AB037682041
575	4130	SW 40 ST	SW 114 CT	E	F	N	1	1	1	10/13/2016 14:1	25.73198	-80.38001	860264.871634383	508758.788934015	239b0349-1c8e-473c-bc90-4cd767cf8f11	0101000020E6100000C80EEF20521854C04C39B96963BB3940	0101000020BC08000054E48AEDCF402A4143F7ABEE610D1F41
576	3265	SW 122 AV	SW 185 ST	N	N	N	0	0	1	11/29/2016 12:4	25.59625	-80.38889	857568.110018447	459413.838770039	f08ca45a-ca30-4770-97f3-e0276ca071fc	0101000020E610000068F31EAFE31854C065D09D35A4983940	0101000020BC080000CABF6B67BE2B2A411FD9D8145E0A1C41
577	4470	SW 87 AV	W FLAGLER ST	S	F	N	1	1	0	11/9/2016 16:52	25.76898	-80.33649	874523.228954934	522274.598887563	c660375a-0a97-4d2a-b444-3f010933f68e	0101000020E6100000056A5A25891554C0533200EBDBC43940	0101000020BC0800000B3853A634B02A4175D9952F91E01F41
578	8726	BISCAYNE BD	NE 135 ST	NE	N	Y	1	1	1	10/8/2016	25.89969	-80.16049	932146.77019465	570115.399207264	29a96f9b-b8d9-4820-a35d-a777d2ce28e9	0101000020E61000003A7F515D450A54C082A6DC5352E63940	0101000020BC080000E393C3C263722C41D198D6370A662141
579	1243	US HWY 41	SW 7TH ST	W	N	Y	1	1	0	9/8/2016 12:38	25.76618	-80.23673	907360.721066989	521437.169751696	f26efe61-5dee-46db-933f-71cd2e5bfefc	0101000020E61000006E3377AD260F54C0A28843E024C43940	0101000020BC0800008DF192A6BFB02B4181CFF0777BD31F41
580	3137	SW 107 AV	SW 93 ST	N	F	N	1	1	1	10/27/2016 11:5	25.68295	-80.36782	864365.480903257	490955.469274625	334be3e4-0261-487a-9c2d-067915f0a24a	0101000020E61000006A8FFB4A8A1754C02214F4C9D5AE3940	0101000020BC08000036F31826D9602A411BED7DA234F71D41
581	1230	NE 2 AV	NE 62 ST	N	F	Y	1	1	1	11/1/2016 15:01	25.83303	-80.19215	921885.946615674	545822.841146052	ff01a8c1-44df-4228-986e-65f883466477	0101000020E61000005C4DFC294C0C54C0530A390642D53940	0101000020BC080000ECCFE21B3A222C41B109F31641A82041
582	8842	NW 7 AV	NW 123 ST	S	F	Y	0	0	0	9/21/2016 13:17	25.88693	-80.21087	915608.665484559	565373.560545459	8b4e2068-a78a-4397-83e3-65388b6983f8	0101000020E610000050998CF87E0D54C0C5112DE40DE33940	0101000020BC08000032AD148B2FF12B41C836E089FE402141
583	9576	S DIXIE HWY	SW 68 CT	S	F	N	0	0	0	11/16/2016	25.69092	-80.30613	884668.28808878	493954.850041054	39600941-7af8-4bcb-b4a5-aa426ab8b9e8	0101000020E6100000235CB683971354C06563F93DE0B03940	0101000020BC080000CD3CFCC576FF2A413ACC6A2912261E41
584	3797	SW 296 ST	SW 150 AV	E	N	N	0	0	1	8/16/2016	25.49208	-80.43475	842617.142551083	421485.400493458	39835e85-57a8-460d-a9ea-f237454a1099	0101000020E61000008D3C97F0D21B54C0828B730FF97D3940	0101000020BC0800009B422476F0B62941F9AA0D4ABCB91941
585	677	COLLINS AV	96 ST	N	N	N	1	1	1	10/11/2016 12:3	25.88696	-80.12262	944623.255765308	565571.248798847	7048f1a3-cfa7-415e-96f5-cb28f69bfe17	0101000020E6100000895E801DD90754C01867F55010E33940	0101000020BC08000074511FBDDCD32C412F2A43EA89422141
586	4665	SW 72 ST	SW 77 CT	E	N	N	2	0	0	9/26/2016 14:13	25.70281	-80.31893	880432.026219498	498256.244669005	1832896e-53e2-413e-ae69-ad49bf4e17f5	0101000020E6100000AD850B2A691454C0E4DF02CBEBB33940	0101000020BC0800005EE5543F5EDE2A41A507A0BE47691E41
587	9285	SW 40 ST	SW 64 AV	E	F	N	1	0	0	10/13/2016 12:5	25.73344	-80.29844	887116.675226621	509423.908658639	af2933a4-3e86-42d6-b16a-f4f5d206f04a	0101000020E610000065E7AC9E191354C093EB7B18C3BB3940	0101000020BC080000A473848C97122B41E54A5169C6171F41
588	1403	S FEDERAL HY	SE 9 ST	N	F	Y	1	1	0	12/13/2002	25.97696	-80.14186	938087.049678568	598243.144107468	0f0d5051-5379-4958-8963-d27d6bb54e8f	0101000020E610000039249D25140954C0312955B01AFA3940	0101000020BC0800008CC0A852CCA02C410579F1B8C9412241
589	6934	NW 2 AV	NW 27 ST	S	F	Y	0	0	0	11/4/2016 14:37	25.80194	-80.19921	919636.083606925	534508.418253846	144be064-55c5-4bb4-96ff-047e7cc8138a	0101000020E61000008F79A3A7BF0C54C073D175824CCD3940	0101000020BC080000E4EBCB61A6102C411252FC3CDC4F2041
590	3818	BUSWAY	SW 160 ST	NE	F	Y	3	1	1	9/29/2016 14:54	25.61985	-80.34553	871815.906985451	468060.55767256	9b79b8f9-b222-4472-9bf1-54349419dbd3	0101000020E61000006AAD3E4A1D1654C07C415E0EAF9E3940	0101000020BC080000257B41010E9B2A41C5734FF778911C41
591	7417	SW 27 AV	SW 16 ST	N	F	Y	0	0	0	9/16/2016 10:57	25.75803	-80.23843	906820.96917408	518472.082220413	e4980373-6ba2-4892-a5d8-5d0bc1600b06	0101000020E610000043933A66420F54C0C5FEB0D20EC23940	0101000020BC080000988A892588AC2B41FF99761D27A51F41
592	7557	SW 42 AV	SW 5 TE	N	F	N	1	0	0	2/13/2017 15:02	25.76684	-80.26328	898625.648315657	521626.992230996	3cb5d47b-3ca1-4725-b50f-6837a17f719b	0101000020E61000004A70BD75D91054C02E5E711050C43940	0101000020BC0800006D154480816C2B41196818C272D61F41
593	9194	COLLINS AV	160 ST	N	N	Y	1	0	1	10/11/2016 13:0	25.9254	-80.12216	944681.291066106	579544.697557248	3caab10d-44aa-4366-bdd1-c9705070849e	0101000020E6100000F435EE8FD10754C0BA6D1596E7EC3940	0101000020BC08000027712BCF50D42C41B44FE4D1B4AF2141
594	3985	SW 137 AV	SW 79 ST	N	N	N	1	1	1	1/5/2017 11:14	25.69278	-80.41562	848603.99505676	494459.021294229	362e6c29-9c61-4df8-a93b-1ee7f09058f9	0101000020E6100000C908B89C991A54C04D2902995AB13940	0101000020BC080000E6FE532BB6E5294115B2DBD8F22D1E41
595	3029	US 1	BROAD CHANNEL DR	NE	N	Y	1	0	0	8/16/2016	25.59262	-80.35685	868140.090845879	458145.570936941	0b5927e7-f695-4cd7-8aa6-a301e9235e8a	0101000020E6100000E0411672D61654C05ABCA582B6973940	0101000020BC080000F715F55E567E2A41ACFF35028DF61B41
596	2024	E 4 AV	E 56 ST	N	F	Y	1	0	0	10/7/2002	25.87371	-80.27474	894638.539116703	560448.452612042	d609140c-d48e-4ec0-bbe2-730263a9d55a	0101000020E610000014044549951154C0D9DDA1B3ABDF3940	0101000020BC0800002F0BBD475B4D2B41CD1CE251841A2141
597	8442	N MIAMI AV	NE 111 ST	N	F	N	0	0	0	11/11/2002	25.87742	-80.19806	919843.471994091	561943.579238437	e4be30d6-6fdb-4587-afbe-a9631aa3dc28	0101000020E61000006A7755FEAC0C54C01B1626D79EE03940	0101000020BC0800002E64992845122C4168A9E09232262141
598	7711	NW 46 ST	NW 17 AV	W	M	Y	0	0	0	8/18/2016	25.81711	-80.22527	911028.103467256	539967.614342883	743d3533-692e-4282-826c-14784b403a74	0101000020E6100000A2FA02B06A0E54C0115FE0192ED13940	0101000020BC080000F2A6BD6A66CD2B4130A30AA2827A2041
599	3046	SW 97 AV	SW 88 ST	S	F	Y	1	0	0	9/29/2016 12:07	25.68672	-80.34998	870231.523326654	492355.626883544	13023a82-2786-4219-882f-2f6e5b9c1d6c	0101000020E6100000DD1B2322661654C065C3301FCDAF3940	0101000020BC0800006769813CAD8E2A4190507244150D1E41
600	1431	HALLANDALE BEACH BD	SE 16 AV	E	F	Y	0	0	0	11/3/2016 16:01	25.98572	-80.13204	941288.228944816	601445.950714521	d7cfe7cc-9fbe-4e9e-b9b8-d04046daa2b9	0101000020E6100000721BDE73730854C03F70595358FC3940	0101000020BC080000DEB2E3AECEB92C41F2655256CF5A2241
601	7629	NE 79 ST	PELICAN HARBOR DR	E	F	Y	1	0	0	10/20/2016 11:3	25.84819	-80.16623	930376.973225433	551385.570833355	5a87ae56-042b-421a-a201-8aca72c936af	0101000020E6100000678E977DA30A54C02EC1556B23D93940	0101000020BC0800001BDEA22A90642C419F93438DB6D32041
602	1526	SW 42 AV	MADEIRA AV	S	N	Y	0	0	0	2/16/2017 10:42	25.75578	-80.26303	898725.798655406	517606.441210032	f3454c34-079b-46bc-a44f-668acb59e51c	0101000020E6100000C154E397D51054C04C0A0D0A7BC13940	0101000020BC080000999427CD496D2B41321AFF8CA0971F41
603	3365	SW 147 AV	SW 171 TE	N	N	N	1	1	1	11/29/2016 14:1	25.60795	-80.42987	844045.456930134	463605.299198508	eaa0d5e9-aeef-41c8-a2ad-1d2402ab4277	0101000020E6100000625AC704831B54C0388787D9A29B3940	0101000020BC0800000F0A481719C22941949355EDDB4B1C41
604	2577	W MOWRY DR	SW 5 AV	E	F	N	0	0	0	8/16/2016	25.46975	-80.48402	826395.105733421	413304.891958982	cebd55a6-b15b-4492-b102-77a706bc8442	0101000020E61000008571C83EFA1E54C0EE716FD641783940	0101000020BC0800001832476134382941BEF3DF3EEA391941
605	5877	NE 185 ST	# 1551	W	M	N	1	1	1	10/27/2016 12:3	25.94564	-80.16953	929068.699291449	586798.537096411	364b8ba6-3291-4343-963e-5810e8e074e1	0101000020E61000007607097ED90A54C0318DE6C515F23940	0101000020BC08000048DB079E575A2C4103C6938060E82141
606	7314	SW 22 AV	SW 2 ST	S	F	Y	1	0	0	10/17/2016 12:3	25.77059	-80.23098	909244.787806239	523048.510024652	c797941f-4aab-4a0a-b5c7-855056bba2b1	0101000020E610000065E39F6BC80E54C0F5785C6E45C53940	0101000020BC080000030B06C977BF2B416800E1D4A8EC1F41
607	4719	NW 7 AV	NW 83 ST	N	F	N	1	1	1	9/21/2016 13:54	25.851	-80.20917	916246.565779801	552319.610606834	d4aaeae9-1a2e-409d-aa6d-797be5b42621	0101000020E6100000B358081A630D54C00B825293DBD93940	0101000020BC080000656F24582BF62B41B31FBEA102DB2041
608	310	SW 37 AV	GRAND AV	N	F	Y	0	0	1	11/16/2016 11:4	25.72804	-80.25352	901912.686636128	507540.522672467	a77c061c-372b-4027-9ef4-52cc91d12f02	0101000020E6100000B4DE3BCC391054C06830A1DF60BA3940	0101000020BC080000E9E73B942F862B4133ADBDDD58FA1E41
609	5676	GOLDEN GLADES	NW 7 AV	W	F	N	0	0	0	10/22/2002	25.92138	-80.21412	914466.711756371	577891.314082347	719e984e-29d4-42e7-8380-f2c9aaf0d6d9	0101000020E61000009B491223B40D54C09BB6DA10E0EB3940	0101000020BC0800002A16AEA243E82B41E3C3310DCAA22141
610	8673	NE 164 ST	NE 17 AV	E	F	N	1	1	1	11/3/2016 14:14	25.92691	-80.16564	930386.783567991	579999.819362201	143cc66c-4322-4510-a6a6-10a7213e9775	0101000020E6100000659C52F0990A54C0C52EE87A4AED3940	0101000020BC0800009B7F6EC9A3642C41912B4E1043B32141
611	4987	NW 72 AV	# 4535	N	M	Y	1	0	0	10/10/2016 11:4	25.81483	-80.31327	882078.119685683	538978.454894669	62c08918-4c3f-49d2-9e80-f2f5438bf150	0101000020E61000006D3598B50C1454C0A85C8EBE98D03940	0101000020BC0800004AB04C6F3AEB2A41AF1F2A50C8722041
612	6993	SW 3 AV	SW 26 RD	SW	F	Y	1	0	0	9/14/2016 11:32	25.75539	-80.20844	916700.264683753	517567.422584824	1e81f18d-0def-487b-8655-d5fb86e87c1a	0101000020E6100000FE8B75E9560D54C01B41DB3761C13940	0101000020BC08000035D515BEB6F92B41041A0B7A04971F41
613	6303	NW 37 AV	NW 191 ST	N	N	Y	1	1	1	9/19/2016 15:23	25.94692	-80.26159	898809.003892321	587083.616884746	c4bef82a-2fb2-496c-8ec0-2c0bde90a252	0101000020E61000000A294D04BE1054C0720F0BDB69F23940	0101000020BC08000035321036F06D2B4136E361A99AEA2141
614	4428	SW 67 AV	SW 49 TR	S	N	N	1	1	1	10/10/2016 14:4	25.72454	-80.30259	885768.566732466	506181.160931103	8c42650a-a6a2-4126-acaf-ddc7a05dde3d	0101000020E61000006BE775905D1354C07E40AFB17BB93940	0101000020BC080000B214C9540F082B41C4BFFA6A1BE51E41
615	8797	NE 6 AV	NE 121 ST	N	N	N	1	0	0	11/13/2002	25.88656	-80.18618	923726.180078089	565290.467215747	f402035d-7a72-4315-ae3a-5c1512f04ccd	0101000020E61000001624BD7FEA0B54C0CC1D80F8F5E23940	0101000020BC080000DBF19A939A302C41517FF85958402141
616	4473	SW 87 AV	SW 5 ST	S	N	Y	1	0	0	11/9/2016 16:53	25.76459	-80.33633	874585.231142689	520680.375321075	76e6979c-83bc-4021-a484-8d7daeabcdfc	0101000020E61000009DB87C75861554C0121B5369BCC33940	0101000020BC080000910573A7B0B02A41425B0C4AA8C71F41
617	5242	NW 46 ST	NW 21 AV	W	N	Y	0	0	1	8/18/2016	25.81691	-80.23016	909415.54108464	539888.723414779	cc68fc9a-c5aa-48fa-ad87-bcec091ada16	0101000020E6100000C775B004BB0E54C0C3816D9521D13940	0101000020BC0800004350B94ACDC02B416A59D6D9E4792041
618	3538	SW 160 ST	SW 139 AV	W	N	N	1	1	1	11/29/2016 12:1	25.61881	-80.41842	847802.395285234	467568.740747891	f0d16435-e5c0-4aa0-b710-fc508b1c6354	0101000020E6100000A59E675FC71A54C066B323926A9E3940	0101000020BC080000B7DF1AF872DF2941279E6BB2C9891C41
619	9661	SW 6 AV	SW 4 ST	S	N	N	0	0	0	10/21/2016 13:2	25.44374	-80.48539	825984.235835105	403849.054869793	a3fe2495-3b9e-4838-abfe-d0aae82041f4	0101000020E610000074124276101F54C0B3569B0C99713940	0101000020BC0800008276B7A3FE342941EDD46BE32AA61841
620	1363	NE 29 PL	AVENTURA BLVD	N	N	N	2	0	1	8/27/2002	25.96007	-80.14183	938134.232308354	592101.479909882	f4197aac-d222-43da-9a78-1e5f20d422c9	0101000020E61000003CB087CD130954C05FE3A453C7F53940	0101000020BC080000298E34B02AA12C41AC700A64CE112241
621	6551	NW 191 ST	NW 29 AV	W	N	N	0	0	0	9/19/2016 17:37	25.94813	-80.24915	902896.427171577	587545.949312873	f0c6f732-035b-49a2-8e7f-bb28ac1f5b02	0101000020E61000001E64FA19F20F54C0CA9FED05B9F23940	0101000020BC080000A88D6F0FDF8D2B41CF14C55337EE2141
622	5478	NW 6 AV	NW 151 ST	N	F	N	1	0	0	11/3/2016 13:18	25.91357	-80.20965	915951.105733648	575058.868979871	7824f61a-913b-41db-a06e-b1c204fd994a	0101000020E610000020E3B1FF6A0D54C08EE550C5DFE93940	0101000020BC0800004822836CDCF32B415469F728A98C2141
623	6263	NW 27 AV	NW 177 ST	S	F	N	1	0	1	11/10/2016 13:5	25.93514	-80.24519	904224.289017405	582831.196282461	e51e2a6c-f547-4d41-b836-02fcf03c2d5d	0101000020E610000092C0EA40B10F54C07452479465EF3940	0101000020BC0800007179E0C83E982B41B3DF7FD161C92141
624	6770	NE 2 AV	NE 39 ST	S	N	Y	1	0	0	11/1/2016 13:03	25.81291	-80.19147	922155.904023524	538509.40463765	27d7d681-dd83-4192-a795-8cb752999dd8	0101000020E6100000754513F5400C54C0A502AD1C1BD03940	0101000020BC0800000CDA280656242C41B74391361E6F2041
625	4865	NW 27 AV	NW 93 ST	S	F	N	1	1	0	9/19/2016 12:02	25.85818	-80.24228	905342.56465387	554863.328337528	7861dfb0-8dd0-406d-999f-5a1894f550f3	0101000020E6100000D8CE488F810F54C0E89FDECBB1DB3940	0101000020BC080000160A2456FBA02B41295C9011E2EE2041
626	7058	NW 7 AV	NW 17 ST	N	N	Y	1	1	1	9/20/2016 13:13	25.7914	-80.20687	917133.620443791	530661.092282809	bdb33722-7a2a-47b1-9fe8-d40c6b51d1f3	0101000020E610000026891F6B3D0D54C06F63359099CA3940	0101000020BC080000ACEA4C7419FD2B41BB318095CD312041
627	8036	W FLAGLER ST	OP SW 20 AV	W	M	Y	0	0	0	9/8/2012 11:14	25.77271	-80.22834	910108.447826423	523824.8575809	1dbbe619-656b-46d4-9eef-35e69c2a83b2	0101000020E6100000261E0D339D0E54C0901FA17FD0C53940	0101000020BC08000089DF021B37C62B410501F838CAF81F41
628	8932	NE 135 ST	NE 12 AV	E	F	N	1	0	0	11/14/2002	25.89986	-80.17454	927526.122628007	570148.228527635	09812989-5c41-4701-aea7-11543148e703	0101000020E6100000C2AF15A02B0B54C029EEC1885DE63940	0101000020BC080000B057A5764A4E2C41764067E04B662141
629	3181	SW 112 AV	SW 211 ST	N	M	Y	1	1	2	8/16/2016	25.57299	-80.37218	863117.979121387	450986.489118867	3dbee4df-ee43-414e-a960-33aa01601c39	0101000020E6100000D0CDB9C6D11754C0DE5407F9AF923940	0101000020BC080000E39410251A572A418B956AACB0861B41
630	3540	SW 168 ST	SW 104 AV	W	F	N	1	0	0	8/16/2016	25.61339	-80.36192	866429.459698096	465685.248767547	97e49818-d2a5-4118-b7a9-f4b34aad5184	0101000020E6100000427D29AD291754C063992B7F079D3940	0101000020BC080000FA69811BF9702A41EE6B12BA5B6C1C41
631	7181	NW 12 AV	NW 54 ST	N	F	Y	1	1	1	11/8/2016 14:09	25.8252	-80.21615	914006.547019165	542929.087755948	648bacc8-3928-4543-917d-57a5fca1e02d	0101000020E6100000DD51797AD50D54C0F63A96E040D33940	0101000020BC080000F6154A4EABE42B41BAC9DA94A5912041
632	5785	NW 47 AV	NW 188 ST	S	F	N	0	0	1	9/1/2016 11:35	25.94405	-80.2777	893520.790054254	586009.474013694	ae052600-6446-4a1d-aa75-b53302a3e056	0101000020E6100000D1D58DF6C51154C06FAE4E81ADF13940	0101000020BC08000076890AC89F442B418594286036E22141
633	6229	NW 22 AV	NW 167 ST	S	N	N	0	0	0	8/19/2016	25.92711	-80.23675	907014.093450487	579929.308012582	d4477429-eac9-42a2-a25d-771d6d192696	0101000020E610000021839005270F54C0DF53C37457ED3940	0101000020BC080000A6450F650AAE2B416896610AB6B22141
634	6573	NW 199 ST	NW 27 CT	W	F	N	1	0	1	9/19/2016 12:50	25.95552	-80.24775	903340.403296109	590232.831391238	d8b4d82e-7164-4bd7-b2ad-781a149869dd	0101000020E610000020D25632DB0F54C025E4B2019DF43940	0101000020BC0800008FC2450357912B415030B41735032241
635	7328	SW 22 AV	SW 24 ST	S	F	Y	1	1	1	10/17/2016 13:2	25.74712	-80.23009	909587.823572736	514522.265608616	4b358f1b-18a9-42c6-aea4-6d0a9cea2f67	0101000020E61000002AA27ED2B90E54C054EF72C243BF3940	0101000020BC0800002CA06BDB25C22B4139A554D86F671F41
636	1708	BLUE RD	RIVIERA DR	W	N	N	0	0	0	10/12/2016 14:4	25.72731	-80.2644	898332.252859857	507254.721431799	9c7c3bc0-235a-44f6-88dd-32c4ed6333eb	0101000020E61000003832460EEC1054C0262B7CF730BA3940	0101000020BC0800005C68C7B5366A2B4187833EA9E1F51E41
637	5352	W FLAGLER ST	NW 97 AV	W	F	N	1	1	1	9/8/2012 11:37	25.76909	-80.35374	868847.640258025	522287.103746675	ec9051f3-77eb-42c8-be5e-f2e23a748ec2	0101000020E610000094C625B0A31654C05E7D0D42E3C43940	0101000020BC080000DBFE3778DD832A4174AA9434C3E01F41
638	8167	SW 8 ST	SW 67 AV	W	N	Y	1	1	0	9/8/2016 10:51	25.76319	-80.30371	885327.9829247	520226.575077884	1acf3399-801d-4734-a7b9-6da87b9fae26	0101000020E61000006E95B9CC6F1354C0E4A0779860C33940	0101000020BC080000E06CDA299E042B413B82961691C01F41
639	6314	NW 37 AV	NW 209 TE	S	F	Y	0	0	0	9/19/2016 14:42	25.96605	-80.26247	898483.276502453	594034.859227106	ed03fd85-fad4-49dd-a334-7a4be8e6bc33	0101000020E6100000CF08BD4DCC1054C037EE7C7E4FF73940	0101000020BC080000B5B2AAC1646B2B41EA526A26E9202241
640	1458	NE 6 AV	NE 117 ST	N	N	N	0	0	0	11/19/2002	25.88277	-80.18605	923777.797478903	563912.809559166	bf0a2462-a0f1-4af3-b2df-c1202fbb8364	0101000020E6100000048C475AE80B54C057571086FDE13940	0101000020BC080000BD07C8CF01312C415C2E290995352141
641	9832	BUSWAY	SW 244 ST	S	F	N	8	1	1	9/29/2016 14:16	25.53949	-80.40862	851157.804879505	438753.336100526	1e95ed91-ecfc-4eb3-a2a6-d9b657f267fd	0101000020E610000074DB90EC261A54C04455B20E1C8A3940	0101000020BC0800004DC54DCAA9F929412818780C8CC71A41
642	7121	NW 12 AV	NW 44 ST	S	F	Y	1	1	1	9/26/2016 14:27	25.81542	-80.21601	914073.137716677	539373.189334661	7be1bdaf-78d2-4f86-8764-8852876bc5b9	0101000020E610000060D9A837D30D54C0285E42ACBFD03940	0101000020BC08000088F5B17C30E52B4174D34CC8DD752041
643	3450	SW 104 ST	SW 156 AV	E	F	N	1	1	1	9/29/2016 12:18	25.66964	-80.44784	838030.077209409	486001.345923916	efdd5a0b-8382-45a1-be7a-4d740fad1d82	0101000020E610000025227470A91C54C033343CC46DAB3940	0101000020BC0800003A6E06541A932941BDBDEB22CCA91D41
644	3870	SW 112 AV	SW 53 ST	S	N	N	1	0	0	10/27/2016 19:5	25.71768	-80.37516	861891.058702972	503567.841324821	c42ad228-69d6-4399-a804-eaf3026a0425	0101000020E6100000CC68A26B021854C0A65C250DBAB73940	0101000020BC08000006BB934D844D2A411500DD2246BC1E41
645	2832	ALTON RD	19 ST	S	N	N	0	1	0	9/10/2002	25.79508	-80.14124	938721.081532478	532133.037134409	e4ef4975-f475-4fd8-9e16-312f9ea74629	0101000020E6100000E1137C1A0A0954C008B4118A8ACB3940	0101000020BC0800008A8C2463C0A52C41882F92794D3D2041
646	4872	NW 27 AV	NW 75 ST	S	F	N	1	1	1	9/19/2016 12:32	25.84226	-80.24174	905554.52192457	549079.0400059	37fbde4f-c80a-4c62-93bf-08ff864497f2	0101000020E6100000B4DFC5A9780F54C081F6D8A89ED73940	0101000020BC080000EB445C40A3A22B414605187DB1C12041
647	2670	INDIAN CREEK DR	65 ST	S	N	Y	1	1	1	10/20/2016 12:4	25.84878	-80.12164	945040.607285924	551694.468801863	018e00c2-b9e0-460a-a904-5c24974561be	0101000020E6100000D995B8F1C80754C0648397E349D93940	0101000020BC08000073DD14711FD72C4188C42C5920D62041
648	4285	SW 72 ST	SW 94 PL	E	F	Y	1	1	1	9/26/2016 13:28	25.70166	-80.3474	871053.721131343	497789.465769611	82253256-c156-4a3b-acc2-d10735d85f7e	0101000020E61000008A2D38E53B1654C0AA23172AA0B33940	0101000020BC080000FCD7E6A119952A41849BDCA0FC611E41
649	9399	SW 67 AV	SW 12 ST	N	F	Y	0	0	0	10/10/2016 12:4	25.75995	-80.30369	885335.521972541	519048.606605634	0f371b3b-2fe8-4173-af69-282720a407cb	0101000020E61000006367F2BB6F1354C08D877C318CC23940	0101000020BC080000A56FC03DAD042B4181A1833629AE1F41
650	3855	SW 107 AV	SW 30 ST	N	N	Y	1	0	0	10/27/2016 19:1	25.74124	-80.36764	864325.615205333	512141.921948954	21b0c5ad-d3d4-46ac-b263-053c620c94ef	0101000020E61000003E33A83A871754C0BBC5E7F2C1BD3940	0101000020BC080000AEF3D26A89602A417B88B3773E421F41
651	4919	NW 32 AV	NW 88 ST	N	N	Y	1	0	1	8/31/2016	25.85448	-80.25013	902769.337201905	553503.687299944	d1230f37-f8c0-4818-acdf-523133551cff	0101000020E6100000E9EB3024021054C013592550BFDA3940	0101000020BC080000A4E75FE1E08C2B419B832AC942E42041
652	4457	SW 82 AV	SW 13 TE	S	N	N	1	1	1	9/8/2016 12:09	25.7574	-80.3279	877373.005079683	518080.798535518	b56192e9-4b3f-45dd-99e9-5e509fbddeb5	0101000020E610000089527E57FC1454C0CFDA5A24E5C13940	0101000020BC08000025A72C3478C62A416ADFFCFA099F1F41
653	3121	SW 107 AV	SW 183 ST	S	F	N	1	1	1	11/17/2016 11:2	25.59902	-80.36457	865578.608428922	460456.810736373	8cd2e04a-7840-4aef-8a94-186c1c5b053c	0101000020E6100000E03A9E39551754C09AF6697B59993940	0101000020BC080000D28CA467536A2A41E77636F8A91A1C41
654	2190	W 12 AV	W 68 ST	N	F	Y	1	0	0	10/10/2016 14:1	25.8849	-80.30748	883850.972117778	564458.596514948	0ef79745-3493-4f76-a117-c7c450e1e65d	0101000020E61000008DBD36BBAD1354C00CCD0E3F89E23940	0101000020BC08000030A0E92314F92A411A04129CD8392141
655	6583	NW 203 TE	NW 44 AV	W	F	N	0	0	0	11/26/2002	25.95864	-80.27474	894464.456803519	591318.987333603	a196f936-0d11-4f1f-ace9-197dc4b3c9c5	0101000020E61000009D693873951154C072154ADF69F53940	0101000020BC080000C6547D1DFF4B2B418F01AF67B10B2241
656	6778	NE 2 AV	NE 21 ST	S	F	Y	1	1	1	11/4/2016 11:30	25.79696	-80.19093	922366.226467784	532714.610805243	13aad741-6f6f-4e53-b876-631e588febb9	0101000020E610000061D7E641380C54C023471E1306CC3940	0101000020BC080000603C37ABFA252C410AE9459FD8412041
657	8518	WESTWARD DR	CURTISS PKWY	E	N	Y	0	0	0	11/8/2016 12:51	25.8212	-80.28233	892244.422505029	541348.412446395	4d467f5e-c23a-4cbb-944d-fce207a603a3	0101000020E6100000127298C5111254C0698B3D463AD23940	0101000020BC0800007255C10BA73A2B41EAC2C13A4C852041
658	4095	SW 26 ST	SW 130 AV	E	N	N	1	1	1	9/27/2016 11:21	25.7437	-80.40661	851488.575893573	512977.127283037	4d437829-0bd6-4d36-a426-bd25762bbf20	0101000020E61000008F47A5F5051A54C0633F694C63BE3940	0101000020BC080000C876FC543FFC2941AB83274A4B4F1F41
659	4091	SW 26 ST	SW 139 AV	E	N	N	1	1	1	9/14/2016 12:38	25.74327	-80.42048	846923.337299712	512800.905523084	86fa0edc-f2d7-4f3f-b5b7-ecd0a4eb0d87	0101000020E61000002D65DA38E91A54C05A86FA2E47BE3940	0101000020BC080000F45740DA94D829416D1615678A4C1F41
660	4429	SW 67 AV	SW 51 TE	S	N	N	1	1	1	10/10/2016 14:5	25.72263	-80.30251	885795.276949484	505487.80372981	f51f6403-24c3-4176-9a7a-1c0dde914c8f	0101000020E6100000EBA1DB6A5C1354C0FADFC0A6FEB83940	0101000020BC080000CEC476C044082B412EC20EFD45DA1E41
661	9689	SW 162 AV	SW 80 ST	S	F	N	1	0	1	9/26/2016 14:46	25.69109	-80.45439	835840.515008956	493787.666973494	8ff5d71b-1439-4289-9236-c70fc73bbac2	0101000020E6100000AA5927C1141D54C01D890F62EBB03940	0101000020BC080000B652ED33FF8129410E92C66D75231E41
662	2787	ALTON RD	16 ST	N	F	Y	1	1	0	11/10/2016 13:4	25.78914	-80.14107	938789.776638925	529975.831463702	124e749c-ea7e-4498-9db5-b650041ce013	0101000020E6100000FD4F3A62070954C0CE207D8405CA3940	0101000020BC080000E72D1CC749A62C4115FDEF0F732C2041
663	9956	NW 17 ST	NW 112 AV	W	F	N	1	0	0	9/7/2016 14:22	25.78991	-80.37704	861141.462125886	529818.816036567	824fd5f7-9b4b-43aa-aa12-cbd4cb1ab6f1	0101000020E61000007F74D28C211854C0A03CE1FA37CA3940	0101000020BC0800008C5AF01BA9472A41261CF107392B2041
664	8988	SINBAD AV	SUPERIOR ST	S	F	Y	0	0	0	9/1/2016 12:33	25.89857	-80.24784	903428.322726078	569534.776338756	b7398ba1-0ae8-4c73-9cc7-1196fdbffc26	0101000020E6100000114799BCDC0F54C0CC2BE50E09E63940	0101000020BC080000FDB506DA06922B419074DDF880612141
665	7053	NW 7 AV	NW 8 ST RD	N	F	Y	\N	\N	\N	42634.47778	25.78174	-80.20663	917235.383719198	527151.216720052	7d996d1b-995b-4785-821c-5a0941e5063f	0101000020E6100000BF838567390D54C08CC3CF9D20C83940	0101000020BC080000C00D13FBE4FD2B41A81AC2D461162041
666	5443	NE 2 AV	NE 112 ST	N	N	N	1	0	1	11/4/2016 10:41	25.87789	-80.19398	921183.316779949	562121.896474883	9042ba72-04cc-4765-ab02-049f3754cc64	0101000020E61000001F2FF52D6A0C54C08620E582BDE03940	0101000020BC080000457E49D9BC1C2C417668753597272141
667	1878	NW 6 AVb	NW 12 ST	S	F	N	1	0	0	8/17/2016	25.45846	-80.48539	825957.976392116	409198.83320573	85806522-1fb7-4f41-8cc0-4d2ca73ae0ef	0101000020E6100000665890BD101F54C057354ABD5D753940	0101000020BC080000F227ED1ECA3429414216B801C2F91841
668	6281	NW 32 AV	NW 208 TE	N	F	N	0	0	0	9/19/2016 12:12	25.96553	-80.25428	901174.281659786	593862.189309865	f35eb9ea-9f3c-44e4-9b4a-11b77c591841	0101000020E61000008183F62A461054C0CF24AC9C2DF73940	0101000020BC080000107496C46A802B41C6E06ACF8F1F2241
669	7559	SW 42 AV	SW 2 ST	N	N	N	0	0	0	2/13/2017 15:18	25.77016	-80.26344	898563.614927243	522833.01607123	fb84efc5-154d-45ef-acb1-cefb68643119	0101000020E6100000AA466336DC1054C026700B9429C53940	0101000020BC080000BBA9166F056C2B416D810FDB4AE91F41
670	7418	SW 27 AV	SW 14 ST	N	F	Y	1	0	0	9/16/2016 11:02	25.75983	-80.2385	906792.831778552	519126.539560296	26bbdbc1-a8ea-4c41-a098-40cdd76508a1	0101000020E6100000E20F9B9C430F54C056D77ADA84C23940	0101000020BC080000929143DF4FAC2B411B5C30F260AF1F41
671	8811	NE 6 AV	NE 145 ST	S	F	Y	1	0	0	11/1/2016 14:16	25.90821	-80.18738	923286.166563004	573158.690686025	f90b3809-d5c5-47b3-b4b7-48e0bc3e449d	0101000020E6100000FBEEF6FEFD0B54C0F9FD6C1681E83940	0101000020BC0800000BDB988C2A2D2C414FFD6ECDD07D2141
672	3537	SW 160 ST	SW 139 AV	E	F	N	1	1	0	11/18/2016 16:1	25.61872	-80.41798	847945.539692163	467538.47541713	43ce2efa-64ef-45ce-8d72-5b49e8ed0b96	0101000020E6100000BD3C1443C01A54C07B311300659E3940	0101000020BC080000180F104291E029412B6FD4A250891C41
673	7377	AVIATION AV	S BAYSHORE DR	N	F	N	0	0	0	11/16/2016 12:5	25.73279	-80.23373	908418.929208152	509304.314081043	5ec90118-e77e-486b-a2d6-7b4d0a16e3d4	0101000020E6100000C4FA5982F50E54C05EEA702B98BB3940	0101000020BC080000E301551104B92B4126308F08E8151F41
674	1624	SW 57 AV	MENDAVIA AV	N	N	N	0	0	0	11/30/2016 13:3	25.72783	-80.28617	891164.724910278	507407.27755513	a5401109-9391-405d-a6bf-d7ea4914e168	0101000020E61000005A35E9B3501254C03DA1D79153BA3940	0101000020BC080000ECAC7FA637322B41D6919AE243F81E41
675	8796	W DIXIE HY	GRIFFING BD	SW	N	Y	1	0	0	11/13/2002	25.8873	-80.19036	922351.192342382	565549.487723388	2b16b5a7-92b2-4490-8827-2871b738d6aa	0101000020E61000001B9459EF2E0C54C071E0883426E33940	0101000020BC08000045F4AE99DC252C41622B99645E422141
676	9312	SW 72 ST	SW 65 AV	W	N	N	1	0	0	9/26/2016 12:04	25.70397	-80.29917	886930.909839418	498711.496371858	f5c475cc-49c8-4742-9455-4930ea1f9f8a	0101000020E61000000401E0B1251354C03A44D1BF37B43940	0101000020BC080000788CA90424112B41095660C064701E41
677	5782	NW 47 AV	NW 194 ST	S	N	N	0	0	0	9/1/2016 11:22	25.95003	-80.27804	893397.393022209	588184.232445225	11ceb94f-1f8b-4a08-b0e3-2f059b88dc03	0101000020E6100000F12B6E84CB1154C0EC6BF5BC35F33940	0101000020BC080000CE549EFCA8432B4149ACB9E433F32141
678	2054	E 4 AV	E 9 ST	S	N	Y	1	0	0	10/19/2016 11:5	25.83035	-80.27367	895076.51232259	544689.76369071	6483cc45-3a5d-4d61-9e3f-05e2aedf17a4	0101000020E61000003B7EF1CD831154C05F7DCCED91D43940	0101000020BC08000067A70A3AC7502B41DE5507EF669F2041
679	1775	NW 87 AV	NW 17 ST	N	F	N	1	1	1	10/31/2016 13:5	25.79068	-80.33668	874422.630734764	530161.369513854	aae89d0f-e18b-4400-b9f9-ead706eebfd6	0101000020E6100000698F4D2D8C1554C07A96AC0C6ACA3940	0101000020BC0800008F831A746BAF2A41F6AD5223E62D2041
680	8040	W FLAGLER ST	NW 30 AV	W	F	Y	1	1	1	9/8/2012 11:31	25.77227	-80.24419	904895.13016279	523635.801530689	05d420b5-2a9b-41a3-bc34-25ceb1e86089	0101000020E610000071489FC9A00F54C00FF2F9DBB3C53940	0101000020BC0800007C07C0777C9D2B4122DF61FFD5F51F41
681	5607	NW 32 AV	NW 119 ST	S	F	Y	0	0	0	9/1/2016 12:56	25.88188	-80.25142	902291.282661282	563459.588981442	7aec9f67-d407-4417-844b-b6c6f6058432	0101000020E61000004E701A21171054C0CA496DDEC2E13940	0101000020BC0800007D564EC524892B4189192C980A322141
682	9090	SW 77 AV	SW 152 ST	N	F	N	0	0	0	11/30/2016 15:5	25.62986	-80.31717	881144.490993463	471744.802644879	de9ebbfc-be98-45eb-b4f2-014fc5a4f3c7	0101000020E610000043A163864C1454C03C3505E03EA13940	0101000020BC080000C153732DEFE32A419ED323F309CB1C41
683	5973	NE 203 ST	NE 22 AV	E	N	N	1	1	1	10/28/2016 17:1	25.96297	-80.15785	932862.560795266	593120.276083663	a1b3183f-a066-4bd8-a50e-bc7dfaa40d66	0101000020E61000006BBFE1521A0A54C0430B3F2F85F63940	0101000020BC0800003602B057FB772C4127EAE0FBC3192241
684	1999	E 4 AV	E 2 ST	N	N	Y	1	0	0	10/19/2016 14:2	25.82375	-80.27325	895228.243641417	542293.112969093	1daa9ca7-f5fb-48c8-af43-6bdb531586d9	0101000020E61000005D4623E87C1154C01C0845A7E1D23940	0101000020BC0800005B8C92B0F6512B41ACD493A1AD8C2041
685	7765	NW 36 ST	N MIAMI AV	E	N	Y	0	0	1	9/25/2002	25.81035	-80.19546	920844.656339675	537569.762144297	6eb30d2e-2ac5-4580-a16f-4dd313d3fc33	0101000020E61000004B7AE28A820C54C0B348A62473CF3940	0101000020BC080000D85F1587171A2C41DC645CEDC6672041
686	4990	NW 72 AV	NW 53 TE	N	M	N	0	0	0	10/10/2016 11:5	25.82312	-80.31349	881990.349213697	541991.185391262	489a86da-8c88-48e9-a4f5-9dd172aaacc1	0101000020E6100000EF01254C101454C0CF47B609B8D23940	0101000020BC0800008F60D7E48AEA2A41945497C6518A2041
687	2159	W 8 AV	W 40 PL	S	N	Y	1	0	0	10/19/2016 16:3	25.85902	-80.29868	886793.21164583	555066.724235579	e94f1702-b1c6-4a18-8f9d-ca470b3d7532	0101000020E6100000B83A199E1D1354C069A30A0BE9DB3940	0101000020BC0800008772109F10102B41D8EA43DC78F02041
688	7797	NE 20 ST	N MIAMI CT	W	N	N	0	0	0	8/31/2016	25.79571	-80.19389	921396.397337262	532252.492315508	4ac663c9-d826-47ed-98d3-e7cb5721c6a6	0101000020E6100000BA7E44B0680C54C09416B6D3B3CB3940	0101000020BC080000C8BA9402671E2C4125D58D623C3E2041
689	7369	NW 22 AV	NW 33 ST	N	F	Y	1	0	0	10/17/2016 16:3	25.80703	-80.23186	908877.914233357	536292.591178119	6d069ec2-7924-4d52-86cf-27e7aed376f6	0101000020E61000003D1F9ED6D60E54C05C7098C299CE3940	0101000020BC0800006715AB099ABC2B4176E4A095CC5D2041
690	6328	NW 37 AV	NW 163 ST	S	F	Y	0	0	0	8/31/2016	25.92194	-80.26058	899194.12223902	578006.356509015	1bccf19f-b0ff-46f8-ae40-38021b3a4a4d	0101000020E61000003287E25EAD1054C00351DBD404EC3940	0101000020BC0800006A6CC972F2702B41EAF5EE22B0A32141
691	6401	NW 167 ST	NW 44 CT	E	N	N	0	0	0	9/1/2016 12:27	25.92491	-80.2735	894939.915147405	579059.559460655	6d7fc616-91d5-4f94-8d6b-ad4e1ed36182	0101000020E6100000643F4822811154C01C2EC203C7EC3940	0101000020BC080000CC062E08B64F2B417B74FF8AEAAB2141
692	6073	NW 74 ST	# 7101	W	N	N	0	0	0	10/10/2016 16:2	25.84079	-80.31309	882088.698721886	548416.090551279	b6522d79-4acb-4afb-93f1-9df235e2e075	0101000020E610000036A73BBA091454C09A9214633ED73940	0101000020BC0800009498D2974FEB2A414A99DE9683BC2041
693	8577	NE 19 AV	NE 169 ST	N	F	N	1	0	0	11/11/2002	25.93182	-80.1621	931540.210709326	581789.375846885	e985a61d-309b-4815-9475-7df0437a2fde	0101000020E61000005F59B5DF5F0A54C007679FCD8BEE3940	0101000020BC080000058D3AA4A66D2C4147AE792D3EC12141
694	7705	NW 54 ST	NW 2 AV	E	F	Y	1	1	0	10/19/2016 14:2	25.82509	-80.19968	919426.314030789	542921.746542931	44a76949-b7ff-4d2f-827b-7148bd91dc7a	0101000020E61000000B0D4C8DC70C54C047D61AAB39D33940	0101000020BC080000E26CACD7020F2C419A1F2CE696912041
695	8063	W FLAGLER ST	NW 61 AV	W	F	Y	1	1	0	9/8/2012 10:33	25.77073	-80.29557	887986.778497323	522983.093818061	59809201-a517-41b7-9bc1-7fead47e0565	0101000020E61000001A1562B6EA1254C0EF6E97104FC53940	0101000020BC0800001EF17AC163192B410721812AA3EB1F41
696	1789	NW 87 AV	NW 29 ST	S	N	N	1	0	0	11/9/2016 16:27	25.80088	-80.33729	874207.521253981	533869.495319277	51fd816b-95f9-4e3a-96a4-c5c0fd05d164	0101000020E6100000E00B4EF5951554C0B96F36D806CD3940	0101000020BC080000EAF8E83BBDAD2A4139423964DE4A2041
697	10576	CARIBBEAN BLVD	MARLIN RD	SW	F	Y	1	0	1	10/4/2016 12:55	25.58054	-80.34738	871278.609124981	453769.232893236	91e65129-1f83-423b-9f6d-ce716073438b	0101000020E610000088348A803B1654C0A3157EA39E943940	0101000020BC0800007474BE68DB962A4142BFC7A62BB21B41
698	1843	NW 25 ST	NW 82 AV	E	N	N	0	0	0	11/8/2016 11:45	25.79678	-80.32932	876835.061315261	532393.664916307	4c224072-f0f7-4d4f-88f9-d99067e6dc3d	0101000020E6100000E80E0D7E131554C0A2D0F057FACB3940	0101000020BC08000055B1C05044C22A41038FE3BA563F2041
699	4005	SW 137 AV	SW 14 ST	N	N	Y	1	0	1	1/5/2017 12:46	25.75405	-80.4165	848216.1116146	516723.269769937	4b6b8b9d-c781-4dd8-aefe-c16d54faf26e	0101000020E6100000D1B68403A81A54C000654C6609C13940	0101000020BC0800001420DD66AEE22941131EE0DCD3891F41
700	4218	SW 56 ST	SW 98 AV	E	N	N	1	1	1	10/12/2016 16:4	25.71595	-80.35294	869205.007631868	502973.549862966	9ecbc252-765d-4d16-850b-14a5ccbb2ff0	0101000020E61000007963169D961654C04074008B48B73940	0101000020BC080000B08C6834A8862A418E9C37F8FCB21E41
701	6508	NW 183 ST	NW 3 AV	E	N	N	0	0	0	9/20/2016 12:24	25.94232	-80.20781	916493.411111102	585512.388077818	3383ce9b-72b5-433e-833e-18e37a2849e4	0101000020E61000009377C9D14C0D54C0849068EE3BF13940	0101000020BC08000055B4F20819F82B41DE40313454DE2141
702	7386	SW 27 AV	SW 6 ST	S	F	N	1	1	1	9/19/2016 14:54	25.76669	-80.23902	906605.648396898	521617.8127582	34780173-54fb-43a1-a7f9-6cda5fa8ffb0	0101000020E61000004B2B9E364C0F54C00A34DF3B46C43940	0101000020BC080000AD2E4481D9AA2B417B189B0A4ED61F41
703	5088	NW 95 ST	NW 14 AV	E	F	N	1	0	0	10/14/2016 14:1	25.86125	-80.2216	912140.747888085	556021.874903053	66733052-b729-4e6f-a460-898a72fed562	0101000020E61000008244B88A2E0E54C0E16226847BDC3940	0101000020BC080000D8FDE0B417D62B417FA78629EFF72041
704	5224	NW 54 ST	NW 25 AV	E	N	Y	1	0	1	10/19/2016 13:0	25.82385	-80.23903	906482.281873561	542392.746610843	6866ef36-9741-4239-a9ce-95b50011c314	0101000020E6100000DC9990604C0F54C0205C3B24E8D23940	0101000020BC080000A6D197C5E2A92B41B43822E6748D2041
705	529	NW 186 ST	NW 67 AV	W	F	Y	1	0	0	10/28/2016 11:3	25.94253	-80.30811	883530.672258604	585401.953912936	5f565a5b-f426-48e7-8175-e6fc2644a9ba	0101000020E61000004F9D2F2FB81354C0C24996B149F13940	0101000020BC080000C173588A93F62A414653C05577DD2141
706	2078	PALM AV	W 37 ST	S	F	N	1	0	0	9/22/2016 12:54	25.85561	-80.28271	892051.500340953	553854.93462687	4a673c56-afe6-46a1-b439-f108f982ec5c	0101000020E6100000DDB83CFB171254C09DA7296F09DB3940	0101000020BC080000BB41923325392B41BFAFCA4701E72041
707	9540	NW 46 ST	NW 12 AV	W	F	Y	0	0	0	9/23/2016 13:31	25.81737	-80.2165	913907.378242072	540082.442831166	e770aa37-9e8e-40d8-a5a1-186cc72114c2	0101000020E6100000C95F1043DB0D54C0195CF5BA3FD13940	0101000020BC080000D201DCF7E4E32B417591444A687B2041
708	8619	NE 12 AV	NE 151 ST	S	N	N	0	0	0	11/4/2016 12:53	25.91445	-80.17562	927139.377003413	575449.096182793	a5d315a5-6b07-44f5-83cf-310410de34d3	0101000020E6100000C19AF63C3D0B54C07A8569B419EA3940	0101000020BC080000DFE2E0F8444B2C419DF3769DB58F2141
709	7348	SW 22 AV	SW 9 ST	N	N	Y	1	1	1	10/17/2016 16:2	25.7644	-80.23053	909406.339029115	520801.348829381	000cf621-2824-41de-b7cf-b44351929f3a	0101000020E6100000893BFE07C10E54C004384017B0C33940	0101000020BC080000EB923BE3BAC02B4165D2362F8CC91F41
710	10330	NW 1 AV	NW 6 ST	N	F	N	1	1	1	10/21/2016 13:1	25.7797	-80.19524	920986.116665896	526429.925179131	0cdb8c54-4df1-4f8f-b767-f9caa1dc49c1	0101000020E6100000E2918CE37E0C54C0420CDA769AC73940	0101000020BC0800001077DF72321B2C412942733FBF102041
711	7048	NW 7 AV	NW 13 ST	S	F	N	\N	\N	\N	9/20/2016 13:27	25.78642	-80.20696	917118.532534998	528849.780950226	9839ac73-07d0-486b-8307-e4358e40cc57	0101000020E610000084B879B63E0D54C0DB2653FF52C93940	0101000020BC0800007E974747FBFC2B41D916D7F5A6232041
712	8084	W FLAGLER ST	SW 52 CT	E	N	Y	1	0	0	9/8/2012 10:37	25.77097	-80.28125	892698.710321411	523093.953846768	5cbde84a-8757-4f35-950b-60f87b71b496	0101000020E6100000E2EF201C001254C032E23B775EC53940	0101000020BC0800001A47189F333E2B41B40A309B5EED1F41
713	3384	SW 152 AV	SW 280 ST	S	F	N	1	1	1	10/4/2016 12:34	25.50636	-80.43695	841869.812676679	426674.817949392	18524a35-676f-43ba-a87a-2afa8451c922	0101000020E6100000FEDADEF7F61B54C0149D975FA1813940	0101000020BC080000A4D81FCD19B12941EAD9B5F6D10A1A41
714	6735	BISCAYNE BD	NE 55 TE	N	N	N	1	1	1	9/8/2016	25.82655	-80.18683	923650.126145348	543475.797584437	8de269d2-4dea-45b7-a4b2-f0e72bd9ba55	0101000020E61000002B567904F50B54C0563A67E498D33940	0101000020BC08000070E3F87702302C41B6506100EB952041
715	655	NE 163 ST	BISCAYNE BD	E	F	N	0	0	1	11/3/2016 14:34	25.92586	-80.15292	934570.344442621	579642.45035284	62803bac-240f-4175-af4e-8c3555227749	0101000020E61000002C749084C90954C0CDD3633505ED3940	0101000020BC080000271A28E952852C41AA88565378B02141
716	6142	NW 7 AV	NW 177 TE	S	N	N	1	0	1	10/26/2016 11:5	25.93722	-80.21297	914807.825222615	583649.895398781	00e47f2c-6bdc-4f86-b176-b3b58c01202a	0101000020E61000008422FC68A10D54C0065DAEF5EDEF3940	0101000020BC080000E25BCADCEDEA2B41A3DF9A37C7CF2141
717	1002	NW 37 AV	NW 7 ST	S	N	Y	1	1	1	42619.5375	25.77943	-80.25577	901066.844204936	526215.039827272	c0ed1ee5-b129-4fd7-b1e8-43577db238f3	0101000020E610000044CA3BA55E1054C02B03C6D588C73940	0101000020BC0800005AC7C4E4937F2B410E55277A110F2041
718	10288	NW 8 ST	NW 1 CT	W	F	N	0	0	0	2/21/2007	25.78183	-80.19675	920487.434589874	527202.912499942	b228466d-acb6-402f-bd4c-2347d63ce912	0101000020E6100000A579337B970C54C05B2C3A6226C83940	0101000020BC080000CB3497154D172C41F35C1839C9162041
719	440	OLD CUTLER RD	SW 92 AV	NE	F	N	1	1	1	10/4/2016 11:17	25.5766	-80.33978	873792.179282237	452348.913557135	bc924369-7b6a-404f-8b52-b4b728fa2ea8	0101000020E610000002860BEBBE1554C0B73AB44B9C933940	0101000020BC0800002F29E98C7EAA2A4158457F5FFA9B1B41
720	8004	NW 7 ST	NW 18 AV	E	N	Y	0	0	0	9/6/2012 14:09	25.77982	-80.22497	911201.980774499	526415.238538481	8c0d4b60-acf5-4987-8d76-d7c7cd3debd9	0101000020E61000000E9B6F00660E54C04A69E064A2C73940	0101000020BC0800003651092CC2CE2B415065CEDFA1102041
721	4330	SW 88 ST	SW 139 AV	E	N	N	1	0	0	10/3/2002	25.68504	-80.42106	846824.220733397	491635.47378923	554e3c26-7f6b-4160-98a5-239a49555768	0101000020E61000001A4E20C6F21A54C039F6E4E35EAF3940	0101000020BC08000088A3A99ECED729418C5C7AA7D4011E41
722	6901	S MIAMI AV	BRICKELL AV	NE	F	Y	1	1	0	10/18/2016 12:2	25.75052	-80.20575	917591.390844975	515803.369367488	317e544e-ab10-464a-900c-fbf4314d6e79	0101000020E61000008291B1152B0D54C0C505563022C03940	0101000020BC0800008FB1CFFEAC002C416F310243747B1F41
723	145	NW 17 AV	NW 95 ST	N	N	Y	1	0	0	8/18/2016	25.86055	-80.22572	910788.035724174	555757.987910427	44b72d75-e811-45bb-b8a5-7be6b61340cf	0101000020E61000004D62DF02720E54C0BDC8FB604DDC3940	0101000020BC080000C464044886CB2B41F8286863DFF52041
724	5301	NW 6 ST	NW 122 AV	W	N	N	1	1	1	11/29/2016 12:0	25.77346	-80.39271	856016.533348907	523814.056428723	bcd67b5f-4a9f-4959-aba9-44c57e1c9c02	0101000020E61000006779711B221954C0B763B49501C63940	0101000020BC0800009135DB3F9F1F2A419EE471049FF81F41
725	7979	NW 7 ST	NW 53 AV	E	F	Y	1	1	1	11/8/2016 14:10	25.77817	-80.28168	892546.876971401	525710.494858138	8c464a87-d253-48e1-8fd4-203e6185e321	0101000020E6100000778759F5061254C0CEB8026436C73940	0101000020BC080000686674F4033D2B41C2250163200B2041
726	9572	S DIXIE HWY	SW 70 ST	N	F	Y	0	0	0	12/12/2016 10:3	25.70617	-80.28701	890930.367390953	499532.530819736	614dc333-e79a-43e4-909e-bd32eab8c81a	0101000020E61000008332517B5E1254C0B1F7B2EDC7B43940	0101000020BC08000093487AEF62302B418F55F8E3387D1E41
727	2241	W 16 AV	W 44 PL	S	N	Y	1	0	0	10/3/2016	25.86275	-80.31486	881465.251188159	556393.27703765	e1c7e866-8870-4a31-88ea-ac6af54af972	0101000020E6100000EF23F5B5261454C02A64BA4BDDDC3940	0101000020BC080000E14D90B270E62A4100A25CF7D5FA2041
728	9599	NW 10 AV	NW 58 ST	S	N	Y	0	0	0	9/23/2016 13:37	25.8286	-80.21242	915225.830950584	544169.664312616	e1f2d4a6-7ca6-4efa-89a6-4a4d901d3935	0101000020E61000005EE0E961980D54C0600CB23D1FD43940	0101000020BC080000B765C6DF31EE2B41CB5A2BBC569B2041
729	9921	BUSWAY	SW 220 ST	N	N	N	0	0	0	11/30/2006	25.56232	-80.38622	858507.433271192	447084.679060705	09d05d90-5621-482d-a050-f658595c2ba4	0101000020E610000082EFF5D2B71854C0124F6E4FF48F3940	0101000020BC080000A805190D15332A416418EE6DB9491B41
730	6144	NW 12 AV	NW 170 TE	N	N	N	1	0	0	10/28/2016	25.93009	-80.22054	912337.379722398	581044.194603316	1eda7b33-150e-46f9-b0ed-963aadb76a0a	0101000020E610000078F2B4561D0E54C0B485A6D11AEE3940	0101000020BC080000A76D5FF8A0D72B418EDD69D06BBB2141
731	7011	NW 3 AV	NW 19 ST	N	N	Y	0	0	0	11/3/2016 16:07	25.79342	-80.20025	919309.108253621	531407.754488282	b8783600-368e-468a-899c-4d16fb98e003	0101000020E61000003F47DADFD00C54C0BC0BA5D01DCB3940	0101000020BC080000907B646E180E2C414333C0E8A2372041
732	5816	NW 68 AV	NW 182 ST	N	F	Y	1	0	0	10/10/2016 16:0	25.93868	-80.31196	882274.115680769	583999.211304292	1a5840d7-774c-4e23-bbc9-4c4a3738d1f2	0101000020E610000030017C32F71354C05B4148F84DF03940	0101000020BC08000033CC346DC2EC2A4107D966D981D22141
733	9786	SW 26 ST	SW 142 AV	E	F	N	1	1	1	9/14/2016 12:34	25.74315	-80.42394	845783.930136565	512753.753402002	df278cf0-5f5a-49a6-b7da-a3a1703f76ea	0101000020E61000006CC689F1211B54C0B475D2943FBE3940	0101000020BC080000BC3FAE09AECF2941654D30CBCD4B1F41
734	7182	NW 12 AV	NW 57 ST	N	N	Y	1	0	1	11/8/2016 14:10	25.82747	-80.21627	913964.789215174	543753.577236429	40b4c0a8-ea8a-4e8c-b6f8-a7b0f80655bc	0101000020E61000007E913C50D70D54C0EB371994D5D33940	0101000020BC080000BA0158CA57E42B41597E988F16982041
735	3277	SW 127 AV	SW 280 ST	N	F	N	1	1	0	10/4/2016 12:47	25.50769	-80.39598	855381.066138893	427217.828990124	260525d6-ee2f-4011-9d89-7770a9f5234b	0101000020E61000004C14CCAE571954C0D13A179AF8813940	0101000020BC08000059F8A250A81A2A41151225024E131A41
736	4914	NW 32 AV	NW 75 ST	N	F	Y	1	0	0	8/31/2016	25.843	-80.24969	902937.532718252	549332.632353805	da442825-ba76-4e57-b885-b518bd9ed97d	0101000020E61000003BD7E3F2FA0F54C00D5A3517CFD73940	0101000020BC080000CE297D45318E2B4164ED84ACACC32041
737	3449	SW 104 ST	SW 161 AV	E	F	N	1	0	0	9/29/2016 12:13	25.66938	-80.45602	835334.545880735	485896.40489918	7c5fe77a-7f68-4d2c-b962-a102084a5b17	0101000020E6100000F794D68A2F1D54C03C47B6DB5CAB3940	0101000020BC080000F73AA5430B7E2941911A2B5F28A81D41
738	8319	NW 67 AV	MIAMI LAKEWAY N	N	F	N	1	1	0	10/10/2016 15:3	25.91865	-80.30902	883280.348934535	576722.216347344	a883295a-f5ba-4713-ba57-0b29ddaec463	0101000020E6100000576840F2C61354C076A2AAF42CEB3940	0101000020BC080000FF29C9E49EF42A416870F4DAA7992141
739	5987	NE 205 TE	NE 11 AV	W	F	Y	1	0	0	11/1/2016 16:50	25.96494	-80.18065	925368.856254403	593792.054569803	772acb8a-ec8a-49e5-a8a6-4f9e5f905397	0101000020E6100000414EAFC38F0B54C0AA765BE106F73940	0101000020BC0800009A8CF4ED6F3D2C416FDB7D8A031F2241
740	7216	NW 17 AV	NW 48 ST	S	F	Y	0	0	0	8/22/2016	25.81914	-80.22444	911293.178412374	540708.13089928	489ff3c1-1cc1-4798-a765-a2bab170a1d0	0101000020E61000006011E0445D0E54C093B4F855B3D13940	0101000020BC0800009E9E289178CF2B416654A3AA4B802041
741	3132	SW 107 AV	SW 160 ST	N	N	Y	0	0	0	8/16/2016	25.62049	-80.36576	865153.027923323	468260.042857423	03538d3b-031a-4a95-92e3-324a0ac8aa8b	0101000020E610000091728386681754C0AB2338DED89E3940	0101000020BC0800009B4E473E00672A4191A0F8E796941C41
742	7716	NE 36 ST	NE 1 AV	W	N	Y	1	1	1	11/2/2016 13:26	25.81061	-80.19286	921705.704499889	537671.72161901	a4a508e3-6196-4c92-b9be-ea66549c4294	0101000020E6100000C731FEA1570C54C07427659384CF3940	0101000020BC0800000ABCF59FD1202C4165EBA1D892682041
743	7254	SW 17 AV	SW 8 ST	N	F	Y	1	0	0	8/18/2016	25.76597	-80.22242	912071.813304003	521388.378212146	58a08eae-40fd-401a-b06f-d2c45cdf054d	0101000020E6100000D057602C3C0E54C0435A0D1D17C43940	0101000020BC08000061D958D68DD52B4124FD734DB8D21F41
744	1187	GRAND AV	SW 37 AV	W	F	Y	0	0	1	10/14/2016 15:4	25.72772	-80.25406	901738.527893912	507423.226690166	a50744ac-6c5e-4408-b362-dac1b5cd89da	0101000020E6100000B643697F421054C01F57ECE64BBA3940	0101000020BC0800008B47F142D3842B41FF31B1AE83F81E41
745	2674	COLLINS AV	# 5660	S	N	N	1	0	1	10/20/2016 13:0	25.83733	-80.1211	945246.364746727	547534.60382095	9c35740d-313a-40c0-879c-9ccbec9986cf	0101000020E610000033B99914C00754C0B78EF8A15BD63940	0101000020BC080000D0B5FAF4BAD82C41DBA1B29DA0B52041
746	4181	SW 56 ST	SW 99 AV	W	N	Y	1	0	1	10/12/2016 12:0	25.7161	-80.35423	868779.34579068	503027.076039553	6190a8e5-1894-4086-b86a-17348645d1a5	0101000020E61000006EFF20C8AB1654C06E12E99152B73940	0101000020BC0800000DED74E154832A41DAD1EF12D3B31E41
747	1175	NE 36 ST	BISCAYNE BD	E	F	Y	1	1	1	10/18/2016 16:0	25.8106	-80.18856	923117.126867551	537675.313469015	3e017ae8-9a04-4550-8bab-c2203a053079	0101000020E610000056F46C58110C54C0B3DC82A883CF3940	0101000020BC08000021E35D78D82B2C41F754B4079A682041
748	3751	NARANJA LAKES BD	US 1	NW	N	N	1	1	1	10/4/2016 16:37	25.51151	-80.43399	842839.770006683	428550.331619397	9bde306f-f7f9-465a-a89f-53daa77eec9e	0101000020E6100000C849C163C61B54C0093F82D1F2823940	0101000020BC08000045475CB7ADB829411F154A0520281A41
749	1680	ANASTASIA AV	SEGOVIA ST	W	F	N	0	0	0	10/12/2016 13:2	25.74195	-80.26704	897437.48792183	512573.156630345	e14f08c5-aa30-4d24-ba05-f35c98f38da3	0101000020E6100000C276E81C171154C0E44AA6CEF0BD3940	0101000020BC0800001BA3F92D39632B4138255068FB481F41
750	4357	SW 88 ST	SW 87 AV	E	N	N	1	0	0	9/29/2016	25.6879	-80.33378	875564.83746507	492811.433027133	97a0b32e-c9a9-4a11-832b-9006c7bd3660	0101000020E6100000AABE31B25C1554C049AF19851AB03940	0101000020BC080000EAEA27DE57B82A411F0B1E7E34141E41
751	1803	NW 53 ST	NW 84 AV	E	N	N	0	0	0	10/31/2016 14:5	25.8197	-80.33493	874944.820305362	540713.730977163	dc3a7c9e-1fe3-4837-8a6a-487cb9e2db16	0101000020E6100000F90177856F1554C05AF17D3BD8D13940	0101000020BC080000A14E28D57FB32A414486B8DD56802041
752	8638	NE 6 AV	NE 177 ST	S	N	Y	0	0	0	10/26/2016 13:4	25.93814	-80.18874	922770.459935699	584031.794227526	2ed5f25b-ac52-4270-b714-702dac11accf	0101000020E610000001ECFE57140C54C00B61690E2AF03940	0101000020BC080000D2F7BE2223292C41BBCFE903C3D22141
753	8264	TIGERTAIL AV	LUCAYA ST	SW	F	N	0	0	0	10/17/2016 13:4	25.73563	-80.23228	908891.902381841	510342.603369504	da80d1a5-0c29-453b-ad7a-1bda97db3333	0101000020E61000002D3BA3ABDD0E54C04251BBE152BC3940	0101000020BC080000C7A69E03B6BC2B41095DFE3021261F41
754	6750	NE 4 CT	NE 54 ST	N	F	N	1	0	0	10/19/2016 14:5	25.82586	-80.18723	923518.105716769	543226.722286716	a8aafe91-d9a9-4758-b09f-11c71ea04aca	0101000020E61000008F5A5DABFB0B54C0B7A090216CD33940	0101000020BC0800008EB8836DFA2E2C41E1B8C5D9F8932041
755	5358	W FLAGLER ST	NW 108 CT	W	N	Y	1	0	0	9/28/2016 11:58	25.76858	-80.37127	863083.633738369	522074.579894662	4aaf7264-8222-4c2f-abd0-4060c477d259	0101000020E610000028E6CAAFC21754C050DD33F7C1C43940	0101000020BC0800007E322B74D5562A41B7D4F21B71DD1F41
756	5139	NW 79 ST	NW 10 CT	E	N	Y	1	1	1	10/20/2016 12:4	25.84678	-80.2143	914569.898561824	550773.111718662	43bfd7b9-f67c-4647-8b8e-4ce08588da61	0101000020E610000054C50A16B70D54C0C51F018EC6D83940	0101000020BC080000AFDC520212E92B41A15A2CA2EDCE2041
757	4343	SW 88 ST	SW 110 AV	E	F	N	1	0	1	10/9/2002	25.68656	-80.37404	862313.070318725	492260.34328039	f1cbefea-1d89-4246-8485-1e1c741eb017	0101000020E61000003F7A3316F01754C0DE3B2AD5C2AF3940	0101000020BC0800001A6AA253D0502A416BD9FB21980B1E41
758	6487	NW 183 ST	NW 38 CT	E	F	N	1	1	1	10/27/2016 15:1	25.9401	-80.26422	897963.279532976	584599.176002026	c0aad2e9-8ad0-44c9-8451-4995064e7dda	0101000020E610000062DA9AE0E81054C0D1B8D7C4AAF03940	0101000020BC08000041A71EC354672B416CE364C731D72141
759	4395	SW 57 AV	SW 62 ST	S	N	N	1	1	1	12/1/2016 13:46	25.71399	-80.2858	891314.745602675	502376.21117872	5a2da038-89af-416f-93d4-00b382e0c772	0101000020E610000037416E974A1254C08470024AC8B63940	0101000020BC0800001B3527B163332B41FDD4719DA7A91E41
760	506	NW 27 AV	NW 175 ST	N	N	N	1	0	0	9/19/2016 13:36	25.93347	-80.2448	904355.305803835	582224.569866687	a404282a-9a51-4c44-8625-0ba26b0d8c16	0101000020E6100000E88F86E5AA0F54C070768F11F8EE3940	0101000020BC0800006AF882D144992B41705CC990A4C42141
761	9457	NE 54 ST	NE 2 AV	W	F	N	1	1	1	10/19/2016 12:1	25.82546	-80.19272	921715.019783609	543069.85978055	758ce8f1-9011-4e27-9c18-53ece17e70f9	0101000020E610000015A3ED84550C54C05B51E3D951D33940	0101000020BC080000CF256641E4202C414DB81120BF922041
762	4947	NW 32 AV	NW 54 ST	S	N	Y	1	0	1	9/1/2016 13:38	25.82397	-80.24904	903192.137829475	542417.81646581	a38ac192-e3dc-496d-9522-d3f32ecbe4df	0101000020E61000002A2DD03BF00F54C0F79F4212F0D23940	0101000020BC08000072EC5B7B2E902B418C46CA09A78D2041
763	520	NW 2 AV	NW 183 ST	N	N	N	1	1	1	9/21/2016 13:45	25.94231	-80.20503	917408.981101178	585516.8457461	eaf79be7-d292-49b4-8378-486cc96a9559	0101000020E61000003ECB732C1F0D54C00AFE12BC3BF13940	0101000020BC0800006D59E32C40FF2B411876641E5DDE2141
764	2505	NW 6 AV	NW 2 ST	S	N	N	0	0	0	10/4/2016 15:43	25.47176	-80.48558	825879.2580112	414034.146398626	2ed592f5-1856-4606-abb2-bdc1d6a3b345	0101000020E610000089DDEDB8131F54C0275B37B2C5783940	0101000020BC0800003DBB19AF2C3429416A6DCC434F451941
765	10244	SW 152 ST	SW 117 AV	E	F	N	1	1	0	11/18/2016 16:1	25.62713	-80.38197	859796.774192642	470648.456353553	f481faec-3adf-48c0-a536-16ed135f0165	0101000020E61000001EC8564A721854C083B7BC178CA03940	0101000020BC080000952DB4BB273D2A4161F82790E8B91C41
766	5985	NE 205 TE	NE 13 AV	W	N	N	1	1	1	11/1/2016 16:50	25.96501	-80.17611	926859.7404719	593826.859973818	da6ff5d9-be78-43cd-8495-66bf0b86cf7e	0101000020E61000003974ED69450B54C05B8EC2770BF73940	0101000020BC0800003CAFDAB215492C416EE9CB26491F2241
767	447	NARANJA LAKES BD	SW 145 AV	W	F	N	0	1	1	10/4/2016 16:30	25.50907	-80.42602	845469.846127946	427675.51151365	1ec847b4-026a-4dd6-bf65-243cf47cacb4	0101000020E6100000D04C80EC431B54C05740A70A53823940	0101000020BC0800007CBFC5DE39CD29414EB357BD741A1A41
768	1894	NW 10 AV (SW 187 AV)	NW 16 ST	N	N	N	0	0	0	10/4/2016 13:00	25.46184	-80.49345	823296.879016068	410417.803243428	602b6024-cf14-4689-a452-cdb7fc8a1f79	0101000020E6100000AD77EAA5941F54C0AACAD8613B763940	0101000020BC0800002ACDB3ECFF1F2941A5DE82E3CD0C1941
769	7826	NW 20 ST	NW 20 AV	E	F	Y	1	0	0	9/1/2016 11:55	25.79452	-80.22782	910233.099489789	531754.130423665	62f93313-0ae4-4db4-b9c6-62ae415e90d6	0101000020E610000084B503AE940E54C0BD6B210966CB3940	0101000020BC080000BB2D9B6830C72B41806B26A9573A2041
770	2467	NW 103 ST	NW 77 AV	E	N	Y	0	0	0	10/14/2016 11:3	25.86661	-80.324	878452.375004616	557782.129566014	0668c9e8-08e8-460d-bc81-7aec1f12cbfe	0101000020E6100000E4D3E875BC1454C03E44E986DADD3940	0101000020BC080000D6958AF1E6CE2A41B3DD28ACAF052141
771	5922	NE 191 ST	# 1601 BUILDING B	W	F	N	1	0	0	11/13/2002	25.95141	-80.16824	929477.989467714	588897.753323741	45e594df-064b-468f-b721-b641066a237e	0101000020E61000000AAC296CC40A54C03285E8C88FF33940	0101000020BC08000002A3A5328A5D2C41442C9FEFC6F82141
772	5024	NW 72 AV	NW 2 TE	S	F	N	0	0	1	10/10/2016 12:5	25.77251	-80.31235	882461.108084198	523599.06766177	b9b667bb-8b19-40e8-9d92-fdedc3043c8c	0101000020E61000001C24D3A2FD1354C072182564C3C53940	0101000020BC080000FAD8856938EE2A41439DE50F43F51F41
773	7812	NW 20 ST	NW 17 AV	W	F	Y	0	0	0	8/31/2016	25.79483	-80.22359	911624.927089013	531874.630512305	148e2c99-e667-481f-8081-0676ca480885	0101000020E61000007433B7574F0E54C0363A4C497ACB3940	0101000020BC0800004CBB941010D22B41DE974AA9483B2041
774	2057	E 4 AV	E 4 ST	S	F	Y	1	0	0	10/19/2016 12:0	25.82521	-80.27349	895143.737601239	542822.230658509	96b5cbb8-ce9c-4244-937d-6f2cd525ac69	0101000020E610000005EC52F8801154C0FFBAAB2341D33940	0101000020BC080000B0AF76AD4D512B417BE8DFDDCF902041
775	4435	SW 67 AV	US 1	N	N	N	1	0	0	10/10/2016 11:2	25.69369	-80.30089	886384.979524158	494970.338190168	dd6d7b4b-0673-40f2-bac5-b3d10288c7cd	0101000020E6100000BB99B0D7411354C0BF7519B695B13940	0101000020BC080000D4023928E00C2B41EE81901DF0351E41
776	8968	NW 27 AV	SESAME ST	S	F	N	1	1	1	9/19/2016 10:02	25.9061	-80.24407	904653.252404086	572278.11336682	f12363c8-ccb0-44e1-9869-f840cf53d419	0101000020E61000002E3B4BE79E0F54C0408ECD69F6E73940	0101000020BC0800007A5322B6989B2B41C4D7BBA5EF762141
777	1761	NW 79 AV	NW 48 ST	S	N	Y	1	0	1	11/8/2016 12:38	25.81672	-80.3256	878021.919144496	539644.434524536	e1aef4c0-cfdb-41ca-9620-f85e99c3ad07	0101000020E610000044873D8BD61454C0444E7F9B14D13940	0101000020BC0800006A8F14088ACB2A41061FE445FC772041
778	8778	W DIXIE HY	NE 131 ST	NE	N	N	0	0	1	9/30/2016 13:48	25.8958	-80.182	925082.198379528	568657.157043278	bdc93f07-d8d8-4b90-94c6-9aa481218967	0101000020E6100000A4AEFDE1A50B54C062303D7553E53940	0101000020BC080000E052189D323B2C413BB9B3BBA55A2141
779	593	NE 36 ST	BSCAYNE BLVD	\N	\N	\N	0	0	0	 	25.81063	-80.18945	922824.898102503	537686.597916886	cd0a7ed3-b3b6-4cc0-bc94-fd0a595c7dd9	0101000020E6100000629EF7E41F0C54C05216810486CF3940	0101000020BC0800005CF73C0390292C419ACB6799B0682041
780	5172	NW 71 ST	NW 15 AV	E	F	Y	1	1	1	9/26/2016 13:25	25.83912	-80.22281	911786.464158364	547975.928015307	e46053f8-6166-4df4-85fb-d7205d149488	0101000020E6100000F69A2890420E54C008854434D1D63940	0101000020BC08000003EB8F2353D32B417310BC4313B92041
781	6099	NW 2 AV	NW 187 ST	N	N	N	1	1	1	9/21/2016 13:57	25.94603	-80.20517	917352.461233981	586869.404359996	00e9a8e1-9f25-4d26-b037-d99e235c20a4	0101000020E6100000A02D0495210D54C0A57FE2A82FF23940	0101000020BC080000F503BD22CFFE2B413BB2A93CEEE82141
782	4891	NW 27 AV	NW 23 ST	S	F	N	1	1	0	9/19/2016 13:55	25.79773	-80.24	906218.347325098	532898.623545781	95674c3e-daa1-41df-a902-c2fdd7946228	0101000020E6100000CB8ED8405C0F54C06878569A38CC3940	0101000020BC080000F1280DE7D2A72B41E8DCE1A548432041
783	337	SW 40 ST	SW 67 AV	W	N	N	2	0	1	10/13/2016 12:0	25.73355	-80.30268	885722.611433424	509457.591342181	35353167-bf4f-4a27-a336-b2d8e50d1363	0101000020E6100000F17B5DFD5E1354C087785280CABB3940	0101000020BC0800001A3C9A6BB3072B4180CD98244D181F41
784	6606	NW 211 ST	NW 34 PL	E	F	N	0	0	0	9/19/2016 11:57	25.96772	-80.25974	899380.758351054	594646.945946835	9cbb5662-aa54-4450-a043-0ae8838f51e0	0101000020E61000002772F3609F1054C0758973F0BCF73940	0101000020BC080000F04F7BB867722B419E3CF952B1252241
785	10227	E 2 AV	HIALEAH DR	S	N	Y	1	0	0	9/22/2016 14:25	25.82298	-80.27741	893860.009841818	542006.06137462	51e7b680-ff50-443b-a5cf-9a69ee263037	0101000020E610000065953921C11154C04E519741AFD23940	0101000020BC0800006D40983846472B41E1A035876F8A2041
786	5129	NW 79 ST	NW 23 AV	E	N	Y	1	0	0	9/26/2016 12:39	25.84605	-80.23664	907227.235088121	550465.221606918	b4756899-9d16-490a-bd24-ab8f5840360a	0101000020E61000003F2BE0F0240F54C0E55731D896D83940	0101000020BC08000031D2B7ADB4AF2B41547165DA85CC2041
787	6308	NW 37 AV	# 20201	N	N	N	1	0	1	9/19/2016 15:56	25.95792	-80.26205	898637.282135416	591079.876305878	89861948-c3e4-4735-8b63-a3519abf013b	0101000020E6100000467A8374C51054C04FBF228E3AF53940	0101000020BC080000D67F9CC4986C2B41F897C02ED3092241
788	663	ABBOTT AV	69 ST	S	N	N	2	1	1	10/20/2016 12:4	25.8548	-80.12239	944780.965784524	553880.949685663	318249c5-152e-4cd2-9ded-c1f6de74526e	0101000020E61000008E0B7A26D50754C0CEFE756AD4DA3940	0101000020BC080000F7E7B22818D52C41CC0BA14F35E72041
789	1241	NW 1 AV	NW 1 ST	S	F	Y	0	0	0	42641.50764	25.77536	-80.19566	920857.856105387	524852.727547824	ddc6d4dc-4d3f-4b7a-8009-4aac3c221a40	0101000020E610000043B7F6C0850C54C054760E3C7EC63940	0101000020BC0800006CD865ED311A2C41BCE612DA6C042041
791	4512	SW 87 AV	SW 52 ST	N	N	N	1	0	1	10/31/2016 11:2	25.72016	-80.33494	875124.119167365	504533.878443047	09fac2b9-681a-4f7f-b979-e8c1961ce2e2	0101000020E6100000DB9465AF6F1554C05D7BAA945CB83940	0101000020BC08000000573E6EE6B42A41B3C02E495ECB1E41
792	8311	NW 60 AV	# 14740	S	F	N	1	0	0	10/10/2016 13:3	25.90833	-80.29943	886450.573247399	572987.220232815	73407f60-6cd1-46e4-85ab-aa249e68cf61	0101000020E6100000D0DE07EC291354C0543A387E88E83940	0101000020BC080000592F1558630D2B41315F89DC797C2141
793	1361	BISCAYNE BD	NE 211 ST	N	F	Y	1	0	1	11/3/2016 15:23	25.97122	-80.14334	937614.154317811	596152.855608903	b339439b-cb3f-4bfc-b9ae-f4ecb9a210e9	0101000020E6100000B41C61692C0954C0C4178B61A2F83940	0101000020BC0800005ED223881A9D2C414C62FF2475312241
794	9212	COLLINS AV	178 ST	S	F	Y	1	1	1	10/11/2016 13:4	25.94107	-80.12149	944866.927498978	585241.910260588	f0e3216a-33eb-4f6a-b6a3-7d953ad46743	0101000020E610000026BC9C67C60754C025E32189EAF03940	0101000020BC080000B815F314C4D52C415BB77B3F37DC2141
795	5806	NW 57 AV	NW 170 DR	S	M	N	2	0	0	12/11/2002	25.92747	-80.29346	888376.837430563	579956.727289729	d1024052-f6f7-423c-94e0-620132deb160	0101000020E6100000B4A6400BC81254C031D7DF3E6FED3940	0101000020BC080000E79699DF6F1C2B41A63F0AE1ECB22141
796	3389	SW 152 AV	# 28600	N	N	N	1	1	1	10/4/2016 16:11	25.5019	-80.43687	841903.058299385	425053.978648521	1bcebdeb-1435-44f6-a992-30616f0d7548	0101000020E6100000D91D53A8F51B54C0F13C31157D803940	0101000020BC080000DE93F14A5CB1294105F5DA9A7EF11941
797	7191	NW 14 AV	NW 67 ST	S	F	N	0	0	0	9/26/2016 13:42	25.83542	-80.221	912388.789412376	546633.52288831	0215543a-154f-479a-b69f-a424b0e92aad	0101000020E610000029520DF5240E54C0279C3A86DED53940	0101000020BC0800000C7120CA07D82B419250237496AE2041
798	7065	NW 7 AV	NW 29 ST	N	N	Y	1	0	0	9/20/2016 13:13	25.80341	-80.20721	916996.776871473	535024.940187074	11d3b26d-2c91-4267-a9db-a79c118f5280	0101000020E6100000F93E6AEC420D54C05D441085ACCD3940	0101000020BC080000701B4BC407FC2B4193E72E48E5532041
799	3429	SW 104 ST	SW 108 AV	W	F	N	0	1	0	9/20/2002	25.67245	-80.37037	863544.813943781	487137.751155958	2f2af92c-c2fd-437e-a308-5f83048500c7	0101000020E6100000F47FE105B41754C0BE4D941E26AC3940	0101000020BC080000EBEE72D06F5A2A4182FC29C28DBB1D41
800	1998	SE 8 AV	OKEECHOBEE RD	S	N	N	1	0	0	2/15/2017 15:45	25.81139	-80.2648	898036.307945404	537817.241364785	65cda14c-a146-4348-be2a-1eb6db45259b	0101000020E61000005779504CF21054C0947826D3B7CF3940	0101000020BC0800009A67DED1E6672B415768BDE2B5692041
801	6995	SW 3 AV	SW 29 RD	SW	F	N	1	1	1	11/16/2016	25.75358	-80.21106	915837.541375276	516906.900931455	3fd1c8ef-af4c-4c8f-ab50-2194aeb46c68	0101000020E6100000598C100D820D54C0EE3B850EEBC03940	0101000020BC0800007C95BF4BF9F22B41C142AD63B28C1F41
802	5669	NW 165 ST RD	OP # 500	SW	M	N	0	0	0	11/3/2016 15:15	25.92405	-80.20889	916178.578727011	578871.758293383	47492687-f168-4264-9a5e-843f95997472	0101000020E61000007927A2835E0D54C0CE2843FB8EEC3940	0101000020BC080000FB07B95EA3F52B41A23BD5F072AA2141
803	1888	SW 187 AV	# 33300	S	N	N	0	0	0	10/30/2002	25.45891	-80.49354	823274.20613911	409351.375552967	f6029fb7-83c3-4237-ba89-3620c70fd443	0101000020E6100000ACCBA6F9951F54C0C43179197B753940	0101000020BC0800005FC53E94D21F2941883C1E2D24FC1841
804	1692	SW 40 ST	MONSERRATE ST	E	F	N	0	0	0	10/13/2016 13:3	25.73437	-80.26943	896663.374986939	509812.28980162	05051410-a71d-4b47-9984-f26d8eff3cba	0101000020E61000005AE9DA663E1154C0249436C8FFBB3940	0101000020BC0800006A20F7F32C5D2B417913DCEFD71D1F41
805	7907	NW 14 ST	NW 12 AV	W	F	Y	0	0	1	11/10/2016 16:3	25.78766	-80.21562	914264.193754267	529284.855199762	40f04efe-a7bc-4a92-bb5c-dcffcfd1d889	0101000020E6100000223A52B2CC0D54C008E82E86A4C93940	0101000020BC080000C92D8899AEE62B4112B9EA1B0D272041
806	8373	OAK LA	NW 79 CT	E	F	N	1	0	0	10/19/2016 15:5	25.9089	-80.32954	876551.762669355	573144.832120925	4271f88e-9bbb-4388-8895-d31f02211ca3	0101000020E6100000C82E8F3E171554C0E9B0E13DAEE83940	0101000020BC0800009F04DBB70DC02A417AB6D915B57D2141
807	4819	NW 22 AV	NW 75 ST	S	F	Y	1	1	0	9/26/2016 12:49	25.8426	-80.2336	908229.784902848	549217.049262501	849b04db-bcb7-4894-b5db-7893b0a2544b	0101000020E61000005335E95CF30E54C0A9FBC6BEB4D73940	0101000020BC080000582C4DC789B72B415857F881C5C22041
808	2289	HIALEAH DR	SUFFOLK AV	W	N	Y	1	0	0	10/19/2016 14:2	25.82315	-80.26982	896356.12656454	542081.273833148	ab34ce30-29fe-486e-af80-66d9733ae207	0101000020E6100000551AA5CA441154C05279ED54BAD23940	0101000020BC08000069E1A874C65A2B41D933EEF3058B2041
809	3863	SW 112 AV	SW 36 ST	S	F	N	1	1	1	10/27/2016 19:5	25.73576	-80.3758	861643.008686565	510138.452176474	15a27e8e-1291-48eb-ba31-268547a75552	0101000020E6100000AECEAE370D1854C0D23310025BBC3940	0101000020BC0800001F360234944B2A4142922B96F0221F41
810	2411	NW 55 ST	NW 36 AV	E	F	N	0	0	0	10/10/2002	25.82414	-80.25506	901208.522055104	542466.873085156	a2359ccf-face-4bee-af67-d88663a8bb95	0101000020E61000003C6E4803531054C0D31445F3FAD23940	0101000020BC0800008AE1CC3FAF802B414FD5CA26098E2041
811	5114	NW 83 ST	N MIAMI AV	W	F	Y	0	0	1	11/2/2016 11:10	25.85118	-80.19758	920057.598842844	552407.416242465	d6f6befa-b618-4454-af13-3b305b5531e1	0101000020E6100000FF3F3B3AA50C54C0FABDA93DE7D93940	0101000020BC080000644F9069F1132C41C47C463EB2DB2041
812	4505	SW 87 AV	SW 76 ST	N	N	Y	1	0	1	10/31/2016 10:5	25.69868	-80.33387	875516.770648878	496728.251671456	eb08f628-f351-444b-b3ba-2d1886373d02	0101000020E610000069C5E71A5E1554C0B7A032CDDCB23940	0101000020BC080000B398EDBBF7B72A4177B86BC567511E41
813	5593	EAST RD	KENNEDY DR	N	N	N	0	0	0	9/30/2016 11:48	25.88125	-80.24454	904550.428117573	563245.720984921	3df7645e-4a3d-4125-891d-e32fad02c492	0101000020E610000079E4CD9EA60F54C0D0326EF999E13940	0101000020BC0800003EDE2310CB9A2B41592498DB5E302141
814	2922	71 ST	RUE GRANVILLE	E	F	N	1	0	1	10/20/2016 12:0	25.85126	-80.13974	939082.39383959	552556.868340597	ebeecbe9-2a37-48c1-9ef3-6d22fad58e00	0101000020E6100000B6794176F10854C08691DC7BECD93940	0101000020BC080000A9A8150393A82C413747D625DDDC2041
815	9104	SW 97 AV	SW 182 ST	N	F	N	1	0	0	11/15/2016 12:5	25.60084	-80.34819	870974.381756674	461143.769034863	026394bc-b3d1-4e7e-9718-2bf2fdbebdf2	0101000020E61000002BD482D2481654C0A67E67A0D0993940	0101000020BC080000BA5251F47A942A41A8C7B9CD65251C41
816	9109	SW 168 ST	SW 94 AV	E	F	N	0	0	0	11/11/2016 16:2	25.61397	-80.3447	872102.613108121	465923.737795047	8c092a49-d081-4266-91fc-b516e22aa661	0101000020E6100000A7626A8F0F1654C007DFF9812D9D3940	0101000020BC080000E22BD06A4B9D2A417E332CAF15701C41
817	8964	NW 27 AV	DUNAD AV	N	F	N	1	0	1	9/16/2016 8:51	25.90738	-80.24385	904721.893286806	572745.58453083	7e206f45-6d20-4059-8963-d0cbe7a3d6f2	0101000020E6100000378A21599B0F54C0353689A04AE83940	0101000020BC0800006B013EFE219C2B41C9E5FB96967A2141
818	9362	NW 112 AV	NW 1 ST	S	N	N	1	0	0	10/27/2016 19:4	25.76977	-80.37722	861121.116025459	522498.875952177	e8334d32-5e37-4c29-ac0d-ea5c50db6042	0101000020E61000003DCF4449241854C0055C6F2610C53940	0101000020BC080000145AC56A80472A4187E7504B12E41F41
819	5440	NE 2 AV	NE 107 ST	N	F	N	0	0	0	11/4/2016 12:54	25.87336	-80.19378	921257.859556597	560478.30950354	21b03b90-1bb6-49cc-8c99-bc2361b34a1f	0101000020E61000003AFBDFF7660C54C0687C841795DF3940	0101000020BC080000DB2731EF511D2C4182FE9A08C01A2141
820	9034	NW 135 ST	NW 32 AV	W	N	Y	0	0	0	2/15/2017 11:16	25.89705	-80.25148	902237.464230139	568974.38175045	cbc26f6b-5b9b-4198-a444-6e8830a844d0	0101000020E610000051A3503E181054C0A4952F3FA5E53940	0101000020BC0800005B063D22B9882B419C63BA2E205D2141
821	2424	E 65 ST	E 5 AV	E	N	N	1	0	0	10/7/2002	25.88159	-80.27346	895040.284709524	563314.886554524	1a2b80a4-0be1-490b-b960-f64cb24b4676	0101000020E6100000E369817A801154C01D502020B0E13940	0101000020BC080000F1216FC57E502B41A8A56330E9302141
822	6352	NW 47 AV	NW 170 ST	N	N	Y	1	0	1	8/31/2016	25.92794	-80.27672	893876.160082713	580155.022446245	e47defbf-b40c-42b3-8a28-9ffcb6cfb0a0	0101000020E6100000283B8DDBB51154C05C4CB9968DED3940	0101000020BC080000D7B78C8566472B41537E2A7879B42141
823	2315	W 18 ST	W 8 AV	E	F	N	0	0	0	10/19/2016 16:4	25.83794	-80.29758	887196.576653477	547405.001003072	d9189e4c-56ff-4f0d-a284-ae4545fa08f8	0101000020E61000000989F98F0B1354C0E4B1593783D63940	0101000020BC080000DDB1E95937132B415EF8E5689DB42041
824	3505	SW 152 ST	SW 99 CT	W	F	Y	0	0	0	11/17/2016 11:5	25.62864	-80.35491	868710.846569017	471237.236055523	e6d34f6c-bcd5-4c09-b527-c2b3cf123481	0101000020E6100000D66F0DE8B61654C0EA4CE897EEA03940	0101000020BC080000D7A2F3E1CB822A412CB4BDAE1BC31C41
825	2708	WASHINGTON AV	11 ST	N	F	Y	1	0	1	11/2/2016 13:12	25.78218	-80.13238	941667.279392466	527463.374591239	e4bf0840-c81d-4ec3-87c1-890138f62446	0101000020E61000000083F0F0780854C0DE4EF11F3DC83940	0101000020BC080000C084D4C8C4BC2C4161E3BC25D2182041
826	10308	SW 187 AV	SW 352 ST	N	F	N	1	1	1	10/21/2016 12:2	25.4408	-80.49324	823392.596346118	402770.24731157	ad1a4b53-f08e-4f23-93e6-ce17442429ac	0101000020E61000004103AA56911F54C0DDCBCB4ED8703940	0101000020BC080000F4E7FE5BBF2029413CC509A84F951841
827	1683	ANASTASIA AV	GRANADA BD	W	N	N	0	0	0	10/12/2016 13:3	25.74169	-80.27448	894987.255604718	512464.745098487	78770df1-1e05-4121-b1d0-780a5e3da50b	0101000020E61000009F268317911154C0F495C8B3DFBD3940	0101000020BC0800004ABCAEB614502B4129A7ACC249471F41
828	303	SW 37 AV	W FLAGLER ST	S	F	Y	1	0	1	42619.54514	25.77126	-80.25554	901161.616645683	523245.619870663	c9adeed9-a007-4c23-b1f1-35148f7a9c10	0101000020E61000001E332EC35A1054C0DC90175771C53940	0101000020BC08000061425F7051802B4116446E45BDEF1F41
829	82	SW 8 ST	SW 27 AV	W	F	Y	1	0	1	9/8/2016 12:48	25.76525	-80.23922	906545.492017459	521091.879108578	972a81a7-45c3-475f-ab5b-96e10dea1733	0101000020E61000001128ED5B4F0F54C0BA440178E7C33940	0101000020BC080000716E303161AA2B41B03D4D4E16CE1F41
830	4671	SW 72 ST	SW 53 AV	E	N	N	1	0	1	9/22/2016 12:27	25.70466	-80.2792	893505.691011354	498997.669378437	3e639e2c-44bc-4e0c-a5d4-999edb7e8351	0101000020E6100000E8BC687DDE1154C00C381BF864B43940	0101000020BC08000005F8649581442B410E73B871DD741E41
831	6503	NW 183 ST	NW 12 AV	E	F	N	1	1	1	10/27/2016 16:2	25.9418	-80.22062	912285.433959812	585300.308143236	31621bb5-b1cd-4dfe-b45f-5dfecebc5890	0101000020E6100000533473AA1E0E54C05EB5E93E1AF13940	0101000020BC08000003481F1439D72B41433C2D0BACDC2141
832	7325	SW 22 AV	SW 19 TE	S	F	Y	0	0	0	10/17/2016 15:5	25.75333	-80.23033	909498.622273773	516777.113488711	ff4d1a24-1511-460d-a087-17684815187a	0101000020E6100000A9E6629BBD0E54C0B5501B69DAC03940	0101000020BC080000ACBB387473C12B41DFE6443DAB8A1F41
833	7520	SW 37 AV	SW 26 TE	N	N	Y	1	0	0	9/22/2016 14:56	25.74181	-80.25415	901678.622818165	512546.043195143	4567c0c1-2254-4635-9a74-2fecf282b246	0101000020E61000008CA6AD09441054C09EF0D8A1E7BD3940	0101000020BC08000053B97C735B842B41D79B02F48E481F41
834	569	NE 19 AV	NE 183 ST	N	F	Y	2	1	1	11/11/2002	25.94483	-80.16272	931307.179721229	586519.817461669	6375dae3-7441-4051-a15e-1a1f16d3dfbd	0101000020E610000032CE97FB690A54C0B76A76F3E0F13940	0101000020BC08000005955194D46B2C410CE0251033E62141
835	6473	NW 177 ST	NW 5 AV	E	N	N	1	1	1	10/26/2016 12:0	25.93677	-80.20917	916058.974336311	583493.861911729	12246d7f-48d5-48de-8ebc-0fee11b553b8	0101000020E6100000B5AFD915630D54C0F313F277D0EF3940	0101000020BC080000F8543629B4F42B41227D80268FCE2141
837	3434	SW 104 ST	SW 122 AV	W	F	Y	1	1	1	9/29/2016 14:13	25.67174	-80.39247	856263.681188203	486844.91089575	dedb71a3-975e-421d-8b29-87c2f095c047	0101000020E6100000A594F7451E1954C0917F3475F7AB3940	0101000020BC080000146CA38B8D212A414D64C465FAB61D41
838	1387	AVENTURA BD	NE 29 PL	W	F	Y	1	1	1	11/3/2016 14:57	25.96113	-80.14325	937668.078051176	592483.729746036	a50080d3-9232-48e6-a6d4-6c4dffbf2633	0101000020E6100000225AB2EB2A0954C01D527CCB0CF63940	0101000020BC08000025541361869D2C41160EF9E3CA142241
839	483	NW 72 AV	NW 22 ST	N	F	N	1	0	0	10/10/2016 13:4	25.79422	-80.31271	882304.751141928	531489.206763998	99f03025-dbed-4850-9082-213ce29da911	0101000020E6100000AB88D55E031454C0C5E19B2D52CB3940	0101000020BC080000C7ECB8B2FFEC2A41A18140D045382041
840	10214	E 2 AV	HIALEAH DR	\N	\N	\N	\N	\N	\N	 	25.82285	-80.27722	893923.106191378	541958.065703474	1b0ebc7d-b759-483e-a6af-ba8589f5babc	0101000020E6100000521D1D00BE1154C08E59358AA6D23940	0101000020BC08000026FAF469C4472B41271B53890F8A2041
841	7991	NW 7 ST	NW 36 CT	E	N	Y	1	1	0	9/6/2012 12:54	25.77888	-80.25491	901353.93184372	526018.931924984	b9ff097a-11cb-4bb6-832b-31a7d8a9222c	0101000020E6100000CB8A6168501054C07672F42E65C73940	0101000020BC080000AD4BB311D2812B41AD41D442890D2041
842	4642	SW 56 ST	SW 82 AV RD	E	F	N	1	0	1	10/12/2016 17:2	25.71736	-80.32302	879053.858344086	503536.87190339	7c96ca8f-042a-47da-85bf-1d9d92de8698	0101000020E610000017794763AC1454C058D0FF35A5B73940	0101000020BC080000F1294BE999D32A41CC512E42CABB1E41
843	9639	N KROME AV	NE 2 ST	S	N	\N	0	0	0	10/7/2004	25.47182	-80.47743	828565.657485835	414067.135182045	34a2e820-c13e-4a2a-abb2-444ac1645e14	0101000020E6100000EC6DB34E8E1E54C0D5BF66C2C9783940	0101000020BC080000B703F17B29492941C7F25E38D3451941
844	6492	NW 183 ST	NW 28 PL	E	N	N	1	0	1	10/27/2016 15:3	25.94065	-80.24893	902984.635333449	584829.047923446	1cf4c038-4faf-46f5-8d70-6db2f5ff7be1	0101000020E61000001385097BEE0F54C0C7E76E13CFF03940	0101000020BC0800005DD4E7798F8E2B419376E685FDD82141
845	2254	W 18 AV	W 60 ST	S	N	N	1	0	0	10/3/2016	25.87773	-80.31939	879947.360536102	561829.874728724	43b06440-96b4-4a3a-8e34-91a06be90123	0101000020E6100000CB9829EE701454C097C5B7F5B2E03940	0101000020BC080000ED0869EA94DA2A413257292A4F252141
846	6614	NW 211 ST	NW 34 PL	W	N	N	0	0	0	9/19/2016 14:03	25.96779	-80.25986	899335.606217351	594671.407514773	7afdea8c-315f-4ea0-8e8b-cf75418f696e	0101000020E6100000E45C929FA11054C013F24D65C1F73940	0101000020BC080000C5988E6A0D722B41FA2B4B3FE2252241
847	4069	SW 24 ST	SW 112 AV	E	N	Y	1	0	1	9/14/2016 13:11	25.74641	-80.37638	861434.103922233	514009.085228182	fbbf8e0f-e8b9-4d21-b7ae-d180f059ce49	0101000020E6100000596E30B4161854C079AE011915BF3940	0101000020BC08000052F29564F2492A415609421F6B5F1F41
848	7252	SW 17 AV	SW 12 ST	N	F	Y	1	1	0	8/18/2016	25.76183	-80.22231	912117.223660897	519883.849682458	26723622-fd1a-4980-80bf-7bcde5c1c8ef	0101000020E610000009AFCD5A3A0E54C074835ACB07C33940	0101000020BC0800003DD098A8E8D52B4181B6E32F36BB1F41
849	5678	EAST RD	STADIUM DR	N	F	N	0	0	0	10/23/2002	25.87486	-80.2443	904641.715331532	560925.055692993	1fb6e86f-723e-43cd-a593-eeabb80a9422	0101000020E6100000263BC2BCA20F54C0FE6C1D76F7DF3940	0101000020BC080000D8D524A3819B2B410B92C1863D1E2141
850	3080	SW 102 AV	SW 168 ST	S	F	N	1	1	1	11/17/2016 14:2	25.61315	-80.3573	867952.648297466	465604.651867948	83a85434-59c6-41bd-bf87-448799448cdd	0101000020E6100000D24546F7DD1654C0F1E217A3F79C3940	0101000020BC0800001201487CDF7C2A4149E6D056196B1C41
851	4549	W FLAGLER ST	GRAND CANAL DR	E	N	Y	1	0	1	9/8/2012 13:46	25.76994	-80.31491	881624.129785266	522662.407158785	97395c0d-c70a-4e70-ad05-3b9597af37c4	0101000020E6100000131ADC8B271454C05FB9954A1BC53940	0101000020BC0800009FCE7374AEE72A4130D6376BA0E61F41
852	182	SW 1 AV	SW 32 ST	\N	\N	\N	0	0	0	 	25.7497	-80.21176	915613.929903746	515493.45297426	99038906-e1fa-400a-ada5-c116fcca5cb6	0101000020E6100000681A0D9A8D0D54C077A10473ECBF3940	0101000020BC08000084DA8F123AF12B4107AF6C989C761F41
853	4	BUSWAY	SW 152 ST	NE	N	Y	6	1	2	9/29/2016 15:12	25.62829	-80.34163	873090.384756077	471133.390450679	f844d900-f3c9-46e2-a7e7-9cfc3496a588	0101000020E61000008616BC29DD1554C031CEC4FBD7A03940	0101000020BC0800001C3703F602A52A418663E04C7CC11C41
854	7428	NW 27 AV	NW 14 ST	N	F	Y	1	0	1	9/16/2016 10:09	25.78747	-80.23947	906414.607141878	529169.389236741	61df2ace-426b-490e-99c2-ac8924088533	0101000020E6100000D929AB8D530F54C07CB3B90198C93940	0101000020BC080000A0462A6C5BA92B41C71E622D26262041
855	3451	SW 104 ST	SW 150 PL	E	N	N	1	1	1	9/29/2016 13:45	25.66988	-80.44028	840520.105022963	486097.587877944	3926972b-1f94-4ee4-8d8f-fa77fabde123	0101000020E61000009B044F8F2D1C54C04D95A63B7DAB3940	0101000020BC08000025CBA1628EA629416C578F1A4DAB1D41
856	5768	N MIAMI AV	NE 184 TE	N	N	N	0	0	0	11/19/2002	25.94405	-80.20108	918700.598601326	586154.630548581	ab481de6-00be-48e2-be01-b621dce1232a	0101000020E6100000E7DF8096DE0C54C0D63C004FADF13940	0101000020BC080000C8AE326957092C41C15554B058E32141
857	4406	SW 62 AV	SW 30 ST	S	N	N	0	0	0	10/12/2016 14:2	25.74298	-80.29522	888155.558019545	512896.221962415	2bd89e75-74f6-4a65-bf78-cdf9e86ce19b	0101000020E61000004D3E91FEE41254C077239E2D34BE3940	0101000020BC0800007E299B50B51A2B41B1DD31AB074E1F41
858	8698	NE 172 ST	W DIXIE HWY	W	F	N	1	0	1	9/8/2016	25.93485	-80.15225	934772.354867883	582914.457881853	d44e73d2-8a62-43eb-bd76-23502616f717	0101000020E6100000EC15A264BE0954C09B1CCFE652EF3940	0101000020BC080000BBFA7BEEE6862C41FCD4855708CA2141
859	6364	NW 57 AV	NW 161 ST	N	N	Y	1	0	0	10/25/2002	25.9192	-80.29283	888600.460036203	576949.413755856	4e63eee0-7815-4412-a0dd-18997c9f93b1	0101000020E61000002E8CA5B4BD1254C07C66D3CD50EB3940	0101000020BC080000213F561E2F1E2B4165051D406E9B2141
860	5254	NW 36 ST	NW 72 AV	W	F	N	1	1	1	11/8/2016 13:34	25.80952	-80.31457	881663.118593715	537049.160850778	9262ca70-efa7-409f-86a5-e1798126e5d9	0101000020E61000006EDAA1E0211454C09EC0BD453DCF3940	0101000020BC080000A262D06EFCE72A4122576AB9B5632041
861	8856	NW 119 ST	NW 14 AV	W	F	Y	1	0	0	9/30/2016 16:11	25.88336	-80.22335	911512.140230924	564052.211837105	2641e4f6-f295-493a-84fa-328bda58d9f1	0101000020E61000008693107E4B0E54C0D8DE0B0F24E23940	0101000020BC080000834E997D2ED12B4146BA11D7AB362141
862	6478	NW 177 ST	NW 7 AV	W	N	N	1	1	1	10/26/2016 14:4	25.93682	-80.21243	914988.467600074	583505.586628564	43f23b15-55ec-4ee7-81a9-b261a6f5bb63	0101000020E610000034F3B372980D54C017DCCEBED3EF3940	0101000020BC080000BC38952557EC2B417E798A99A6CE2141
863	280	US 1	CARIBBEAN BD	NE	N	N	2	0	0	8/16/2016	25.57913	-80.3688	864219.574357379	453223.336735152	33480309-5a3f-430f-ae36-b8f00ca4c1c7	0101000020E6100000CC85247F9A1754C00893285D42943940	0101000020BC0800006FFFFB55B55F2A41EF56EE10A4A91B41
864	2228	W 16 AV	W 44 PL	N	N	Y	1	0	0	10/3/2016	25.86211	-80.31464	881539.799248792	556160.678707071	4817ff37-3c75-4c9e-93fa-184f8176e590	0101000020E61000005C29A10E231454C0DC738A49B3DC3940	0101000020BC080000EA4738CB05E72A41591F14C504F92041
865	1633	SW 57 AV	CATALONIA AV	N	N	N	1	0	0	11/30/2016 14:1	25.74299	-80.28692	890893.634213988	512914.935815483	2083c754-05a6-4a0d-bc99-411716df84d7	0101000020E6100000DC1756B65C1254C086FB2CE634BE3940	0101000020BC08000081F20C7819302B41C6C33186524E1F41
866	5738	NE 10 AV RD	NE 205 TE	NW	N	Y	1	0	1	10/28/2016 17:1	25.9629	-80.18535	923827.562780946	593040.183741488	c70815f6-9b1a-4e2c-a908-9a7fa723d16a	0101000020E61000000583E3D9DC0B54C051BB460E81F63940	0101000020BC0800001A9A735765312C41C1377BCC23192241
867	5649	NW 135 ST	NW 24 AV	E	F	Y	1	1	1	10/24/2002	25.8973	-80.23919	906275.999159735	569089.57678356	6501e623-a396-4865-b385-bea5f4c60a62	0101000020E6100000C16114F34E0F54C0C370D6D3B5E53940	0101000020BC080000CD07C53446A82B41B642A192065E2141
868	9638	N KROME AV	NE 2 ST	N	N	Y	0	0	0	10/21/2016 13:5	25.47154	-80.47731	828608.28702113	413965.174386337	066ca75a-8819-4c8c-b73d-280d49844703	0101000020E61000000C6DD4358C1E54C0BA93FD57B7783940	0101000020BC0800003AE253BE7E492941071363603B441941
869	3240	SW 117 AV	SW 104 ST	N	N	N	1	1	1	8/17/2016	25.67117	-80.38386	859100.184703767	486651.587778047	ded3f746-95ca-4f60-b615-ec45e2e02180	0101000020E6100000B2493139911854C0201ABB3BD2AB3940	0101000020BC0800004308D78DB6372A41DFE3AC1AF5B31D41
870	3230	SW 117 AV SERVICE RD	SW 139 TE	N	N	N	1	1	1	8/17/2016	25.63879	-80.38249	859606.342797268	474884.402945213	19cb63ee-1931-43ed-b927-9b08cd0a4819	0101000020E6100000270CFEC67A1854C07D79C90B88A33940	0101000020BC080000B2E1CDDEAA3B2A4164FB685A18FC1C41
871	3726	SW 268 ST	SW 125 AV	W	F	N	1	1	1	10/4/2016 15:42	25.51835	-80.39408	855987.768354647	431094.255299598	3a5a7a79-e0cd-4f38-aa31-8bb3c3474ab9	0101000020E6100000C3C4FAAA381954C0135AB515B3843940	0101000020BC080000168B36B8651F2A412652E2B7DF4F1A41
872	3696	SW 216 ST	OP # 10467	E	F	N	1	0	0	10/4/2016 13:59	25.56632	-80.36098	866820.322803151	448577.720967293	f4550943-120c-41ab-b1ec-a725d43e24ee	0101000020E6100000B1AA48571A1754C010984F74FA903940	0101000020BC080000CAFE95D506742A413BA157990D611B41
873	3185	SW 112 AV	SW 161 ST	N	N	N	1	1	1	11/17/2016 15:0	25.6192	-80.37395	862455.560203772	467778.35255941	299a07af-43c0-41ca-891b-c2029056cc68	0101000020E6100000784174C2EE1754C0EB009B53849E3940	0101000020BC080000764D8F4EED512A414AAF1425108D1C41
874	6337	NW 42 AV	NW 196 ST	N	F	N	0	0	0	8/31/2016	25.95219	-80.26992	896061.291223507	588984.126874305	d4d0fff8-70cb-4fd5-a786-4b06838cce50	0101000020E6100000F154AB7A461154C0E62CC34BC3F33940	0101000020BC080000D069E6C878582B41B562BEAE73F92141
875	2686	INDIAN CREEK DR	43 ST	S	F	Y	0	0	1	11/2/2016 14:03	25.81502	-80.12373	944433.344716404	539420.450720951	e30c65bc-3f59-44f5-8c20-993f341a894b	0101000020E6100000E462C944EB0754C094D6BAA7A5D03940	0101000020BC080000A9DBA0EA60D22C41400F384E3C762041
876	3628	SW 197 ST	SW 114 AV	W	N	N	1	1	1	11/15/2016 15:2	25.58356	-80.37646	861686.101450991	454820.743586577	7e99c04a-9f77-4038-b5ed-121067f96071	0101000020E610000068741A0C181854C0E88CAF8E64953940	0101000020BC08000046BE8D63EA4B2A41018FEDB199C21B41
877	4128	SW 40 ST	FLORIDA TURNPIKE	E	N	Y	3	0	1	10/13/2016 14:1	25.73188	-80.38502	858614.735229634	508716.175187767	d917f04b-2c5c-4ec4-a9a7-9a98009dfa07	0101000020E610000026C0FA42A41854C080581B1F5DBB3940	0101000020BC080000C7729AA7EB332A415FF8197AB70C1F41
878	3711	OLD CUTLER RD	FRANJO RD	E	F	N	1	1	1	10/4/2016 11:26	25.57888	-80.33523	875284.554526366	453186.14026615	eb9346f7-09d4-42fd-a2b8-aed698839d2f	0101000020E61000006C90E688741554C0B68015EA31943940	0101000020BC080000F585354D27B62A414D2ABC470FA91B41
879	181	SW 22 ST	SW 27 AV	E	F	Y	1	0	0	9/14/2016 11:12	25.75022	-80.23785	907026.975674011	515631.984212853	33735ce8-b756-4e3d-92cd-19e6519d7008	0101000020E6100000DC934EF6380F54C0828626870EC03940	0101000020BC080000F4D2E82824AE2B41312357B8C6781F41
880	7337	SW 22 AV	SW 26 ST	N	N	Y	1	0	0	10/17/2016 15:5	25.74384	-80.22975	909709.015548561	513329.31855569	9c8e2372-8c2c-4da4-a398-bd1f36e394b7	0101000020E6100000C6D41223B40E54C0C4D40C8A6CBE3940	0101000020BC080000959AB23D18C32B4115EF3A0ECC541F41
881	9015	NW 42 AV	OP #12950	N	F	N	1	0	0	2/15/2017 10:19	25.89155	-80.26737	897023.418194681	566947.258230314	c38b5905-0698-484b-9b40-5c1989462d4c	0101000020E6100000D5239AA61C1154C0455C970F3DE43940	0101000020BC080000AB2A180AFD5F2B41029944EF494D2141
882	8128	SW 7 ST	SW 10 AV	W	N	Y	1	1	1	9/8/2016 12:02	25.76689	-80.21104	915814.83798961	521745.386338085	251f7764-23cd-4bcd-b5c3-7b8246359703	0101000020E6100000D92A5FBD810D54C02772DE7853C43940	0101000020BC080000EFE891E3CBF22B4113A5C9554CD81F41
883	9162	SW 77 AV	SW 136 ST	N	F	Y	1	0	0	11/30/2016 15:5	25.64461	-80.3177	880942.576371834	477103.391958736	3df9fd6b-8a80-4c46-bba6-dc52bf530b7f	0101000020E6100000B9EA2D31551454C014D5E64405A53940	0101000020BC08000041FE17595BE22A413A29D84FC41E1D41
884	8511	NW 41 ST	HAMMOND DR	W	N	N	1	0	0	11/8/2016 12:32	25.81172	-80.301	886120.686734259	537870.068986304	627090ea-51b2-4c5c-9f8d-cb4ef27c41d8	0101000020E61000000BB577AD431354C0769DF60ECDCF3940	0101000020BC0800007CD03F92CF0A2B414EE7758A1F6A2041
885	2016	E 4 AV	E 37 ST	N	N	Y	1	0	0	10/3/2002	25.85596	-80.27457	894728.10589112	553996.485221125	57580e10-6e36-457b-b7a0-9025eaca428a	0101000020E6100000B75B6699921154C09DDD694E20DB3940	0101000020BC080000343EDF690E4E2B415C62B5611CE82041
886	8822	N MIAMI AV	NE 125 ST	N	N	N	0	0	0	11/3/2016 17:14	25.88929	-80.19855	919653.69776259	566258.445945919	7de28f42-e4b0-422b-8c20-9b9c9d1b2441	0101000020E61000007847E722B50C54C07479DC03A9E33940	0101000020BC080000D286229CC9102C41F437494FE8472141
887	4976	MILAM DAIRY RD	NW 14 ST	N	N	N	1	1	1	10/10/2016 13:3	25.78599	-80.3192	880181.149775691	528488.626156114	d64401db-e0ef-466b-9920-2b4e46147d4f	0101000020E6100000BDF702E26D1454C0DB16F82437C93940	0101000020BC080000336C837E68DC2A413E7791A6D4202041
888	7617	NW 79 ST	NW 4 AV	E	F	N	0	0	0	10/20/2016 13:1	25.84716	-80.2032	918222.412590187	550935.044835083	24662155-e18d-490e-b99c-a17c8f1495dc	0101000020E610000081C4B217010D54C04F613AC9DFD83940	0101000020BC0800006E7EFC099B052C415FA4D97F31D02041
889	5762	NE 2 AV	NE 209 TE	N	N	N	0	0	1	11/1/2016 17:03	25.96805	-80.1982	919595.891119845	594886.384392761	4c41eda3-5835-4fec-a612-ca24933fa7c2	0101000020E61000005FF98A49AF0C54C00C29BAA1D2F73940	0101000020BC0800003C5020FF55102C419F9C693390272241
890	2183	W 12 AV	W 51 PL	N	F	Y	0	0	0	10/10/2016 13:5	25.86936	-80.3068	884107.327611107	558812.258058019	7c2cfb12-7590-44d6-acf7-aa59d021287e	0101000020E6100000BBF05571A21354C0953799F28EDE3940	0101000020BC080000516609DA14FB2A41F33BF7EDBB0D2141
891	290	NW 53 ST	NW 87 AV	E	F	N	0	0	0	11/6/2002	25.8197	-80.33637	874471.772086542	540710.978651322	4a1c4be3-1a2e-41d4-981a-b4d5e2395db5	0101000020E61000008772E014871554C0833CB92AD8D13940	0101000020BC080000FFFF6EBCCDAF2A41C552855C51802041
892	4604	SW 40 ST	SW 72 AV	W	N	N	1	1	1	10/13/2016 12:0	25.73335	-80.3104	883178.255976364	509371.162750132	f9413715-0ff5-46e8-bb73-52a7b20b8a07	0101000020E6100000CA0F58A3DD1354C070551754BDBB3940	0101000020BC080000A61C62B5D2F32A41FACC7C6DF3161F41
893	4787	NW 22 AV	NW 62 ST	N	F	Y	1	0	1	10/17/2016 17:2	25.83199	-80.23286	908497.312936842	545363.903425075	02b0d59f-689e-404f-97c8-e0ee0ba79bec	0101000020E6100000B2C82628E70E54C05D5A5CBCFDD43940	0101000020BC0800005B8CB7D5A0B92B41CDCBCA36ABA42041
894	7265	NW 17 AV	NW 19 ST	N	F	Y	1	1	1	8/18/2016	25.79306	-80.22315	911774.15971316	531231.789945044	ce4cfb28-7ceb-4dab-a0a3-3ec0aab036dc	0101000020E6100000867ED419480E54C03399D83806CB3940	0101000020BC0800004960C5873AD32B4141DFDAFA42362041
895	10533	NE 2 AV	NE 4 ST	W	N	Y	1	1	1	11/1/2016 14:15	25.77789	-80.19048	922559.541722413	525782.392372504	17f48f28-b6e9-4e2e-8e64-30287c53c098	0101000020E6100000496AE7C0300C54C01E10A3F923C73940	0101000020BC0800004FBCB64C7D272C4175938A2EB00B2041
896	7223	NW 17 AV	NW 28 ST	S	F	N	1	1	0	8/22/2016	25.80185	-80.22362	911598.352305498	534427.913446508	0f81af88-e930-451b-a357-c405d133f7dc	0101000020E6100000345684EA4F0E54C0192B44AD46CD3940	0101000020BC080000CE644CEADAD12B41D8F57D3A3B4F2041
897	3047	SW 97 AV	# 8980	SW	N	N	1	1	1	9/29/2016 12:21	25.68566	-80.351	869897.502348825	491967.987573959	40a70038-cb49-4463-8fa7-cbada09bc087	0101000020E6100000E9FD52D8761654C09EE4C88587AF3940	0101000020BC08000064EEC331118C2A413855BAB506071E41
898	5009	NW 72 AV	NW 41 ST	S	N	N	1	0	1	10/20/2016 10:5	25.81187	-80.31347	882020.564032108	537903.366505273	7595d932-b735-4c88-adc9-27ba12e806f8	0101000020E61000005244E5DA0F1454C0DBCA4FF4D6CF3940	0101000020BC080000B154E252C7EA2A41BC2CC622626A2041
899	7661	NW 62 ST	NW 11 AV	E	N	Y	1	0	0	10/18/2016 15:3	25.832	-80.21525	914288.860076528	545399.535583638	dfb704e9-51e4-4406-98c5-0ef038f10e7c	0101000020E6100000466B05AFC60D54C05CD077FFFDD43940	0101000020BC080000ED5687EEDFE62B41288B7F7AF2A42041
900	2764	WASHINGTON AV & 17 ST	17 ST	S	F	Y	1	1	1	11/2/2016 13:21	25.79197	-80.13201	941765.241786033	531024.7362101	2d3d7ae5-28ee-43ba-bba6-5f61afc59b9d	0101000020E6100000D7B33DE5720854C0A052961DBFCA3940	0101000020BC0800008F0F8EB588BD2C410EF36ADFA4342041
901	7244	SW 17 AV	SW 19 ST	S	F	Y	1	1	1	8/22/2016	25.75397	-80.22219	912172.922057528	517026.158277728	f53dfcc3-7d3e-40be-a7d4-8598e1310ebe	0101000020E6100000CE25E06B380E54C07CD1147C04C13940	0101000020BC08000018891B0E58D62B41A9CC316B8F8E1F41
902	4596	SW 40 ST	SW 58 CT	W	F	N	1	0	0	10/13/2016 11:4	25.73405	-80.28995	889910.757609677	509659.11689914	a9f81d4a-9196-44e5-b2e2-e8eef418cf75	0101000020E6100000B025D4808E1254C06D747ECFEABB3940	0101000020BC080000EFD21BB76B282B41463DC13E731B1F41
903	651	NW 135 ST	NW 7 AV	E	N	Y	0	0	0	11/12/2002	25.89818	-80.21193	915241.16462747	569463.462830268	b06fb5c3-5f14-4f44-8876-21f3c14d3735	0101000020E6100000D901360F900D54C040C51EB2EFE53940	0101000020BC08000038F88F8A50EE2B41A0075F58F2602141
904	3065	FRANJO RD	SW 187 ST	N	N	N	1	1	1	11/15/2016 13:0	25.59361	-80.348	871050.565650225	458518.87895371	84a45ff7-cde7-47f7-ba86-ab8faf8d02cb	0101000020E610000054CE34AD451654C0D2468F42F7973940	0101000020BC0800006255595213952A416E42CC3D62FC1B41
905	3873	SW 112 AV	SW 60 ST	S	N	Y	0	0	0	10/27/2016 19:5	25.71184	-80.3748	862013.047931109	501446.521758363	5383eafb-fe38-4661-b4e8-967f4eda69c0	0101000020E6100000DA7B91D9FC1754C0E4F1BB733BB63940	0101000020BC080000FF091848784E2A418FA911DB209B1E41
906	5588	NW 27 AV	NW 116 ST	S	N	Y	1	1	1	9/19/2016 11:15	25.88012	-80.2431	905026.924512405	562837.36877846	c557320d-cb38-4d86-8f44-189b15a51c8c	0101000020E6100000CA3C9EFE8E0F54C0DDA968DA4FE13940	0101000020BC08000084736B0E849E2B41814D58272E2D2141
907	5044	NW 107 AV	FOUNTAINEBLEAU BD	N	N	N	2	0	0	1/5/2017 12:43	25.77533	-80.36939	863687.316598456	524530.861428164	d83c78ec-90d7-4446-b812-7b999296a945	0101000020E61000003B2F710CA41754C0422A71557CC63940	0101000020BC080000F8C3D9D18C5B2A41F60C691EE9012041
908	1656	SW 24 ST	TOLEDO ST	E	N	N	0	0	0	9/14/2016 10:26	25.74881	-80.27298	895466.444943488	515053.487958588	302015eb-f367-453e-8c8c-203ad76a3872	0101000020E61000005B514088781154C0A994B5FDB1BF3940	0101000020BC08000071339C17D3532B41F36901BCBC6F1F41
909	10378	Golden Glades P&R	(East lot)	E	T	Y	6	0	0	10/17/2016 12:1	25.92277	-80.21202	915151.948545936	578400.310429312	70800f17-a041-4a82-b3da-55e90e2b2910	0101000020E61000005C0A33D4910D54C0296867183BEC3940	0101000020BC0800007060E91B9EED2B41E735690BC4A62141
910	6182	NW 15 AV	NW 165 ST	N	N	N	1	0	1	10/17/2016 14:0	25.92402	-80.22502	910878.356724191	578827.366361208	581ff168-980c-413d-8246-53e9bf12282a	0101000020E61000006D8CFFB8660E54C02BEB0BB08CEC3940	0101000020BC0800003EEB6DEC3ACC2B41660120281AAA2141
911	7071	NW 7 AV	NW 47 TE	N	N	Y	0	0	0	9/21/2016 13:00	25.81888	-80.20781	916762.879750572	540647.309807427	a380c053-b716-441f-aa43-07f28f1a7bdb	0101000020E6100000E8C98CE24C0D54C0892E387EA2D13940	0101000020BC080000E58712F933FA2B4155B02A06D27F2041
912	1873	N MIAMI AV	NW 87 ST	S	F	Y	1	0	0	11/4/2016 14:23	25.85454	-80.19724	920161.621964339	553630.448530421	dd31fc99-e349-441d-9f9e-f50451227adb	0101000020E6100000D5E05BAC9F0C54C097BC74A3C3DA3940	0101000020BC0800003B126A75C1142C41728DE44E40E52041
913	8146	SW 8 ST	SW 34 AV	W	F	Y	1	0	0	9/8/2016 13:07	25.76488	-80.25167	902447.399811395	520937.203605026	8adc68b2-2bd1-450e-b2d4-46d6c0033c80	0101000020E61000002E52CD671B1054C03A356FCFCFC33940	0101000020BC080000484066015D8A2B41F6DD859AABCB1F41
914	9018	NW 42 AV	# 12950	S	N	N	1	0	1	2/15/2017 11:35	25.89168	-80.26765	896932.741217796	566994.367702104	17992471-e236-4107-8476-2fe68917221c	0101000020E610000019870928211154C0F21F65A545E43940	0101000020BC080000E5346FAF475F2B41BD414627A84D2141
915	9571	S DIXIE HWY	SW 70 ST	S	N	Y	1	0	0	11/16/2016	25.70619	-80.28746	890782.47595479	499540.092513219	e768dfa0-d0c1-4419-a04c-33eb20b425cf	0101000020E6100000D6BE8FD6651254C0AAF3936FC9B43940	0101000020BC080000B8E407273B2F2B4149774023577D1E41
916	5755	NE 2 AV	OP # 18450	N	M	N	1	0	0	11/19/2002	25.94438	-80.19698	920048.544738829	586282.462666176	d77f5504-419d-4990-9685-8487b170adb6	0101000020E6100000B95E13599B0C54C04731B3DEC2F13940	0101000020BC080000999ECE4DDF132C416CB4615A58E42141
917	4536	W FLAGLER ST	NW 74 AV	W	N	Y	1	0	0	9/8/2012 10:52	25.77011	-80.31606	881244.692914944	522720.408679835	9907cad3-3d67-46d4-bb38-80ee76409903	0101000020E6100000F821B36B3A1454C0DD94D31A26C53940	0101000020BC0800000D64C294B7E42A41D364EE6C88E71F41
918	9737	SW 207 ST	SW 85 PASSAGE	E	F	N	0	0	0	12/12/2016 15:1	25.57495	-80.32857	877487.760787394	451767.383227542	cf0b263f-e6ab-43ae-9bd9-697c631ec280	0101000020E61000005A226F62071554C04649821830933940	0101000020BC080000D0F833B75DC72A41B4925D40E4921B41
919	5047	NW 107 AV	NW 14 ST	S	F	N	1	1	1	9/7/2016 12:37	25.78578	-80.3689	863829.720807508	528328.316417508	964d4be0-8706-4d34-9273-cfde720da0be	0101000020E61000000D499F0D9C1754C0502F48EC28C93940	0101000020BC08000017B8D0A0A95C2A412065D807941F2041
920	123	SW 12 AV	SW 1 ST	N	F	Y	1	1	1	10/18/2016 13:1	25.77311	-80.21451	914658.680853553	523998.225675784	cc6c6fac-b96d-46dd-a35a-9a2711695be7	0101000020E6100000B1FA00A0BA0D54C00098DDE8EAC53940	0101000020BC080000287FE692C3E92B41761512B27FFB1F41
921	9374	W FLAGLER ST	NW 112 AV	W	N	Y	2	0	0	9/28/2016 11:59	25.7685	-80.37673	861284.234137859	522036.955297269	2c2e34c4-a9c4-481c-ad2b-e45ac9bcf6bc	0101000020E61000005B6440461C1854C0A35F04B9BCC43940	0101000020BC080000813D58A7C6482A4190E2369CDADC1F41
922	7233	NW 17 AV	NW 7 ST	S	N	Y	1	0	1	8/22/2016	25.78025	-80.22268	911956.942166436	526577.79988268	0f5ecc47-6e7b-497f-8b0e-936ed5bae671	0101000020E610000099591E5E400E54C0F512FAE6BEC73940	0101000020BC080000955A5518A8D42B41375C4AFFE6112041
923	7961	NW 7 ST	NW 45 AV	W	N	Y	0	0	0	11/8/2016 11:20	25.77883	-80.26915	896666.618723147	525974.864077069	cd678465-5a7d-43fe-8227-64c35cc7e855	0101000020E61000009DA510C8391154C0C6A5DBF861C73940	0101000020BC080000239DC670335D2B41B582FF1F310D2041
924	9145	SW 67 AV	SW 112 ST	S	F	N	1	0	0	11/30/2016 11:3	25.66644	-80.30241	885938.656304922	485063.877663553	c6598a3f-788b-456e-9990-635badf1da1a	0101000020E61000007DA2DDA55A1354C0657BA2EB9BAA3940	0101000020BC080000E312C88263092B415B3F6B43269B1D41
925	6935	NW 2 AV	NW 25 ST	S	F	Y	0	0	1	11/4/2016 14:38	25.80057	-80.19918	919645.377880525	534008.32441093	f63a8a70-6833-4f69-ab47-25f46f66ff59	0101000020E61000001218F257BF0C54C015BAFE54F2CC3940	0101000020BC0800000D256DF8B8102C415A13DA0CF44B2041
926	7060	NW 7 AV	NW 2O ST	N	N	Y	1	0	1	9/20/2016 13:13	25.79475	-80.20691	917114.122485463	531876.815879397	3ebd5753-0aef-4d97-8385-640b134d021c	0101000020E610000077C74F063E0D54C0146D02C874CB3940	0101000020BC08000027EE6075F2FC2B4168D72F084D3B2041
927	4029	SW 152 AV	# 7515	N	F	Y	1	1	1	9/26/2016 13:44	25.696	-80.43832	841125.328226857	495596.563966408	b3c3fd8e-e132-4b70-b65a-0a2ea3edd346	0101000020E6100000BF067A720D1C54C05521E18E2DB23940	0101000020BC080000A1FDE3D448AB29419712D204B93F1E41
928	6403	NW 167 ST	# 2320	E	N	N	0	0	0	10/31/2016 16:2	25.9262	-80.23929	906181.183692273	579594.784427367	bd3abe7c-b438-41f8-9e78-66efc8fe8012	0101000020E61000005EA519A3500F54C073DDD1031CED3940	0101000020BC0800000B461B9388A72B41E54B4AFE18B02141
929	7556	SW 42 AV	SW 8 ST	N	F	N	1	0	1	2/13/2017 14:54	25.76476	-80.26317	898661.477617092	520869.712554641	d61d1cdf-648f-48c4-9954-a0c985696750	0101000020E6100000D8E816E3D71054C0EADDB67CC7C33940	0101000020BC080000246BCC28C96C2B41D1AF9BA39DCA1F41
930	2427	E 65 ST	E 7 AV	W	F	Y	0	0	0	10/7/2002	25.88192	-80.26977	896257.477504868	563441.226198681	d881127c-ebaa-4e79-94ad-2a0fc764c97b	0101000020E6100000A5B5CBCA431154C06C86D5AFC5E13940	0101000020BC080000E9245E28015A2B41AC7A4ADEE5312141
931	1687	ANASTASIA AV	PALERMO AV	W	N	N	0	0	0	10/12/2016 13:4	25.74385	-80.28156	892652.045081578	513237.062800318	930b6ad9-6449-4a4a-9d3a-ee2576d1e3a2	0101000020E61000003CCC621B051254C090DB97426DBE3940	0101000020BC080000F1D09C4AD63D2B41A3A45C085B531F41
932	10136	NW 10 AV	NW 69 ST	N	N	Y	0	0	0	9/23/2016 14:00	25.83749	-80.21272	915108.786271978	547400.31536869	35000017-08f6-4686-b325-de8e6b48181c	0101000020E6100000774E9F3F9D0D54C08A122FDB65D63940	0101000020BC080000CF84D9C847ED2B41FD52E90994B42041
933	3055	SW 97 AV	SW 110 ST	S	N	N	1	0	0	9/29/2016 13:02	25.66755	-80.35123	869853.060847867	485385.821910664	ddf55c04-c2e2-41d9-be77-3b664aec5e5e	0101000020E61000001E7098A97A1654C0BA8519BBE4AA3940	0101000020BC080000961BB24FB88B2A41CE0F3C0A2EA01D41
934	296	NE 36 ST	BISCAYNE BD	E	N	N	1	0	0	11/8/2016 8:47	25.81055	-80.1899	922674.743863743	537653.686568975	b5dbf924-ac02-4d02-b965-a7c5f861164b	0101000020E6100000C786C461270C54C03832184080CF3940	0101000020BC0800002B3538B463282C41A5A8BCC66E682041
935	7837	NW 20 ST	NW 4 CT	E	F	Y	1	1	1	11/8/2016 13:42	25.79524	-80.20208	918702.611421231	532067.427055985	9289c9b0-81f4-48c2-8a42-2dae9bee0205	0101000020E61000004DA4A0DFEE0C54C08EE5106B95CB3940	0101000020BC08000041CAD16F5B092C41A06F1E41CA3C2041
936	155	NW 25 AV	NW 165 ST	N	N	N	1	0	1	10/31/2016 16:0	25.92494	-80.24157	905438.081507105	579131.397215694	45743f9e-8b5a-427a-97c3-b41712b9c7da	0101000020E61000006E9BF9CF750F54C080EE333EC9EC3940	0101000020BC0800007BD8BB5EBAA12B413D2BFF377AAC2141
937	1945	E 8 AV	E 25 ST	N	N	N	1	0	0	2/14/2017 15:04	25.84468	-80.26606	897552.611055039	549913.596416607	4ba7a367-0b52-475a-ada1-76b070418508	0101000020E610000090451D06071154C0A9947B523DD83940	0101000020BC080000372FDA6C1F642B41C606189A36C82041
938	4740	NW 14 AV	NW 97 ST	N	F	N	0	0	0	8/18/2016	25.86343	-80.22183	912056.807800174	556812.315218061	d9f8d697-acd8-44df-a5e0-30f54df5f2ff	0101000020E6100000BB098D7D320E54C06B02641F0ADD3940	0101000020BC0800007DA48BD36FD52B410CB5170B1CFE2041
939	8251	SW 22 ST	SW 29 AV	W	F	Y	1	0	0	9/14/2016 12:39	25.75035	-80.24082	906049.411359251	515676.505099356	bec25b99-e54c-4855-8915-5bc70556275c	0101000020E61000002E5C329B690F54C0978D6B9217C03940	0101000020BC0800000BB0E30781A62B41E89700CE78791F41
940	4075	SW 24 ST	SW 99 AV	E	M	Y	1	1	1	42621.52014	25.74705	-80.35363	868921.802525032	514275.93508818	2378d330-2a44-436e-8852-e7d677a3ab0c	0101000020E610000090D08CF3A11654C0157D8FB63EBF3940	0101000020BC080000B62C4BCB71842A41026EAF8596631F41
941	3984	SW 137 AV	SW 82 ST	N	F	N	1	1	1	1/5/2017 11:09	25.69017	-80.41559	848623.995370854	493510.845043331	e1c54c20-302f-423b-9298-aeec24588be5	0101000020E61000001FCE63D3981A54C091FF3B9DAFB03940	0101000020BC080000AEE5862BDEE52941A965DD23221F1E41
942	3093	SW 104 AV	SW 183 ST	S	F	N	0	0	1	8/17/2016	25.59889	-80.36061	866890.181580935	460418.773422204	1d20ef44-8666-4381-8331-5c09a3090541	0101000020E610000038117B08141754C0A950977C51993940	0101000020BC08000023B02F8D92742A41839F0BD2111A1C41
943	4661	SW 72 ST	SW 84 PL	E	F	N	1	1	1	9/26/2016 13:56	25.70229	-80.33124	876378.801063698	498047.624359064	7b511b92-a042-462e-b1a1-a08536aa2cef	0101000020E61000002C0055E2321554C016642DE9C9B33940	0101000020BC08000074838CCBB3BE2A410D654B4305661E41
944	2145	W 8 AV	W 79 ST	N	F	N	0	0	0	10/3/2016	25.89445	-80.29995	886309.517082933	567942.84809652	921cbb43-9b3e-432c-b1dd-ad6aeb68019e	0101000020E61000009B5D514B321354C0184F841DFBE43940	0101000020BC080000C733503B490C2B41FC325E1D11552141
945	3741	SW 268 ST	SW 138 AV	E	F	N	1	1	1	8/17/2016	25.518	-80.41412	849379.689663745	430935.62177863	c5c59944-a55d-49f4-884f-b2e6b1c63b28	0101000020E6100000E43BA8FC801A54C0C6FAC8D19B843940	0101000020BC080000F3D0258FC5EB29414EE6FA2E654D1A41
946	10323	BUSWAY	PALM DR	W	N	Y	1	1	0	2/21/2017	25.44828	-80.47937	827961.688598741	405508.215247273	f44760b4-4c17-4d2c-8beb-ce7db67511b3	0101000020E6100000571718F6AD1E54C01D1C4BD8C2723940	0101000020BC0800002AB1EC8B714429411AD2E48717C01841
947	8026	W FLAGLER ST	NW 6 AV	W	N	Y	1	1	1	9/8/2012 10:49	25.77395	-80.20427	918031.739075188	524323.787375055	ed9ae621-184c-4098-8790-32e29e2669fb	0101000020E61000001778679B120D54C04413B9F521C63940	0101000020BC0800009B3C1BB11D042C419DD296F84A002041
948	10400	N KENDALL DR	SW 157 AV	E	N	\N	\N	\N	\N	 	25.68421	-80.4464	838480.2249626	491299.514470488	83f74aaf-0297-4a01-a023-0efac0670e2d	0101000020E61000009EDFD1F1911C54C083F3E1C128AF3940	0101000020BC08000091E3B79F9E962941D501E2D094FC1D41
949	91	NE 2 AV	APPROX # 3699(37 ST)	N	N	Y	1	0	1	11/4/2016 10:48	25.81119	-80.1912	922249.234251574	537884.424937718	af701190-0fd1-4e2b-ab6f-c17dfbd2369a	0101000020E6100000798239803C0C54C007AC1553AACF3940	0101000020BC080000207234AF10252C41BF75E4403C6A2041
950	5671	NE 167 ST	NE 2 AV	E	F	Y	2	0	0	10/17/2016 14:4	25.92814	-80.1959	920440.678452961	580382.182426549	087cf227-98cc-4fb9-9c7f-5eb735c5d057	0101000020E6100000B620A39A890C54C0180D6DA19AED3940	0101000020BC080000DA4D6092EF162C4131C720CA3FB62141
951	5615	NW 119 ST	NW 27 AV	E	F	Y	1	0	1	9/30/2016 11:57	25.88262	-80.24246	905230.476916991	563745.792811245	57dfe253-16ef-4799-9a2e-1853d2effbbb	0101000020E61000003CF43B97840F54C0577B576EF3E13940	0101000020BC080000109F41291BA02B4188B2840047342141
952	2504	NW 6 AV	NW 4 ST	S	N	Y	0	0	0	10/4/2016 15:40	25.47387	-80.48561	825864.748509776	414801.320395119	ebfd366b-8e7f-487f-982a-bad49bd2c457	0101000020E61000004C00BB4B141F54C0E464EB0A50793940	0101000020BC0800002A3E40AA0F342941415A2DF64B511941
953	2909	41 ST	SHERIDAN AV	W	N	Y	1	0	0	11/10/2016 14:3	25.81388	-80.12688	943400.122389734	538998.113951564	bce2933b-f939-42e1-9474-5d46b689e44b	0101000020E6100000DE9DA6DC1E0854C009A760BF5AD03940	0101000020BC080000F916AD784ECA2C415B36C9A1EF722041
954	5423	NE 6 AV	NE 159 ST	N	N	Y	1	0	0	11/1/2016 11:46	25.92103	-80.1878	923118.912287496	577816.11609187	01ab7656-4e87-46fe-a9e1-64627a33a9fd	0101000020E6100000EE2FC4E4040C54C01AAB4AFFC8EB3940	0101000020BC0800005EBF630ADC2B2C414FF1F0A733A22141
955	1324	NW 79 ST	NW 27 AV	W	N	Y	1	0	0	11/8/2016 14:35	25.84618	-80.24095	905803.499405716	550504.954135895	5d7532ad-483b-4af4-a57f-c2634be8522a	0101000020E6100000AA2BD4D96B0F54C04C4BC47E9FD83940	0101000020BC0800008CACCB3495A42B41D2095851D5CC2041
956	10507	W FLAGLER ST	SW 118 AV	E	N	N	0	0	0	9/27/2016 13:08	25.76808	-80.38592	858258.835293218	521871.187896691	9bc8ccad-d352-4066-90ab-ea86ad0b4463	0101000020E61000005A26E4ECB21854C0A415EE64A1C43940	0101000020BC08000073DCABDA23312A4199F7998A43DA1F41
957	8087	W FLAGLER ST	SW 48 AV	E	N	Y	0	0	1	9/8/2012 10:48	25.77125	-80.2742	895018.956983536	523210.624872327	bfa105db-973c-4864-a338-787d92ee0b19	0101000020E6100000862CE3918C1154C0512B873571C53940	0101000020BC080000F0F1C31D54502B41649A4B4A31EF1F41
958	4374	SW 42 AV	SW 16 TE	N	N	Y	1	0	0	2/13/2017 14:13	25.75624	-80.26283	898791.999030162	517775.826691814	cd6a417e-16d7-4185-98d0-873974adc96c	0101000020E6100000C8C43F40D21054C0F37E788399C13940	0101000020BC0800007C2CBF33CE6D2B41BD3ED717469A1F41
959	7429	NW 27 AV	NW 16 ST	N	M	Y	0	0	0	9/16/2016 10:11	25.7888	-80.23952	906396.349912964	529652.708448164	a69a3476-b710-48ee-b1dc-baae31483d82	0101000020E6100000BBD6CD52540F54C0A1156D2BEFC93940	0101000020BC08000004BC5BE836A92B41BC70CED0EC292041
960	6384	NW 159 ST	NW 39 PL	W	N	N	0	0	0	8/31/2016	25.91886	-80.2657	897520.178410783	576874.513932958	3b62f93b-a953-4fd0-945c-1bcfe4914004	0101000020E6100000244E2C20011154C09CB5CD743AEB3940	0101000020BC080000B3135C8FDE632B415E1A6D73D89A2141
961	2354	W 29 ST	W 5 AV	E	N	Y	1	0	0	10/3/2016	25.84794	-80.29257	888823.887700628	551049.208610944	f9b65499-054b-4432-a414-977bf2456b1b	0101000020E610000069331687B91254C05F3E19B512D93940	0101000020BC080000CF6A75F9ED1F2B417C84B3D315D12041
962	8015	NW 6 ST	NW 7 AV	W	N	Y	1	0	0	9/6/2012 13:46	25.77961	-80.20618	917385.827004384	526378.275067948	1eef9de3-60c2-438a-abd3-947929fb1833	0101000020E61000000C417125320D54C0AA281F1795C73940	0101000020BC0800009FD814DE11FF2B41B636A4F257102041
963	9181	SW 111 ST	SW 59 AV	E	F	N	1	0	0	11/30/2016 16:1	25.66824	-80.28787	890723.43046977	485746.522659704	758e270d-732c-487a-aac9-50dfee447367	0101000020E61000009A4740796C1254C053FAD76812AB3940	0101000020BC0800004980C10FC52E2B4172DC00D8D0A51D41
964	3041	SW 87 AV	SW 198 ST	N	N	N	1	1	1	10/4/2016 12:21	25.58302	-80.33183	876399.353805583	454696.824887067	87f6b627-7c61-4dc9-9fb3-fee3f703a259	0101000020E6100000C55C4ABF3C1554C01713934C41953940	0101000020BC0800000127A7E6DCBE2A4192477005AAC01B41
965	1611	PISANO AV	GRANADA BD	E	N	N	0	0	0	10/12/2016 15:1	25.7222	-80.27277	895588.213439543	505382.903655931	bb949ac9-8e0e-4c8c-9300-69eab0955aee	0101000020E6100000699CD41F751154C06E1B7035E2B83940	0101000020BC08000098932AA1C6542B41815B5263A2D81E41
966	8400	BISCAYNE BD	NE 93 ST	SW	F	N	0	0	0	10/8/2016	25.86062	-80.18202	925158.587656442	555871.262970753	33c807cb-1ffb-4696-8177-580fc3e69888	0101000020E61000007138ED0BA60B54C08821F61852DC3940	0101000020BC08000062947E64CB3B2C41C5A94DF0C1F62041
967	5252	NW 36 ST	MILLER DR	E	M	Y	1	1	1	11/11/2016 13:0	25.80808	-80.27166	895782.484654676	536600.512490526	53f57a8e-9395-4964-a712-f8122218daa5	0101000020E6100000493C63DF621154C07D8938B4DECE3940	0101000020BC080000CA5BF72B4B562B41AAF8726D34602041
968	5048	NW 107 AV	NW 12 ST	S	N	N	2	0	0	9/23/2002	25.78473	-80.36894	863821.998078369	527948.456639871	8a8d4546-945b-45b4-b896-1602c3222d79	0101000020E6100000342242879C1754C05ABD1970E4C83940	0101000020BC080000A718B22E9A5C2A412438A64F9C1C2041
969	9628	NW 11 AV	NW 54 ST	N	N	\N	0	0	0	9/30/2004	25.82455	-80.21417	914659.618823353	542696.358898424	314668ec-f4f4-4ee2-94ea-d3d00626294c	0101000020E610000014E98D05B50D54C0227B9E3616D33940	0101000020BC080000D98C2773C5E92B41C0B4A31FD48F2041
970	4282	SW 72 ST	SW 102 AV	E	N	Y	1	1	1	9/26/2016 12:49	25.70125	-80.35862	867362.452299472	497624.185250275	baffb8a6-f93a-4171-a323-677cea412496	0101000020E6100000011BC497F31654C0A03C4E9F85B33940	0101000020BC0800001B90D91743782A419E4D6D81675F1E41
971	5878	NE 185 ST	NE 14 AV	W	N	Y	1	0	1	10/27/2016 12:4	25.94487	-80.17298	927935.739907946	586510.388069086	1034120a-cfcd-40f8-ba61-d859402122a2	0101000020E6100000D67EF810120B54C034B8191DE3F13940	0101000020BC080000171FB8B27D512C410AD33F3420E62141
972	8529	79 STCY	HISPANOLA AV	E	F	N	1	1	1	10/20/2016 11:4	25.84866	-80.15028	935623.69339573	551589.65572498	6d75a6bc-a263-4031-b428-3a42c90d5f75	0101000020E6100000782442119E0954C0DF84DC2742D93940	0101000020BC080000BBA70D9C8D8D2C41DA7DCEB84ED52041
973	5741	NE 10 AV	NE 196 TE	S	F	N	0	0	1	11/1/2016 16:52	25.95639	-80.18198	924949.004781023	590678.310179748	bcde3e6e-fd3f-4c85-898b-ea12c33d7c88	0101000020E61000009B8478ABA50B54C007AB21F5D5F43940	0101000020BC080000CFD9ED39283A2C41F211EB0CB0062241
974	4154	SW 42 ST	SW 133 AV	W	F	Y	1	1	1	10/13/2016 11:2	25.72942	-80.41058	850206.598453358	507781.509765595	b578bd72-7554-4dce-ba4c-102dfcef45b7	0101000020E610000082CB0FEC461A54C0D0A07882BBBA3940	0101000020BC08000001D37C603BF229414A9D46D01CFE1E41
975	7698	NW 54 ST	NW 11 AV	E	F	Y	1	1	1	10/19/2016 14:1	25.82462	-80.21399	914719.334619299	542722.522852294	877139ab-656e-44cb-816f-88c2e8b3b0a4	0101000020E6100000F263300AB20D54C0C3B3CDDD1AD33940	0101000020BC08000088D6B1E13CEA2B41E4C2A17308902041
976	1407	S FEDERAL HY	HALLANDALE BEACH BD	S	F	Y	1	0	1	11/3/2016 13:02	25.98495	-80.14258	937829.167680439	601145.054960079	a82ab547-0a97-4a7b-8283-32c716ac72e4	0101000020E610000021BDDF0E200954C0FB32C43026FC3940	0101000020BC0800006BA1FA8EC89E2C41C0269B8B75582241
977	5296	NW 7 ST	OP # 8370	E	N	N	1	1	1	11/9/2016 13:18	25.77661	-80.33183	876042.78336953	525056.998511121	08e3e9af-0fbe-4754-a249-8e55ffc96e2b	0101000020E61000009ECFE4CB3C1554C0E3FB4C38D0C63940	0101000020BC080000C2C556C213BC2A417E1FAE6405062041
978	4161	SW 42 ST	SW 132 AV	E	N	N	0	0	1	10/13/2016 14:1	25.72928	-80.40785	851102.598962624	507736.453372627	20c3a64c-80ba-4ad3-84f5-eaa746834d7a	0101000020E6100000DAA85B571A1A54C080DB8EA9B2BA3940	0101000020BC080000C39DCF603BF92941A453BF9668FD1E41
979	6264	NW 27 AV	# 17210	S	M	N	1	1	1	11/10/2016 13:5	25.93116	-80.24499	904299.341635462	581384.962912276	842a3a0e-8960-41d8-adaa-8cd74d25c191	0101000020E61000004DB579EDAD0F54C02949F3BE60EE3940	0101000020BC0800007319B6E3D4982B41449CE65915BE2141
980	5589	NW 27 AV	NW 115 ST	S	F	Y	1	1	1	9/19/2016 11:18	25.87874	-80.24307	905039.343821324	562337.290095538	3f23a5d5-1a28-4b15-8542-f92db6d1726e	0101000020E6100000925AFC848E0F54C0EDA3F3ACF5E03940	0101000020BC080000BDD0FFE49C9E2B4198A7F0FE45292141
981	5575	NW 27 AV	NW 111 ST	N	N	Y	1	0	0	9/19/2016 11:25	25.87528	-80.24262	905193.577420384	561080.170836471	d1837c42-98a9-44a7-a439-883894e0355e	0101000020E6100000D2E92032870F54C0DA23FDDA12E03940	0101000020BC08000084AFAC5CD19F2B41B74BC6C1731F2141
982	2302	E 9 ST	E 10 AV	E	F	N	1	0	0	10/18/2016 15:1	25.83057	-80.26109	899214.088710465	544793.872047871	a963eae5-71ef-4628-a042-57d8b0d106dd	0101000020E6100000C66E95B1B51054C0D05A248BA0D43940	0101000020BC080000D253AA611A712B417100AB2637A02041
983	2635	COLLINS AV	# 4747	N	F	Y	1	1	0	10/11/2016 15:4	25.82163	-80.12244	944842.058812767	541822.93118497	49345fca-a4a9-4579-96d8-ed78708c8def	0101000020E6100000B654F01DD60754C0C201F45256D23940	0101000020BC080000677A3F5892D52C41551E9E4401892041
984	625	ALTON RD	6 ST	S	N	Y	1	0	1	11/10/2016 16:3	25.77583	-80.14092	938870.358818859	525138.362468846	a1e5d0bf-85dc-4c76-80ef-6d99069d74ae	0101000020E61000001EDB45F1040954C0886AB03B9DC63940	0101000020BC0800004D373DF1EAA62C412776321FA8062041
985	10328	NW 8 ST	NW 6 AV	E	F	N	1	0	0	10/21/2016 13:1	25.78146	-80.20443	917959.978063706	527051.268429726	0de824c3-1bd5-40a9-9a51-88aa9e9913db	0101000020E61000009C600B5C150D54C0F6BFC2CE0DC83940	0101000020BC0800007F42902B8E032C4137FE4BEF99152041
986	518	NW 7 AV	NW 62 ST	N	F	N	1	0	1	9/20/2016 13:13	25.83255	-80.2084	916541.504850443	545615.861890107	d527842d-1349-4ec5-af64-bd0ec9e672f5	0101000020E6100000E812A36B560D54C052B0259122D53940	0101000020BC080000BDC9003979F82B4152C07721A3A62041
987	4354	SW 88 ST	SW 92 CT	E	F	Y	2	0	0	9/29/2016 16:42	25.68754	-80.3446	872001.181842946	492662.405786358	64e987c9-5dd3-4f09-aed8-291af669b575	0101000020E610000089DB29050E1654C0E79D83DC02B03940	0101000020BC080000C08BE58D809C2A415F632B62E0111E41
988	1505	PONCE DE LEON BD	MERRICK ST	N	F	N	0	0	0	10/12/2016 10:4	25.71614	-80.2757	894636.297701649	503174.674466304	5217d804-0782-47cb-8cf2-04b3a10dfd3d	0101000020E610000063F8C018A51154C08DB1B4FE54B73940	0101000020BC080000DE0443CC564D2B41386FE17721B61E41
989	5631	NW 119 ST	NW 2 AV	W	F	N	1	0	1	9/30/2016 13:50	25.88418	-80.20267	918312.072840773	564391.40866451	c547e523-535a-4ada-a2fe-9b95ecb35a90	0101000020E610000001C5788EF80C54C00D1E25DD59E23940	0101000020BC08000095A7F05B4E062C41AB87DF3B52392141
990	9001	PERVIZ AV	ARABIA AV	N	N	N	1	1	1	8/31/2016	25.90982	-80.2563	900629.837212987	573607.259975255	816a5230-3032-4144-a1d8-bdd11877ceb3	0101000020E61000004437ED0C671054C0E73C0E35EAE83940	0101000020BC080000F3F00AE1297C2B41A0DFEEF051812141
991	4350	SW 88 ST	SW 99 CT	E	N	N	1	0	0	10/9/2002	25.68718	-80.355	868577.137845121	492515.806032293	b70530f9-5bfd-4f5a-9caf-c554b15daaee	0101000020E61000005429BD65B81654C05F5E0B77EBAF3940	0101000020BC08000068050F77C0812A419E7BE6FB950F1E41
992	4664	SW 72 ST	SW 79 CT	E	N	N	1	1	1	9/26/2016 14:08	25.70266	-80.32334	878976.539966911	498192.064348176	626609e2-b327-49e9-857d-5641821f0b03	0101000020E610000044641199B11454C01105C691E1B33940	0101000020BC0800006B593246FFD22A419C05040647681E41
993	1983	E 8 AV	E 19 ST	S	N	Y	1	0	0	2/15/2017 13:59	25.83986	-80.26604	897567.650086991	548162.808888964	ac90c949-b0da-4812-a7fd-94e0c1dc378f	0101000020E6100000518401C3061154C08E349EA201D73940	0101000020BC080000734FE7803D642B4199A6A80689BA2041
994	5013	NW 72 AV	NW 31 ST	S	F	N	1	0	0	10/10/2016 11:4	25.8013	-80.3132	882129.762311224	534063.126795098	5445f1ae-95e8-42d5-81af-5da85b03470d	0101000020E610000009063E6A0B1454C052286E6F22CD3940	0101000020BC0800008DEE58B8A1EB2A41204696A7614C2041
995	3133	SW 107 AV	SW 151 TE	N	F	N	0	1	1	8/16/2016	25.62889	-80.36621	864986.52623789	471310.485577457	7b036fcc-28b5-4156-96f4-7de42ef33acc	0101000020E610000012921614701754C0969CFB0AFFA03940	0101000020BC080000631C703DB3652A4133080DAE40C41C41
996	3618	QUAIL ROOST DR	SW 123 PL	NE	F	Y	1	1	0	11/17/2016 17:4	25.58198	-80.39177	856647.321152084	454223.820953056	519bce36-262e-4f71-85a4-132b0c20bad9	0101000020E6100000E75C00A4121954C0CC963A24FD943940	0101000020BC08000060895FD38C242A415F84090146B91B41
997	6216	NW 22 AV	NW 179 ST	N	N	N	0	0	0	8/18/2016	25.93725	-80.23695	906928.869543541	583613.817750171	f3d81cf0-c20a-4f38-8115-b2ccdbc55e6d	0101000020E61000007A9B42332A0F54C085DB39DCEFEF3940	0101000020BC08000049FC61F25FAD2B41D77FEC0F7FCF2141
998	4294	SW 88 ST	SW 87 AV	W	F	N	1	1	1	9/29/2016 12:07	25.68816	-80.33393	875519.24701244	492904.977130666	a1d43927-9c9d-41a9-afd9-c4ff9dec8ced	0101000020E61000006BA9D0F05E1554C040C99D6D2BB03940	0101000020BC080000DB6DD5AFFCB72A410E7D25ABAA151E41
999	7493	SW 37 AV	CHARLES TE	S	N	N	0	0	0	9/22/2016 12:42	25.7255	-80.25354	901912.304742582	506618.390039027	acbb040c-90ab-4c26-99b9-8f623190893a	0101000020E6100000AB248A133A1054C02504D39BBAB93940	0101000020BC0800002394ADD02E862B41D7268F55F0EB1E41
1000	317	W 3 CT	W 74 PL	N	N	Y	0	0	0	10/10/2002	25.8897	-80.29068	889367.757011097	566233.118245177	88a9156e-b7bf-4ad4-b68d-7b156c83fbb4	0101000020E61000002C6354599A1254C0D8147DE2C3E33940	0101000020BC080000BBFF8DB62D242B4177BA58A7B5472141
1001	2586	LUCY ST	KROME AV	W	N	N	0	0	0	10/21/2016 13:4	25.46257	-80.47706	828705.221554291	410702.553286098	5ca2f63b-58ee-47f3-a9fc-cca77822a522	0101000020E610000015F94708881E54C0818B1FF66A763940	0101000020BC08000067F4C19C404A2941291E95E340111941
1002	7502	INGRAHAM HY	PARK DR	SW	N	N	0	0	0	9/22/2016 13:40	25.71194	-80.25479	901528.597848259	501686.082616545	b5134bbf-63f8-4ad9-aa29-f0e9a69162d9	0101000020E610000092CF6A8E4E1054C04A9E9BAD41B63940	0101000020BC080000E419C1662F832B41C97F8619DF9E1E41
1003	3971	SW 137 AV	SW 47 ST	S	N	N	1	1	1	11/29/2016 14:1	25.72212	-80.41561	848559.78454132	505121.28537894	c70a6363-22e7-4482-bf17-eba780523b0f	0101000020E6100000D815F976991A54C073588929DDB83940	0101000020BC080000B94672BF5DE5294144AEF3E98BD41E41
1004	7884	VENETIAN WAY	#  1000	E	M	N	2	0	0	9/10/2002	25.79014	-80.17368	928058.92929206	530271.37812943	e0eff0b9-90d1-46ab-9b45-9bad941d90a4	0101000020E6100000059A5A911D0B54C0175B422F47CA3940	0101000020BC080000C8F5EB1374522C414E02DE27C22E2041
1005	7985	NW 7 ST	NW 45 AV	E	N	Y	1	0	1	11/8/2016 14:22	25.77861	-80.2697	896485.410141803	525893.894782513	2a5c7299-391b-472d-8e12-9badc4b4dfab	0101000020E6100000B08752D3421154C04371DF8D53C73940	0101000020BC0800006B6EE505C95B2B412D63C72F8F0C2041
1006	3915	SW 122 AV	SW 22 ST	NE	N	Y	2	0	1	10/13/2016 14:1	25.7476	-80.39095	856636.190631662	514418.096548557	436e9b06-2bf2-477c-9c1b-2d8fedc7fe20	0101000020E610000090E2356B051954C0424D92E362BF3940	0101000020BC0800003EF67E9076242A41F520E52ACF651F41
1007	1062	SW 88 ST	SW 127 AV	E	F	N	2	0	0	10/8/2002	25.68569	-80.4002	853693.669228308	491903.440456681	0271daf8-23f1-4b35-a7e0-842f7608cec5	0101000020E6100000ACBF88F89C1954C084BF69AF89AF3940	0101000020BC08000097181385790D2A4109E0378504061E41
1008	5219	NW 54 ST	NW 35 AV	E	N	Y	0	0	0	10/21/2016 9:07	25.82342	-80.25319	901827.459143624	542208.315869547	3293b69c-c00d-4d52-b0da-6c50d6f0c250	0101000020E610000012F29042341054C03648E9B2CBD23940	0101000020BC0800006670BE1F85852B4175338F09048C2041
1009	3587	SW 184 ST	SW 112 AV	W	F	Y	1	1	1	11/17/2016 11:3	25.59804	-80.37301	862801.682193477	460088.857406832	19f0a4a8-0cc1-4393-8fa0-33c595c58f68	0101000020E6100000B82ECE5BDF1754C04A35D78419993940	0101000020BC08000063C7158DA1542A41D7C90C28EA141C41
1010	3798	SW 296 ST	SW 148 CT	E	N	Y	0	0	1	8/16/2016	25.49212	-80.43159	843657.130577013	421504.003508709	3b1a86fc-952b-4127-8a95-e329134cb1b5	0101000020E61000009FDCF1479F1B54C0025BC69DFB7D3940	0101000020BC0800008301327010BF29412D747BB306BA1941
1011	7555	SW 42 AV	LOQUAT AV	N	F	N	0	0	0	10/14/2016 14:1	25.72387	-80.26149	899300.556366242	506013.41945982	58aef7bb-c921-43a0-a57c-b7aa6bf9e703	0101000020E61000007F44E636BC1054C08A8D9F2D50B93940	0101000020BC08000031E04E51C7712B41B292C9737CE21E41
1012	5078	NW 103 ST	NW 25 AV	W	N	Y	0	0	1	10/14/2016 15:5	25.86836	-80.24015	906020.65020217	558566.752342097	cae3d69f-b9ad-4acd-8f4a-96351f8232e6	0101000020E6100000507F00B65E0F54C0886868D24CDE3940	0101000020BC080000B1F1088247A62B41C20528EBD00B2141
1013	597	NW 41 ST	NW 97 AV	E	F	N	2	0	2	11/8/2016 13:51	25.81148	-80.35228	869251.349731009	537698.690373741	ff3fe553-25a1-4765-b5bd-dd704ad68041	0101000020E610000055E20CD18B1654C0163113B9BDCF3940	0101000020BC080000E5376DE304872A4174BC85C8C8682041
1014	3071	SW 97 AV	SW 104 ST	N	N	Y	2	0	0	9/29/2016 16:14	25.67264	-80.35124	869841.012927432	487237.603957169	efdf3fa8-82e7-42b7-8d27-d06303a2462c	0101000020E6100000FB5958CF7A1654C0783107A332AC3940	0101000020BC080000B5CD2D37A08B2A41AA44682B1DBD1D41
1015	9063	ALI BABA AV	PERVIZ AV	SW	N	Y	0	0	0	8/31/2016	25.90142	-80.25135	902271.791559547	570563.355931945	5a4d70e2-1c82-4281-8fcc-761459df9634	0101000020E6100000546BAB14161054C07BF26AB4C3E63940	0101000020BC0800002765DCC9FD882B412C2EC6218A692141
1016	3112	SW 107 AV	SW 104 ST	S	N	N	2	0	0	10/27/2016 8:54	25.67271	-80.36783	864378.652173206	487236.228989437	5aa95e2f-cf09-4f16-b5e6-31209a495784	0101000020E61000001835B4858A1754C0D410AA2837AC3940	0101000020BC080000A301BA7DF3602A41F0DAB1AB17BD1D41
1017	19	NW 2 AV	NW 79 ST	S	F	N	1	0	1	11/4/2016 14:27	25.84687	-80.20105	918925.582084078	550832.086687684	9218cb8c-5e57-4617-afb8-af6fa1bb7e28	0101000020E61000002D94A918DE0C54C025DAF373CCD83940	0101000020BC080000FD92CF60190B2C41EC0E429563CF2041
1018	5210	NW 62 ST	NW 32 CT	W	F	Y	0	0	0	9/20/2002	25.83106	-80.25093	902555.409760587	544990.154824816	4ec4e6af-9ff1-4237-87aa-0285a668b1ac	0101000020E610000012583F370F1054C08B426B86C0D43940	0101000020BC080000DAFE7D06358B2B414C986AB7BFA12041
1019	5870	NE 186 ST	NE 24 AV	E	N	Y	2	0	1	10/27/2016 17:4	25.94721	-80.15292	934519.834350664	587402.319974735	51697f8a-dc23-47e8-a01a-49b85b6d280e	0101000020E6100000CDEFC388C90954C0C90D3F567CF23940	0101000020BC0800007B6EE5E3ED842C416E4B7F1118ED2141
1020	1881	NW 6 AV	NW 2 ST	S	N	N	1	0	0	8/17/2016	25.44994	-80.48536	825979.827672701	406102.746249668	061f5826-e9ea-4c9d-bb43-8f29b50ca508	0101000020E610000090FABA3F101F54C0B61329702F733940	0101000020BC080000A293D9D2F53429413463FAA761C91841
1021	5314	FOUNTAINEBLEAU BD	NW 99ct	E	F	N	1	0	\N	9/6/2012 13:00	25.77584	-80.35839	867305.370380089	524732.243562751	c87b3477-5172-4e86-a53e-876badf2c57c	0101000020E610000024D7ABDFEF1654C0C939B87E9DC63940	0101000020BC080000E02FC1EDD0772A4128281CE27B032041
1022	6705	BISCAYNE BD	NE 30 ST	S	F	Y	1	1	1	11/8/2016	25.80502	-80.1895	922822.000467148	535646.352947205	e95214fd-0775-4b59-b1c8-ba07db1696a3	0101000020E6100000575419AA200C54C05BC6F32916CE3940	0101000020BC080000D2C1AC378A292C418D599A1BC0582041
1023	7808	NW 20 ST	NW 12 AV	W	N	Y	1	1	1	11/8/2016 13:45	25.7951	-80.21443	914637.349227488	531989.185051255	f2c25927-4ab9-465d-b8cf-2f3cffa1b802	0101000020E61000007A347650B90D54C065D707B88BCB3940	0101000020BC080000402A17E998E92B411A0A33C52D3C2041
1024	8108	SW 1 ST	SW 18 CT	E	F	N	1	0	0	9/6/2016 15:11	25.77157	-80.22583	910939.223044422	523415.366613299	193e46ba-7a92-4d91-a04e-53f79aa26b1e	0101000020E61000008B94FBF5730E54C0546C9CC985C53940	0101000020BC080000D35019A8B4CC2B411A92394264F21F41
1025	6555	NW 199 ST	NW 42 AV	E	N	N	1	1	1	10/28/2016 12:3	25.95431	-80.27072	895796.755999461	589751.782153532	1ebf61b6-ef8f-4d6d-9997-1dbf5dab4090	0101000020E61000009A808E74531154C072305DF84DF43940	0101000020BC0800007B71DCB667562B41D5CA56FE72FF2141
1026	3665	SW 200 ST	SW 117 AV	E	F	Y	1	1	1	11/17/2016 13:1	25.58084	-80.38011	860489.94928525	453825.447736256	1390ce2a-0cc0-45eb-8a23-b64b1b07149a	0101000020E610000017D6F4BB531854C0886A541AB2943940	0101000020BC080000D85B7D1592422A41D4FFF6820CB31B41
1027	1192	BLUE LAGOON DR	# 5201	W	N	N	0	0	0	11/8/2016 13:40	25.78218	-80.28071	892855.169357769	527168.977883659	7f77ce38-ae19-4b93-9252-43d012e9bd3e	0101000020E610000092EE9F36F71154C012DF190F3DC83940	0101000020BC08000008AB228A6C3F2B41B61F735A85162041
1028	6974	NW 2 AV	NW 64 ST	N	F	N	0	0	0	11/3/2016 16:31	25.83462	-80.20038	919178.9287268	546384.230758592	dd530123-d52c-4a43-83ab-991572955259	0101000020E61000002555FAD2D20C54C04476033AAAD53940	0101000020BC08000011DD6B12140D2C415A6990DEA3AC2041
1029	1527	SW 42 AV	NAVARRE AV	S	N	Y	0	0	0	2/16/2017 10:47	25.75423	-80.26299	898744.417711314	517043.161504373	58db2606-01b5-4d6b-896c-137be118a321	0101000020E6100000E3A7C0D2D41054C0B4395C7515C13940	0101000020BC080000BD951A0A6F6D2B41F196506ED38E1F41
1030	2599	CRANDON BD	E WOOD DR	N	N	N	1	1	1	11/14/2016 11:2	25.68796	-80.16358	931615.868720807	493151.495043769	22a3ffb5-5420-4f7c-a6d3-c1f40a8f9309	0101000020E6100000B03A0730780A54C07B6604631EB03940	0101000020BC08000085BB57F53D6E2C41F5D2DCBD84191E41
1031	6948	SW 2 AV	SW 3 ST	N	N	Y	1	0	1	10/3/2016 10:37	25.7713	-80.19749	920263.935088448	523375.194129869	db4f78ea-1afd-4829-96f0-77b50d4a9c8e	0101000020E610000026ABEDC4A30C54C03073697C74C53940	0101000020BC080000FFB4CC158E152C416FB66591C3F11F41
1032	2549	NE 8 ST	US 1	W	N	Y	0	1	1	8/17/2016	25.47737	-80.46421	832921.317418881	416101.194432445	2448b2f9-6ac6-4986-a6e9-9d62de584930	0101000020E6100000BD82A098B51D54C01C44336B357A3940	0101000020BC0800006C0E63CE306B29416CCA6A759B651941
1033	5316	FOUNTAINEBLEAU BD	NW 97 AV	E	F	N	1	1	2	9/6/2012 13:05	25.77565	-80.35288	869117.646605622	524672.048119582	c6d76fb2-9c50-4373-bb6a-5f66e18d1215	0101000020E6100000009FD2A9951654C032640E0B91C63940	0101000020BC0800000ED48D7BF9852A4153A9097E03032041
1034	10487	THREE IS BLVD	HALLANDALE BEACH BD	S	F	Y	1	0	2	11/3/2016 12:19	25.98685	-80.12617	943216.819589991	601868.820600003	43b8769c-57a0-4e2f-9efd-406fa0080cf0	0101000020E6100000F2D38C21130854C0789F0B40A2FC3940	0101000020BC080000F2C568DDDFC82C41CDA2B6131D5E2241
1035	8109	SW 1 ST	SW 18 AV	E	F	N	1	0	1	9/6/2016 15:14	25.77177	-80.22451	911373.20086759	523492.067582279	ab85c5b8-0efc-49df-81f7-34d1216146ce	0101000020E610000024A480555E0E54C0922D242893C53940	0101000020BC08000086AAB59C18D02B41E0C1D40F97F31F41
1036	5087	NW 95 ST	NW 17 AV	E	F	N	1	0	1	8/18/2016	25.86113	-80.22532	910913.406197876	555968.819881566	76f18ba6-924c-4521-8e07-e41f4117dc4b	0101000020E6100000FBDA0FB46B0E54C08D63374273DC3940	0101000020BC0800006D2ACF0581CC2B4175E84E0D85F72041
1037	8211	SW 13 ST	SW 3 AV	E	F	Y	1	1	0	9/14/2016 14:23	25.76135	-80.19829	920023.965413567	519757.474937558	61f74d76-0466-4b8b-aa50-91fbba19ce52	0101000020E6100000EB0D97CFB00C54C0BE11DA77E8C23940	0101000020BC0800007B7D6525AE132C41723E08B03CB91F41
1038	2800	ALTON RD	DELAWARE AV	NE	N	N	1	0	1	8/30/2002	25.82687	-80.13137	941891.132983625	543708.024526536	4e4d3447-1000-495a-b53c-493184ecc8b0	0101000020E6100000B84F7875680854C086CF94BBADD33940	0101000020BC0800006113F87D84BE2C4122889374BB972041
1039	5692	W DIXIE HY	OP.# 19800	N	N	N	1	0	0	11/1/2016 13:41	25.95814	-80.14744	936294.455470093	591388.639469929	9f65832c-30c3-4868-b3e7-908538d254e5	0101000020E6100000316C2BC46F0954C0D24D29F948F53940	0101000020BC08000009F71A22CB922C4147FAB4B53C0C2241
1040	6389	NW 160 ST	NW 26 AV	W	N	Y	1	0	1	10/31/2016 12:4	25.9203	-80.24318	904921.274490442	577442.936022967	39cb6690-e163-4f24-aa82-55e25fe4b6b7	0101000020E610000068BD400F900F54C055063A5A99EB3940	0101000020BC080000DEF78DC1B09D2B4131B5A74B499F2141
1041	9860	SW 37 AV	N PROSPECT RD	N	N	N	0	0	0	12/1/2003	25.70918	-80.25276	902207.613880713	500687.827106975	c25b613a-83cb-4377-9578-5746727b94b3	0101000020E6100000D161100D2D1054C0BF90D0FE8CB53940	0101000020BC08000025D2116F7D882B4153379913468F1E41
1042	9845	STATE HWY 5	OVERSEAS HWY	\N	\N	\N	\N	\N	\N	 	24.85859	-80.72464	747465.640220191	190963.355984837	624f40fd-5d0c-404a-b26e-55a44ea0f47e	0101000020E61000003797DB83602E54C0E5656BD8CCDB3840	0101000020BC0800005638DE6891CF264145927BBFA74F0741
1043	8689	NE 167 ST	NE 1 AV	W	F	N	1	0	0	10/17/2016 10:5	25.92828	-80.19845	919599.618466262	580429.734872207	b96169c6-99c9-4f31-906f-807a6448205d	0101000020E6100000AB16AC83B30C54C0C3B61E22A4ED3940	0101000020BC0800002E1480735D102C410FF0FEE49EB62141
1044	2838	ALTON RD	10 ST	S	N	N	1	1	1	10/11/2016 13:4	25.78072	-80.14103	938823.244063087	526912.955092512	17aed8fb-7bb5-4165-9608-69b269b788c8	0101000020E6100000A3E342B6060954C08370DE3EDDC73940	0101000020BC080000B27F78B68CA62C411822E04E85142041
1045	1812	NW 36 ST	NW 87 AV	E	N	N	1	0	0	11/8/2016 11:57	25.81002	-80.33891	873653.215637743	537190.278661706	961ffc37-e9d8-46dc-bba5-8a13085c46c9	0101000020E610000052B0CCBAB01554C035241C1B5ECF3940	0101000020BC0800008C7F749F68A92A4127F0C1F5CF642041
1046	2692	INDIAN CREEK DR	27 ST	S	N	N	1	0	1	10/11/2016 12:5	25.80426	-80.12685	943434.184953876	535500.854903497	a0e4d026-332a-4f12-addd-eca2129d8949	0101000020E6100000998D3D521E0854C06836F928E4CD3940	0101000020BC080000381EA99892CA2C41C44DBC1C9D572041
1047	4334	SW 88 ST	SW 133 AV	E	N	Y	2	1	0	10/8/2002	25.68543	-80.4091	850767.338136047	491794.307157964	364c6de9-8463-4f05-91b7-989576b2106b	0101000020E6100000371753932E1A54C00A16386278AF3940	0101000020BC080000C8A32ADB9CF62941D56BA6FC4F041E41
1048	3083	SW 102 AV	SW 169 ST	N	F	N	1	1	1	11/17/2016 14:1	25.61293	-80.35719	867988.949697573	465525.957139142	3b6d105e-f4a0-4d41-bb3d-2260975d82d0	0101000020E610000075A6182EDC1654C0F4386E6AE99C3940	0101000020BC080000083D9816287D2A41AD00678FDE691C41
1049	517	NW 7 AV	NW 36 ST	N	N	Y	0	0	1	9/20/2016 13:13	25.80974	-80.20745	916906.267220698	537324.138293624	cdd754fd-89a2-44fd-808f-f7270f431a84	0101000020E61000002FB1AFBD460D54C0B8398E2A4BCF3940	0101000020BC080000F6C076BF52FB2B41B40103AEDB652041
1050	10530	BISCAYNE BLVD	NE 11 ST	N	N	Y	1	0	1	9/8/2016	25.78452	-80.18915	922979.426031973	528195.581456102	4cfca7c8-9aee-4545-961f-f4c002c7182d	0101000020E61000001CEC3A1C1B0C54C0DB042A9CD6C83940	0101000020BC080000756E7811C52A2C4183D1B98F8A1E2041
1051	7645	NW 62 ST	NW 3 AV	W	N	Y	1	0	0	10/18/2016 14:0	25.83258	-80.20196	918659.774867054	545639.571811534	5c4148f2-1cd9-4e2c-a5c5-db0f0b6f8dd2	0101000020E610000077FF4FE8EC0C54C079B37B8824D53940	0101000020BC0800003B1090C305092C41C193088DD2A62041
1052	5918	NE 191 ST	# 1530	E	M	N	0	1	0	11/13/2002	25.95124	-80.17007	928877.03100384	588832.145887308	72b7cdd2-66a2-4103-ba80-afaf54376d34	0101000020E61000006484BD67E20A54C0BC24C5A484F33940	0101000020BC0800007899D747D8582C41BE1187B843F82141
1053	5070	NW 103 ST	NW 12 AV	E	N	Y	1	0	0	8/18/2016	25.86878	-80.21826	913218.89960343	558762.395316824	d67056f0-86b4-477a-a26b-7c67c31d5189	0101000020E6100000AC241304F80D54C00AE8667A68DE3940	0101000020BC0800006A49BB0284DE2B4182CC5534580D2141
1054	2497	WASHINGTON AV	NE 4 ST	N	N	N	0	0	0	8/16/2016	25.4734	-80.47621	828968.215113539	414640.050670125	7143396b-3aa0-4042-a316-fab504dba4a3	0101000020E6100000A75B4A347A1E54C079C82DC830793940	0101000020BC080000888C80994E4C2941382ADAE1C64E1941
1055	8884	NW 125 ST	NW 1 AV	E	F	Y	1	0	0	10/31/2016 16:4	25.88959	-80.20043	919034.278384857	566362.985765412	c1ec8e3b-528c-4aae-81d1-94e49c1f18f3	0101000020E6100000858896F8D30C54C028B67A8BBCE33940	0101000020BC0800005E2F57C5F20B2C41EA46B963B9482141
1056	8092	W FLAGLER ST	SW 40 AV	E	F	Y	1	0	1	9/8/2012 11:33	25.77164	-80.26133	899253.35933131	523375.545829229	f488264d-b619-47e1-84e5-41b46db43de5	0101000020E610000025145FB9B91054C08652DFB38AC53940	0101000020BC080000D7944EEC68712B41641D6EF9C4F11F41
1057	399	HIALEAH DR	E 4 AV	W	F	N	0	0	0	9/23/2016 13:11	25.823	-80.27362	895109.672709625	542021.304783463	e6d73311-dec2-465c-802f-962ae7eb7f95	0101000020E610000079E70EE3821154C02C6378C3B0D23940	0101000020BC080000F457218C09512B41E2C6D9038E8A2041
1058	8080	W FLAGLER ST	SW 58 AV	E	N	Y	0	0	1	9/8/2012 14:26	25.77066	-80.29019	889760.780824658	522964.989195585	dd16f1b1-831c-4496-b796-77cd01d6907c	0101000020E610000092411467921254C0D2A184154AC53940	0101000020BC08000099BCD4C23F272B4127C95CBF5AEB1F41
1059	1703	GRAND AV	BROOKER ST	W	F	Y	0	0	1	10/14/2016 15:5	25.72759	-80.25587	901143.231154382	507372.978406958	b62b0b65-5722-47a9-8c0d-f0e4ccb564de	0101000020E6100000039FE822601054C07481AA7243BA3940	0101000020BC08000098B6FBAA2C802B41C2BE5FB0BAF71E41
1060	3107	SW 107 AV	SW 88 ST	S	F	Y	1	1	1	10/27/2016 8:54	25.68627	-80.36597	864966.981352761	492167.951714091	654e499e-e774-4cbc-8f1b-2952fdb1c705	0101000020E61000005E11AF146C1754C07C398AE4AFAF3940	0101000020BC080000C5146F268C652A41AB6BE290260A1E41
1061	8316	NW 67 AV	MIAMI LAKEWAY S	N	F	Y	0	0	0	10/10/2016 14:3	25.9042	-80.30835	883527.628621779	571469.813820012	449415d2-a945-46ff-b05f-a071b0ac10b5	0101000020E6100000820F7500BC1354C02FFABAB279E73940	0101000020BC080000472DFC738DF62A4120B52F0C9F702141
1062	1003	SW 8 ST	SW 32 AV	E	N	Y	1	0	0	9/6/2016 13:27	25.76484	-80.24713	903941.699305817	520928.266251862	389e8b36-3c69-48b0-b1d1-5e875165e835	0101000020E6100000995CA805D10F54C01F991CAACCC33940	0101000020BC080000EF41FD9A09962B41D04899DA87CB1F41
1063	6815	NE 2 AV	NE 82 TE	N	F	Y	1	1	1	11/4/2016 12:58	25.85091	-80.19286	921614.79716653	552320.267456181	165277da-159a-4040-8377-936588ffcab1	0101000020E6100000ECC894AE570C54C08081EDCED5D93940	0101000020BC080000B60655CF1B202C411CC30BF203DB2041
1064	3842	SW 107 AV	SW 88 ST	S	N	Y	1	1	1	10/27/2016 8:54	25.68764	-80.36597	864964.27205364	492664.064893954	9492aef2-af19-4d65-80fa-276390715e3b	0101000020E61000001496E1186C1754C04135745909B03940	0101000020BC080000CC4D45BB86652A410CE2E004E7111E41
1065	8056	W FLAGLER ST	NW 53 AV	W	N	Y	1	0	1	9/8/2012 12:21	25.77114	-80.28155	892599.649174009	523154.113811761	c6124438-6b12-4857-89d1-65f50ec663eb	0101000020E610000056076B06051254C089F90A6969C53940	0101000020BC0800009667DD7F6D3D2B411D32173F4FEE1F41
1066	272	E PALM DR	SW 167 AV	W	F	N	0	0	0	8/17/2016	25.4481	-80.46104	834010.130197968	405465.010953076	d72067b0-a804-4c15-8c54-077875a97598	0101000020E6100000D9DCACA8811D54C0EF9F84B8B6723940	0101000020BC0800002748CC6EB2732941F2E0D8B66ABF1841
1067	8460	NE 95 ST	N MIAMI AV	W	N	N	0	0	0	10/14/2016 15:4	25.86243	-80.19729	920130.290967528	556497.057662092	3f565866-7c88-4f94-85a8-def2407f9c05	0101000020E6100000E8D1855CA00C54C0F7E66585C8DC3940	0101000020BC0800004A81FFCB82142C41C5A23587A5FB2041
1068	4110	SW 40 ST	SW 92 AV	W	N	N	2	0	1	10/13/2016 12:3	25.73305	-80.34339	872319.404342145	509205.641432166	ced00c4a-92e7-4a57-99d9-dfe80e4ee5bd	0101000020E6100000ADCEE318FA1554C035579578A9BB3940	0101000020BC08000046DFD6FFFC9E2A41C5C4AD575D141F41
1069	8845	NW 17 AV	NW 123 ST	N	F	N	0	0	0	8/18/2016	25.88692	-80.22684	910361.307210475	565339.053120315	4abc3c48-9290-48a9-a4f1-c51c8a1cc935	0101000020E61000005131A975840E54C01A042F4D0DE33940	0101000020BC080000DD2DF5D230C82B4103410F86B9402141
1070	4205	SW 56 ST	SW 132 AV	E	N	N	1	0	0	10/1/2002	25.71457	-80.40718	851349.822224483	502388.868644282	76a47ec3-0f90-4fdd-95eb-8e8fe6cee7ba	0101000020E610000062D89E3B0F1A54C0A9AFFC3BEEB63940	0101000020BC0800009A3F20D329FB2941369A943EDAA91E41
1071	8926	NW 135 ST	NW 4 AV	E	F	N	0	0	0	11/12/2002	25.89844	-80.20499	917519.191891991	569568.808079667	a34b6d4b-0118-440e-a433-ca625b216e05	0101000020E6100000F8677B801E0D54C0E9C9FC3500E63940	0101000020BC080000EA2DEA981C002C41EB432009C5612141
1072	3237	SW 117 AV	SW 112 ST	N	F	Y	1	1	1	8/17/2016	25.66466	-80.38364	859184.666777313	484284.402555801	559dd24a-fd4a-45d4-ab4b-61dcfc7f7500	0101000020E6100000234FDD918D1854C080B3EC5427AA3940	0101000020BC080000DA0898845F382A41EE9D865CF88E1D41
1073	6870	S MIAMI AV	# 3251	SW	N	N	1	0	0	10/14/2016 13:2	25.74704	-80.21106	915851.102024414	514530.201647095	72c55aa1-311f-44e5-802d-97c22c9685c4	0101000020E6100000E8A77315820D54C0156147843EBF3940	0101000020BC080000BE74BC6A14F32B41B55B01978F671F41
1074	4753	NW 17 AV	NW 81 ST	N	F	Y	0	0	0	8/18/2016	25.84873	-80.22536	910928.809069768	551460.284270056	242f6ab0-efd5-4260-8534-f8d3b63d162f	0101000020E61000000379AA426C0E54C0FB4A935946D93940	0101000020BC0800008DF30BD49FCC2B41B4C180FA4BD42041
1075	2526	SW 14 AV	SW 4 ST	N	N	Y	0	0	0	42647.36389	25.46591	-80.49347	823284.660498485	411896.243493423	f0d54442-5b07-4628-977e-b4b5abf8b873	0101000020E6100000FA66CDF9941F54C0EEEB94FB45773940	0101000020BC080000E1FDC87CE71F2941E6E185A6E7231941
1076	9802	SW 103 AV	SW 146 TE	S	N	N	0	0	1	11/17/2016 15:5	25.6336	-80.36031	866924.541117474	473032.424384885	3993b8f8-e0e4-491b-8519-31a947a65123	0101000020E610000034FF534C0F1754C08C273DD933A23940	0101000020BC0800000E115845D7742A41AE36DC6F28DF1C41
1077	5875	NE 186 ST	NE 22 AV	W	N	N	1	1	1	10/27/2016 12:2	25.9473	-80.15646	933360.907904539	587428.279551715	0087f522-c7d0-4a6b-b26a-e4eec11ea97f	0101000020E61000000656E24D030A54C0EA90C05D82F23940	0101000020BC0800001D837909E07B2C41502DD2FC4BED2141
1078	4172	SW 47 ST	SW 140 AV	E	F	N	1	1	1	10/13/2016 14:1	25.72385	-80.42074	846870.049028143	505743.351717383	cf9d9860-4d77-478e-b73c-d82e61da2c76	0101000020E6100000FE6F976AED1A54C00C71B1AB4EB93940	0101000020BC080000DAADB5462AD829419AE30A2E44DE1E41
1079	7886	S VENETIAN WY	NE 12 PL	E	F	N	1	0	0	11/14/2016 9:03	25.78997	-80.16926	929516.368668132	530218.392680384	1fcd88f7-4081-4806-8331-f17b86e46f87	0101000020E610000011E4F804D50A54C0746B5CFA3BCA3940	0101000020BC080000C5C3F3F4D65D2C413F9C542F582E2041
1080	9997	NW 6 ST	NW 2 AV	W	F	N	1	1	1	11/8/2016 13:42	25.77985	-80.1982	920012.03531336	526478.507435232	c925d728-2e55-4387-bb3e-97d225e554c1	0101000020E610000092E27E5EAF0C54C011936E4BA4C73940	0101000020BC08000009041E4996132C41D745906920112041
1081	3414	SW 167 AV	SW 296 ST	S	N	N	0	0	1	10/4/2016 14:05	25.49217	-80.46114	833911.030993313	421481.643330283	0fd2b912-4664-49bd-b77c-f3e4a9532079	0101000020E61000003FAEE35C831D54C055469FE4FE7D3940	0101000020BC0800008B1DDF3BEC72294154D89842ADB91941
1082	10017	SW 168 ST	SW 88 CT	W	F	N	0	0	0	11/11/2016 16:2	25.61437	-80.33605	874952.317332964	466083.66922567	190d6b06-6f0a-416c-b906-da3bdecc182c	0101000020E610000048A2ADD6811554C0B5AEA3C9479D3940	0101000020BC080000AD02B9D38EB32A411269D16895721C41
1083	5156	NW 79 ST	NW 31 AV	W	N	Y	1	0	0	10/20/2016 13:0	25.84597	-80.24748	903656.899694357	550418.459242448	e8efbe6c-585b-452a-83d5-04af754f490c	0101000020E6100000565841CED60F54C05811372092D83940	0101000020BC080000F5596C01D0932B41D2E6005428CC2041
1084	1255	NW 2 ST	OP # 11591	E	M	N	0	0	0	11/15/2016 11:3	25.76998	-80.38344	859071.452482782	522565.929312684	520fef51-6bdc-48e0-9b3d-f660ab065624	0101000020E6100000C25F354F8A1854C046716EFA1DC53940	0101000020BC080000B13AC1167D372A41F022E3811EE51F41
1085	3260	SW 122 AV	QUAIL ROOST DR	N	N	N	0	0	0	11/29/2016 12:3	25.58409	-80.38888	857592.434768982	454992.510634765	03af93fc-3edf-476d-ab11-7411cac2d56a	0101000020E61000003A60CA7CE31854C04ED0BAF686953940	0101000020BC080000CF5F9D0DEF2B2A414CD382C348C51B41
1086	10500	NE 1ST AVE	NE 8TH ST	\N	\N	\N	\N	\N	\N	 	25.78202	-80.19234	921935.274227832	527280.100035638	392a45b5-0085-4e7d-90c3-383f42902271	0101000020E61000005C8A10604F0C54C0E60257B432C83940	0101000020BC080000693C99C39C222C41730A229963172041
1087	8094	W FLAGLER ST	SW 38 AV	E	N	Y	1	0	1	9/8/2012 11:52	25.77171	-80.25719	900621.285716359	523408.315075748	d66f720c-f694-40bd-bbee-4999b6c6c90f	0101000020E61000006993A59D751054C07FD37E398FC53940	0101000020BC0800009061DEC6187C2B418FEB350D48F21F41
1088	3216	SW 117 AV	SW 196 ST	S	N	N	1	1	1	11/17/2016 13:1	25.58515	-80.38062	860315.188483551	455391.49050308	3a6a4cb0-af47-4fa4-830c-d8a5da465fb4	0101000020E61000008EABA90E5C1854C0BAB7EAA0CC953940	0101000020BC08000036C6EC8F34412A41B22126AF84CB1B41
1089	5302	NW 6 ST	NW 124 AV	W	N	N	0	0	0	11/29/2016 12:0	25.77323	-80.39697	854617.293077089	523725.487383425	9131962f-1777-41cf-b6c1-d3240fba552e	0101000020E6100000756FD3C9671954C0EDB710C6F2C53940	0101000020BC080000BE59A5C4B0142A4183D7B6BD3CF71F41
1090	8067	W FLAGLER ST	NW 67 CT	W	F	Y	1	1	1	9/6/2012 12:45	25.77054	-80.30541	884748.460508455	522897.571366102	93560be5-80d4-4f79-b84f-c0b1e62c8848	0101000020E610000017258BF28B1354C0D4BF76BE42C53940	0101000020BC080000913C3A1E17002B416D2E6D134DEA1F41
1091	7984	NW 7 ST	NW 47 AV	E	F	N	1	0	1	9/7/2016 12:22	25.7786	-80.27165	895846.685671102	525886.724166639	bd12aa65-caae-4ab5-a14b-85854af20284	0101000020E6100000E71178A0621154C0738B1AE652C73940	0101000020BC080000AB13EF92CB562B419FA45BD8800C2041
1092	2702	WASHINGTON AV	4 ST	N	N	Y	0	0	1	11/10/2016 16:5	25.77348	-80.13422	941081.898360625	524297.557119779	93327e31-0124-4346-9dac-391f227406d3	0101000020E61000007AE5D91E970854C067FDE60603C63940	0101000020BC0800002B40A50532B82C417F2BB98216002041
1093	8227	SW 22 ST	SW 29 AV	E	F	Y	1	1	1	9/14/2016 11:10	25.75018	-80.24019	906257.470938001	515615.185677625	914ce1f3-6d7f-4427-96b4-d0050f0ada8f	0101000020E6100000993898445F0F54C0F260BB4C0CC03940	0101000020BC080000E0EC5A2621A82B419F83BA8683781F41
1094	3284	SW 132 AV	OP # 27825	S	N	N	0	0	0	10/4/2016 12:11	25.50866	-80.40432	852628.14314881	427557.600953862	3070cf24-81cc-49a2-ae8b-77691f8c1261	0101000020E61000002A61B05BE01954C0EDF7381B38823940	0101000020BC0800002799B77726052A41A71FC9189D181A41
1095	1005	NW 37 AV	NW 7 ST	N	F	Y	1	1	0	42619.55208	25.77948	-80.25558	901133.877876312	526232.865216427	7a04b8c4-8b89-405e-af96-c5f920e16211	0101000020E61000005C43974D5B1054C0DCA510FB8BC73940	0101000020BC080000BFED12F619802B414B21AE20350F2041
1096	1672	ANASTASIA AV	PALERMO AV	E	N	N	2	0	0	10/12/2016 12:1	25.74435	-80.28206	892485.147474885	513418.616601855	57b6b101-4409-4249-b981-7467fa752f9a	0101000020E6100000946A515D0D1254C0AC8EC0288EBE3940	0101000020BC0800001762F87E883C2B41C668833F31561F41
1097	1674	ANASTASIA AV	COLUMBUS BD	E	N	N	1	0	0	10/12/2016 12:1	25.74144	-80.27938	893375.099082284	512363.586524554	04d9b616-c093-4692-8ffa-3ae09cf54a6f	0101000020E6100000AC6A6A5BE11154C0C9315D0ECFBD3940	0101000020BC0800001DFC44667C432B417B123320B5451F41
1098	3647	CARIBBEAN BD	GULFSTREAM RD	NE	N	N	1	1	1	10/4/2016 15:49	25.57847	-80.35088	870126.961490564	453012.316113248	ee411d6d-ef21-4327-96b7-9c6e95fc0b5d	0101000020E6100000B11D94ED741654C05E7EFB2C17943940	0101000020BC0800000709061DDC8D2A41A8CE04FC57A61B41
1099	1689	SW 4O ST	PINTA CT	E	N	N	0	0	0	10/13/2016 13:1	25.73399	-80.2805	893019.527947966	509655.239273749	efbe1ee1-5160-462c-961f-bfdc63d70ab7	0101000020E6100000F6B401CAF31154C0758D3513E7BB3940	0101000020BC0800002989DF41B5402B41CDB033BC631B1F41
1100	1429	HALLANDALE BEACH BD	SE 10 AV	E	F	N	1	0	1	11/3/2016 15:52	25.98555	-80.13794	939352.056036372	601370.620813191	1984dea0-5a1c-466f-8eed-73c23ca85994	0101000020E61000000A124D09D40854C010BBA80D4DFC3940	0101000020BC08000031DFFB55AEAA2C41D48466AD385A2241
1101	5382	COLLINS AV	HAULOVER LIFEGUARD B	S	F	N	1	1	1	10/11/2016 14:2	25.91338	-80.12282	944493.948913362	575171.333640836	bbdbbab9-dcb9-4d87-824e-2b20489abe73	0101000020E6100000D89BFA5BDC0754C0BF3BB051D3E93940	0101000020BC08000006B7E31FDAD22C41F7900B178A8D2141
1102	5808	NW 67 AV	NW 192 TE	N	N	Y	1	0	1	10/28/2016 11:5	25.94691	-80.307	883889.315588411	586996.980581865	513a0dad-9a6b-4999-b5a7-61e53052dc6d	0101000020E61000002CB825E2A51354C01FCD21F068F23940	0101000020BC0800001D5DCCD360F92A4129958B63EDE92141
1103	5869	NE 186 ST	NE 22 AV	E	F	N	1	1	1	10/27/2016 17:4	25.94711	-80.15608	933482.944373995	587359.638983518	38c5113d-2d96-43d1-8381-941b1231a834	0101000020E610000016F9FD3DFD0954C06B974FD975F23940	0101000020BC0800009C6E161CD47C2C414FF3DBB4C2EC2141
1104	4613	SW 40 ST	SW 84 AV	E	F	N	2	0	1	10/13/2016 11:3	25.73306	-80.33149	876237.226502806	509229.311283395	395c2f8b-f518-4ec3-bdc4-97809231417a	0101000020E61000007C1D761C371554C006A82431AABB3940	0101000020BC080000A0D76AA598BD2A418F958F05BC141F41
1105	1867	NE 2 AV	NE 90 ST	S	N	N	1	0	1	11/4/2016 10:50	25.85785	-80.19328	921456.579004332	554840.787371419	9b3878bf-7442-4d4c-beb6-3904a237a29d	0101000020E6100000C421E9CA5E0C54C0F002826E9CDB3940	0101000020BC08000033889A5FDF1E2C4192A09BFCB4EE2041
1106	3546	SW 168 ST	SW 112 AV	W	N	Y	0	0	0	11/17/2016 14:4	25.61289	-80.37333	862671.040381093	465484.496244647	18f89542-0da2-477f-8c7f-d3b5795f7866	0101000020E61000008795CB95E41754C000283C88E69C3940	0101000020BC080000D23059449C532A419C036EB738691C41
1107	10196	NW 29 AV	NW 43 TER	S	N	N	0	0	0	10/21/2016 11:1	25.81475	-80.24252	905355.895009436	539079.681090996	be0d69f5-a885-4d3f-82d0-b689f737e9ba	0101000020E61000005DEA226D850F54C02FECD7F593D03940	0101000020BC080000D1FA43FF15A12B41CFFD09C492732041
1108	1864	NE 2 AV	NE 86 ST	N	F	Y	1	0	1	11/3/2016 16:53	25.85443	-80.19295	921572.416355841	553597.654688217	c8357171-caa3-4f8a-be42-8f7cca8def65	0101000020E61000001A28FD66590C54C0D5C2DC2ABCDA3940	0101000020BC080000D7FB430CC71F2C41F22A90B8FEE42041
1109	9283	SW 67 AV	SW 48 ST	N	N	N	0	0	0	10/10/2016 12:1	25.72578	-80.30247	885802.721829209	506633.496630475	9e33b50c-33fc-4975-9f65-26a8ece13477	0101000020E61000009435E4BE5B1354C0E9A08B38CDB93940	0101000020BC080000BF442AA453082B414528DAC22CEC1E41
1110	2694	COLLINS AV	24 ST	SW	N	Y	1	1	1	10/11/2016 13:0	25.80032	-80.12727	943308.125549506	534067.875774369	82c6e9be-07b4-4594-8001-a5386111e4e5	0101000020E6100000ADE44A12250854C01A15B6F2E1CC3940	0101000020BC080000F2375A7A96C92C413C0A38276B4C2041
1111	6424	NW 173 DR	# 4420	E	M	Y	0	0	0	11/26/2002	25.93115	-80.27346	894942.119889103	581329.512233779	4b08e6c5-3e4c-41de-b2f7-95313ba98f93	0101000020E610000012AE8865801154C0411A7E4960EE3940	0101000020BC080000527C1671BA4F2B41A3301C73A6BD2141
1112	1008	PALMETTO GENRL HOS	INSIDE PKG LOT	E	N	N	1	1	1	10/3/2016	25.88521	-80.32479	878156.174823485	564542.325369366	8ff3131a-a4e5-4206-9025-dd5feef02c81	0101000020E6100000BC96627CC91454C0B1218BB19DE23940	0101000020BC080000371B078B96CC2A41EFAC4B11803A2141
1113	5341	W FLAGLER ST	SW 97 AV	E	N	N	3	1	2	9/8/2012 12:10	25.76885	-80.35342	868953.372307528	522202.207635358	2dcb5bfc-78ef-4616-892b-1b4cc876c88c	0101000020E6100000F3C8F7719E1654C0F2F266DBD3C43940	0101000020BC080000AA2212EFB0842A41DC97CA9E6FDF1F41
1114	1034	SW 104 ST	SW 113 PL	W	N	N	1	1	1	9/29/2016	25.67219	-80.37798	861039.764145408	487029.579479158	d9caa691-6fa8-44c4-8ba4-0ed4304ddc53	0101000020E6100000BCCEF5A7301854C0C1C59EC014AC3940	0101000020BC080000DB41A5B6DD462A418F417B12DDB91D41
1115	449	SW 85 AV	SW 212 ST	N	F	N	1	1	1	10/4/2016 11:52	25.57076	-80.32637	878220.684827078	450249.656316034	aa1686cf-26cb-4937-99e9-874d9b99a99c	0101000020E610000010EDF656E31454C0836113C31D923940	0101000020BC08000024AC4D9017CD2A41C52088572D7B1B41
1116	7368	NW 22 AV	NW 32 ST	N	F	Y	1	0	0	10/17/2016 16:3	25.80582	-80.23182	908894.948975179	535854.335467875	77668394-f20d-4a29-8c6b-90af2567b615	0101000020E61000008E09121ED60E54C0FE2849B94ACE3940	0101000020BC08000017675D1BBCBC2B418F50C712605A2041
1117	6568	NW 199 ST	NW 1 AV	E	N	N	1	0	0	11/15/2002	25.95714	-80.20361	917840.550497707	590909.635510877	06da5556-10c0-4740-8197-619ef3ef2770	0101000020E6100000CC05E605080D54C028FE7A9107F53940	0101000020BC0800000E0783509F022C411C508DB37E082241
1118	215	FIU BISCAYNE BAY CAMPUS	INSIDE CAMPUS	N	M	Y	1	1	1	10/26/2016 10:4	25.9111	-80.14003	938842.860848118	574306.584365405	5db21f61-dfec-4da3-85d7-3c3bd92aae26	0101000020E61000002BC3944BF60854C08B64B9283EE93940	0101000020BC0800002C5727F2B3A62C4113FF2B97C8862141
1119	9765	SW 85 AV	SW 212 ST	S	N	N	1	0	0	12/12/2016 15:2	25.57082	-80.32661	878141.465851724	450269.608004913	1e79ede6-3279-4cd4-8ded-36c37d5a90a7	0101000020E6100000A4369845E71454C013179A6E21923940	0101000020BC0800004C3C492079CC2A41003F31267D7B1B41
1120	7801	NW 20 ST	NW 3 AV	W	F	Y	1	1	0	8/31/2016	25.79549	-80.20084	919109.412778836	532160.037781753	caa57c63-f72d-4bac-a420-ababd64b05cd	0101000020E6100000AC951397DA0C54C019A7D2ABA5CB3940	0101000020BC080000901A2C0A890C2C418AD8D179833D2041
1121	9107	SW 168 ST	SW 92 AV	W	F	N	0	0	0	11/11/2016 16:2	25.6142	-80.34124	873241.719084263	466011.527327113	d4a52f8c-44df-44d6-9412-09869bfb00aa	0101000020E6100000742F82E7D61554C0F351A2513C9D3940	0101000020BC080000B82444A131A62A41137090D774711C41
1122	8893	NE 125 ST	NE 11 CT	E	N	N	1	0	0	10/31/2016 16:5	25.89059	-80.17636	926948.291463587	566775.788720667	e1ef3f12-e6cd-4187-a1a6-82c6563d64e9	0101000020E6100000062C1B7A490B54C0C8917925FEE33940	0101000020BC0800009C361CCDC6492C414308CAFEF24B2141
1123	8338	NW 82 AV	NW 167 TE	N	N	N	1	1	1	10/19/2016 15:4	25.92542	-80.33346	875232.006767206	579142.002545998	1cfc746f-349a-4adc-9041-00205fba012f	0101000020E6100000C421A080571554C038B902C4E8EC3940	0101000020BC080000C2CB9534BEB52A41EA65DB6D8FAC2141
1124	4503	SW 87 AV	SNAPPER CREEK EX	S	N	Y	1	1	1	11/9/2016 17:11	25.69575	-80.33395	875495.456698991	495665.00902725	7d439922-38c3-4a7e-b64a-2764599de488	0101000020E61000005B10A56E5F1554C001E8D21B1DB23940	0101000020BC080000E1BF171BCDB72A4145376CCCCA401E41
1125	1730	HARDEE RD	SW 42 AV	E	N	Y	0	0	0	10/14/2016	25.7126	-80.26138	899359.694069341	501916.332845949	1232815d-0d56-404e-a6b4-6fa20e0b0abf	0101000020E610000059178769BA1054C09DCD02646DB63940	0101000020BC080000416FBA973D722B412DB6DC1978A21E41
1126	3444	SW 104 ST	SW 150 PL	W	F	Y	1	1	1	9/29/2016 15:01	25.67017	-80.44018	840552.591513518	486204.218267374	cee3a8a8-a51c-4b7a-9829-73aad58a6ccb	0101000020E61000001A4FE1EB2B1C54C05007656F90AB3940	0101000020BC080000AD37A85BCFA6294183175CA0F7AC1D41
1127	5961	NE 199 ST	NE 3 CT	W	N	N	1	0	1	11/1/2016 16:58	25.95782	-80.19493	920693.149401393	591175.349188834	c98becb8-006f-4973-984b-d8c27f17ee51	0101000020E6100000D18B2BB6790C54C06FCB515434F53940	0101000020BC08000042BC6383E8182C41B0EEFC20920A2241
1128	3885	SW 112 AV	SW 43 TE	N	F	Y	0	0	0	10/27/2016 19:1	25.72744	-80.37544	861778.133077439	507115.436282136	7f9e179b-ae79-4461-83af-b7636efa2225	0101000020E6100000131B5F34071854C014365ED039BA3940	0101000020BC08000041179873A24C2A41C3AB0285B4F31E41
1129	5379	COLLINS AV--OP	HAULOVER CLUB HOUSE	N	M	N	1	1	1	10/11/2016 12:5	25.90874	-80.12256	944591.025862429	573486.098445229	d29540e5-e7b0-45e1-bd1a-e7f64bf05eb3	0101000020E610000058E74215D80754C0E132EE5CA3E83940	0101000020BC08000034A456479CD32C41ABED589E5F802141
1130	169	SW 22 AV	SW 22 ST	N	N	Y	1	0	0	10/17/2016 16:0	25.7504	-80.23	909611.475370359	515714.604751937	d915084a-e83d-4992-a934-2ceff8735e8e	0101000020E6100000F6BA6D4CB80E54C0CC81BBB71AC03940	0101000020BC080000CC0F222955C22B415078F833117A1F41
1131	9217	COLLINS AV	ATLANTIC AV	S	F	Y	1	1	1	10/11/2016 14:0	25.92661	-80.12246	944582.051773008	579982.407633394	3886849c-b9e2-4aa5-9532-c483dfaa5ce8	0101000020E6100000F26CDD5CD60754C0F6786C9F36ED3940	0101000020BC08000063C58C548AD32C41C99D8B3D20B32141
1132	4573	SW 24 ST	SW 72 AV	W	N	N	1	1	1	9/14/2016 12:42	25.7482	-80.31137	882831.747815605	514765.776621148	64cfadfa-4804-4d54-a6fc-f5181dcb99bb	0101000020E610000036E93C7BED1354C0AC5E7A578ABF3940	0101000020BC0800009E4817B11DF12A41FD697BE33D6B1F41
1133	9248	SW 62 AV	SW 64 ST	S	F	N	1	0	0	9/22/2016 11:57	25.71055	-80.2938	888688.021853786	501113.568019189	3e0412a0-3f4a-4b8f-82e4-3091ba2ca847	0101000020E6100000F3607CA1CD1254C00676432CE7B53940	0101000020BC0800009D8A2B3EDE1E2B41D4588F0AED951E41
1134	8634	NE 6 AV	NE 170 ST	N	F	N	0	0	0	10/26/2016 14:3	25.93176	-80.18831	922924.814563122	581716.23559016	40bec381-3141-4303-aea4-e69c48a25215	0101000020E610000040EF385D0D0C54C0C049316588EE3940	0101000020BC08000081FD58D8572A2C412264A5E5ABC02141
1135	3862	SW 112 AV	SW 32 ST	S	F	N	1	1	1	10/27/2016 19:4	25.73906	-80.37585	861623.181297086	511337.42649211	90c347ea-b141-4f8c-8100-fe3f3dd78ac5	0101000020E6100000975609EC0D1854C0E11E1E3633BD3940	0101000020BC080000F721588C6C4B2A41BF21237CAC351F41
1136	2235	W 16 AV	W 60 ST	S	F	Y	1	0	0	10/3/2016	25.87665	-80.31535	881276.460846782	561444.232827425	2711adb9-4b6f-4427-a97f-86a32b683aca	0101000020E61000009041F3CD2E1454C094F7502E6CE03940	0101000020BC080000EE88D31DF7E42A41999B67E14B222141
1137	7345	SW 22 AV	SW 14 TE	N	N	Y	0	0	0	10/17/2016 16:0	25.75934	-80.23034	909479.601635195	518964.039233521	33425007-e53a-4f17-ac0e-4c079940db89	0101000020E61000002A4814EBBD0E54C047F2A0BD64C23940	0101000020BC080000FA7BA6694DC12B4115189AF1D6AC1F41
1138	9307	SW 72 ST	SW 58 AV	E	N	Y	1	0	1	9/22/2016 12:13	25.70429	-80.2875	890776.995018132	498846.927548245	afe4a960-88d5-421d-b436-2dddd85700e8	0101000020E61000004913004C661254C0E93F69754CB43940	0101000020BC080000DF32CB30302F2B41A723ED7982721E41
1139	6998	SW 3 AV	SW 28 RD	NE	F	N	1	0	0	9/14/2016 14:03	25.75423	-80.20965	916299.896071609	517146.657359898	43d02675-5d4a-4cee-be98-c88102e0d057	0101000020E6100000F0F449F76A0D54C0CE1543C915C13940	0101000020BC0800003B806A0196F62B419A24416A71901F41
1140	1962	E 8 AV	E 65 ST	N	N	N	1	1	1	2/15/2017 10:09	25.8815	-80.26704	897151.001273148	563294.635943212	f8bfaa5a-555d-4b28-80dd-50ea51c325a1	0101000020E610000099DC414F171154C0E966BF5BAAE13940	0101000020BC08000011D59C34FC602B41790F2BB0C0302141
1141	5200	NW 62 ST	NW 18 AV	E	N	Y	1	1	1	10/18/2016 15:2	25.83154	-80.22708	910398.540101212	545209.654036969	5357c9b5-05ca-496d-b951-ab079e388bd7	0101000020E61000004152A681880E54C08B23B5EADFD43940	0101000020BC080000EC45414A7BC82B4129AA03B776A32041
1142	95	NE 12 AV	NE 135 ST	N	N	N	1	0	0	11/4/2016 12:01	25.89944	-80.1747	927472.844232455	569994.501121514	bf23b4ea-37c9-4bac-8f92-6c2670b24f70	0101000020E6100000F2EE24542E0B54C0CDFEC4E041E63940	0101000020BC080000832910E8DF4D2C4161A9F46B18652141
1143	5786	NW 47 AV	NW 185 TE	S	N	N	1	0	1	9/1/2016 11:39	25.94208	-80.27763	893550.033437643	585295.393724985	eb0f21d5-8b34-4c10-b062-51bb45c26fe0	0101000020E6100000DFAF98B3C41154C0D47310BA2CF13940	0101000020BC080000A3B68844DA442B4141C4E836A2DC2141
1144	1288	SW 108 AV	OP # 30 G	N	M	N	0	0	0	42689.54167	25.76812	-80.37091	863198.310375057	521906.115650058	5a58d377-7aeb-4c7b-aba8-d15753560762	0101000020E61000009DAF8F04BD1754C03F64CE7DA3C43940	0101000020BC080000BD87A5CEBA572A4121B99640CFDA1F41
1145	2169	W 12 AV	W 23 ST	N	F	Y	1	0	0	10/10/2016 13:0	25.84288	-80.30608	884393.27812428	549188.94728224	1fd336aa-8639-433e-a663-c3d6da3874ce	0101000020E610000018F466BA961354C060E9CF8DC7D73940	0101000020BC080000BD25BAC050FD2A41B92FB34D8DC22041
1146	4940	NW 32 AV	NW 69 ST	S	N	Y	0	0	1	9/1/2016 13:18	25.83632	-80.24965	902964.539844763	546906.202176198	d9d9dc56-52de-4b5c-a563-00798f185572	0101000020E610000096EF1E4BFA0F54C083857D9219D63940	0101000020BC08000057B72149678E2B41735ADBCFB7B02041
1147	3576	HIBISCUS ST	HOMESTEAD AV	E	N	N	0	0	1	11/17/2016 12:5	25.6052	-80.35378	869124.372297585	462722.302318558	c1f1367e-2345-4d5e-a098-b4a49eb65a1a	0101000020E61000009400AE68A41654C092334CE3EE9A3940	0101000020BC080000D20922EF06862A416BC647F00F3E1C41
1148	6766	NE 2 AV	NE 49 ST	S	F	N	0	0	0	11/1/2016 12:55	25.82016	-80.19175	922046.285856515	541143.253711134	333901ee-49be-4179-b000-c2ac510f0e43	0101000020E61000008D92429C450C54C015A3F81DF6D13940	0101000020BC08000023EA95C97A232C4119DDA3E9B1832041
1149	6329	NW 39 AV	# 21010	NW	N	Y	1	0	0	9/19/2016 19:19	25.96662	-80.26767	896775.896073289	594232.818787828	7c87eb16-fbf1-440e-aafa-2d5b67a9ffa3	0101000020E6100000BE23C362211154C01F8345EA74F73940	0101000020BC08000041BEB3FE0D5E2B412438BB1175222241
1150	6980	NW 2 AV	NW 77 ST	N	N	Y	1	0	1	11/3/2016 16:37	25.84525	-80.2008	919012.039926745	550244.49632211	5ec89cfc-0afe-49f0-ad3b-f47f791fb14d	0101000020E610000077C0B2F7D90C54C0EB716A6A62D83940	0101000020BC080000A78C3E4BC60B2C417D37FC66CCCA2041
1151	1194	NW 158 ST	NW 57 AV	E	N	N	1	1	1	10/26/2016 12:3	25.91693	-80.2937	888318.933663189	576124.978687815	0d820699-0ac0-4c98-a4f1-6eda75a6e793	0101000020E61000008462B0F5CB1254C04645306EBCEA3940	0101000020BC080000944AEB10FC1B2B418B733F61FD942141
1152	4143	SW 40 ST	SW 92 AV	E	N	N	2	0	1	10/13/2016 11:2	25.73277	-80.34391	872148.726863731	509102.658689082	080f2257-6340-4d5d-8fcf-a12e12fbbfec	0101000020E61000005737ED9D021654C0C65F320E97BB3940	0101000020BC080000023900A5A79D2A4119256A69C1121F41
1153	10385	NW 75 PL	NW 176 ST	N	F	Y	0	0	0	11/11/2016 12:0	25.93329	-80.32486	878044.1809402	582014.783872463	a2241408-996c-45df-92f4-0c0bde21791c	0101000020E6100000E9326895CA1454C0F1A61124ECEE3940	0101000020BC080000F55A288EB6CB2A41EC1136FE00C32141
1154	4227	SNAPPER CREEK DR	SW 109 CT	NW	N	N	0	0	0	10/27/2016 19:1	25.70496	-80.37152	863105.251454346	498950.354145855	6bfc97e4-ced3-471d-b83b-f31becafeb04	0101000020E6100000091B0D18C71754C01CD1E56E78B43940	0101000020BC08000008C479B000572A41954CCB2E20741E41
1155	3088	SW 104 AV	SW 174 TE	S	F	Y	0	0	0	8/17/2016	25.60718	-80.36108	866716.1566367	463429.551172748	b52a0fb4-4000-4ca5-96b2-6abbafe569d6	0101000020E610000048C086F61B1754C0BF6DA484709B3940	0101000020BC08000074CA5E8036732A41CC7634EF1C491C41
1156	8150	SW 8 ST	SW 44 CT	W	N	N	1	1	0	9/8/2016 13:39	25.76439	-80.2674	897272.680507645	520728.576061055	1cf3aa31-b620-4ad8-8210-40321a960c3f	0101000020E610000044F3710F1D1154C03D2D766FAFC33940	0101000020BC08000068238390EF612B413FCAB21769C81F41
1157	4409	SW 67 AV	SW 8 ST	S	F	Y	1	1	1	10/10/2016 13:2	25.76278	-80.304	885228.705574345	520079.208580226	cd8da9f7-2ca3-4620-b820-623177bd2d42	0101000020E6100000EEDACAC7741354C01E17791E46C33940	0101000020BC080000AB4ACF9BD7032B4140A55D9F43BE1F41
1158	2006	E 4 AV	E 17 ST	N	F	Y	0	0	0	10/19/2016 14:4	25.8377	-80.27376	895033.140387755	547360.71336665	7168a9c5-6369-4b67-9a44-1feb78bb3913	0101000020E6100000D01BD83A851154C0E6DF978D73D63940	0101000020BC08000007F3A77B70502B41E3ACA6D544B42041
1159	493	NW 72 AV	NW 19 ST	S	N	N	1	0	1	10/10/2016 12:0	25.79321	-80.31299	882213.545640986	531122.351496339	488cff61-32b1-4038-8c22-98afb24eff5e	0101000020E61000000448D301081454C04ABB281E10CB3940	0101000020BC080000C94C794949EC2A417DB6311A68352041
1160	3217	SW 117 AV	SW 204 ST	S	N	N	1	1	1	11/29/2016 14:2	25.57691	-80.38047	860377.295659006	452396.540104359	93e7952b-1da1-4b23-b33f-3b105bab048a	0101000020E6100000E0CD4BAA591854C002EBD88BB0933940	0101000020BC080000C176BBC6B0412A41D00DFFE0B89C1B41
1161	9601	NW 10 AV	NW 53 ST	S	F	Y	0	0	0	9/23/2016 13:36	25.82367	-80.21224	915300.366933543	542380.32868582	1e9acb9b-db22-4227-a7ae-ff1f69f65b54	0101000020E610000018D13634950D54C0FE34A98ADCD23940	0101000020BC080000338D50F2C6EE2B4195140A105C8D2041
1162	5641	NW 127 ST	NW 18 CT	W	F	N	1	1	1	8/18/2016	25.89035	-80.22989	909348.237741441	566580.932807706	1abd0265-5563-4ade-80b4-33ec306c2a16	0101000020E61000005A250B94B60E54C0F3945B49EEE33940	0101000020BC08000050423CAF46C02B41A2F37C486D4A2141
1163	3723	SW 264 ST	SW 139 AV	W	N	N	0	0	0	10/24/2002	25.5218	-80.41649	848591.363507878	432314.358499922	21ee5cbe-bbf3-430e-a748-b856c9d28b2e	0101000020E61000009D758DD9A71A54C076E58F0D95853940	0101000020BC0800001496F8E79CE529414172D921F0621A41
1164	7654	NW 62 ST	NW 15 AV	W	F	Y	0	0	1	10/18/2016 14:3	25.83188	-80.22312	911702.690704614	545342.377549745	c2381d74-f615-48a9-8231-0b3330f061bc	0101000020E6100000E1C4D682470E54C02D0F1576F6D43940	0101000020BC08000079E89597ABD22B41867C6F2980A42041
1165	2325	E 21 ST	E 3 AV	E	F	N	0	0	0	10/4/2002	25.84091	-80.2758	894353.075170252	548526.629703864	ffe2ba24-f682-4d3f-ab06-92956ac417a5	0101000020E6100000D329C8C8A61154C0A99CB37246D73940	0101000020BC0800005EB92C5A204B2B41A0930EAB60BD2041
1166	7945	NW 7 ST	NW 23 AV	W	F	Y	1	1	1	9/6/2012 13:48	25.77972	-80.23365	908345.453670155	526363.269501217	5bf4457c-6f01-4f64-99a8-9160b598a21d	0101000020E61000002250323BF40E54C06F247F099CC73940	0101000020BC08000016E2D71D71B82B41101EC4EF39102041
1167	1738	SW 72 ST	ALMANSA ST	W	F	Y	0	0	0	9/22/2016 14:14	25.70531	-80.26519	898118.626982968	499260.068804182	ea5e0274-829c-4168-8d89-52d7224b5386	0101000020E6100000BDF89BE6F81054C089D6DAB28FB43940	0101000020BC080000031138758B682B41018AA90AF7781E41
1168	4486	SW 87 AV	SW 36 ST	S	F	Y	1	0	1	11/9/2016 17:05	25.73639	-80.33591	874775.734375063	510431.185561851	7a364cfd-62a3-437a-bf60-632cb603442f	0101000020E6100000FDF27C8B7F1554C085E0F03A84BC3940	0101000020BC08000072052CA92DB22A411EE2148583271F41
1169	2590	CRANDON BD	HARBOR DR	S	F	Y	1	0	1	11/14/2016 14:2	25.69856	-80.16269	931885.868211806	497008.264560908	7b287215-f603-47ed-8f70-705e0656fd7d	0101000020E61000000A47528A690A54C0CB4E3376D5B23940	0101000020BC08000018052BF559702C41B64FC3D2C7551E41
1170	189	SW 24 ST	SW 42 AV	W	F	N	1	0	1	9/14/2016 13:53	25.74955	-80.26377	898500.804353073	515340.018577553	f1471e1a-f015-4715-aecf-a0a7755cdd5b	0101000020E6100000EB3A2C6CE11054C065D7689EE2BF3940	0101000020BC080000778C07D0876B2B410B1D74DB36741F41
1171	1355	BISCAYNE BD	NE 183 ST	N	F	Y	1	0	1	12/12/2002	25.94574	-80.14725	936386.583592121	586880.465370886	98fea746-75cd-4bbe-b53a-ed8aa604e0ed	0101000020E610000041060DA36C0954C02E1C86101CF23940	0101000020BC0800004C08CA6383932C41952EF25B04E92141
1172	2788	ALTON RD	19 ST	N	N	Y	1	0	1	11/10/2016 14:5	25.79454	-80.14121	938731.889604159	531939.006025963	8857748a-ed01-4f9c-9d5f-5f1e298a77d0	0101000020E6100000A831DAA0090954C0F4DA088B67CB3940	0101000020BC080000B1FFDA00D6A52C41A9289869C93B2041
1173	8779	W DIXIE HY	NE 132 ST	NE	N	Y	1	0	1	9/30/2016 13:50	25.89678	-80.18117	925353.179496083	569014.338722877	60fa6004-b937-43e1-aa68-9a6b9351a93b	0101000020E6100000443B8544980B54C0CD125D8D93E53940	0101000020BC08000049897993503D2C417661B518705D2141
1174	1796	NW 97 AV	NW 33 ST	S	F	Y	1	0	0	10/27/2016 12:5	25.80407	-80.35338	868903.685447462	535003.673793025	f11519c9-b338-408d-8244-2879b020da54	0101000020E610000030D833CA9D1654C0D32EE219D8CD3940	0101000020BC080000127D498F4D842A4141EFD2BFBA532041
1175	4899	NW 32 AV	NW 44 ST	N	N	Y	0	0	0	8/31/2016	25.81461	-80.24848	903393.825428568	539014.99778536	2497e2ab-18de-4bd3-b059-d87913344dd3	0101000020E6100000862F2B28E70F54C029AE97538AD03940	0101000020BC080000AF357CDBC1912B4166CC426611732041
1176	5911	NW 192 ST	NW 82 CR CT	E	F	N	0	0	0	10/27/2016 13:0	25.94815	-80.33532	874583.033005971	587399.810460478	d83dd495-eda3-4762-b2d4-623c0a089261	0101000020E6100000033783C3751554C09745AB44BAF23940	0101000020BC0800001B5BDF41ACB02A4103A79B0C13ED2141
1177	2187	W 12 AV	W 60 ST	N	F	Y	1	0	0	10/10/2016 14:0	25.8776	-80.30716	883969.198898755	561806.570352949	86afb446-0f83-4b57-aaef-379c0f57ba71	0101000020E61000003F699D89A81354C0AF9DE3F6AAE03940	0101000020BC080000999C2D9800FA2A414542458E20252141
1178	4599	SW 40 ST	SW 63 AV	W	F	Y	0	0	0	10/13/2016 11:5	25.73378	-80.29697	887600.280905385	509548.972095206	99180c57-735f-4be1-9fd2-56ffb3e57db7	0101000020E61000009366DA84011354C079146B2ED9BB3940	0101000020BC0800002C62A5C25E162B41195A43AABA191F41
1179	2517	NW 6 AV	NW 2 ST	N	N	N	0	0	0	10/4/2016 13:49	25.4715	-80.48548	825910.304868139	413939.77057109	8c7877ce-6cf9-4c84-a648-475d5407d709	0101000020E61000006FFFDB32121F54C03ED91FA8B4783940	0101000020BC080000265519C76A3429418947EAC2D5431941
1180	4134	SW 40 ST	SW 108 AV	E	F	N	1	1	1	10/13/2016 10:4	25.73216	-80.36985	863609.282933604	508838.236630328	8952822d-d1e5-4508-bfc3-976593208b05	0101000020E6100000DC85CAAAAB1754C0C803BCE16EBB3940	0101000020BC080000597692C0F05A2A419CDAFCB89F0E1F41
1181	4735	NW 7 AV	LITTLE RIVER DR	S	N	N	1	1	1	9/20/2016 13:13	25.85532	-80.20956	916109.525693655	553886.851265073	9317d711-c9a0-42bb-ad5a-81fbd6a72a3c	0101000020E61000005B896C75690D54C0B0F83E4CF6DA3940	0101000020BC080000B9B98A4319F52B41828D2D1D41E72041
1182	8996	OPA LOCKA BD	RUTLAND ST	W	N	Y	1	0	1	8/31/2016	25.89968	-80.24893	903069.654486068	569935.095759541	78ba404e-6d6e-4442-ace1-a74f6de46fc7	0101000020E6100000F01B3A7FEE0F54C029E0469B51E63940	0101000020BC0800008318C883398F2B411FDE5B9CA1642141
1183	77	SW 8 ST	SW 12 AV	E	F	Y	1	0	1	9/8/2016	25.76579	-80.2141	914809.159554005	521336.643745959	f92d9b9f-b099-408a-8b59-e7c788ff97dd	0101000020E6100000005687ECB30D54C0D0B0B5DB0AC43940	0101000020BC0800006D0D1488F0EA2B41916F675DE9D11F41
1184	4628	SW 56 ST	SW 62 AV	W	N	N	1	0	1	10/12/2016 10:3	25.71868	-80.29393	888630.079022679	504067.534214117	8103bba0-69a8-4a1f-9a0a-5f94e7fdf8f5	0101000020E6100000D3615BBACF1254C041F282D9FBB73940	0101000020BC08000067E9725B6A1E2B41F79AB4E814C41E41
1185	4750	NW 17 AV	NW 74 ST	N	N	Y	0	0	0	8/18/2016	25.84167	-80.22518	911001.153395176	548896.35109169	a5f88f1c-5009-47e3-be00-1588786015ee	0101000020E6100000E246DC68690E54C0356B4BFE77D73940	0101000020BC08000021EC598430CD2B41C4DC781C44C02041
1186	6896	S MIAMI AV	S. 3601 BLK	NE	F	Y	0	0	0	9/18/2002	25.74383	-80.21537	914438.995569732	513354.289273083	244fc7f7-72fa-42d0-af2b-1d19f27c073d	0101000020E6100000696219B7C80D54C0BA28D8036CBE3940	0101000020BC08000033931D340CE82B413D8971F02F551F41
1187	7953	NW 7 ST	NW 34 AV	W	N	Y	1	0	0	9/6/2012 13:49	25.77919	-80.25099	902642.962771531	526137.82870236	9d19e80e-5726-4cb0-8316-aa3a0bef6c84	0101000020E61000002541E532101054C083428D4D79C73940	0101000020BC0800002728BF21E48B2B411D7EE80D770E2041
1188	511	NW 7 AV	NW 79 ST	S	F	N	2	0	0	9/20/2016 13:13	25.84657	-80.20922	916241.126863386	550709.349084072	15ccead3-343d-471e-891d-67723d2efd26	0101000020E6100000DB80F8DA630D54C084923840B9D83940	0101000020BC08000036BC7D7720F62B41C489921B6ECE2041
1189	5190	NW 62 ST	NW 32 CT	E	N	Y	0	0	1	10/18/2016 15:1	25.83086	-80.25089	902568.973051716	544918.990588836	38dcb177-afc9-4e60-872d-1c90d1d833ad	0101000020E61000007F79798F0E1054C086E717AEB3D43940	0101000020BC080000E30EEF26508B2B4139744D6331A12041
1190	7037	NW 7 AV	NW 29 ST	S	N	Y	0	0	0	9/20/2016 13:13	25.80378	-80.20739	916935.419769913	535160.512395464	8dfc78eb-7eaf-4f75-9307-1f4788b0daf0	0101000020E6100000BEE829F0450D54C0D775BF07C5CD3940	0101000020BC08000029EC7B0D8DFB2B41C62A3A6DF4542041
1191	7959	NW 7 ST	NW 40 AV	W	F	N	1	1	0	9/7/2016 13:50	25.77883	-80.26219	898956.032466721	525986.535325035	c3fd331d-9e64-4ba2-94b5-b9da0236f18a	0101000020E6100000ECDB47CCC71054C0461689C661C73940	0101000020BC08000039A4FB44166F2B418D87B677480D2041
1192	7640	NE 62 ST	NE 3 AV	W	F	Y	1	1	0	10/18/2016 13:3	25.83321	-80.19046	922439.13674546	545892.03426785	7fca47ff-9da3-453a-a0fd-ebdc99d07f04	0101000020E610000061D7F896300C54C07D65E5E24DD53940	0101000020BC08000065503B7D8C262C415A98C479CBA82041
1193	7580	NW 62 AV	NW 2 ST	S	F	Y	0	0	0	9/6/2012 12:32	25.77209	-80.29625	887762.001404412	523475.123674639	ee5b8158-cee9-4d44-b7f5-132b65e4b611	0101000020E61000003F3C8AC5F51254C0D25146FFA7C53940	0101000020BC08000082139333A2172B41B8D6494953F31F41
1194	3203	SW 117 AV	SW 128 ST	S	N	Y	1	1	1	8/17/2016	25.64839	-80.38327	859333.114981677	478371.24443306	9684d2ee-fb18-4025-a19d-bc572f31c800	0101000020E61000009CA48C8E871854C0738AC4FEFCA53940	0101000020BC0800003568186A88392A41F420FBB893321D41
1195	8602	NE 15 AV	NE 179 ST	N	N	N	0	0	0	11/4/2016 13:26	25.94012	-80.17051	928756.064100511	584791.175922439	9a4179ff-216a-422e-b200-58aecb7507df	0101000020E6100000807965B6E90A54C08727FB35ACF03940	0101000020BC080000D7F2DB58E6572C4165BF6FC7B1D82141
1196	2440	W 68 ST	W 9 AV	W	F	Y	0	0	0	10/3/2016	25.88425	-80.30181	885716.761372846	564233.312851667	4b175f60-44e8-4a1a-9bde-9f5158712e11	0101000020E61000003C464ED1501354C0208030D85EE23940	0101000020BC080000AF9554B8A7072B41EF31C70A16382141
1197	3690	SW 216 ST	SW 114 AV	E	F	N	1	1	1	8/16/2016	25.56626	-80.37622	861795.417801958	448533.832963496	bca48068-0954-4c2d-863c-0f5e3bb60480	0101000020E61000006D211415141854C0412D91D9F6903940	0101000020BC080000B6168B05C54C2A41647C090C5E601B41
1198	2532	NE 15 ST	KROME TE	W	N	N	0	0	0	10/4/2016 14:43	25.48452	-80.47536	829230.07941024	418682.588216461	c1da544c-c2d8-4df0-bd23-3b9fdc93a697	0101000020E6100000DCE2AE686C1E54C09F3DE18A097C3940	0101000020BC080000AB2919545A4E294141C65909F18D1941
1199	4164	SW 47 ST	SW 132 AV	W	N	N	1	0	0	9/30/2002	25.72202	-80.40709	851366.954405461	505099.274320789	3ef81476-e302-4e98-8bc8-d591e94ed327	0101000020E61000004F2854C60D1A54C0B3BFB7EFD6B83940	0101000020BC080000E9C9C1164CFB29417A2B9ADE33D41E41
1200	2195	W 12 AV	W 84 ST	N	N	Y	1	0	0	10/10/2016 14:4	25.89774	-80.30806	883634.353808373	569123.767987512	437062e2-c377-4df5-af1d-9d962c6176fd	0101000020E61000002122B04CB71354C0782C0199D2E53940	0101000020BC08000019665FE762F72A414A377BF44A5E2141
1201	309	SW 72 ST	OLD CUTLER RD	E	N	N	1	0	1	9/22/2016 12:54	25.70531	-80.26141	899362.999514915	499264.464763097	a47be3fb-504d-41b6-a082-03a71b1abe2f	0101000020E6100000183A54FCBA1054C0DDD46A3D8FB43940	0101000020BC080000DCD2293444722B41394129A008791E41
1202	7504	SW 37 AV	BATTERSEA RD	N	M	N	0	0	0	9/22/2016 13:19	25.71052	-80.25278	902192.675244424	501174.795285746	4000ca88-1c70-4690-9428-9acae9e01c96	0101000020E610000020A040A82D1054C0BFE54DD0E4B53940	0101000020BC08000054DE828E5F882B41A66658F3E1961E41
1203	6469	NW 175 ST	NW 42 AV	W	N	Y	1	0	1	10/26/2016 13:3	25.93284	-80.26858	896542.553707648	581950.520517625	db46a099-2226-4f7f-9e3d-8ae357c59dd1	0101000020E61000008CCB5271301154C0ADC056A6CEEE3940	0101000020BC080000EA0C6E4F3B5C2B417BF47C7780C22141
1204	3817	BUSWAY	SW 168 ST	NE	F	Y	3	1	1	9/29/2016 14:50	25.61444	-80.34805	870996.863026362	466088.383481629	e1b8912f-04b6-4d4a-89e9-1413e5655caf	0101000020E61000008A24EC7E461654C067E0B32D4C9D3940	0101000020BC080000931D99EAA7942A41BFB23844A8721C41
1205	2160	W 8 AV	W 39 ST	S	F	Y	0	0	0	10/19/2016 16:3	25.85671	-80.29865	886811.514103118	554225.739042401	20f74bfc-987d-43d6-bb48-a389da9447da	0101000020E61000009140F0ED1C1354C0E8878E6451DB3940	0101000020BC080000C5B1E43935102B41070FBFE3E6E92041
1206	5049	NW 107 AV	NW 7 ST	S	F	N	2	0	1	11/29/2016 11:0	25.77502	-80.36967	863594.728203807	524417.016830012	e88769e8-fd59-4145-950f-7ae381de5674	0101000020E6100000A6F76DAFA81754C00E0CF4E267C63940	0101000020BC08000089308CA4D35A2A413E61066E05012041
1207	8995	OPA LOCKA BD	WEST DR	E	F	Y	0	0	1	9/1/2016 12:30	25.89954	-80.24904	903033.773351282	569885.820232347	d63490d8-a11d-4304-b8ee-507403f390fe	0101000020E61000001649994CF00F54C0468559C248E63940	0101000020BC080000E6FDB1C0F18E2B41743D450F3F642141
1208	5291	NW 7 ST	NW 109 AV	W	N	Y	1	0	0	10/27/2016 19:3	25.77565	-80.37342	862363.184049089	524640.853311129	613a71e1-013f-4ec2-927f-5235c1f9bed4	0101000020E6100000A4CEF0F1E51754C09199274E91C63940	0101000020BC080000EFC2C38D34512A41FD7B431AC5022041
1209	3431	SW 104 ST	SW 112 AV	W	F	N	2	0	1	8/17/2016	25.67226	-80.37634	861574.864749819	487058.268736333	83315efe-38d8-405e-a93d-475cad24c0cb	0101000020E610000025143708161854C003FB927819AC3940	0101000020BC08000051D639EA0B4B2A4169942ED44FBA1D41
1210	6827	BRICKELL AV	SE 25 RD	SW	N	N	1	1	1	10/14/2016	25.75132	-80.2027	918592.585695617	516100.193876319	3e3b6b80-2f08-464f-baa7-fde8a085b856	0101000020E61000009927A529F90C54C015BD1E9E56C03940	0101000020BC0800002252B7627F082C4167EC668F17801F41
1211	7208	NW 17 AV	NW 63 ST	S	N	Y	0	0	0	8/22/2016	25.83312	-80.22505	911063.215908397	545789.319561072	c02271ac-ddb9-42b5-a728-80d7de4ad08a	0101000020E61000004293033B670E54C08671D4B947D53940	0101000020BC08000059635FA4ACCD2B41769FDC0BFEA72041
1212	1252	NW 82 AV	NW 154 ST	N	F	Y	2	1	1	10/19/2016 15:3	25.91372	-80.33292	875430.801322974	574890.705230325	4c8b6c3e-05ff-4d91-84aa-240b96d4a439	0101000020E61000009A57E5AB4E1554C07CB14D0FEAE93940	0101000020BC080000551B6ACB4BB72A4188B807D5588B2141
1213	6809	NE 2 AV	NE 68 ST	N	F	N	1	0	0	11/6/2002	25.8374	-80.19232	921823.250213265	547407.607956484	1c37583a-d4d3-496b-a66c-e3c0a63b2a42	0101000020E61000007C5E44CD4E0C54C0E759B1D35FD63940	0101000020BC0800004CDB58B7BC212C414ECFD29FA2B42041
1214	298	W 3 CT	W 74 PL	S	F	Y	0	0	0	9/23/2016 12:12	25.88936	-80.29077	889337.197349921	566108.279881097	9778e92a-3f42-4328-901e-405d42cf1eda	0101000020E6100000C953CAE79B1254C0FFE0E667ADE33940	0101000020BC080000F62C0798F0232B41E23133FABB462141
1215	1970	E 8 AV	E 45 ST	S	F	Y	1	1	1	2/15/2017 12:23	25.86343	-80.26682	897260.672657412	556726.818368256	17ad9d2c-cdc6-4cac-b005-9d9441b803ed	0101000020E6100000E4781EAC131154C06A79960E0ADD3940	0101000020BC08000080EF578CD7612B41987FA90C71FD2041
1216	7587	SW 67 AV	SW 6 ST	S	F	Y	0	0	0	10/10/2016 13:2	25.76498	-80.30407	885201.118027519	520878.334944703	d577755d-c43c-4eb8-9c57-56c590868ca8	0101000020E610000035AE96F1751354C0A8A7933BD6C33940	0101000020BC08000014FCF66EA0032B419C5BD920C0CA1F41
1217	2286	HIALEAH DR	E 9 AV	W	N	Y	2	1	1	10/19/2016 14:1	25.82332	-80.26298	898606.179167613	542155.251349479	04eb42d9-945a-455d-9827-9556488fca28	0101000020E610000051BE66B5D41054C0408A4968C5D23940	0101000020BC080000E0AAEE8F5A6C2B418B236EE8998B2041
1218	423	NW 62 ST	NW 32 AV	E	N	Y	1	1	0	10/18/2016 15:1	25.83084	-80.24961	902989.062807545	544914.843291618	cc07d24d-b734-4a06-a1b8-e1bece7a7121	0101000020E6100000131A58A3F90F54C04BD91980B2D43940	0101000020BC080000BBC6ED54988E2B41B95DDD1729A12041
1219	7227	NW 17 AV	NW 20 ST	S	N	N	1	1	1	8/22/2016	25.79514	-80.22339	911693.354096249	531988.802843183	c933bed8-32bb-4da8-a28d-9a18a20f00bb	0101000020E6100000F262E8E64B0E54C05DE890CC8ECB3940	0101000020BC08000028E246EB98D22B411EE993012D3C2041
1220	7020	NW 7 AV	NW 75 ST	S	F	Y	0	0	0	9/20/2016 11:40	25.84317	-80.20909	916291.651675008	549473.448977731	737ec484-d90f-4903-a787-4e38f81ea4b9	0101000020E6100000B7DF83B5610D54C03736E75CDAD73940	0101000020BC080000CD86218485F62B41A315A24EC6C42041
1221	8037	W FLAGLER ST	NW 23 AV	W	F	Y	0	0	0	9/8/2012 11:19	25.77261	-80.23315	908530.297757268	523780.386892229	e02730af-3026-48fe-ad20-509a31dcdaf4	0101000020E61000007C15F0C6EB0E54C001BD3B24CAC53940	0101000020BC080000861E03CEE2B92B41F4A7F85618F81F41
1222	2250	W 18 AV	W 66 PL	N	N	N	1	0	0	10/3/2016	25.88295	-80.31951	879896.735643335	563730.224626191	20717687-82c4-471e-a21d-5859680605db	0101000020E6100000916242F6721454C04695CCA509E23940	0101000020BC080000A88B5EAA2FDA2A41CAA684DD27342141
1223	491	W 12 AV	W 49 ST	S	F	Y	1	0	0	10/10/2016 14:4	25.86614	-80.30691	884073.722677592	557640.598660879	a264ddd5-abde-47ee-8a15-6620b0cee243	0101000020E61000005123D86CA41354C068CC9FB9BBDD3940	0101000020BC08000070C43DA4D1FA2A4145584A9C94042141
1224	7887	S VENETIAN WY	NE 13 PL	E	N	N	1	0	0	11/14/2016 9:03	25.79005	-80.16756	930071.951875851	530251.706931956	ee4ec05f-7536-49ca-81c2-483dc7e26424	0101000020E6100000932DCA58B90A54C089D0175A41CA3940	0101000020BC0800008D85BE1F2E622C41FA2138D09A2E2041
1225	6540	NW 191 ST	NW 29 AV	E	F	N	0	0	0	9/19/2016 13:20	25.94797	-80.2494	902813.291129671	587487.67874904	8f484559-9830-4809-87ae-288225d85846	0101000020E6100000494A5543F60F54C03C0A5B9AAEF23940	0101000020BC0800004394ABC9388D2B4173DB3EC9C2ED2141
1226	5824	NW 82 AV	NW 182 ST	S	F	Y	1	0	0	10/19/2016 15:4	25.93861	-80.335	874701.517318189	583933.928958587	e1c38bc8-4ac5-4f2f-930d-91280477a74a	0101000020E61000004151DCBB701554C0B72F514049F03940	0101000020BC0800004233E03999B12A41D5F7D548FFD12141
1227	2537	NE 15 ST	KROME TE	E	F	N	0	0	0	10/28/2002	25.48443	-80.47558	829157.303307977	418649.954717964	96b1d10c-2ad4-4827-82d5-7b1fe60ad546	0101000020E6100000C9B8A007701E54C08D13B2B5037C3940	0101000020BC0800006422B2C6C84D2941D58599806E8D1941
1228	4951	NW 32 AV	NW 48 ST	S	F	Y	1	0	0	9/1/2016 13:49	25.81722	-80.24876	903296.943420708	539964.575298093	d4f01eea-4476-44a7-9ad9-731aeba8f704	0101000020E61000001D3C2FB6EB0F54C0BBC83EA335D13940	0101000020BC0800005340D91700912B41BD0E078E7C7A2041
1229	558	SW 88 ST	SW 152 AV	W	N	N	2	0	1	9/29/2016	25.68468	-80.44081	840322.1228166	491477.728354752	50619207-f542-4203-85cc-6e015c94697c	0101000020E610000053EEAE46361C54C04953687E47AF3940	0101000020BC08000092889C6B02A529419CD007AC5DFF1D41
1230	2141	W 8 AV	W 70 PL	N	F	N	0	0	0	10/3/2016	25.88703	-80.2996	886435.037835609	565245.788816236	40511bfe-f35b-4f0d-b68b-bd3918db7ab6	0101000020E61000003D8CA3C12C1354C0199AF7B414E33940	0101000020BC0800004475FC45440D2B41D13B9CFEFE3F2141
1231	4944	NW 32 AV	NW 60 ST	S	N	Y	0	0	0	9/1/2016 13:29	25.82922	-80.24931	903094.736167099	544324.430398725	0ca128b4-239a-40d6-b9f9-eeb9aef58bfa	0101000020E61000004806EA8AF40F54C0C25955F047D43940	0101000020BC0800002029BCAD6B8F2B41D9FD6D448C9C2041
1232	8749	NE 16 AV	NE 133 ST	N	N	N	0	0	0	11/14/2002	25.89827	-80.16658	930144.674131818	569586.112807833	0cf8a38a-bd11-4e10-a932-d99839b25e22	0101000020E6100000BBA5934EA90A54C01A816C33F5E53940	0101000020BC0800007A9C6B91BF622C413ED136A5E7612141
1233	1010	W 29 ST	W 16 AV	E	M	N	1	0	0	10/3/2016	25.84793	-80.31321	882037.317276053	551010.299250953	a14e5b46-c2de-47ee-aea4-89e3da0e4138	0101000020E61000002890939C0B1454C08801E02E12D93940	0101000020BC080000D5727DD4E8EA2A4164F90F02C8D02041
1234	3991	SW 137 AV	SW 62 ST	N	N	Y	2	0	1	9/26/2016 12:43	25.70951	-80.41474	848868.170026429	500540.506844163	1a346cac-5b29-4c10-8d06-729f68a92f4a	0101000020E6100000C88CF4208B1A54C05B3F20F3A2B53940	0101000020BC080000C5AEEB84C6E72941ADA26FCBF88C1E41
1235	8401	BISCAYNE BD	NE 91 ST	SW	F	N	1	0	1	10/8/2016	25.85863	-80.18369	924609.288550723	555144.145964935	d3d2b29b-a5c1-48f5-b191-0316eb6d48df	0101000020E6100000153323A3C10B54C01239839DCFDB3940	0101000020BC08000057D84BCB80372C41494D34B413F12041
1236	1784	NW 87 AV	NW 41 ST	S	N	N	1	0	1	11/9/2016 12:09	25.81232	-80.33758	874086.904729012	538026.260929935	59c01e75-71c8-492c-b815-27180d8277b8	0101000020E610000090C32DEC9A1554C097630E72F4CF3940	0101000020BC08000094103D00CCAC2A41A8EFCFEC576B2041
1237	135	NW 17 AV	NW 79 ST	S	N	Y	1	0	0	8/22/2016	25.84686	-80.22548	910892.677574858	550782.54218062	b0abd2db-7eb6-4540-975f-3a2abc0d517c	0101000020E6100000342760426E0E54C0EE13D730CCD83940	0101000020BC080000B191AD9057CC2B413F47807E00CF2041
1238	2973	US 1	SW 238 ST	SW	F	N	0	0	0	10/23/2002	25.54546	-80.40239	853203.59381621	440931.936113141	c9aa4e41-979a-431a-bee9-3c8b98933145	0101000020E6100000937344C9C01954C0301FED3DA38B3940	0101000020BC0800005D837F5EA5092A41C87F817396E91A41
1239	6173	NW 13 AV	NW 163 ST	S	F	N	1	0	1	10/17/2016 13:4	25.92189	-80.22155	912021.171993148	578060.279298812	737f1a96-25f8-4524-b6d7-55a67f3e63cf	0101000020E6100000679D1EFC2D0E54C03883562901EC3940	0101000020BC080000851A008E28D52B41CD1E63FB1BA42141
1240	7009	NW 3 AV	NW 15 ST	N	F	Y	1	1	1	11/8/2016 13:41	25.78986	-80.19991	919427.193310637	530115.571035862	cbb930ce-392c-487d-9726-fc5c3dd8b5bb	0101000020E61000002016C262CB0C54C0CDBE12B434CA3940	0101000020BC0800001CC7F799040F2C41FDDCA68A8A2D2041
1241	2362	W 29 ST	W 6 AV	W	N	Y	1	1	1	10/3/2016	25.84811	-80.29399	888357.193093337	551108.489673525	5eb29f28-f29e-4f62-9bab-a3e908999687	0101000020E6100000AFB49CC2D01254C0A9BE39D91DD93940	0101000020BC080000C5C5CB95481C2B41F31894638CD12041
1242	1731	INGRAHAM HY	RIDGEWOOD RD	W	F	N	0	0	0	9/22/2016 13:43	25.70832	-80.25797	900489.254468191	500365.189588785	3ff9a1f3-894e-4c1e-accd-8f65110612c7	0101000020E610000077711CA4821054C04DF3A09154B53940	0101000020BC080000B421DBB6107B2B41D4B4B1863B8A1E41
1243	6132	NW 7 AV	NW 214 ST	S	F	N	1	0	1	10/28/2016 12:0	25.97134	-80.21493	914094.556968786	596049.264327176	57bd2f39-4485-4514-8837-888e41ece6cd	0101000020E6100000FF4CB742C10D54C0A2EB8E4FAAF83940	0101000020BC08000055274E535BE52B41C64816F6A5302241
1244	5318	FOUNTAINEBLEAU BD	OP # 9361	E	F	N	1	1	1	9/6/2012 13:09	25.77363	-80.34895	870414.563311171	523947.140132971	6db79864-5cec-440a-b1ea-57eeb7c364be	0101000020E6100000DB463446551654C056824C2F0DC63940	0101000020BC080000BBCF03511B902A41A073405AB3FA1F41
1245	4895	NW 32 AV	NW 30 ST	N	F	Y	0	0	1	8/31/2016	25.8037	-80.24811	903537.542015318	535051.370856255	379cfa83-f3de-4573-91d4-32cde1349ac8	0101000020E610000036F7A820E10F54C0171F7586BFCD3940	0101000020BC080000E4725E4AE1922B413DFDB3241A542041
1246	733	ALTON RD	LINCOLN RD MALL	N	F	Y	0	0	0	8/20/2002	25.79097	-80.14108	938782.474112205	530641.326854318	3453dc28-2a86-4636-bb10-1c5da877086f	0101000020E6100000DA39FA87070954C0FC4197837DCA3940	0101000020BC0800006872382C3BA62C41D858C50DA6312041
1247	10202	NW 33 AV	NW 49 ST	N	N	N	0	0	0	10/21/2016 11:4	25.81905	-80.25077	902630.923406117	540627.031643912	cd887787-2a32-4f81-b8c5-f483ee2ae013	0101000020E6100000622752B10C1054C0284DE4C3ADD13940	0101000020BC0800009908880DCC8B2B41266CCE77A97F2041
1248	227	BUSWAY	SW 200 ST	N	F	Y	5	1	2	9/29/2016 14:27	25.5805	-80.36824	864401.146527044	453719.59226802	43d3cda2-b008-46a0-a35f-458a134080c5	0101000020E61000003663B75A911754C0312C83B09B943940	0101000020BC080000D062FC7A20612A4108A1DB1665B11B41
1249	8506	NW 36 ST	DE SOTO DR	W	N	N	1	1	1	11/8/2016 12:01	25.80814	-80.27723	893949.855157599	536610.036051221	58c389d4-3cd2-45d3-ba1f-d98a341c1991	0101000020E61000008D8BA921BE1154C0B6A02E3EE2CE3940	0101000020BC0800003E0082E9F9472B41B3CC787947602041
1250	2358	W 29 ST	PALM AV	E	N	Y	1	0	0	10/3/2016	25.84823	-80.28305	891955.294808667	551174.495799012	30b28258-4110-4594-ae51-d60d7e8452fe	0101000020E610000074FCB8801D1254C08214BB3C26D93940	0101000020BC08000076AD3FCA64382B41F855D46610D22041
1251	7226	NW 17 AV	NW 21 TE	S	F	Y	0	0	1	8/22/2016	25.79621	-80.22342	911678.898441125	532375.459269121	a39ad93e-9d9c-4b33-885e-88a09e437f27	0101000020E6100000309819824C0E54C08DA78687D4CB3940	0101000020BC080000B8B6F3017CD22B41C8779751323F2041
1252	5705	NE 22 AV	NE 191 ST	N	N	N	0	0	0	11/1/2016 13:14	25.95169	-80.15691	933199.785187483	589024.791837484	42257066-a8df-4e62-a217-06a704c810fc	0101000020E6100000FC5912D30A0A54C054B4A565A2F33940	0101000020BC0800007C9393CA9D7A2C41BDE05203C5F92141
1253	127	NW 71 ST	NW 12 AV	W	F	Y	1	1	1	11/8/2016 14:18	25.83947	-80.21739	913573.045257658	548111.56558153	2c786a72-24b1-4111-907f-552a3c24cf86	0101000020E6100000B7B14E88E90D54C0D6FC9FBFE7D63940	0101000020BC0800006699534D48E12B41D624198A22BA2041
1254	6790	NE 2 AV	NE 24 ST	N	N	Y	1	0	1	11/4/2016 10:34	25.79977	-80.19081	922400.101702165	533734.385648072	0955bfd9-6185-4a08-92dd-98741e60fcca	0101000020E61000001D203242360C54C0603D3BE7BDCC3940	0101000020BC08000020EC596B3E262C4103FA392CD0492041
1255	9563	SW 193 AV	SW 378 ST	N	N	Y	0	0	1	10/21/2016 12:4	25.41657	-80.50331	820102.28862438	393954.605841875	915b8177-2b9e-40e4-9d55-ad9136496d88	0101000020E61000007A605053362054C0025CF9E4A46A3940	0101000020BC080000B9D314BE0A07294109961215910B1841
1256	211	NW 27 AV	NW 113 ST	N	F	Y	1	0	0	9/19/2016 11:28	25.87773	-80.24271	905159.182154059	561969.411182076	92bb2aba-58c9-4665-b10e-c511a21cd2e2	0101000020E6100000D8906CA7880F54C06779DA38B3E03940	0101000020BC08000044003A928C9F2B41FF25F23C66262141
1257	7805	NW 20 ST	NW 8 AV	W	F	Y	0	0	0	8/31/2016	25.79525	-80.20935	916309.181161147	532055.168531105	cec48f3b-cc32-4a22-8920-6311d3601513	0101000020E610000088DDFF0C660D54C03566B9CF95CB3940	0101000020BC080000E04E5A93A8F62B41FE9CBBBCB13C2041
1258	1952	E 8 AV	E 39 PL	N	N	Y	1	0	0	2/14/2017 16:31	25.8585	-80.26649	897381.177652605	554934.451874264	66b2f8a9-b84c-4925-8a60-1501b9795a0b	0101000020E6100000F6B9D42A0E1154C05FC08EC4C6DB3940	0101000020BC080000A304058FC8622B41D1AEB65070EF2041
1259	9910	SW 152 ST	SW 133 AV	E	N	N	2	0	0	11/18/2016 16:1	25.62627	-80.40834	851109.154057439	470294.035491906	7592a83e-af38-4502-8de5-e51ffd3aef66	0101000020E6100000F52E5D5A221A54C0C9C3A45653A03940	0101000020BC08000026080A7D48F92941CD7ACFE05EB41C41
1260	5536	NW 17 AV	NW 119 ST	S	N	Y	1	1	1	8/22/2016	25.88374	-80.22686	910357.920114785	564183.884151891	2dbb4d4a-9882-4a21-a42d-693d28cbca3a	0101000020E61000000426AFF7840E54C00D2F2C073DE23940	0101000020BC08000089C4C20C2AC82B4109C74A2FB3372141
1261	6730	BISCAYNE BD	OP # 4301	NE	M	N	1	1	1	9/8/2016	25.81614	-80.18827	923198.14082434	539689.144753747	80009d37-2028-4fd0-bed8-f73c450c9acb	0101000020E6100000259E3EB10C0C54C0368A8BA9EED03940	0101000020BC080000164D8D7F7A2C2C41E8299DB155782041
1262	9111	SW 174 ST	SW 97 AV	W	N	Y	1	0	1	11/17/2016 13:4	25.60838	-80.34837	870901.258861605	463884.256989889	f9217b23-e455-4ba0-a987-451245ae4580	0101000020E610000087CBAEC94B1654C0CFB76DD5BE9B3940	0101000020BC080000F53D5EB5E8932A41724240C237501C41
1263	5146	NW 79 ST	NW 15 AV	W	N	N	0	0	0	10/20/2016 12:3	25.84672	-80.22315	911657.660605747	550735.443213895	eedf7649-1f3c-44e3-8baf-98c9845a54a7	0101000020E61000005F9A9D2A480E54C0157778E2C2D83940	0101000020BC080000AB77128851D22B4177C3C44BA2CE2041
1264	10008	SE 8 AV	S ROYAL POINCIANA BLVD	N	F	N	0	0	0	9/16/2004	25.80973	-80.26453	898124.900957331	537212.18548701	a4dd1aec-65d6-4b7a-bf16-0909468bb576	0101000020E610000053D7FC0DEE1054C0E7D750A44ACF3940	0101000020BC080000A1D1790198682B416D7C12C6FB642041
1265	3574	SW 176 ST	SW 103 AV	E	N	Y	0	0	0	11/17/2016 11:4	25.60589	-80.3591	867370.268882204	462963.846746027	98c25bab-3451-4d06-b8a2-2d9c10bdae8e	0101000020E6100000C5F7308EFB1654C06D0406FA1B9B3940	0101000020BC080000D182E9B952782A41CD71DF1DD6411C41
1266	2928	71 ST	INDIAN CREEK DR	E	F	Y	1	1	1	10/20/2016 12:2	25.8559	-80.12459	944050.818603456	554277.008643933	11eb4453-8be1-4d03-99b6-c718ca44dcc2	0101000020E6100000FACA4764F90754C056BFBAB31CDB3940	0101000020BC080000834127DD63CF2C417EEEDC6D4DEA2041
1267	7204	NW 16 AV	W FLAGLER ST	S	N	Y	0	0	0	9/16/2002	25.77379	-80.22142	912383.163417816	524230.431230329	e6aa8d0e-e69a-431e-9450-90831f81148d	0101000020E61000008217A7D62B0E54C02C37403617C63940	0101000020BC08000069B6AD89FCD72B41B15B798420FF1F41
1268	7679	NW 54 ST	NW 2 AV	W	F	N	1	1	1	10/19/2016 12:5	25.82526	-80.20029	919228.576271519	542980.518078625	c6edf3ea-23fe-40b0-8e87-868f8a5532a5	0101000020E6100000D532E161D10C54C0AF7F557B44D33940	0101000020BC080000ED7CF25D770D2C4107882D710C922041
1269	3461	SW 104 ST	SW 123 CT	E	F	Y	1	1	1	9/29/2016 14:34	25.67139	-80.39453	855587.077230856	486715.323866919	c8fe0ae8-b901-487f-9c96-d6fface1f5f4	0101000020E6100000D20775F53F1954C0D76DB9A6E0AB3940	0101000020BC08000031624856441C2A410433B30CF4B41D41
1270	8029	W FLAGLER ST	NW 9 AV	W	F	Y	0	0	0	9/8/2012 10:56	25.77377	-80.20962	916266.533635147	524247.372810505	ae3e3e92-ef97-4c9f-8d67-485a3d6111c5	0101000020E610000087A0D9816A0D54C0AA81091916C63940	0101000020BC08000059AAC44753F62B4106729F4864FF1F41
1271	8538	NE 35 AV	NE 166 ST	N	F	Y	1	1	1	11/3/2016 13:19	25.93285	-80.13712	939750.674958359	582218.15844588	226d6037-7303-42c3-b926-000b19225e66	0101000020E61000004AC33674C60854C013317C80CFEE3940	0101000020BC0800007E8B0993CBAD2C41FD0821BE97C42141
1272	9963	NE 203 ST	NE 26 AV	E	N	N	0	0	0	11/29/2004	25.96336	-80.1503	935342.377375543	593279.158958279	3184bab0-8c3d-4ff5-bb41-e78d241f5a51	0101000020E6100000369EE09F9E0954C052B1B1F09EF63940	0101000020BC0800009B5117FA5A8B2C4113E3D5BF011B2241
1273	8549	BISCAYNE BD	NE 140 ST	N	M	Y	2	1	1	10/8/2016	25.90618	-80.15844	932802.946715984	572477.927605405	9cdab6f1-6768-47a2-a8b4-39b34f893495	0101000020E6100000D1BA8BE8230A54C07E377686FBE73940	0101000020BC08000002E43F1D84772C416925A5467F782141
1274	8963	NW 27 AV	ALI BABA AV	N	N	N	1	1	1	9/19/2016 12:30	25.90493	-80.24376	904757.282004748	571853.438686796	3013c16e-08e0-4e4b-8725-f8df10d82a32	0101000020E6100000F54240D7990F54C0A8A477BCA9E73940	0101000020BC080000377A5FC5689C2B414578494C9E732141
1275	2041	E 4 AV	E 37 ST	S	F	Y	0	0	0	10/3/2002	25.85586	-80.27475	894667.780864574	553962.348807037	b93c0f4d-e1ee-44b6-9b24-190147c7983d	0101000020E610000056F3279D951154C02C7B24361ADB3940	0101000020BC080000BA256BC3954D2B417FBDF01BD8E72041
1276	3467	SW 107 ST	SW 109 CT	SW	F	Y	1	1	1	9/29/2016 15:22	25.67002	-80.37225	862927.498534653	486249.425505467	7827f5f8-2e16-48b3-9876-095cf2d31356	0101000020E6100000E58588F0D21754C0FFE2467986AB3940	0101000020BC080000A34D002F9D552A41BC348774ACAD1D41
1277	8546	BISCAYNE BD	# 13675	N	N	Y	2	0	1	10/8/2016	25.90184	-80.15977	932373.86425098	570897.992745355	75512007-d2ed-4f01-9616-10a0445c88e4	0101000020E6100000646323CC390A54C06C1A192ADFE63940	0101000020BC0800001CD5F7F229742C41DE53D767276C2141
1278	7852	NW 17 ST	NW 7 AV	W	N	N	0	0	0	11/8/2016 13:43	25.79163	-80.20655	917237.422392875	530745.681671523	88ebe689-8b81-494e-8568-cff52a1f45c6	0101000020E6100000B3228839380D54C0FDCBC0B3A8CA3940	0101000020BC0800009C8EED0EE9FD2B41A26B49C376322041
1279	2198	W 12 AV	W 78 ST	S	N	Y	0	0	0	10/10/2016 14:0	25.89323	-80.30806	883642.348222278	567483.43890591	b9729ef9-c6c6-4c87-9bf3-979a25b494a8	0101000020E6100000B03D1355B71354C0780569D5AAE43940	0101000020BC080000D4BE88E472F72A417356B44B7A512141
1280	5721	NE 18 AV	# 18901	N	N	Y	0	0	0	11/13/2002	25.95	-80.16519	930484.822768018	588391.638194047	c25d37c2-bea3-4404-883d-92b32412fc6e	0101000020E6100000D073C062920A54C08113076133F33940	0101000020BC080000CC9773DD67652C417BE9A1B4D2F42141
1281	8736	NE 16 AV	NE 143 ST	S	F	Y	0	0	0	11/14/2002	25.90705	-80.16714	929941.625026565	572775.532004885	5c4ff99e-639e-4987-8305-b0821aeb82de	0101000020E6100000D8B59C6AB20A54C09E76DF7934E83940	0101000020BC080000BBAC337829612C4147B1387CD27A2141
1282	3997	SW 137 AV	SW 42 ST	N	N	Y	2	0	1	10/13/2016 14:1	25.72884	-80.41548	848591.770311628	507563.520325631	40c1169f-34fd-4b30-9726-9acae041db17	0101000020E61000007C02B655971A54C0C496B07F95BA3940	0101000020BC080000D17443B89DE52941F48A3CDBB4FA1E41
1283	9939	SW 8 ST	SW 89 AV	E	F	N	2	0	0	3/25/2005	25.76169	-80.33988	873423.464744687	519620.484420203	68ee9454-7ec3-4601-a810-1641962c1589	0101000020E61000000E057F8EC01554C0BC61675BFEC23940	0101000020BC080000D63DE71E9DA72A412779B2B918B71F41
1284	8879	NW 125 ST	NW 10 AV	E	N	N	0	0	0	10/31/2016 16:4	25.88898	-80.21511	914212.797211338	566110.33170183	fc156b32-0d5b-4766-99a5-7a7be5033cda	0101000020E61000005112DA4EC40D54C0AD967A3D94E33940	0101000020BC08000053BE5ACE47E62B414922C214C0462141
1285	4550	SW 8 ST	FLAGAMI BD	W	N	N	0	0	0	9/8/2016 11:09	25.76277	-80.31667	881058.094168212	520053.025880791	44ef1190-1a24-4558-b11b-5ef077827894	0101000020E6100000A2310866441454C06FED205545C33940	0101000020BC080000A601246242E32A412FBC2CE4DABD1F41
1286	9632	NW 10 AV	NW 65 ST	N	F	Y	0	0	0	9/23/2016 13:56	25.83463	-80.21262	915146.579831004	546362.437476009	0ef96b24-48dd-4ca3-88c4-c6cad0b561ff	0101000020E610000011D0F7AC9B0D54C03A826EAFAAD53940	0101000020BC08000026F7315F93ED2B418AA0454878AC2041
1287	10252	SW 72 ST	SW 57 AV	E	F	N	0	0	0	9/22/2016 12:21	25.70438	-80.28502	891589.804758534	498886.939625062	c4894840-9370-4dec-b1d5-55d13490ff37	0101000020E610000041BB43D83D1254C0AF3697E152B43940	0101000020BC080000BA1D6DCF89352B41A12F4B8622731E41
1288	3515	SW 152 ST	SW 130 AV	W	F	Y	1	0	0	11/17/2016 11:5	25.62669	-80.40325	852785.579533219	470456.387552649	8ddb2bcf-2bb0-4dea-8105-12850abe4748	0101000020E6100000DB7259F5CE1954C050EEBF416FA03940	0101000020BC080000791B145761062A41D86DA749E8B61C41
1289	8043	W FLAGLER ST	NW 33 AV	W	N	Y	1	0	1	9/8/2012 11:36	25.77211	-80.24968	903086.741061244	523566.219973274	ba10b899-6695-4971-bd79-b0ada2f730e0	0101000020E6100000061286D5FA0F54C005714B2DA9C53940	0101000020BC080000DF014EB05B8F2B413C9B01ACBFF41F41
1290	7604	NE 79 ST	NE 7 AV	W	N	N	0	0	0	10/20/2016 11:4	25.84798	-80.18256	925009.930797674	551274.06446036	5d38114a-9378-49b9-9f8c-438ab74dca9b	0101000020E61000009502A8E0AE0B54C0C805026515D93940	0101000020BC080000EC023D14A23A2C417941028AD7D22041
1291	5246	NW 36 ST	OP # 6355	E	F	N	1	1	1	11/11/2016 12:4	25.80712	-80.30026	886375.650149815	536201.264585905	9fcf76ed-0d59-40b8-9142-92e58ab274a6	0101000020E6100000149F206C371354C0CE93A4EB9FCE3940	0101000020BC080000CBEC7C7FCD0C2B41834680EE155D2041
1292	4257	SW 72 ST	SW 142 AV	W	N	Y	2	0	0	9/26/2016 14:02	25.69984	-80.42177	846572.780601885	497015.016484074	4f640101-26df-44e1-9f9b-86a65edb74eb	0101000020E610000042C4951CFE1A54C03A73D81529B33940	0101000020BC080000546244BDD7D529417A4374D4E2551E41
1293	2244	W 16 AV	W 37 ST	S	F	Y	1	0	0	10/3/2016	25.85495	-80.31463	881555.02164752	553558.280086145	48095db3-070c-428d-831d-6d98e8e9895b	0101000020E61000009A76A7F9221454C01445A20CDEDA3940	0101000020BC080000A7BE1A3D24E72A41959D8FF8AFE42041
1294	595	W FLAGLER ST	NW 1 AV	W	N	Y	3	1	1	11/20/2002	25.77422	-80.19524	920998.281337179	524438.490557462	9e37687c-e035-4f30-9f07-577a82031d7c	0101000020E6100000F89A8BE37E0C54C0E4C8776433C63940	0101000020BC08000029A041C74A1B2C41AA2DA76030012041
1295	2144	W 8 AV	W 77 ST	N	F	N	1	0	0	10/3/2016	25.89293	-80.29986	886340.742714614	567389.801955253	109d790e-e49d-4b59-86e3-5efa067b625f	0101000020E6100000E0569BE2301354C0A804955E97E43940	0101000020BC080000CF0BC9AE870C2B41F725A305BF502141
1296	2282	HIALEAH DR	SE 10 CT	E	M	N	1	0	0	10/19/2016 12:3	25.82326	-80.25921	899846.807243105	542138.958441056	6168fa90-ce6d-4030-b890-6c3d583c8feb	0101000020E6100000C45BADEC961054C070D78B36C1D23940	0101000020BC0800001DB3A4D10B762B4112E08552798B2041
1297	8747	NE 16 AV	NE 127 ST	N	F	N	0	0	0	11/14/2002	25.89364	-80.16638	930222.093974035	567905.468260743	bd484f4a-e760-444b-99ee-4c79fb53afad	0101000020E6100000749A22FBA50A54C0CBACC618C6E43940	0101000020BC080000960B4E685A632C41D8AAEF5AC6542141
1298	604	NW 57 AV	NW 167 ST	S	N	N	1	1	1	10/26/2016 14:2	25.92641	-80.29341	888394.689113822	579571.898618497	50d92fba-9856-4af7-a553-d98f1e3e6bd0	0101000020E61000000E6CEC41C71254C001BCCCD729ED3940	0101000020BC080000E8CDB493931C2B41E1D9B738EBAF2141
1299	4739	NW 14 AV	NW 95 TE	N	N	N	0	0	0	8/18/2016	25.86206	-80.22178	912074.561037805	556313.722403593	3dc15fc5-99c5-46d5-9075-60bb706b5732	0101000020E61000006978CDC0310E54C066EC0735B0DC3940	0101000020BC080000FCF93E5593D52B41E1CE78DB36FA2041
1300	9207	COLLINS AV	186 ST	S	N	Y	1	1	1	11/3/2016 14:57	25.94884	-80.12097	945017.55352189	588066.192364961	11335518-c6e8-4f21-9d7f-5fefc9adb9b8	0101000020E61000009C8A59F3BD0754C06017CD8DE7F23940	0101000020BC08000055F28B55F1D62C41C17853D047F22141
1301	7134	NW 12 AV	NW 14 ST	S	F	Y	1	1	1	2/22/2017	25.7869	-80.21512	914428.734453145	529007.773725405	e08ed23c-29c3-428d-9544-bde12a20c817	0101000020E6100000977C2496C40D54C0B4289A6372C93940	0101000020BC0800001A0A4BAEF7E72B41C86335F2E2242041
1302	264	MDCC-S	SW 109 CT ENTRANCE	W	T	N	3	0	2	8/17/2016	25.6737	-80.37306	862656.996121749	487586.405743755	81e4131c-8fd7-4d32-b937-eb3bc4d62999	0101000020E610000033295D14E01754C040F4FEC677AC3940	0101000020BC080000FC5EB82D80532A416EA99A6090C21D41
1303	2208	W 12 AV	W 51 PL	S	N	Y	0	0	0	10/10/2016 14:3	25.86933	-80.30703	884027.478332125	558801.29580728	410b2dfe-f813-49c0-8fa0-b0e22c6c3e18	0101000020E610000098DA8C6CA61354C0D2EF0E0C8DDE3940	0101000020BC080000A87E272775FA2A41A8D24601A60D2141
1304	7850	NW 17 ST	NW 4 AV	W	N	Y	0	0	0	11/8/2016 13:42	25.79171	-80.20166	918848.920178827	530784.500511862	7259b34e-610e-4da7-9348-e682aa0837cb	0101000020E6100000716CD2F9E70C54C0074CEFF1ADCA3940	0101000020BC080000EE1A030E800A2C41A5399A66C4322041
1305	3933	SW 131 AV	SW 11 ST	S	N	N	0	0	0	10/8/2002	25.75712	-80.40705	851323.123141572	517854.778322816	afa29702-8c4e-427c-91ea-715f95e1b679	0101000020E6100000F6BB5C1A0D1A54C06BF642ECD2C13940	0101000020BC080000D7C6406DF4FA29419FB228E6819B1F41
1306	1497	PONCE DE LEON BD	DICKENSON DR	S	N	Y	0	0	0	10/12/2016 15:2	25.7133	-80.2795	893391.097723201	502136.333344489	d37909c8-d04c-412f-8422-c7d0ef433b9b	0101000020E61000004DA6EB56E31154C08D43F6009BB63940	0101000020BC080000F3DFAF659C432B4178D1891AE8A51E41
1307	9179	SW 112 ST	SW 62 AV	E	N	N	1	0	1	11/30/2016 16:1	25.66717	-80.29444	888564.757676158	485344.954206109	9973a631-8a2f-4b8f-8ea8-48ff6add37c8	0101000020E6100000C3F6E4F3D71254C064BFE416CCAA3940	0101000020BC080000E39DE4B6E71D2B41DE1DE0918A9F1D41
1308	7975	NW 7 ST	NW 57 CT	E	F	Y	0	0	1	9/6/2012 15:09	25.77787	-80.28899	890140.565871686	525589.126372136	0000d03b-7f97-4040-a0b6-f485470a3ccd	0101000020E6100000409F7ECA7E1254C05D7464DC22C73940	0101000020BC08000073F6E054372A2B417F4F38A62D0A2041
1309	8890	NE 125 ST	NE 7 CT	E	F	Y	1	0	1	10/31/2016 16:5	25.89032	-80.18327	924677.394744739	566663.81490393	6eebbbad-b6b7-4163-847a-226ee5168d2e	0101000020E61000000DBB8FACBA0B54C04F3F6884ECE33940	0101000020BC0800004424A30109382C4123C54B0C134B2141
1310	9665	SW 187 AV	SW 354 TE	N	N	Y	0	0	1	10/21/2016 12:1	25.4382	-80.49327	823385.619664986	401827.089082718	a1af1dc9-d807-45a5-a920-531d9634d7e8	0101000020E6100000D48EE0DC911F54C01B8FE83D2E703940	0101000020BC08000068B2FE67B1202941A2E7C60593861841
1311	116	NW 9 AV	NW 17 ST	S	N	Y	1	1	0	9/26/2016 15:29	25.79193	-80.21032	915996.929813791	530845.450809672	493662e5-aaa2-44ad-a611-514c3357aa53	0101000020E6100000EADBACF5750D54C0FD620409BCCA3940	0101000020BC080000BCB0801238F42B41A998104D3E332041
1312	4383	SW 57 AV	SW 35 ST	S	F	N	1	1	1	12/1/2016 12:44	25.73766	-80.28678	890945.90544473	510979.372766681	10d87ee2-662a-40d9-980b-b715456dce17	0101000020E6100000C3A4A8A15A1254C07A43B4DAD7BC3940	0101000020BC0800003014EA0282302B41BE9D2A4514301F41
1313	10569	HARRISON ST	BOGGS DR	E	F	Y	0	0	0	11/17/2016 12:5	25.63496	-80.37539	861956.355139293	473504.467703462	f93eb218-95f7-4e5d-9feb-a674906e8c18	0101000020E610000025EDE53C061854C019AD5D3D8DA23940	0101000020BC080000704A7BE5064E2A41711D6F9C88E61C41
1314	1334	NW 211 ST	NW 37 AV	W	F	Y	0	0	0	11/10/2016 13:4	25.96742	-80.26234	898524.835528057	594531.249312811	d407e3a5-17fb-448f-824c-41b83904b6f2	0101000020E61000009C398117CA1054C03B5A64F3A8F73940	0101000020BC08000068CFE1DFB76B2B41967E33EEC9242241
1315	4278	SW 72 ST	SW 113 PL	E	F	Y	1	1	1	9/26/2016 12:22	25.70061	-80.37638	861513.735991791	497362.113557257	a7122cd3-ed90-4266-8764-a3e236ed00fb	0101000020E610000029D799A7161854C03BB4C36A5BB33940	0101000020BC08000062F13FA8914A2A411154F3374F5B1E41
1316	36	BISCAYNE BD	NE 123 ST	S	F	Y	4	1	1	10/8/2016	25.88911	-80.16396	931026.248173673	566261.072588459	cdffdd78-fcc9-45d2-8140-30e74421d866	0101000020E61000008C5D156E7E0A54C0BDE6BEB19CE33940	0101000020BC08000039BF5FB7A2692C41A7701190ED472141
1317	3038	SW 87 AV	OLD CUTLER RD	S	F	N	1	0	1	10/4/2016 11:36	25.57932	-80.33188	876390.633347321	453351.980824724	6ae4cca1-2375-46e5-81ff-3df6f45c3a7f	0101000020E6100000BA126C843D1554C06F55D9D04E943940	0101000020BC080000DEA7B675CBBE2A415FA2B6A4A6AB1B41
1318	1171	SW 42 AV	W FLAGLER ST	N	N	N	1	0	1	2/13/2017 15:27	25.77138	-80.2635	898540.730124846	523276.69006519	2f41ee81-f8ab-4f34-aa44-3389c7ab25d1	0101000020E610000017306F3ADD1054C0ECE8039979C53940	0101000020BC0800001A551AAAD76B2B411CB2268D39F01F41
1319	3868	SW 112 AV	SW 47 TE	S	F	N	1	1	1	10/27/2016 19:5	25.72243	-80.37536	861812.094302345	505295.735495046	0e742e1a-99c2-416e-9f20-66b474fda6fb	0101000020E610000032FE68F1051854C01AA0D4ACF1B83940	0101000020BC08000080E2DB5FE64C2A4180D0E0B645D71E41
1320	2533	NE 15 ST	KROME AV	W	N	Y	0	0	0	10/28/2002	25.48451	-80.47694	828708.877378229	418678.720404178	0eb6511a-a742-4318-a05e-e923a00b3826	0101000020E6100000FBF9AF4B861E54C01915FE36097C3940	0101000020BC080000D7B695EC474A2941E1BCE390E18D1941
1321	6267	NW 27 AV	NW 163 ST	S	F	N	0	0	0	11/10/2016 13:5	25.92208	-80.24463	904434.709529862	578085.675565518	7ca2f766-d82c-48a6-8cbd-a9384dd2d3c5	0101000020E6100000AE22B020A80F54C0DB8591BE0DEC3940	0101000020BC0800004E312FA0E3992B41B3AA5DC64EA42141
1322	5984	NE 205 TE	NE 15 AV	W	N	N	1	1	1	11/1/2016 16:49	25.9648	-80.17214	928164.97863213	593757.310560629	e6ccace6-c1b4-4746-a367-0a501e217fc1	0101000020E6100000B9AF575A040B54C0BE427371FDF63940	0101000020BC080000289EEB2C48532C41D04E9D0DBE1E2241
1323	9627	NW 10 AV	NW 53 ST	N	N	N	0	0	0	9/23/2016 13:21	25.82349	-80.21207	915352.078754093	542314.848127872	eaaf4d8a-9078-49d7-bfce-4601ff2805b5	0101000020E6100000D884E6A5920D54C037B2FCADD0D23940	0101000020BC0800005C18C25E2EEF2B41F809211AD98C2041
1324	2200	W 12 AV	W 71 ST	S	M	Y	0	0	0	10/10/2016 14:1	25.88689	-80.30778	883747.858155798	565182.460915014	532db2f7-8783-422e-b0f7-f03c4a76fbd1	0101000020E61000007CE7E4ADB21354C02F970ADC0BE33940	0101000020BC08000089CE8CE945F82A411259AA56803F2141
1325	8557	BISCAYNE BD	# 14100	S	N	Y	2	1	1	9/8/2016	25.9063	-80.15874	932708.630647771	572523.849061795	1bc150f8-f7f0-4f6d-9696-23285b655589	0101000020E610000080231E98280A54C05018F1E903E83940	0101000020BC0800001D02667BC7762C414C10721EDB782141
1326	5412	NE 12 AV	NE 144 ST	N	F	N	0	0	1	11/4/2016 12:15	25.90826	-80.17517	927302.446238972	573198.671247669	ca6bd937-f31e-4d5c-b7bd-fdc714b8da6f	0101000020E610000069E0F0D0350B54C045BD4BC683E83940	0101000020BC080000B6875D1C8B4C2C4139548DC3207E2141
1327	7867	NW NORTH RIVER D	NW 19 AV	W	N	N	0	0	0	11/19/2002	25.78815	-80.22697	910531.972233783	529439.800438039	f4802f61-499b-4f1b-a658-2d12cb257671	0101000020E61000009E918C79860E54C0C5DEB170C4C93940	0101000020BC080000CA579A2786C92B41870EFCFF42282041
1328	7806	NW 20 ST	NW 10 AV	W	F	Y	1	1	0	11/8/2016 13:44	25.79518	-80.2117	915535.111504588	532024.720085189	81af1a4f-bd5f-4d55-ad88-e6bafece53f4	0101000020E6100000BDB5339A8C0D54C0D3748E2891CB3940	0101000020BC080000C5AA826F9CF02B41D3972ED7743C2041
1329	5733	NE 10 AV	NE 167 ST	N	F	N	1	0	0	11/1/2016 12:28	25.92939	-80.18016	925609.787236672	580869.303211764	72810bd4-467e-40d7-ab50-bb22fc2494b7	0101000020E6100000FC070DC9870B54C021BB86AEECED3940	0101000020BC080000FEA0BECA513F2C41301C2C080EBA2141
1330	7229	NW 17 AV	NW 18 ST	S	F	Y	1	1	1	8/22/2016	25.79165	-80.22326	911740.992469527	530718.362160996	ab38bc99-cdf7-463e-8064-447c93e20990	0101000020E61000009DA234E7490E54C0238A64AFA9CA3940	0101000020BC080000647C1332F8D22B413156A71F40322041
1331	2663	HARDING AV	83 ST	S	F	N	1	0	1	10/11/2016 15:3	25.86782	-80.12235	944758.556666359	558612.731230341	f83354ba-ad02-4546-8aaa-2684e2b0bdea	0101000020E61000001BB709B1D40754C028DF4F9029DE3940	0101000020BC080000932F3257EBD42C41FC8574E02C0C2141
1332	2652	COLLINS AV	67 ST	N	N	N	1	0	1	10/11/2016 11:5	25.85042	-80.12024	945495.742237929	552295.09292803	499a83ec-f6e9-4bca-a18b-7ddfb834e8ec	0101000020E61000006B1F7812B20754C01DEF55A1B5D93940	0101000020BC080000476F43B6ADDA2C410C56B098D1DA2041
1333	131	NW 22 AV	NW 190 TE	S	N	Y	1	0	1	8/19/2016	25.94792	-80.23765	906676.579068273	587489.643321157	5ef04a72-4796-49db-b3a6-4457b5a5a9c2	0101000020E610000000E913A7350F54C0C653D7EEAAF23940	0101000020BC0800001E9A9F5D67AB2B4164311FB7C6ED2141
1334	1133	SW 27 AV	SW 8 ST	S	F	Y	1	0	0	9/19/2016 14:57	25.76493	-80.23894	906636.325500872	520978.999088846	61612be9-a223-40db-b45a-90e47b0f0455	0101000020E61000009752AFDE4A0F54C021F38405D3C33940	0101000020BC0800009F18E7DB16AB2B41360832C952CC1F41
1335	9049	FISHERMAN ST	OPA LOCKA BD	E	N	N	0	0	0	11/26/2002	25.90212	-80.25146	902235.168276839	570816.85744568	99c5c51f-5709-42ad-9feb-aaab73b8b767	0101000020E610000026EF75D5171054C0ADF7ED72F1E63940	0101000020BC0800002ACBB78AB4882B41DD069522856B2141
1336	4497	SW 87 AV	# 6000	S	F	Y	1	1	1	11/9/2016 17:10	25.71268	-80.33482	875176.657805368	501816.871751398	df4b13f0-b108-403d-82d5-e97117626022	0101000020E61000008F0279C06D1554C0B4182DA272B63940	0101000020BC080000E1AEFC814FB52A41AC35A641EAA01E41
1337	6774	NE 2 AV	NE 29 ST	S	N	Y	1	1	1	11/4/2016 11:25	25.80445	-80.19118	922266.271257959	535433.568607435	42c55f72-74ec-4e66-a7bf-a0c800ef7381	0101000020E6100000E4380F673C0C54C0B0F3496AF0CD3940	0101000020BC080000007536C232252C418892148A16572041
1338	6408	NW 167 ST	NW 13 AV	E	F	N	1	1	1	10/17/2016 14:2	25.92686	-80.22108	912164.915188521	579868.019791506	278c242b-ef55-434f-b1dd-bdaefb58eefc	0101000020E6100000F48ACC48260E54C00935E8F046ED3940	0101000020BC0800008905690A48D62B412F92CB763BB22141
1339	7689	NW 54 ST	NW 15 AV	W	F	Y	0	0	0	10/19/2016 13:1	25.82457	-80.22273	911842.72391523	542687.616109043	c60086bf-0bf2-4042-945a-7dbc92579435	0101000020E6100000D90B6451410E54C0C13CB6A717D33940	0101000020BC080000A022A2A8C3D32B4197F15BA3C28F2041
1340	216	NE 135 ST	W DIXIE HY	W	N	Y	0	0	0	11/14/2002	25.89989	-80.17797	926396.807305291	570150.949967332	6f992b64-efd6-487f-904e-f2fcffb3e6a9	0101000020E61000006A5385E7630B54C0AD3FBD4D5FE63940	0101000020BC080000B3240FD577452C419D40E15151662141
1341	6797	NE 2 AV	NE 40 ST	N	F	Y	1	0	1	11/1/2016 14:32	25.81375	-80.19132	922200.410504889	538815.730501868	caf108fc-2af8-42fe-b3b1-845ed4c77b4a	0101000020E6100000A023AEA53E0C54C0B717174B52D03940	0101000020BC08000090BD6609AF242C41712261DD82712041
1342	8618	NE 12 AV	NE 154 ST	S	F	N	1	0	0	11/4/2016 12:50	25.917	-80.17573	927095.092323504	576375.35120324	513f2d5a-ddcb-4bd6-b0f3-82f8571d2f62	0101000020E61000003696B2273F0B54C0F8E885C1C0EA3940	0101000020BC080000B34C1767EC4A2C41B1940520F2962141
1343	3848	SW 107 AV	SNAPPER CREEK DR	N	F	N	1	0	0	10/2/2002	25.70239	-80.36614	864882.234451048	498026.198879398	29642cd5-ab67-4f49-b2c1-d1341feb8dcc	0101000020E6100000CC151CE66E1754C0FF048F44D0B33940	0101000020BC080000A172F7A7E2642A4147E0A68FAF651E41
1344	4534	SW 87 AV	SW 2 ST	N	N	Y	2	0	0	10/31/2016 12:4	25.76751	-80.33622	874615.426963925	521742.581864372	7adbccc2-1ea6-4b96-92b2-cee295c35876	0101000020E610000009A780B0841554C08C5A5FE87BC43940	0101000020BC080000A23DBD0BEDB02A41A2F8091E41D81F41
1345	9669	SW 195 AVENUE RD	SW 194 AV	S	F	Y	0	0	0	10/21/2016 14:1	25.41693	-80.50531	819443.662599731	394081.544903524	7a112cf0-e0ab-4008-ac2a-197e50ab276e	0101000020E610000029E1C2FE562054C0A3A6A739BC6A3940	0101000020BC0800009CDA657DE501294165EA78D68C0D1841
1346	6603	NW 210TH ST	NW 30TH ST	N	F	N	1	1	0	10/28/2016 12:1	25.96809	-80.21903	912752.275197621	594856.98651579	2e972cd0-99ab-499a-9ef5-0240a67924e1	0101000020E6100000726EBA8C040E54C07AB960CBD4F73940	0101000020BC080000C40DDFC2DEDA2B416265CE6755272241
1347	6161	NW 12 AV	NW 178 TE	S	N	N	1	0	1	10/26/2016 12:2	25.93773	-80.22104	912157.528369699	583819.067634135	ba7d6778-d7f5-4273-a7bb-7b9ad9768f3f	0101000020E610000072B9477B250E54C0DF094B510FF03940	0101000020BC080000C15A664439D62B4109C7CA8F19D12141
1348	6344	NW 43 AV	NW 201 ST	N	F	N	0	0	0	8/31/2016	25.95628	-80.27192	895399.114048094	590466.356809132	b0028092-b772-4b05-88c4-f6df366c7c82	0101000020E6100000A4B05515671154C0DD890B35CFF43940	0101000020BC080000B2DE296E4C532B415A8DB02408052241
1349	4027	SW 152 AV	COTTONWOOD CR	S	F	N	0	0	1	10/13/2016 13:0	25.71572	-80.43841	841063.571178146	502764.064049266	e93c6e5e-8348-4c43-b174-9b8cb7d277d0	0101000020E61000006F00EF000F1C54C0D11370FE39B73940	0101000020BC080000197F5051CDAA29416B68A406B7AF1E41
1350	5407	W DIXIE HY	NE 143 ST	NE	F	Y	1	0	0	9/30/2016 14:09	25.90754	-80.17079	928738.320046943	572948.196323626	9b2a1828-8394-4122-a43b-d352945e8d4d	0101000020E610000035BD2F55EE0A54C022FD5CFB54E83940	0101000020BC080000F1A1ECDBC2572C4187636BD02B7C2141
1351	5191	NW 62 ST	NW 31 AV	E	F	Y	0	0	1	10/18/2016 15:1	25.83091	-80.24685	903899.091472592	544944.398996115	1b9671d7-fcb8-45b4-8686-351d83c419ec	0101000020E61000003FCFB34DCC0F54C036232BE4B6D43940	0101000020BC080000745BC463B4952B41E4BB763464A12041
1352	1641	SW 8 ST	GENOA ST	E	N	Y	0	0	0	9/8/2016	25.7637	-80.28104	892782.555297635	520453.78261403	efe365c5-3fc6-4efa-b312-109326b12c65	0101000020E61000009C9120A7FC1154C0C0BDBE5882C33940	0101000020BC08000038B2D44FDB3E2B41F49460EB1DC41F41
1353	3777	SW 288 ST	COLORADO RD	W	F	N	1	1	1	10/4/2016 12:53	25.4995	-80.44003	840864.789392002	424176.594930597	04b1118d-d33a-403c-90cd-25db4e493e43	0101000020E610000069C7226A291C54C045BF4EAADF7F3940	0101000020BC0800009B1210C13FA929410537BD11C9E31941
1354	6420	NW 171 ST	NW 37 AV	E	F	N	1	0	1	9/1/2016 13:27	25.9294	-80.26042	899230.437100701	580715.5944883	b9610b39-cfce-4495-a234-9ca34f10673e	0101000020E61000002CAD60CCAA1054C0B6567A45EDED3940	0101000020BC0800001A15FB133B712B41F218239DDAB82141
1355	1462	SW 37 AV	SW 8 ST	S	F	Y	1	0	1	9/22/2016 11:15	25.76434	-80.25522	901281.124603704	520734.321133934	9d845445-fe58-48e7-89fb-cf1333cdaf2c	0101000020E610000079350085551054C02D8EBA6BACC33940	0101000020BC0800000C286A7440812B41D11BEC1280C81F41
1356	8387	BISCAYNE BD	NE 93 ST	NE	F	N	1	0	1	9/8/2016	25.86114	-80.18135	925374.798218533	556059.441754065	34128287-29e4-4475-b2c5-68e94d34c40d	0101000020E6100000FFB67D379B0B54C0F8BB73C873DC3940	0101000020BC080000AE1450D07B3D2C41188AD74B3AF82041
1357	7598	NE 84 ST	N MIAMI CT	E	N	N	0	0	0	11/3/2016 16:42	25.85225	-80.19663	920368.984371923	552796.793038726	28e431f0-e861-4ad5-9d02-bce9aa667763	0101000020E61000008F87DC98950C54C0B13B2E1A2DDA3940	0101000020BC08000038FB0B2F60162C415FB834FFBCDE2041
1358	4310	SW 88 St	117 Ave Rd	W	N	Y	2	0	0	10/3/2002	25.68657	-80.38277	859433.071827017	492250.070652269	21ca01b1-71c7-42ea-90b8-b6291b64fe5b	0101000020E61000002A22675D7F1854C0741B246CC3AF3940	0101000020BC0800004F031054503A2A41F9DA940A6F0B1E41
1359	1822	NW 36 ST	NW 84 BLK	W	F	Y	1	0	0	11/8/2016 14:22	25.80998	-80.33471	875035.722040217	537179.799706645	086f5d41-c01a-4c25-9253-020822646854	0101000020E6100000439E53E26B1554C0110DCFF55ACF3940	0101000020BC0800001C3FE4A235B42A415CA58900BB642041
1360	304	SW 37 AV	CORAL WAY	S	F	Y	1	0	1	9/22/2016 11:48	25.74946	-80.25467	901492.73149604	515324.112469234	c71faa7c-844e-4b2d-bb84-5ea40c8b65e3	0101000020E6100000E16522824C1054C0E15378B8DCBF3940	0101000020BC0800002AF11CABE7822B41089AA33BF7731F41
1361	2554	NW 8 ST	NW 1 AV	W	F	Y	0	0	0	10/4/2016 15:22	25.47716	-80.48013	827667.319065928	416003.686712995	4169dc37-3852-4966-b1d8-61222349a162	0101000020E6100000760A548BBA1E54C037D73397277A3940	0101000020BC08000066338ACE2442294177568B6D15641941
1362	3811	BUSWAY	MARLIN DR	SW	F	Y	3	1	1	9/29/2016 12:39	25.58936	-80.36133	866665.960878797	456950.667489499	af0a504e-6f3b-4753-84c5-f14d426cb291	0101000020E61000002CD88402201754C00360B156E0963940	0101000020BC080000A5C4261CD2722A412A78AD64E1E31B41
1363	7044	NW 7 AV	NW 18 TE	S	F	Y	\N	\N	\N	9/20/2016 13:13	25.79296	-80.20705	917070.325630367	531226.649510734	d4bf1884-f009-4fd4-95f6-f2f33571544c	0101000020E61000004E0E7D66400D54C0E18F579AFFCA3940	0101000020BC080000798555DD9AFC2B410D77F1B238362041
1364	5491	NW 7 AV	NW 115 ST	N	F	N	1	1	1	9/21/2016 11:35	25.8804	-80.2103	915811.978096984	563004.501962706	a34d3374-1182-4c1f-bd95-f09c351a42d8	0101000020E6100000B527D28C750D54C0B51DEA8762E13940	0101000020BC0800003A0A3A2BC6F22B41879A716B7C2E2141
1365	2705	WASHINGTON AV	7 ST	N	F	Y	1	1	1	11/2/2016 13:03	25.77766	-80.1334	941341.42933872	525820.088806897	25a1b5d6-47fc-4ca2-82f2-d0d8be418d10	0101000020E61000003AFCB6B3890854C0D399CA3A15C73940	0101000020BC0800000C4C891539BA2C4144483793FB0B2041
1366	6772	NE 2 AV	NE 33 ST	S	F	N	1	1	0	11/4/2016 11:23	25.80723	-80.19126	922234.378963821	536447.124328665	1efc9949-6f2a-4105-a0c5-3a599153ff97	0101000020E61000007ADA37AE3D0C54C0C0C5F131A7CE3940	0101000020BC08000015523DF9F2242C41CCCAAEA6015F2041
1367	5874	NE 186 ST	NE 24 AV	W	N	N	2	0	1	10/27/2016 12:2	25.94744	-80.15256	934643.492562413	587489.631495096	95d656c8-c68d-4d24-b439-cece8c352bbf	0101000020E6100000C7365157C30954C04F053CEF8BF23940	0101000020BC0800006D81ED34E5852C413FD113B1C6ED2141
1368	5735	NE 10 AV	NE 171 TE	N	F	N	1	1	1	11/1/2016 12:39	25.93326	-80.18032	925548.39528599	582276.350253202	f8919be5-b1b0-481c-a69d-15c8ee6b7270	0101000020E6100000488224688A0B54C017E1E96FEAEE3940	0101000020BC0800002F47FF01D73E2C4103A460200CC52141
1369	7937	NW 7 ST	NW 12 AV	W	N	N	1	0	1	9/6/2012 13:46	25.78032	-80.2143	914716.441261452	526619.251278594	49af3795-1b4b-48ca-b3e5-09679a0628ca	0101000020E61000003809ACF8B60D54C035659C6CC3C73940	0101000020BC08000013FF3C1837EA2B4180BB6CE639122041
1370	1229	NE 54 ST	NE 1 AV	W	F	Y	1	1	1	42676.50625	25.82542	-80.19442	921159.178038176	543051.548768237	b6eb28de-1cf3-4a1b-b06d-2b1febb1ed6f	0101000020E610000045DE4E35710C54C0D8A5092A4FD33940	0101000020BC080000E2533C928C1C2C4162B4EC809A922041
1371	6455	NW 175 ST	NW 18 AV	W	N	Y	1	0	1	10/26/2016 12:3	25.93422	-80.23056	909034.371571291	582526.228338838	c7b967fa-00aa-457a-9256-2c7f711ebd75	0101000020E6100000AA903A8EC10E54C04F1F5B8C29EF3940	0101000020BC080000D785C7F3D2BD2B41D320E3E1FFC62141
1372	4700	SW 88 ST	SW 82 AV	W	N	N	1	0	0	9/29/2016	25.68844	-80.3252	878392.757968821	493022.050116323	b0326031-623b-4acc-94c2-003d522f76c2	0101000020E61000003DD51CF5CF1454C0E1BFCAE83DB03940	0101000020BC080000DC02C5B56FCE2A41F387FCF57E171E41
1373	183	SW 13 ST	SW 2 AV	E	F	N	0	0	0	9/13/2002	25.76139	-80.19698	920455.707986329	519772.824655101	00e037dc-68d9-4e04-9107-6a2915422e7d	0101000020E61000009979AA509B0C54C0BFAB0FC3EAC23940	0101000020BC080000F81285A10D172C419E114D167AB91F41
1374	3975	SW 137 AV	SW 62 ST	S	F	N	1	1	1	9/26/2016 15:10	25.70945	-80.41505	848770.809377823	500517.177495286	69f7a259-750e-48e2-9f80-235b2cd455f8	0101000020E61000002E7677FA8F1A54C0B04A28D29EB53940	0101000020BC0800006FC43FCC03E72941490A217A9B8C1E41
1375	1916	US 1	SW 336 St	N	N	N	1	0	0	10/31/2002	25.4556	-80.47501	829386.95078595	408173.120047241	2b82fb8e-5859-4585-a720-d90b063d103b	0101000020E6100000487EACAC661E54C09C9A385FA2743940	0101000020BC08000046925312944F294154B91D27BBE91841
1376	4686	KINGS CREEK DR	SW 87 AV	W	N	N	1	0	1	10/31/2016 10:4	25.69366	-80.3334	875678.771261882	494904.110640645	49a8990c-9ecd-4b06-8db5-636bb8433fa3	0101000020E6100000A605BF80561554C0F793C5BE93B13940	0101000020BC08000095FD40BC3BB92A41F5318034E7341E41
1377	6981	NW 3 AV	NW 20 ST	S	F	N	1	1	1	11/4/2016 14:41	25.79486	-80.2004	919256.898040295	531931.576935276	1b42a57c-0fe0-4857-9ccd-8ad15e14abda	0101000020E610000034C5CD50D30C54C0743467517CCB3940	0101000020BC080000F673B102B00D2C410356DD8DBA3B2041
1378	8309	NW 60 AV	APPROX # 14401	N	F	N	0	0	0	11/8/2002	25.90611	-80.29858	886734.301657215	572181.815301932	c6b5f1c5-bbdd-467d-be5f-410c2ce9efc7	0101000020E6100000F009DEFE1B1354C015CCC800F7E73940	0101000020BC0800000A5614CD9A0F2B411B990B0D2F762141
1379	2465	NW 103 ST	NW 81 AV	E	N	Y	1	1	1	10/14/2016 11:3	25.86923	-80.33081	876206.84832127	558722.203458793	bef3de11-e69c-437b-954a-a5e3550a8961	0101000020E61000003F69E8192C1554C0C343AC1986DE3940	0101000020BC08000075588CE35BBD2A41B7820CD2070D2141
1380	3135	SW 107 AV	KENDALE BD	N	F	Y	1	1	1	10/27/2016 11:4	25.6751	-80.36774	864404.4765683	488103.934904695	c9852c50-57ff-4334-8189-3e983459969f	0101000020E610000088720508891754C08C98E297D3AC3940	0101000020BC080000586FED2327612A4128BFC27EA6CA1D41
1381	6098	NW 2 AV	# 18601	N	M	N	1	0	1	9/21/2016 13:53	25.9446	-80.20513	917368.112767577	586348.257809795	2540e410-a758-41bf-99fe-34e5982a812b	0101000020E61000009E6AA1F5200D54C0A9275BAED1F13940	0101000020BC08000042295570EEFE2B412FE789F1DBE42141
1382	6157	NW 12 AV	NW 191 ST	S	N	N	0	0	0	10/26/2016 11:5	25.94953	-80.22164	911934.187261939	588107.970172599	7d7125b1-7c22-4afa-bda8-7fe6626bfabd	0101000020E6100000BCF140582F0E54C0D015D3D614F33940	0101000020BC0800009734AE957AD42B416E9D705E9BF22141
1383	7036	NW 7 AV	NW 32 ST	S	F	Y	0	0	0	9/20/2016 12:30	25.8062	-80.20747	916902.810552575	536040.666492827	f42c638d-7d48-47c6-bc82-f7ee413b76b4	0101000020E61000003D4F4A4C470D54C0B5592EC263CE3940	0101000020BC080000645BA6D54BFB2B41B7AA35BCD45B2041
1384	8127	SW 7 ST	SW 9 AV	W	F	Y	1	0	0	9/8/2016 11:52	25.76698	-80.20933	916377.112795025	521779.288181089	98a06247-49be-4a0a-9b56-f337673af4cd	0101000020E6100000FE7B4EBD650D54C0379329FA58C43940	0101000020BC080000EBC34A7030F72B41C84764F1D3D81F41
1385	5945	NW 199 ST	NW 62 AV	E	N	N	1	0	0	10/28/2016 12:0	25.95215	-80.30247	885366.795222968	588910.188044272	39a1048f-e309-4ea9-8b3e-6acd65d98e0c	0101000020E610000097E386B65B1354C08A7F567AC0F33940	0101000020BC080000633C87C9EB042B4137471ACEDFF82141
1386	6520	NW 183 ST	NW 19 AV	W	F	N	1	1	1	10/27/2016 13:3	25.94147	-80.23424	907808.541351698	585154.67586121	69156dd6-4c02-4442-855d-083285bac245	0101000020E6100000EAD0DAE5FD0E54C0E9DBFABF04F13940	0101000020BC080000915E8D4A3FB42B416AEF66C788DB2141
1387	4684	KINGS CREEK DR	APPROX # 8251(82 PL)	W	F	N	0	0	0	10/31/2016 10:3	25.695	-80.32764	877574.109993897	495401.846820898	26b5c5a7-a225-4a7a-b3e4-cde4e84a7807	0101000020E6100000E634F714F81454C0BDA593C2EBB13940	0101000020BC080000F0D1EB690AC82A41CC5B6026AE3C1E41
1388	7419	SW 27 AV	SW 12 ST	N	F	Y	0	0	0	9/16/2016 11:04	25.76167	-80.23857	906764.61921208	519794.081487656	cce5c96a-1667-498d-aabb-09d1d5d55e19	0101000020E61000006D83FCD2440F54C02221373EFDC23940	0101000020BC08000096D2647217AC2B41B772131DCFB91F41
1389	8030	W FLAGLER ST	NW 10 AV	W	F	Y	0	0	0	9/8/2012 10:58	25.7737	-80.21166	915596.966055356	524219.371854953	590484be-74fe-43b8-8469-0d164ef890ad	0101000020E6100000928D43D98B0D54C00EC9BEC511C63940	0101000020BC080000F8AD062518F12B412CB2D447F4FE1F41
1390	7378	NW 27 AV	NW 17 ST	S	F	Y	1	1	1	9/19/2016 14:10	25.79021	-80.23982	906298.620140437	530165.373766117	d596ea22-6c90-43f7-9a4c-8d62793d32c1	0101000020E6100000F863C20A590F54C06954DDB44BCA3940	0101000020BC080000D1A4C27273A82B41C2CBA125EE2D2041
1391	1309	SW 1 AV	SW 1 ST	N	N	Y	1	1	1	9/20/2016 13:13	25.77304	-80.19546	920928.156536043	524011.336557366	b41453c9-851c-44a0-8fdd-c47db647bb4f	0101000020E6100000E6707D82820C54C073810474E6C53940	0101000020BC08000080BB4687BE1A2C4141819E23B4FB1F41
1392	1023	SW 137 AV	SW 88 ST	S	N	Y	2	0	1	11/29/2016 15:0	25.68563	-80.41671	848257.84677295	491855.489762291	6aecc771-e3f8-4969-82bf-7eb7124d403d	0101000020E610000036F9BB67AB1A54C06CA5E36C85AF3940	0101000020BC08000078A55ADF01E32941D78AB5B744051E41
1393	6215	NW 22 AV	NW 175 ST	N	N	Y	1	0	1	8/18/2016	25.93381	-80.23679	906987.757578466	582362.683104523	7ceb91f2-e66b-4884-a699-5c6d5908387b	0101000020E610000074C1C0A0270F54C080FA40380EEF3940	0101000020BC080000AE4017B9D5AD2B41DF7FB9CAB8C52141
1394	7147	SW 12 AV	SW 15 ST	S	F	Y	1	1	1	10/18/2016 13:5	25.75903	-80.21435	914742.836515371	518879.864197098	d63a84e0-af1f-45fb-9d20-82dc81bd283e	0101000020E61000001BE053F4B70D54C0AE8641F74FC23940	0101000020BC080000AB4FB4E26BEA2B41110F763E86AB1F41
1395	1627	SW 57 AV	ALGARDI AV	N	N	N	0	0	0	11/30/2016 13:5	25.73306	-80.28635	891095.525246408	509306.036219008	39afe4dc-4c2b-48c0-85ea-7672f938e2d3	0101000020E61000003A1AB1A2531254C0A914D4FEA9BB3940	0101000020BC080000BAE22740AD312B4167650BECEE151F41
1396	7702	NW 54 ST	I 95 EX	E	M	Y	0	0	0	10/19/2016 14:2	25.8249	-80.20634	917236.226199884	542838.322523981	570ae5f5-ae98-425d-8acb-082a6aaf1265	0101000020E6100000E8E32CA7340D54C0F9C417052DD33940	0101000020BC0800000E4F80AAE6FD2B414C05050DF0902041
1397	6449	NW 175 ST	NW 14 AV	E	N	Y	1	0	1	10/26/2016 14:4	25.93436	-80.22503	910852.509997979	582586.015971787	677b7054-e2b3-4bc9-99bb-aae7d8389a4b	0101000020E6100000C98823E7660E54C08BF9476532EF3940	0101000020BC0800004AAACC3A07CC2B4134F5387577C72141
1398	3124	SW 107 AV SERVICE RD	CARIBBEAN BD	N	N	N	0	0	0	10/4/2016 15:37	25.57612	-80.36379	865879.218345068	452134.349395923	cd20045c-8bfb-4e22-830c-45e80b2b34d6	0101000020E610000011A6EB43481754C0A29584937C933940	0101000020BC080000533FF89FAC6C2A41E266DB1DA0981B41
1399	1743	SW 72 ST	TRIONFO ST	W	N	Y	0	0	0	9/22/2016 14:25	25.70492	-80.27698	894235.528764926	499095.433308139	379e25f5-30f0-4654-a971-12a43fda291b	0101000020E6100000F6BC6F26BA1154C0FAC99FE075B43940	0101000020BC080000466F8342354A2B41E04DDC7F64761E41
1400	5736	NE 10 AV	NE 173 ST	N	F	Y	1	1	1	11/1/2016 12:41	25.93492	-80.18037	925527.525568061	582880.339206852	8b5681ff-0342-4d43-ac35-a9d3ed11b333	0101000020E610000011F43E428B0B54C02254A45B57EF3940	0101000020BC080000495BB744AD3E2C41E7F6C41AC4C92141
1401	3232	SW 117 AV	SW 134 ST	N	F	N	0	1	0	8/17/2016	25.644	-80.38286	859476.597626392	476778.872273393	0844924e-9251-4331-a792-a2dca72d0516	0101000020E6100000C3BF4DCA801854C0D32537C0DDA43940	0101000020BC080000A1D03D61A73A2A41CE5A833BB2191D41
1402	6831	BRICKELL AV	# 1809	NE	M	Y	1	1	0	11/14/2016 13:1	25.7555	-80.19618	920729.755322445	517634.691833749	e1e5ce4f-84e1-454d-9a0b-ccd6337f1ed7	0101000020E61000003BC994528E0C54C01CBB8EF368C13940	0101000020BC080000F0F4CDB931192C41F808898D11981F41
1403	7622	NE 79 ST	NE 2 AV	E	F	Y	0	0	0	11/2/2016 13:50	25.84748	-80.19257	921715.860943299	551074.137371004	7b571106-7203-41af-81a0-c2d5386fc25f	0101000020E6100000B9726607530C54C0DC311105F5D83940	0101000020BC0800000A56E9EFE5202C41FDE05DAF47D12041
1404	8076	W FLAGLER ST	SW 62 CT	E	N	Y	1	0	0	9/8/2012 14:13	25.77054	-80.29728	887426.037808161	522909.586450361	d61da4eb-4887-4236-b9e4-7a866d2dc6c2	0101000020E6100000D98CACA5061354C0FFD3CF5942C53940	0101000020BC080000FC182E4602152B4124A5FF227DEA1F41
1405	7833	NW 20 ST	NW 10 AV	E	F	Y	1	1	1	9/1/2016 13:25	25.79502	-80.21064	915885.54258202	531970.843593135	5f7b7807-af7b-484d-8369-5d0649ab01e1	0101000020E610000017C7762B7B0D54C0A180DC1087CB3940	0101000020BC080000D5DD334C59F32B4180C87516093C2041
1407	9271	SW 67 AV	SW 72 ST	N	F	N	0	0	0	10/10/2016 11:4	25.70438	-80.30138	886203.06943123	498855.208681099	67c35cb0-e1dd-4159-9fd1-75d41259ffb1	0101000020E61000006692E6DE491354C02C9E5A5B52B43940	0101000020BC080000B62A3D56740B2B41A390BD99A3721E41
1408	3302	SW 137 AV	15300 BLOCK	S	N	Y	2	0	1	11/29/2016 12:0	25.62513	-80.41463	849039.448243327	469873.045194484	88f78757-d586-40e6-bbb4-3d32ff3e9909	0101000020E61000006A96F55B891A54C0E0770E1609A03940	0101000020BC080000F9C171131DE92941A0D2ACEACAAD1C41
1409	9476	SW 4 ST	SW 107 AV	E	N	N	0	0	0	10/27/2016 19:4	25.76481	-80.36913	863789.544738516	520706.232929766	dec88e49-d406-432b-ac4f-ed4209e44845	0101000020E610000044BBE4DE9F1754C024B7FBA1CAC33940	0101000020BC080000873A9846595C2A41CA6453B80FC81F41
1410	3301	SW 137 AV	COUNTRY WALK DR	S	N	N	2	0	0	11/29/2016 11:5	25.63191	-80.41484	848959.696088977	472337.287991196	a27a8f17-7be9-4a8f-9f26-04209d7e815e	0101000020E610000037E291C88C1A54C0ACBF607CC5A13940	0101000020BC08000081334F927DE829412ED3E7E34BD41C41
1411	4842	NW 27 AV	NW 58 ST	N	N	N	1	1	1	9/16/2016 10:50	25.82736	-80.24079	905898.593414541	543663.73028513	e1a06834-f409-4014-974b-962601539ac6	0101000020E610000071BEFD14690F54C0889F28E9CDD33940	0101000020BC0800003A96F46453A52B412BA5E5DD62972041
1412	10337	NW 8 ST	NW 6 AV	E	F	N	0	0	0	10/3/2007	25.78173	-80.20711	917075.15959369	527144.436238222	1a21bc34-a03f-42fc-aa95-9815dd370c3a	0101000020E61000003DE52462410D54C01C8F60911FC83940	0101000020BC08000002086388A4FC2B413FEA324554162041
1413	6556	NW 199 ST	NW 39 CT	E	F	N	1	1	2	10/28/2016 12:4	25.95449	-80.26651	897177.146607272	589823.830890447	c3eab92a-675f-496c-b93b-90325de337df	0101000020E61000007565169C0E1154C0088EF19159F43940	0101000020BC080000F075017F30612B4120136D1703002241
1414	6353	NW 47 AV	NW 173 DR	N	F	Y	1	0	0	8/31/2016	25.93137	-80.27691	893806.161845535	581403.920897916	6b8d57ea-6b94-4737-b81f-f96363094b34	0101000020E6100000F137DC00B91154C006940CD66EEE3940	0101000020BC08000093126286DA462B4107706D443BBE2141
1415	10572	SW 8 ST	SW 127 AV	E	N	\N	1	1	0	10/13/2016 14:0	25.76075	-80.40109	853278.431237787	519184.442321204	44e6c59a-952e-49b4-a6c4-74bcc6dee8d0	0101000020E61000003EAE8078AB1954C04D64AC14C1C23940	0101000020BC08000086221F0B3B0A2A410C6C2D8E48B01F41
1416	6823	BRICKELL AV	SE 15 RD	SW	F	N	1	1	0	11/14/2016 11:3	25.7578	-80.19328	921679.832800571	518475.406977691	e3011017-8163-49f0-912b-6af79c20307e	0101000020E610000038AFB4C65E0C54C02B30D87CFFC13940	0101000020BC080000E593B5E19D202C416A1C4E6A34A51F41
1417	2610	HARBOR DR	W HEATHER DR	S	F	Y	0	0	0	11/14/2016 13:5	25.69413	-80.17228	928737.265577909	495376.397399843	5151fb04-5e68-449c-a053-9d0311f94b01	0101000020E6100000A42C19B2060B54C025E03DCFB2B13940	0101000020BC080000DE241FC0C0572C41F3546E5A483C1E41
1418	8157	SW 8 ST	SW 53 AV	W	F	Y	1	1	0	9/8/2016 14:03	25.76387	-80.28204	892452.76496556	520514.502303749	74347a68-2596-48fe-aa7c-9dae95a95982	0101000020E61000001009A00D0D1254C01BBB6A9E8DC33940	0101000020BC080000199D2FBB473C2B4188021ECC10C51F41
1419	10369	STATE HWY 5	OVERSEAS HWY	\N	\N	\N	\N	\N	\N	 	24.95992	-80.56844	799138.979160089	227922.555049799	b999683e-0d03-4b0d-98d2-c28b856298ff	0101000020E6100000F0FA6455612454C04174BEBDBDF53840	0101000020BC0800003E66161D446328411840686AA1D20B41
1420	10004	COMMERCE WAY	#14261	N	N	N	0	0	0	10/19/2016 15:1	25.90351	-80.33008	876386.895495843	571184.491534613	b59eaf70-8c28-4933-8768-0b88b0dfc919	0101000020E6100000A82AEDF51F1554C041FAE4EF4CE73940	0101000020BC08000018E0D8FBC3BE2A4194BD3567646E2141
1421	7000	SW 3 AV	SW 24 RD	NE	F	Y	1	1	0	9/14/2016 14:09	25.7567	-80.20606	917479.117476758	518048.989212483	051ca933-8141-4f52-b770-85362568c1dd	0101000020E6100000E09FFCFF2F0D54C0303B8F33B7C13940	0101000020BC080000F319D272CCFF2B41472E22BE8A9E1F41
1422	9657	SW 167 AV	SW 336 ST	S	F	Y	0	0	0	10/21/2016 14:2	25.45396	-80.4607	834113.702168003	407596.667436108	c7172a57-da3d-47cd-bd7a-41fe2f96f162	0101000020E6100000D6E69C167C1D54C0CC6A240637743940	0101000020BC0800008D7F9A9381742941762FAF57B9E01841
1423	2413	W 60 ST	W 28 AV	E	F	N	1	1	1	10/19/2016 16:3	25.87695	-80.33863	873625.894806225	561514.416066892	0f8b8fc2-f925-45ae-97a2-4a2a7e7767f0	0101000020E61000002F8CA7FEAB1554C0A4BC3FE87FE03940	0101000020BC080000BA9414FB31A92A41F3DC2E3FD8222141
1424	2773	WASHINGTON AV	4 ST	S	F	N	1	0	1	11/10/2016 13:5	25.77345	-80.13456	940969.751241844	524285.188700646	c7eeaebb-54ec-4fa9-803d-d0087581817c	0101000020E610000045691BB59C0854C09F6B09EE00C63940	0101000020BC080000F27F6ABA51B72C41D6176D8CFBFF1F41
1425	8823	N MIAMI AV	NE 127 TE	N	N	Y	0	0	0	11/3/2016 17:14	25.89197	-80.19872	919592.187740061	567231.84887284	fff931a5-ad91-469a-b220-873149cb49d1	0101000020E6100000B4B4BDE7B70C54C0F9490C9658E43940	0101000020BC080000278CFF964E102C4180ECC11D834F2141
1426	9667	SW 187 AV	SW 358 ST	S	F	N	0	0	0	42664.59792	25.435	-80.49336	823364.626213796	400663.995964773	6d0b6065-2771-44e8-a0e5-fc357f0cb7fa	0101000020E6100000A4A2D71F931F54C0182DD1865C6F3940	0101000020BC080000DD63566B87202941EF383BA666741841
1427	7049	NW 7 AV	NW 9 ST	S	F	Y	\N	\N	\N	9/20/2016 13:27	25.78221	-80.20682	917171.835274611	527320.942452565	b4617169-a28a-42a0-8526-902208380d02	0101000020E61000000E6E70843C0D54C05F4D8E493FC83940	0101000020BC080000D5B845E265FD2B4188656C48B5172041
1428	2856	HAWTHORNE AV	79 ST	N	N	N	1	0	1	8/28/2002	25.86396	-80.1284	942779.687606696	557197.928938113	f12dfb76-6143-4dd5-b0cf-7c93ee3adb81	0101000020E61000004450CEBF370854C02E4B58DB2CDD3940	0101000020BC0800008405F29975C52C41EEF875451F012141
1429	8164	SW 8 ST	APPROX # 6351(63 CT)	W	F	Y	1	1	0	9/8/2016 10:44	25.76332	-80.29887	886917.703217108	520284.797393918	bbd228d0-8b04-4145-9c63-aafa667c8aae	0101000020E61000006D8408A6201354C03EB7F39269C33940	0101000020BC080000011FD49A09112B41E40467FA79C11F41
1430	7547	NW 42 AV	NW 4 ST	S	F	Y	1	0	0	2/16/2017 10:04	25.77582	-80.26402	898361.244310509	524889.14972467	8e440b4f-dd09-42a9-92ff-0f67cf127f5e	0101000020E6100000297D15B7E51054C0D5CA19839CC63940	0101000020BC08000041C04DB1706A2B4100283DB2B5042041
1431	2223	W 16 AV	W 32 PL	N	N	N	0	0	0	10/3/2016	25.85049	-80.31432	881669.690421138	551940.690749034	951a6e8c-b785-4561-a484-f03e9512a09d	0101000020E610000088C6E5AE1D1454C0D6197348BAD93940	0101000020BC08000098236D9309E82A418ED0A1CA0CD82041
1432	4572	SW 24 ST	SW 70 CT	W	N	Y	1	1	1	9/14/2016 12:37	25.74815	-80.30848	883783.11993235	514752.944595456	3eb71c37-0f8a-43b0-b95a-16b66f013d83	0101000020E61000005059B221BE1354C0133F662187BF3940	0101000020BC080000EFFDBE6F8CF82A41C310978F0A6B1F41
1433	9582	NW 41 ST	# 9915	W	N	Y	1	0	0	11/8/2016 15:30	25.81178	-80.35591	868059.243900675	537798.971680768	ee69ee93-c2ae-4db4-93ba-c5b69abd2a5d	0101000020E6100000F2C6D228C71654C0307407DCD0CF3940	0101000020BC0800001BEE1AADB47D2A416C8FA55891692041
1434	10286	NW 57 AV	NW 7 ST	S	F	N	1	0	0	12/1/2016 11:15	25.77767	-80.28847	890312.405700441	525518.086498462	60628912-03b8-4257-9000-73743e887e10	0101000020E6100000CEA84341761254C022F181E215C73940	0101000020BC080000578AE5028F2B2B41FBC3E0919F092041
1435	7904	NW 14 ST	NW 1 CT	W	N	N	0	0	0	11/10/2016 15:4	25.78827	-80.19699	920392.86916801	529543.151235662	f1ecd847-7810-4806-9d11-059c8c035322	0101000020E610000047F19B7A9B0C54C04E34866FCCC93940	0101000020BC08000034CC1CF48F162C416B25A1B311292041
1436	8119	SW 1 ST	SW 5 AV	E	N	Y	0	0	1	9/8/2012 13:25	25.77281	-80.20278	918519.344728705	523910.550630003	f37d92c1-d212-48da-94e0-af28c1ce41b2	0101000020E6100000F656FF74FA0C54C09E92CCEBD6C53940	0101000020BC0800002A8657E7EC072C41AF5FB7FE20FA1F41
1437	6241	W BUNCHE PARK DR	NW 24 AV RD	SW	N	N	0	0	0	10/31/2016 12:4	25.92219	-80.23867	906395.398481589	578138.821484074	106046d0-b10d-4583-abb5-30edd96876fb	0101000020E6100000C24F7661460F54C0B079F54715EC3940	0101000020BC0800003455350135A92B4155AD1A11B9A42141
1439	6311	NW 37 AV	NW 205 ST	N	N	N	0	0	0	11/27/2002	25.96252	-80.26218	898584.816026364	592750.879157521	3f8adfb5-e8d0-4ccf-b07a-68566b2b786c	0101000020E61000005512F999C71054C04418CBE367F63940	0101000020BC0800008985DBD52F6C2B41132B6E30E1162241
1440	3129	SW 107 AV	SW 176 ST	N	N	N	1	1	1	11/17/2016 11:2	25.60558	-80.36485	865475.238571215	462840.237096593	e10c308f-f512-443a-9fe7-ab89768213ad	0101000020E61000002BCCD4CB591754C057EB3355079B3940	0101000020BC080000AAB139AA84692A411A509DADE73F1C41
1441	5153	NW 79 ST	NW 25 AV	W	N	Y	1	0	0	10/11/2002	25.84624	-80.23951	906280.270441826	550529.519370541	06b7e11c-44b1-4e9f-9165-2e5ad2416b4c	0101000020E6100000DA1E1718540F54C0B471676DA3D83940	0101000020BC080000D28C99BF4EA82B4199DCC17206CD2041
1442	10483	SW 157 AV	#8600	S	\N	\N	\N	\N	\N	 	25.68645	-80.44621	838541.695921399	492113.188393645	82f8231f-6643-4793-8eb3-2c5332eb0692	0101000020E6100000F31D8BB78E1C54C08F444C6DBBAF3940	0101000020BC0800006853C690199729418E081E834B091E41
1443	7563	NW 42 AV	NW 7 ST	N	F	Y	1	1	1	2/13/2017 15:52	25.77971	-80.26387	898401.724208493	526302.565223113	5e81f632-9756-414a-ab7c-cd0c4ff594ce	0101000020E6100000C51A854EE31054C0FC03F1509BC73940	0101000020BC08000090B10BA7C16A2B4169E51987C00F2041
1444	9992	SW 37 AV	S DIXIE HWY	N	F	N	0	0	0	4/5/2004	25.73336	-80.25383	901799.687223554	509475.014205098	a84f3666-0506-4e64-968b-ffb458251184	0101000020E6100000CB6D77E03E1054C09D278EC9BDBB3940	0101000020BC0800009E6192944D852B418AC097D592181F41
1445	2591	CRANDON BD	EAST DR	S	F	Y	1	0	1	11/14/2016 14:2	25.69555	-80.16311	931754.160104334	495913.357274145	5b079179-77be-404b-a01d-b7527043cfbf	0101000020E6100000FA871F70700A54C06CD4C33210B23940	0101000020BC080000232A8F8A526F2C4125215231AC441E41
1446	2893	DADE BD	MICHIGAN AV	SW	F	Y	1	1	0	11/11/2016 13:4	25.79419	-80.13999	939132.507569954	531814.40097487	b4e3908e-896f-47c0-8844-6d6af1046f8a	0101000020E6100000A5BBC4B8F50854C06163039B50CB3940	0101000020BC080000B2D64B3DF7A82C4123C6C033D03A2041
1447	5248	NW 36 ST	# 5600	E	N	Y	2	2	0	11/11/2016 12:4	25.80756	-80.28703	890726.152286898	536382.72616937	2094a548-29f5-4712-ac3b-fa377660a0e3	0101000020E6100000BA4A3EBA5E1254C0A434BB6DBCCE3940	0101000020BC080000B60B3381CA2E2B4199FDD5DA805E2041
1448	9213	COLLINS AV	174 ST	S	N	Y	1	1	1	10/11/2016 13:4	25.93786	-80.12168	944808.379085738	584072.879770555	9afa3873-e139-4e5b-820b-40e50ba0c5a0	0101000020E6100000A539DCB6C90754C084A05DD617F03940	0101000020BC0800007BBA3EFC4ED52C417387B22F15D32141
1449	1142	NW 183 ST	NW 37 AV	W	N	Y	0	0	2	10/27/2016 14:3	25.94046	-80.26069	899120.316892449	584736.545456417	68e74bd2-ea23-4c48-a7bf-cf5f72f85291	0101000020E61000007F1D1128AF1054C0D2FDA65CC2F03940	0101000020BC080000CBA667D65E702B41F160A58444D82141
1450	10327	NW 8 ST RD	NW 11 ST	E	F	N	0	0	0	10/21/2016 13:1	25.7837	-80.20924	916371.911028776	527855.536549516	295ad8c8-784d-47c9-830c-3d6e1054af59	0101000020E61000005882D92E640D54C04CE8F48AA0C83940	0101000020BC0800006216090926F72B419142AE78E21B2041
1451	7621	NE 79 ST	NE 1 CT	E	F	N	0	0	0	11/2/2016 13:47	25.84743	-80.19447	921093.710312754	551051.417944677	7f867126-1efa-4e66-b52a-b84e9ea189b6	0101000020E61000007C340607720C54C06EABA69CF1D83940	0101000020BC080000E570C0A2091C2C41CD9A053F1AD12041
1452	1459	NE 6 AV	NE 119 ST	N	N	N	0	0	0	11/19/2002	25.88449	-80.18614	923747.612162732	564538.546189599	69cc1338-7683-4b0f-9e67-10ec97580908	0101000020E61000001B40D4A9E90B54C0B67A6F606EE23940	0101000020BC080000E95EC870C5302C4183F36282783A2141
1453	8990	PERVIZ AV	HAREM AV	SE	F	N	1	1	1	9/1/2016 11:56	25.90735	-80.25576	900806.519560084	572711.189579025	4b90d545-e6d0-4927-a12a-695b263e56db	0101000020E610000034C57E7F5E1054C00779E27648E83940	0101000020BC08000082FB803E8B7D2B412841D3CC517A2141
1454	1569	SEGOVIA ST	PALERMO AV	N	N	N	1	0	0	10/12/2016 12:3	25.74463	-80.26647	897617.733308651	513547.538226314	032c1384-d90d-46e8-9c19-831a1d45b613	0101000020E61000006AF852DF0D1154C0AED70950A0BE3940	0101000020BC08000021B98EABA1642B41EFF821EF34581F41
1455	5162	NW 74 ST	# 6900	E	N	N	0	0	0	10/10/2016 12:2	25.84064	-80.31116	882725.097422529	548363.445982009	022e6cfe-2ad3-4254-945c-26b4f43c897d	0101000020E61000005EF4710AEA1354C0C4D3634B34D73940	0101000020BC08000027B2FA6348F02A417E99D84C1ABC2041
1456	8667	NE 163 ST	NE 18 AV	W	N	Y	1	0	0	10/8/2016	25.92607	-80.16369	931030.321683846	579696.045032486	ba14bffe-f1fb-4847-9df7-63b88c1e8411	0101000020E6100000B1030BF5790A54C0931E96F812ED3940	0101000020BC080000E7E4F4DCAA692C41BCF5B683E3B02141
1457	1830	NW 25 ST	NW 87 AV	W	F	N	0	0	0	11/5/2002	25.79698	-80.33767	874086.346010767	532449.535545602	33e7e88a-acba-4891-b9f3-9281e65b2f82	0101000020E6100000165815599C1554C094A429ED06CC3940	0101000020BC08000061EE36E2CAAC2A4147749778C63F2041
1458	8378	OAK LA	NW 148 ST	N	N	N	1	1	0	10/19/2016 15:2	25.90767	-80.32778	877132.9386576	572698.187962659	531d74e5-27e8-4515-a48d-a4b34bae3296	0101000020E61000003D176364FA1454C01F25782C5DE83940	0101000020BC0800000F6AFE1198C42A41CFA5FECB377A2141
1459	8465	NE 96 ST	NE 6 AV	E	N	Y	0	0	0	10/14/2016 15:0	25.86368	-80.18565	923954.654071614	556975.32079421	bd947897-2eb3-4c74-bb8d-d5c559d98882	0101000020E6100000C8F032AFE10B54C0788AB0811ADD3940	0101000020BC0800000C1F638663322C41364EEB0D62FF2041
1460	7486	SW 37 AV	SW 28 ST	S	N	Y	1	0	0	9/22/2016 12:04	25.73923	-80.25428	901641.134031702	511607.342634574	ffff3cc2-5d01-41dc-ac70-5a61d8ac0c7d	0101000020E6100000FDC2EF2A461054C05CC4106B3EBD3940	0101000020BC0800009553467910842B41F8317C26E4391F41
1461	1422	HALLANDALE BEACH BD	LAYNE BD	W	N	Y	1	1	1	11/3/2016 12:41	25.98616	-80.12987	942001.33578556	601613.173097424	fa5c787a-e6bd-4706-9c88-4b3e17202572	0101000020E6100000081F73D54F0854C0BF53C29E75FC3940	0101000020BC0800006FD29FE560BF2C415A7734C81D5C2241
1462	2793	ALTON RD	29 ST	N	F	N	0	0	0	8/22/2002	25.80561	-80.13829	939665.386448439	535965.996334456	bca4fb3f-2c0d-48ff-9428-5239ca63d696	0101000020E61000002CE40FD6D90854C0C0BCA6803CCE3940	0101000020BC080000E2F378FF20AD2C4156C233653F5B2041
1463	8857	NE 123 ST	NE 15 AV	SE	F	Y	1	1	1	10/31/2016 16:5	25.88959	-80.16825	929615.328098871	566427.671021096	ddf4eab5-905f-4baa-89b6-eeb06ab86591	0101000020E61000006B7F43AFC40A54C01CCA2959BCE33940	0101000020BC0800001E6020E09C5E2C41B0749BC23A492141
1464	6090	N MIAMI AV	NW 189 ST	S	F	N	0	0	0	10/26/2016 14:4	25.94746	-80.20132	918613.513851881	587393.230769977	cd7bb5ab-c3cf-4a03-8361-aa52e84601fd	0101000020E6100000FB3B868DE20C54C08A1F89B88CF23940	0101000020BC0800006237CF3DA9082C4184D0CFE305ED2141
1465	10368	MILE MARKER 87	OVERSEAS HWY	\N	\N	\N	\N	\N	\N	 	24.96039	-80.568	799283.217036873	228092.001549006	2a32f7eb-5dd1-4450-841a-dcf4454f5bd7	0101000020E6100000C2F87B2C5A2454C08FB02A37DCF53840	0101000020BC0800009CCAE69664642841A49268FDECD70B41
1466	4697	SW 88 ST	7500 BLOCK	W	N	Y	1	0	0	9/29/2016 11:28	25.68875	-80.31464	881865.25105381	493152.228951193	69459a79-b28c-470f-b826-0b06ec0aecdd	0101000020E6100000212EF82B231454C03C37F52852B03940	0101000020BC080000BEF1B8B290E92A41594401AD87191E41
1467	3091	SW 104 AV	SW 180 ST	S	N	N	1	0	1	8/17/2016	25.60228	-80.36079	866818.673194136	461647.281174123	1106e810-ebe0-4ac8-b785-a0f28c22e625	0101000020E610000062E5254B171754C001A85E102F9A3940	0101000020BC080000FACDDD8803742A4173134ADA432D1C41
1468	299	PALM AV	W 49 ST	S	N	Y	1	0	0	9/22/2016 11:43	25.8671	-80.28313	891890.246404998	558031.861335658	1403486e-36cb-42d5-897d-b3068f09808a	0101000020E6100000C0F00AE11E1254C0F9A38AB4FADD3940	0101000020BC08000060436CB1E2372B411292D122A3072141
1469	8245	SW 22 ST	SW 19 AV	W	F	Y	1	0	0	9/14/2016 12:10	25.75085	-80.22626	910839.607456282	515883.903614156	a29f4843-46bf-4465-936e-cbc4fdbbfdbe	0101000020E6100000B896E41E7B0E54C0F23B5EF237C03940	0101000020BC080000C8C3DB6CEDCB2B41B0A4F365B67C1F41
1470	3138	SW 107 AV	# 9045	NE	N	Y	1	1	1	10/27/2016 12:0	25.68448	-80.36652	864787.977450211	491516.85983073	534930a9-b334-4950-8a27-8cb1404ec3b7	0101000020E610000029782324751754C05BBA19A63AAF3940	0101000020BC0800002642612426642A412678AE32FAFF1D41
1471	6451	NW 175 ST	NW 13 AV	W	F	Y	1	0	1	10/26/2016 12:2	25.9345	-80.22316	911466.128506497	582640.538493596	308bc0eb-9b45-447b-bc87-33372fc04c04	0101000020E610000059E42D4C480E54C0C98A19923BEF3940	0101000020BC08000019DB9C77D2D02B41E87CC880E4C72141
1472	6516	NW 183 ST	# 1301 (OP TURNPIKE)	W	M	N	1	0	0	10/26/2016 12:0	25.94192	-80.22381	911237.829450537	585337.705026142	83afc5c2-d64d-4e4e-a4bb-52495f4ed4f0	0101000020E61000005332B3E1520E54C0A4D12E1C22F13940	0101000020BC08000062BA7BDE09CF2B416E6162D6F6DC2141
1473	2779	ALTON RD	6 ST	N	F	Y	1	0	1	8/20/2002	25.77634	-80.14066	938956.369158532	525322.847056441	e7df7c9b-e53c-4912-9f8a-c1fb6a88dde3	0101000020E61000006DE6C899000954C075B4F864BEC63940	0101000020BC080000A56972F696A72C41FD16661719082041
1474	9607	NW 46 ST	NW 25 AV	W	N	Y	1	1	1	9/23/2016 13:59	25.81665	-80.23809	906807.656557597	539775.765330493	d50d7e1d-a6b1-4949-9643-906c95f05507	0101000020E6100000D0DD55ED3C0F54C031FA5AF40FD13940	0101000020BC08000018D164856DAC2B41074C60EF02792041
1475	5137	NW 79 ST	NW 13 AV	E	F	Y	1	0	1	10/20/2016 12:4	25.8466	-80.21905	913011.970922742	550700.942959867	21c66850-2792-4893-a9c3-96d98997f135	0101000020E61000004801A9B6040E54C048BC8937BBD83940	0101000020BC08000048803127E6DC2B41DA65A64B5DCE2041
1476	8628	NE 10 AV	NE 183 ST	N	N	N	2	0	0	10/27/2016 17:1	25.94318	-80.18106	925282.965370476	585881.962457709	1fc5a1fe-ef12-4750-ac9c-6dce22df6a72	0101000020E610000065AEBB83960B54C0F3600BD174F13940	0101000020BC0800005032DC25C43C2C41401F505A37E12141
1477	4414	SW 67 AV	SW 21 ST	S	F	Y	0	0	0	10/10/2016 13:4	25.75095	-80.30369	885354.109890696	515778.199431375	0e0588b6-5b30-4aba-b059-957474aed261	0101000020E61000005C392BAB6F1354C00D2D12803EC03940	0101000020BC080000C896BE6AD2042B41070FDB940F7B1F41
1478	7641	NE 62 ST	NE 1 PL	W	F	Y	1	1	0	10/18/2016 13:4	25.83285	-80.19296	921617.296175729	545753.219895869	1dfb7771-de25-4271-915e-4be5ff785e9e	0101000020E6100000CFA8ED90590C54C0FEC0E0C435D53940	0101000020BC0800009A34CACE20202C4189FECFD8B5A72041
1479	1351	BISCAYNE BD	NE 180 ST	S	N	Y	1	0	0	9/8/2016	25.94292	-80.14856	935963.405977566	585853.02453883	aa064e2e-89de-4815-bf4a-e73972f325d5	0101000020E6100000625A3411820954C078AA865163F13940	0101000020BC0800006D89C00835902C41B451047AFDE02141
1480	9239	SW 57 AV	SW 88 ST	S	N	N	1	0	0	12/1/2016 15:58	25.6898	-80.28493	891649.107460275	493587.88494204	1e9d75bd-b9c6-4172-8e0f-6b2878cdb126	0101000020E610000047EF2F523C1254C0AD56B95D97B03940	0101000020BC0800007A137F6A00362B4140D2244D56201E41
1481	43	BISCAYNE BLVD	I 195	N	F	Y	2	0	1	9/8/2016	25.81146	-80.18934	922856.603758834	537987.393212751	8ef9a5c5-f4eb-4d16-9f25-b1a4f6383a41	0101000020E610000053CD26391E0C54C02CD34037BCCF3940	0101000020BC08000066CB6A6CCF292C41382794300A6B2041
1482	1837	NW 25 ST	NW 102 PL	E	F	N	1	1	1	11/8/2016 10:49	25.79674	-80.36242	865940.402333293	532324.631886594	209b38b1-5d3b-4e2e-9268-fcffba3f5f31	0101000020E61000006C2EE2FF311754C05C3F0FA8F7CB3940	0101000020BC080000362301FE266D2A41085CE4A9CC3E2041
1483	3210	SW 117 AV	SW 186 ST	S	N	N	1	1	0	11/17/2016 12:2	25.59554	-80.381	860170.660553869	459168.581715815	2d15e160-9211-4f02-85e5-ad6e074d4df6	0101000020E6100000E332795D621854C09DB758CF75983940	0101000020BC080000B1A3928113402A41ED61920D89061C41
1484	3483	SW 112 ST	# 9890	E	N	Y	1	0	0	9/29/2016 15:58	25.6654	-80.35418	868886.517159272	484599.285137728	72072d7c-c492-46bd-8535-7ec7da99ffec	0101000020E6100000D39F04EEAA1654C038164CC357AA3940	0101000020BC0800004B0E44392B842A4136283FE4E3931D41
1485	5672	NE 167 ST	NE 4 AV	E	F	Y	2	0	0	10/17/2016 14:4	25.92832	-80.19183	921775.98750598	580456.188878976	ace18a01-166b-4739-98d6-95c158bd9bf1	0101000020E61000000875FC04470C54C0DFAF1B7EA6ED3940	0101000020BC08000061B1A8305E212C41F83990CDD3B62141
1486	5237	NW 54 ST	NW 31 AV	W	F	Y	1	0	0	10/19/2016 13:5	25.82383	-80.24709	903831.267468404	542369.493061945	506cc97d-dc5a-454d-9c55-4fb11361b4be	0101000020E61000002C15796AD00F54C03C8D1FB3E6D23940	0101000020BC0800009E23E5BD2C952B4142264364468D2041
1487	9321	COLLINS AV	# 9011	N	N	N	0	0	0	8/26/2002	25.87707	-80.12167	944964.595939565	561978.227821402	90fb53ce-3ea5-4e45-bfd8-9b32c595c044	0101000020E61000009C97FF4DC90754C0C7737A1988E03940	0101000020BC0800003470526B87D62C41D6190BDF77262141
1488	8007	NW 7 ST	NW 15 AV	E	N	Y	0	0	0	9/16/2002	25.77995	-80.22036	912720.061020881	526473.266290732	dcf8b87d-409f-46aa-ba91-0f66277eba49	0101000020E6100000EE31E9671A0E54C04F24D13DABC73940	0101000020BC080000A81E5E559EDA2B41B5C813EE15112041
1489	7346	SW 22 AV	SW 12 ST	N	N	Y	1	1	0	10/17/2016 16:2	25.7611	-80.23042	909452.834300846	519602.51101663	fc694a95-49a1-4445-8bf6-abd2bc66a76d	0101000020E6100000D19FAC10BF0E54C0836A35E3D7C23940	0101000020BC080000013EE4E017C12B41C95F17D5D0B61F41
1490	6444	NW 175 ST	NW 22 AV	E	F	N	1	0	1	10/26/2016 14:2	25.93393	-80.23652	907075.249194566	582407.537951306	7967e06d-26ae-40b3-aead-85e028ee5c26	0101000020E610000048BADF40230F54C0B9E6113716EF3940	0101000020BC0800007EB7D6B484AE2B415E70668012C62141
1491	4641	SW 56 ST	SW 82 AV	E	F	N	1	0	1	10/12/2016 17:2	25.71721	-80.32614	878025.2318241	503478.907433115	b00f107b-7861-4ce3-ab83-570da5206aea	0101000020E61000009A847C96DF1454C0981950B59BB73940	0101000020BC08000026A041A890CB2A415B969B66E2BA1E41
1492	4853	NW 27 AV	# 8401	N	N	Y	1	1	1	9/16/2016 11:30	25.85191	-80.24179	905515.200099416	552587.847638048	08e59231-038d-4749-bfde-f445b425a29f	0101000020E6100000F9910B9D790F54C05F4A235817DA3940	0101000020BC080000B0229B9B54A22B412BAC231B1BDD2041
1493	5512	NW 7 AV	NW 139 ST	S	F	N	1	0	1	9/21/2016 12:43	25.90151	-80.21157	915346.655186389	570673.775377162	64e72e84-28bc-4dff-b18f-5ba68f7bb851	0101000020E6100000816291708A0D54C0F3F2B5CCC9E63940	0101000020BC08000045E5C18523EF2B41C6F273F8666A2141
1494	4187	SW 56 ST	SW 113 AV	W	N	Y	1	0	1	10/12/2016 12:3	25.71512	-80.37827	860865.569610499	502631.808420561	9e03aa17-7aac-41dc-b331-2d8fd3a24619	0101000020E6100000B5266BAB351854C01B2AE92512B73940	0101000020BC0800008DB6115381452A412A9FF100A6AD1E41
1495	2930	71 ST	BYRON AV	W	F	Y	1	0	1	10/20/2016 15:2	25.85611	-80.12355	944396.944870669	554355.286001027	2e0abd91-a155-4e83-8138-d838b298a809	0101000020E6100000095D7B1FE80754C017A029662ADB3940	0101000020BC0800009B78DC1D18D22C41C1D6E2FBE9EA2041
1496	5147	NW 79 ST	NW 17 AV	W	F	Y	1	0	0	10/20/2016 12:5	25.84664	-80.22603	910711.597192992	550701.873066597	3a351e53-5da9-450b-b5e4-828b84b2af83	0101000020E61000005A12A14D770E54C03DE2A2D6BDD83940	0101000020BC0800005AE98F67EDCA2B4125F0EB275FCE2041
1497	7756	NW 36 ST	NW 15 AV	E	F	Y	0	0	0	11/7/2016 12:00	25.80953	-80.22153	912270.162369724	537220.85964752	37d09958-509a-4120-a295-a39e49767417	0101000020E6100000943B07A42D0E54C08E6BE3883DCF3940	0101000020BC080000D22C28891AD72B4120A1571F0D652041
1498	1892	NW 10 AV (SW 187 AV)	NW 8 ST	N	N	N	2	1	1	10/4/2016 12:48	25.45617	-80.49342	823311.632901683	408358.955635928	5be254c6-9ad4-4718-9233-30acce757676	0101000020E6100000A1FAD54D941F54C0EDF1E31EC8743940	0101000020BC08000083CBB06E1D2029410200F07EA2EC1841
1499	5465	N MIAMI AV	NW 160 ST	S	N	N	0	0	0	11/4/2016 14:10	25.92185	-80.20009	919076.51684254	578088.223766074	758d9f07-909f-484d-b2ea-0ab1f52760da	0101000020E6100000E9485C4DCE0C54C062B5428AFEEB3940	0101000020BC08000083796E3F470C2C41FD5100DF53A42141
1500	2621	COLLINS AV	18 ST	N	N	Y	1	0	1	10/11/2016 14:3	25.79375	-80.12944	942607.612514913	531676.941252448	69357255-6fbb-45d2-8d36-11c24d194a2b	0101000020E610000055814BBD480854C09AAE41B433CB3940	0101000020BC080000C6B98B731DC42C4170696E48BD392041
1501	2388	E 49 ST	E 5 AV	E	F	Y	1	0	0	10/14/2016 12:5	25.8671	-80.2723	895453.18353131	558050.004329905	5ebb5cd5-c2c1-4487-b749-312ab21deb1c	0101000020E61000009F37BF5B6D1154C094CE7071FADD3940	0101000020BC080000D367C291B8532B410A531A6CC7072141
1502	3778	SW 288 ST	SW 154 CT	W	N	N	0	0	0	10/4/2016 12:58	25.49949	-80.44183	840271.092126556	424170.829854071	72b7946a-4ca6-46f9-9849-8725ce6de9a8	0101000020E6100000D538E2E7461C54C06A1A5013DF7F3940	0101000020BC080000FC110F5C9CA429414CA25302B2E31941
1503	2638	COLLINS AV	# 5005	N	F	Y	1	0	1	10/11/2016 15:5	25.82648	-80.12158	945113.517249078	543589.121836126	8b72b92d-81d4-42d2-b097-8c0eef87728c	0101000020E6100000657AA302C80754C0BDC2946F94D33940	0101000020BC08000056D42043B1D72C416DE37EA6CD962041
1504	3387	SW 152 AV	SW 288 ST	S	N	N	1	1	1	10/4/2016 12:50	25.49966	-80.437	841861.656157743	424237.135153621	8a6b2522-503f-44ed-8b2c-cc2882a6bcad	0101000020E6100000E783BFE2F71B54C06B52C6D2E97F3940	0101000020BC080000A20FFB7C09B1294171D8E13ABBE41941
1505	9183	SW 124 ST	SW 68 CT	W	N	N	1	0	0	11/30/2016 11:5	25.65592	-80.30523	885027.872973945	481237.971636578	ffe78cba-15be-4ef3-9de3-7cc2e1f5189f	0101000020E61000007A36F8F2881354C05635B5F0EAA73940	0101000020BC08000084EF98F145022B41DB416DA25E5F1D41
1506	6950	NW 2 AV	NW 8 ST	N	N	Y	1	1	0	10/21/2016 13:1	25.78154	-80.19793	920096.815302871	527093.668929547	f35afb7c-e727-4658-8785-fd73723815c8	0101000020E6100000D7BF3AF6AA0C54C09507B91D13C83940	0101000020BC08000087B188D83F142C4191D562BCEE152041
1507	2313	E 9 ST	E 2 AV	W	N	Y	0	0	0	10/2/2002	25.83011	-80.27745	893832.942326937	544597.495794758	1a992922-381e-4723-91ee-0b5466ddbf16	0101000020E610000041EFCCC4C11154C0EC092A8782D43940	0101000020BC0800009364191610472B41E59FE065AE9E2041
1508	2416	W 60 ST	W 16 AV	E	N	Y	1	0	0	10/3/2016	25.87697	-80.31573	881153.527043868	561562.084571451	c8ab806d-9684-4cc0-ab18-eaa876372368	0101000020E610000010BA3AE6341454C0C410AD8B81E03940	0101000020BC080000F51BC33F01E42A414E797F9537232141
1509	9791	SW 26 ST	SW 143 CT	W	F	N	1	1	1	9/14/2016 16:12	25.74328	-80.42724	844699.761726476	512796.645689622	0d99ad32-0872-489b-aa39-7c018dbd26f1	0101000020E610000084C361E5571B54C0B731A02A48BE3940	0101000020BC080000B8E55BB335C72941B105B65C794C1F41
1510	6584	NW 203 TE	NW 46 AV	W	N	N	0	0	0	8/31/2016	25.95852	-80.27705	893706.013141304	591269.35589245	00bab575-9a6b-4bdf-94a6-f916e73e9864	0101000020E61000003035DF47BB1154C0EED820AE61F53940	0101000020BC080000F12C3E3A12462B41FD8C6B244E0B2241
1511	9718	SW 147 AV	SW 56 ST	N	F	N	1	1	1	10/13/2016 14:1	25.71423	-80.431	843506.612183791	502232.605178177	5b990d3d-87df-4a33-b185-868b1252d305	0101000020E6100000EAC08D8C951B54C01C2D9A47D8B63940	0101000020BC080000E7449766E3BD29414BEAC13069A71E41
1512	7670	NE 62 ST	NE 1 AV	E	N	Y	0	0	0	11/2/2016 12:25	25.83261	-80.19429	921185.269211482	545665.515347853	ef4c8eee-e8ad-4d85-88cf-c48e68440377	0101000020E610000065DD6F1C6F0C54C0457F066F26D53940	0101000020BC0800002B4506C1C01C2C412D58297006A72041
1513	5831	NW 173 DR	NW 53 PL	E	F	N	0	0	1	10/26/2016 13:0	25.93118	-80.28815	890114.08525629	581313.18718113	c76ad011-73e6-4bb4-b304-7f7e626e36d9	0101000020E6100000DEABE113711254C0CC79411F62EE3940	0101000020BC080000F5A0A95E022A2B413EF9B0CC85BD2141
1514	1714	SUAREZ ST	RIVIERA DR	SE	N	N	0	0	0	10/12/2016 11:1	25.72658	-80.26588	897849.096005082	506989.967991851	c45d8c5c-1372-4891-a14d-2bf0af811375	0101000020E6100000C6374B2C041154C00B901BB701BA3940	0101000020BC0800002F5D496570662B41739ABBA5BEF11E41
1515	3115	SW 107 AV	SW 160 ST	S	F	N	1	1	1	8/17/2016	25.62017	-80.36588	865111.403665699	468144.263566814	2020e8ac-1690-41d8-90e2-7d8c71ff5733	0101000020E61000007373629F6A1754C0D6800E07C49E3940	0101000020BC0800003641A3FEAC662A417AE4ECC9C7921C41
1516	2509	SW 6 AV	SW 4 ST	S	F	Y	0	0	0	8/17/2016	25.46583	-80.48549	825915.619170636	411880.155276418	554c37bc-2af4-4fbe-b900-c6bdd1abf0fc	0101000020E610000097646954121F54C032DC9C4341773940	0101000020BC080000CC57F86775342941043D314CA7231941
1517	5946	NW 199 ST	NW 59 PL	E	F	N	1	0	0	10/28/2016 12:0	25.95324	-80.29962	886301.186695807	589310.279750571	049b6dda-786c-471a-8b52-2e160ab2973c	0101000020E61000004732C2042D1354C0FF3A2DB707F43940	0101000020BC08000038DB1A92380C2B410A6125FDFFFB2141
1518	2507	SW 6 AV	W MOWRY DR	S	F	N	0	0	0	8/17/2016	25.46924	-80.48554	825893.691712637	413115.779483385	63d1709b-ffcb-4a82-a6d3-41310686ccbc	0101000020E61000005DD6832E131F54C0C9D32B1620783940	0101000020BC0800007AC2298D49342941CE7BA7CBF5361941
1519	8306	NW 59 CT	NW 151 ST	S	M	N	0	0	0	11/8/2002	25.91013	-80.29771	887012.139055591	573644.485317446	8b5b5f3a-bbf6-41f3-8e0a-8b7a94622fa2	0101000020E610000064C104C20D1354C0629C3675FEE83940	0101000020BC0800001C94D279C6112B4134D154649C812141
1520	2174	W 12 AV	W 32 ST	N	N	Y	1	0	0	10/10/2016 13:2	25.85058	-80.30628	884310.427606143	551986.174263924	9830b145-3270-4210-b93a-4596ecb861de	0101000020E61000005324A01E9A1354C0066312FCBFD93940	0101000020BC08000025423F0DABFC2A41FD762CC267D82041
1521	1783	NW 87 AV	NW 53 ST	S	F	N	0	0	0	11/9/2016 16:26	25.81891	-80.33774	874020.88879041	540422.291223928	dc22d57c-a063-4807-9002-d15d021881b3	0101000020E6100000E56B0C9C9D1554C0EB064686A4D13940	0101000020BC080000535E11F847AC2A4189AC8BFC0F7E2041
1522	10347	BUSWAY	NE 2 DR	S	F	N	1	1	0	10/10/2016 13:2	25.47169	-80.47515	829318.711108468	414021.757283896	b874391f-85a7-4e6d-9d3a-6e44057c321e	0101000020E610000005694BEB681E54C0C834070BC1783940	0101000020BC0800004B8B92970B4F2941E9ED6DB51D451941
1523	7384	SW 27 AV	SW 3 ST	S	N	Y	1	1	1	9/19/2016 14:45	25.76966	-80.23913	906563.536314461	522698.184312344	a770ad3a-903b-4fe7-895e-b03af28e65e3	0101000020E6100000A9CACBFF4D0F54C0C3D08C1209C53940	0101000020BC08000043F2EA4785AA2B4127D144872FE71F41
1524	8246	SW 22 ST	SW 21 AV	W	N	Y	1	0	1	9/14/2016 12:14	25.75078	-80.22797	910277.559673402	515854.075595848	9e1ff0b9-d784-4394-81de-a2840dd07107	0101000020E6100000CBB7C31A970E54C01AF8A12933C03940	0101000020BC080000A6AB655489C72B4132EE3B163F7C1F41
1525	6338	NW 42 AV	NW 199 ST	N	N	Y	0	0	1	8/31/2016	25.95425	-80.26988	896070.602229718	589730.409136273	88692a20-2f6e-40d4-ba0c-a3ebc379f0d5	0101000020E610000094E8B3CE451154C0B9CA65D749F43940	0101000020BC080000651F19688B582B41023F5B3F48FF2141
1526	6744	BISCAYNE BD	NE 72 TE	N	F	Y	1	0	1	9/8/2016	25.84197	-80.18432	924441.337795991	549087.805063486	fdedba2b-8813-4f24-b496-dec8e617950a	0101000020E6100000120D93E0CB0B54C03201CDD98BD73940	0101000020BC080000F31180E430362C4132D1E604C3C12041
1527	2077	PALM AV	APPROX # 3950(39 PL)	S	F	Y	1	0	0	9/22/2016 12:09	25.85793	-80.2828	892019.931502029	554697.665610127	18d4fc5e-1b49-45f2-be47-58494ff5f9c9	0101000020E61000007C882C53191254C09C3A8D69A1DB3940	0101000020BC080000FCF43510E6382B415C2437BE96ED2041
1528	1865	NE 2 AV	NE 88 ST	N	N	Y	1	1	1	11/4/2016 12:56	25.85572	-80.19301	921549.799275219	554067.137665659	d5a20b1b-94b9-442b-9da0-4fe03fbbe1b2	0101000020E610000008FFA4625A0C54C0753C07D710DB3940	0101000020BC0800003ACF6FD0991F2C412319EAAFA9E82041
1529	385	W 8 AV	W 29 ST	S	F	Y	1	1	1	10/19/2016 16:4	25.84732	-80.29836	886920.832467027	550813.651061453	a972fa59-f1a7-40a1-99f9-2ea1e8cf1eec	0101000020E6100000C1C11D64181354C047F63713EAD83940	0101000020BC080000F0C4EBDC0F112B41712628B63ECF2041
1530	8537	NE 35 AV	NE 164 ST	N	F	Y	1	1	1	11/3/2016 13:16	25.93098	-80.13595	940137.396616317	581539.883869395	88b48de6-1240-4de5-894f-ade24045b4d6	0101000020E6100000F8B53C66B30854C069B8C4C054EE3940	0101000020BC08000009727E04D1B02C41F64C95314BBF2141
1531	2130	W 8 AV	W 25 ST	N	N	Y	0	0	0	10/19/2016 12:2	25.84424	-80.29809	887015.9326405	549696.109332412	65d3a611-b4ca-48b7-a5ae-35ff9721a1fa	0101000020E61000008A8C75F3131354C0DE737F7C20D83940	0101000020BC080000403F3C10CE112B417A00A6A083C62041
1532	4036	SW 157 AV	# 8501	N	N	N	1	0	1	9/26/2016 12:30	25.6867	-80.44592	838636.159689505	492204.812209874	b9f7162a-58d4-4795-b5a3-e9e2a44afe25	0101000020E6100000CAA294FF891C54C087AF65E0CBAF3940	0101000020BC080000AE8A577ED6972941DE310B02BA0A1E41
1533	3136	SW 107 AV	SW 96 ST	N	F	N	1	1	1	10/27/2016 11:5	25.68014	-80.368	864311.394058384	489937.517531566	5809303f-319d-4715-a1cf-5aa674b3aede	0101000020E61000004974C3398D1754C0C3A4BE491EAE3940	0101000020BC080000D76EA5F96C602A413E42D0D34CE71D41
1534	5328	FOUNTAINEBLEAU BD	OP # 9140	W	F	N	1	0	1	9/6/2012 13:49	25.77287	-80.34584	871443.367976855	523673.455630317	a3ceb344-a263-4f0d-ad9d-27c29426284c	0101000020E6100000AADB941F221654C024872BEBDAC53940	0101000020BC080000038F26ED24982A4142444D9D6CF61F41
1535	7143	SW 12 AV	SW 8 ST	S	N	Y	1	0	1	10/18/2016 13:4	25.76604	-80.21455	914661.159859106	521428.81218981	87d3de94-5ba6-4adb-ab0e-1720cc4617fd	0101000020E6100000754B9543BB0D54C01E97B0A21BC43940	0101000020BC0800009F1D1C88C8E92B4137B1E1095AD31F41
1536	8942	NE 135 ST	NE 9 AV	W	F	Y	0	0	0	11/14/2002	25.89976	-80.18108	925374.34807355	570099.845049918	648673a2-99d9-4934-bc34-66f786a153c7	0101000020E61000004FC200E0960B54C02C86213E57E63940	0101000020BC080000D29FCFE97A3D2C4102F70F1CEB652141
1537	8113	SW 1 ST	SW 12 AV	E	F	Y	0	0	1	9/6/2016 11:29	25.77245	-80.21435	914717.053763092	523757.223862991	b0237913-b7fc-4764-b3bd-5662796829da	0101000020E6100000645F63CAB70D54C077D2C864BFC53940	0101000020BC080000CB9BE45138EA2B41473D1CB0BBF71F41
1538	6900	S MIAMI AV	BRICKELL AV	NE	N	N	0	0	0	10/14/2016	25.7495	-80.20719	917118.956763308	515431.959998868	ef9033c5-4af9-4b49-99a1-cbc42c809afa	0101000020E61000001E30E2B5420D54C0CAD13EBCDFBF3940	0101000020BC080000DD7E7920FCFC2B4143BCCD9FA6751F41
1539	4502	SW 87 AV	SW 76 ST	S	F	Y	1	0	0	11/9/2016 17:11	25.69834	-80.33407	875450.869825605	496605.431725785	4c36fa2b-5381-4d3e-916e-84b35af998e2	0101000020E6100000D939286A611554C091F843B7C6B23940	0101000020BC0800000559A5EE73B72A4167A08D7D7C4F1E41
1540	2099	PALM AV	W 29 ST	N	N	Y	1	0	0	10/20/2016 8:45	25.84816	-80.28226	892216.253279798	551148.296052448	65dc20b9-79a5-4870-a838-2bfcc17dfe36	0101000020E6100000184CA382101254C0A877A64121D93940	0101000020BC080000707804B56E3A2B412F027600DCD12041
1541	10109	Meridian Ave	18 St	N	N	N	0	0	0	7/14/2005	25.79308	-80.13649	940288.785419848	531417.771849722	75e3cb5c-95d6-4f79-bdba-594faafeaed2	0101000020E6100000C74D8847BC0854C0FAC6BDBA07CB3940	0101000020BC080000EA91D5CBFFB12C41338995F1B6372041
1542	3792	SW 296 ST	SW 153 CT	W	N	N	0	0	0	8/17/2016	25.49212	-80.43935	841099.387018006	421495.7009883	b29f4afe-f5b3-48f8-bd4a-f7c21ffd3749	0101000020E6100000CB8D96521E1C54C006483413FC7D3940	0101000020BC080000648826F314AB2941A9788D7DE5B91941
1543	1017	DADE BD	ALTON RD	NE	N	N	0	0	0	8/22/2002	25.79304	-80.14173	938564.355843719	531390.503543504	73cf1879-686e-4c27-89a0-331aa4ee3f2f	0101000020E61000004F9AE325120954C010A48CD804CB3940	0101000020BC08000019838BEF86A42C412B98426880372041
1544	6120	NW 2 AV	NW 179 ST	S	F	N	0	0	0	9/20/2016 12:37	25.93872	-80.20512	917387.658973698	584210.70496843	d339aeda-fbe2-4a16-aca4-5b2f04cb6992	0101000020E61000004372BFA1200D54C05B8A884350F03940	0101000020BC0800000ED2E78715FF2B417A3549D628D42141
1545	2314	E 9 ST	E 1 AV	W	N	Y	0	0	0	10/18/2016 15:5	25.83005	-80.27945	893175.513501752	544572.443049826	d2fd68c6-cd1e-4972-a3de-a4c2bf4f0fd2	0101000020E6100000B2223985E21154C0354B4EA97ED43940	0101000020BC0800008942573AED412B41948DEC4A7C9E2041
1546	5315	FOUNTAINEBLEAU BD	# 9740	E	N	N	2	0	1	9/6/2012 13:03	25.77561	-80.35609	868066.61952249	524652.723400392	1d950e37-c2e9-4613-b036-1a501eafa104	0101000020E61000004C6B6FFEC91654C0DCC8BC7C8EC63940	0101000020BC080000B8DB756DC37D2A41B73BBFD7DC022041
1547	5380	COLLINS AV	OP # 15000(BOAT RAMP)	N	N	N	1	1	0	10/11/2016 13:0	25.91678	-80.12243	944617.809237443	576409.496486872	fc043629-9f96-48ed-8a65-010f0eb47458	0101000020E610000069BCDEC5D50754C030F75467B2EA3940	0101000020BC080000338958D8D1D32C4122DD746A36972141
1548	9035	NW 135 ST	ALEXANDRIA DR	W	F	N	0	0	0	2/15/2017 11:18	25.89691	-80.25491	901112.087235715	568919.631891578	10f91e9f-ec85-499a-871d-c104e9752e03	0101000020E610000090419D57501054C0C868D1879CE53940	0101000020BC080000DA4B2A61EE7F2B416B6FCBAEB25C2141
1549	9132	SW 57 AV	SW 102 ST	N	F	N	1	0	0	11/30/2016 15:4	25.67727	-80.28438	891855.892781489	489031.839911588	6c19d380-14e2-44ed-b3a0-809e7d057200	0101000020E61000005C76BD42331254C0A412EDAC61AD3940	0101000020BC0800009FDC82FC9D372B41E8D5A31D26D91D41
1550	754	NW 36 ST	PALMETTO DR	W	F	N	1	0	0	11/8/2016 12:04	25.80798	-80.2816	892510.139516927	536545.45087669	63b850a5-2c81-4f21-8b19-f2e4b8ed3ed1	0101000020E6100000715423D8051254C000C6F104D8CE3940	0101000020BC0800006999E67ABA3C2B411956DC4DC65F2041
1551	8060	W FLAGLER ST	NW 58 AV	W	F	Y	1	1	1	9/8/2012 10:30	25.77084	-80.29023	889747.591564007	523030.706589185	7980fcc8-052e-4176-ba00-bbf76ab30090	0101000020E6100000709BA70A931254C04EBF33F255C53940	0101000020BC080000FD20026225272B4118C7299E61EC1F41
1552	1876	NW 6 AV	LUCY ST (SW 8 ST)	S	F	N	1	0	1	8/17/2016	25.46197	-80.48541	825948.763139583	410474.120369248	f170c6e5-6bb8-4b63-9e02-eb2c3c9ee1b0	0101000020E6100000677916F4101F54C0A3FD8EB443763940	0101000020BC080000F3C6C8B1B7342941F6CF2A28AF0D1941
1553	6299	NW 37 AV	NW 167 ST	N	F	N	2	0	2	9/1/2016 13:23	25.92702	-80.26059	899178.447367836	579852.393797167	f1aabb4c-33c4-4d1c-a738-a5d43fe80c49	0101000020E61000007148FEA1AD1054C0508D5BB051ED3940	0101000020BC08000014574919D3702B4170B75B361CB22141
1554	4734	NW 7 AV	NW 90 ST	S	N	Y	1	1	1	9/21/2016 14:32	25.85731	-80.20964	916080.164238419	554612.550276443	7895cef6-b941-4ea9-847e-751a2838bb08	0101000020E6100000751831B46A0D54C0CB105B2C79DB3940	0101000020BC080000B2B8988ADEF42B4161373583ECEC2041
1555	10223	NW 107 AV	NW 25 ST	N	F	N	0	0	0	11/14/2006	25.79717	-80.36895	863793.425320424	532468.761567548	2114cd88-d469-4aa4-a900-416b980449e7	0101000020E6100000449F56DF9C1754C0EA9B648213CC3940	0101000020BC0800008E0F7A09615C2A41BDF16AECEC3F2041
1556	5058	NW 118 AV	NW 2 ST	S	N	N	1	1	1	1/5/2017 11:41	25.77018	-80.38723	857825.159034479	522629.901293628	d8f9ca2a-6315-4c38-94eb-b2daba2dc10d	0101000020E6100000C9F5D856C81854C0BDFEA58F2AC53940	0101000020BC0800000A895380C02D2A411A3846651EE61F41
1557	5947	HONEY HILL RD	NW 55 PL	E	F	N	1	1	1	10/28/2016 12:1	25.95631	-80.29231	888696.196363427	590440.137058914	58c65101-cf3d-4d0f-99bd-2c9e63de9801	0101000020E6100000EDFAF74CB51254C05237941BD1F43940	0101000020BC080000EE0A5697EE1E2B4137A843B4D3042241
1558	4751	NW 17 AV	NW 75 ST	N	F	N	1	1	1	8/18/2016	25.8431	-80.22521	910988.555626038	549415.327749312	1a8d44b1-a7ed-41e2-b0b7-9b6d294fd3df	0101000020E61000001B297EE2690E54C019812894D5D73940	0101000020BC080000B83B4E5217CD2B41D48F821052C42041
1559	961	W FLAGLER ST	SW 72 AV	E	F	Y	1	1	1	9/8/2012 13:50	25.77007	-80.31175	882665.502717849	522712.903789163	27d4e706-f697-4787-9d62-56803f78931a	0101000020E61000000330E1B0F31354C0A492F76A23C53940	0101000020BC0800002765A233D1EF2A41D48EE2676AE71F41
1560	9885	HARBOR DR	WESTWOOD DR	S	F	N	0	0	0	11/14/2016 14:0	25.68706	-80.17181	928908.802647047	492808.408135869	1d54d8c6-4f51-4910-95c0-563e1d376a67	0101000020E6100000C91062F6FE0A54C09421D799E3AF3940	0101000020BC080000422F21D317592C41DA8AA16428141E41
1561	3308	SW 137 AV	SW 136 ST	N	F	N	2	0	0	11/29/2016 14:5	25.64167	-80.41465	849010.904358573	475883.758907042	3d0f2821-ac4d-4c5e-b87a-19b473ba4955	0101000020E610000005E01F75891A54C03979B8EB44A43940	0101000020BC080000D3FD01FDE3E82941DAB70CC7B50B1D41
1562	1344	BISCAYNE BD	NE 211 ST	SW	N	Y	1	0	1	11/3/2016 13:18	25.97061	-80.14397	937407.635711908	595929.045044459	db27bcae-3d32-4fcf-ba1f-02ec03120b56	0101000020E6100000AF4960C8360954C0A124E2457AF83940	0101000020BC080000031E937E7D9B2C4143A0E685B52F2241
1563	7075	NW 7 AV	NW 54 ST	N	F	Y	1	1	1	9/20/2016 13:13	25.82525	-80.20806	916668.334961403	542963.208066471	5ae445a7-88d5-4f37-b8de-16e4b4e0af64	0101000020E61000003AC627E6500D54C00315712744D33940	0101000020BC080000430813E276F92B41A7926CD2E9912041
1564	5435	NE 6 AV	# 15156	S	M	Y	1	0	0	11/1/2016 13:59	25.91444	-80.18768	923170.907241438	575419.597532727	ac3676ca-fb53-4e34-aa34-f0500a74d3c6	0101000020E61000008662CF0A030C54C0DE3E49DA18EA3940	0101000020BC080000F7ECD207442C2C41AA58069E7A8F2141
1565	3511	SW 152 ST	# 11905	W	N	Y	2	0	0	11/17/2016 11:5	25.62727	-80.38626	858384.004032016	470693.135445014	80ac14b6-845e-47e9-a457-e74e312629b8	0101000020E6100000395C5387B81854C0A563505595A03940	0101000020BC080000B91F2C311E322A410A135A479BBA1C41
1566	7988	NW 7 ST	NW 39 AV	E	N	N	0	0	0	9/7/2016 12:42	25.77872	-80.26001	899674.969678916	525950.222098872	014934cb-9664-4851-81ce-ea30b8c0704e	0101000020E6100000E067EB03A41054C0DEBC46805AC73940	0101000020BC080000BF9DDB24B4742B415DAC6ED7FF0C2041
1567	4241	SW 72 ST	SW 103 PL	W	N	N	1	1	0	9/26/2016 13:55	25.70134	-80.36162	866373.452314299	497649.198994391	8fb93c4d-c3a5-4903-bdf5-49d799446bc0	0101000020E61000004F7843CB241754C0D8FB0BFF8AB33940	0101000020BC0800004520B41789702A417A66B18FCB5F1E41
1568	10002	COMMERCE WAY	NW 85 AV	E	N	N	1	0	0	10/19/2016 15:0	25.90202	-80.33891	873485.93311809	570628.919838428	423e46de-75b3-4b59-bb0e-fd657127b5cd	0101000020E6100000DDF439AEB01554C0C742636BEBE63940	0101000020BC08000020DDA00E1AA82A415F9A68420D6A2141
1569	2888	17 ST	JEFFERSON AV	E	F	Y	0	0	0	11/14/2016 13:3	25.79207	-80.13746	939972.680099212	531047.488158084	8a2100fb-27b6-4dcf-8bcd-4eb9936347c4	0101000020E6100000F8B49E23CC0854C0024B6E57C5CA3940	0101000020BC080000DAEDD89587AF2C4189E16060D2342041
1570	7327	SW 22 AV	SW 23 ST	S	F	Y	1	1	1	10/17/2016 15:5	25.74874	-80.23015	909565.298647288	515110.238182262	861f4d09-d964-4406-af22-ab5e0602e97b	0101000020E6100000644BC5C5BA0E54C0AFD3FFCBADBF3940	0101000020BC08000055888ECEF8C12B41ED7F80BC9F701F41
1571	2828	ALTON RD	29 ST	S	F	N	1	0	0	8/22/2002	25.80502	-80.13861	939562.817428604	535751.594529897	d1745bd3-5414-40e7-96c9-e2a5cb0121e5	0101000020E6100000C7B37603DF0854C0350FA4F715CE3940	0101000020BC080000344D12DC53AC2C417249609792592041
1572	5366	SW 8 ST	SW 94 AV	W	F	N	2	0	1	9/8/2016 11:22	25.76189	-80.34967	870199.004691873	519678.604390524	965bc2be-c005-43b1-a224-105310479e13	0101000020E6100000B883E80D611654C0FE90F2B90BC33940	0101000020BC0800000681F5326C8E2A41D11F533401B81F41
1573	9355	SW 109 AV	W FLAGLER ST	S	F	N	1	0	0	11/15/2016 12:3	25.76808	-80.37306	862494.408860877	521891.493989818	9af013e3-fdc2-4b46-bd8b-2eb74296b171	0101000020E610000034802E10E01754C08C22B875A1C43940	0101000020BC080000DAC0F5003B522A4186D618C494DA1F41
1574	8937	NE 135 ST	ARCH CREEK RD	W	N	N	1	0	1	11/14/2002	25.90032	-80.16268	931420.742129557	570339.756663896	2145d12c-30b6-4391-bd60-771de90432b5	0101000020E61000008FE29079690A54C0018F839D7BE63940	0101000020BC080000A7FB53B4B76C2C411986F5EECA672141
1575	7608	NE 79 ST	NE 3 AV	W	F	Y	1	0	0	11/2/2016 10:54	25.8477	-80.19112	922188.975526426	551157.013554201	59472927-f0d5-4af7-9399-15c8c8b14084	0101000020E6100000ADEF986F3B0C54C0DACC0C7003D93940	0101000020BC0800000F7BC32A98242C41B994E36FEDD12041
1576	1340	SW 1ST AVE	W FLAGLER ST	N	N	Y	1	1	1	10/25/2016 10:5	25.7735	-80.19564	920869.552640986	524176.725649953	41b3de27-7149-4121-8d96-5591c90a0d7e	0101000020E6100000CB307D60850C54C0118B6D5604C63940	0101000020BC08000044DC2252491A2C41598020B249FE1F41
1577	2279	HIALEAH DR	SE 8 AV	E	F	Y	1	0	0	10/19/2016 12:2	25.82306	-80.26471	898036.292156361	542058.284672089	cf1b5d50-9dd1-4e2a-9f73-c7a54039dc66	0101000020E61000004718531EF11054C06A36C57FB4D23940	0101000020BC0800008548BFC9E6672B41BCE68EF9D78A2041
1578	5324	PARK BD	NW 87 AV	W	F	N	1	0	0	9/6/2012 13:42	25.7733	-80.33767	874128.970891126	523842.436258398	4227ae83-27e0-4c16-83bc-347a489d7863	0101000020E6100000A67378619C1554C0F944D3F7F6C53940	0101000020BC0800003382222220AD2A417001838910F91F41
1579	5277	BLUE LAGOON DR	# 6161	W	N	N	1	0	1	11/8/2016 12:24	25.78324	-80.29583	887878.55693721	527529.18615295	86865a6a-b74e-4cbb-a7cd-6f296b0f6a60	0101000020E6100000F97FEFE3EE1254C0F38ED8DA82C83940	0101000020BC08000042D2FE4F8B182B4109E229C555192041
1580	7246	SW 17 AV	SW 22 ST	N	F	Y	1	1	1	8/18/2016	25.75126	-80.22184	912293.276773743	516042.209779829	3c633e56-920f-441a-812f-ee6b7d23e258	0101000020E6100000A2CA42B8320E54C0D0E596F252C03940	0101000020BC0800006656ADC348D72B4109937F9F2F7F1F41
1581	7425	NW 27 AV	NW 3 ST	N	N	Y	1	1	1	9/16/2016 11:37	25.7751	-80.23907	906573.510020144	524675.553035498	533b03a3-bca2-4a99-b568-ca05556cff02	0101000020E6100000F0372BEF4C0F54C0C2A99F966DC63940	0101000020BC080000D0E3633A99AA2B41FACDBA800A032041
1582	7295	NW 19 AV	NW 18 ST	N	N	N	0	0	0	11/19/2002	25.7917	-80.22733	910403.975117546	530727.942839034	50bf71f6-0b69-4a17-b895-bd1e86031350	0101000020E610000071B7AA788C0E54C0CBB9B5D4ACCA3940	0101000020BC0800003F76122986C82B41E0A6174953322041
1583	4222	SW 56 ST	SW 93 AV	E	N	Y	1	0	0	10/12/2016 17:1	25.7162	-80.34523	871741.742390975	503079.102131248	39bccdf9-2c32-4896-9eec-9a904c4e3156	0101000020E61000000DF6C45B181654C08ECCF65159B73940	0101000020BC0800007C91F3AC799A2A4121EAAD2DA3B41E41
1584	1016	BRICKELL AV	SE 12 ST	N	N	Y	1	0	0	9/13/2002	25.76206	-80.19165	922208.493173882	520025.615473188	654e4524-f57f-4749-998c-2a85ca64b4c1	0101000020E6100000FD7C04FD430C54C07526B06816C33940	0101000020BC08000034C1E333BF242C41D00D03406DBD1F41
1585	8858	NE 123 ST	NE 16 AV	E	F	N	1	1	1	10/31/2016 16:5	25.88922	-80.16555	930504.864410404	566299.918603569	a61b13a7-f963-40e6-867d-916379652028	0101000020E6100000A2420D66980A54C03939EB4BA4E33940	0101000020BC0800003E7CE6F28F652C4182E14C413B482141
1586	6910	SW 1 AV	SW 13 ST	S	N	Y	0	0	0	9/13/2002	25.76164	-80.19519	921041.996164739	519866.906529665	9d9bae4d-7a38-4228-a3e2-fa6844bd91e6	0101000020E61000003457381A7E0C54C0D9739614FBC23940	0101000020BC0800004CD03935A21B2C41CA59366AF2BA1F41
1587	3795	SW 296 ST	SW 155 AV	E	N	Y	0	0	1	8/16/2016	25.492	-80.44299	839898.879278071	421447.411112562	799b8654-e13a-49f0-9e2a-9d96ca7c8efc	0101000020E6100000364FDBF5591C54C0DC8BB646F47D3940	0101000020BC0800001C5411EFB3A12941861EB55424B91941
1588	2693	INDIAN CREEK DR	26 ST	S	F	N	1	0	1	10/11/2016 12:5	25.80194	-80.12634	943608.238771297	534658.717487603	af9e65eb-5662-4dd6-9acf-022686b4f045	0101000020E6100000178AC1EE150854C0943ED21D4CCD3940	0101000020BC080000626A3DB4EECB2C41206441D608512041
1589	7109	NW 10 AV	NW 4 ST	S	N	N	0	0	0	9/6/2012 14:58	25.77761	-80.21166	915592.424724013	525638.366421156	bd8025d3-7de2-4ca0-bd9e-a01d289d5f6c	0101000020E61000006E03EEA68B0D54C0614D03A011C73940	0101000020BC0800006BF9EC0F0FF12B412A713521900A2041
1590	3298	SW 137 AV	SW 128 ST	S	F	Y	2	0	1	11/29/2016 11:3	25.64785	-80.4157	848650.464097291	478126.148791924	dc9d2409-9761-46c6-afaf-ac65e0463de8	0101000020E610000086BCDEE39A1A54C02758488AD9A53940	0101000020BC08000054167E1B13E62941228E1957BF2E1D41
1591	1209	NE 163 ST	# 290 (COLONIAL BNK)	E	M	Y	0	0	0	8/27/2002	25.92965	-80.12503	943731.614164177	581081.744029768	27e3887a-78ef-466b-a8c3-ffe4e9b0a55c	0101000020E610000059434163000854C082F82BDAFDED3940	0101000020BC08000039217874E5CC2C41CB4AE5E9B6BB2141
1592	8103	W FLAGLER ST	# 2520 (SW 25 AV)	E	N	Y	1	0	1	9/8/2012 12:28	25.77231	-80.23721	907192.479881939	523664.669248082	5c1cf4f4-a8e7-42aa-a380-8064756a690f	0101000020E61000005F582D692E0F54C0847A66ADB6C53940	0101000020BC080000B58C0C2B6FAF2B41B6E1FF7749F61F41
1593	5504	NW 7 AV	NW 155 LA	S	F	Y	1	0	1	9/21/2016 12:05	25.91706	-80.21202	915167.05318734	576325.259489469	5d04028c-e029-4a9f-abde-51925b037321	0101000020E610000036A5A5B2910D54C04F3A44F3C4EA3940	0101000020BC08000069E37051BCED2B4149761BF18D962141
1594	3496	GRAHAM DR	MONROE ST	E	N	N	0	0	0	8/17/2016	25.63101	-80.37401	862414.519574597	472070.241239943	10ae6914-3275-400e-9153-3eff3754f4d0	0101000020E610000088A6B3CAEF1754C0ADA6CA3D8AA13940	0101000020BC0800000A60AA399B512A41133E14B41FD01C41
1595	3053	SW 97 AV	SW 104 ST	S	F	N	1	0	0	9/29/2016 12:56	25.6725	-80.35141	869786.91658397	487186.453811377	964012f0-6662-4013-aae1-874752cbc4c5	0101000020E61000002C9967837D1654C02A4F377629AC3940	0101000020BC080000FC7CED05348B2A411AE6A99150BC1D41
1596	8742	NE 16 AV	NE 130 ST	S	N	N	0	0	0	11/14/2002	25.89568	-80.16662	930136.509120762	568646.078607827	c4869298-9290-4b54-801b-89e06a4bf6c6	0101000020E61000008E24EF02AA0A54C0708089B94BE53940	0101000020BC0800008B1EE93CAF622C4188CF81938F5A2141
1597	2690	INDIAN CREEK DR	31 ST	SW	N	N	1	0	1	10/11/2016 12:4	25.80705	-80.12552	943867.98299583	536520.411593333	cfb116b2-906d-4de9-88bb-f90f4d3e7901	0101000020E6100000C1441062080854C02D4FD6769BCE3940	0101000020BC08000010475D31F6CD2C415318CA39945F2041
1598	3819	BUSWAY	SW 144 ST	NE	N	Y	6	1	0	9/29/2016 15:17	25.63566	-80.33821	874202.534747113	473818.734135285	3998dfad-3568-4656-a05a-1d66ad087d7e	0101000020E610000061D4FD31A51554C031F3342EBBA23940	0101000020BC08000067E5EA42B3AD2A41488052AD71EB1C41
1599	186	SW 13 ST	SW 2 AV	W	N	Y	0	0	0	9/13/2002	25.76157	-80.19706	920426.997404508	519839.16637639	60657e42-d576-47d3-8e53-c827f3570e6a	0101000020E6100000588060B99C0C54C0DE1447C1F6C23940	0101000020BC080000A4D1BE35D4162C4139660B7483BA1F41
1600	6489	NW 183 ST	NW 33 CT	E	N	N	1	1	1	10/27/2016 15:2	25.94038	-80.25713	900291.073735058	584713.727898985	31b07d43-adc9-4f46-a039-1df538611e01	0101000020E6100000D00FF3CB741054C03A3CB30DBDF03940	0101000020BC0800002F670B5A84792B41EE9C0EE216D82141
1601	8255	SW 22 ST	SW 36 AV	W	F	N	1	1	1	9/14/2016 13:18	25.75005	-80.25232	902262.403180737	515544.372826479	ec79f304-7f15-4a8d-b5ca-652e8b2f351d	0101000020E6100000088A1223261054C03E5624A603C03940	0101000020BC08000050631C03EB882B41E876654668771F41
1602	1444	96 ST	W BAY HARBOR DR	W	N	Y	1	1	1	10/31/2016 12:5	25.88677	-80.13297	941222.094242416	565476.670921877	d1aff433-cf8a-49f1-ade0-50379161eb42	0101000020E6100000B5A3C89F820854C01D67155703E33940	0101000020BC08000034A4F9694AB92C4154EE79C2CC412141
1603	7192	NW 14 AV	NW 63 ST	S	N	N	1	1	0	9/26/2016 13:45	25.83377	-80.22099	912395.625690542	546034.909946531	501da1cd-88c5-4bdd-b52a-b9e5e3c02c2b	0101000020E610000082DA1BCB240E54C0863B229672D53940	0101000020BC080000F30B527615D82B411FA5333AE9A92041
1604	8661	NE 163 ST	NE 26 AV	W	N	Y	1	0	1	11/3/2016 13:57	25.92634	-80.14653	936671.42226731	579832.740653299	8512efae-3949-4e4f-94da-96e6c55c18c4	0101000020E6100000596DCAB9600954C0F6CB1A0F25ED3940	0101000020BC080000A4834111BD952C419A70ECE7F4B12141
1605	1537	SW 42 AV	VELARDE AV	S	N	Y	0	0	0	10/12/2016 14:1	25.73577	-80.26226	899022.229507536	510333.912098959	89b3240f-f059-4060-b558-ac1215674329	0101000020E6100000B86EE8DCC81054C0E3E389775BBC3940	0101000020BC080000AE2DC6A99A6F2B41A62B366DFE251F41
1606	2194	W 12 AV	W 78 ST	N	N	Y	0	0	0	10/10/2016 14:3	25.89284	-80.30787	883706.533449657	567344.565781072	9fe6cebb-5a65-4339-92f7-e8cbfb2b95a0	0101000020E61000000DAA932BB41354C0A246BDBB91E43940	0101000020BC08000058675743F3F72A41F569BA8C64502141
1607	8639	NE 6 AV	NE 175 ST	S	M	Y	0	0	0	10/26/2016 13:4	25.93535	-80.18863	922812.880753685	583019.740163796	8d4db272-146c-4911-a28f-67a40b76a6f2	0101000020E6100000DFBE9F8A120C54C003B3D88973EF3940	0101000020BC080000261D2DFA77292C41C15005E8DACA2141
1608	1368	W COUNTRY CLUB DR	AVENTURA BLVD	S	F	Y	1	0	1	11/3/2016 13:44	25.96067	-80.13972	938826.427788351	592325.938391231	1b8cabc1-e514-4f56-82af-522e49d34f4c	0101000020E6100000F0215B37F10854C04664DCF9EEF53940	0101000020BC080000BADD471493A62C41BF2FD84E8F132241
1609	3555	SW 168 ST	SW 107 AV	E	F	Y	1	1	0	8/17/2016	25.6132	-80.36479	865484.048228137	465609.469413184	ffcf9148-1cff-43f3-8843-c7aeff4764d9	0101000020E6100000DE1DD1B2581754C0876ED7A6FA9C3940	0101000020BC0800002CCEB64896692A41A1631E9C2C6B1C41
1610	8151	SW 8 ST	SW 45 AV	W	N	Y	1	1	0	9/8/2016 13:42	25.76432	-80.26953	896569.493274666	520699.23026906	68c868ff-4ae7-4cef-b51d-ba8eae093576	0101000020E61000005BB1AC12401154C0FE0D0FD9AAC33940	0101000020BC080000549C9830715C2B4125AA96B5F3C71F41
1611	4594	SW 24 ST	SW 58 AV	E	N	Y	0	0	1	9/14/2016 13:01	25.74828	-80.28952	890024.454885367	514832.643280938	44e842a9-777f-4cdf-ac4d-1da6606f9505	0101000020E6100000D1F14775871254C0CA3CE2848FBF3940	0101000020BC080000069C171C4F292B41D0C5F25A496C1F41
1612	9305	SW 72 ST	SW 62 PL	E	M	Y	1	1	1	9/26/2016 14:58	25.70396	-80.29435	888522.697049644	498715.245420352	6e81d56f-4683-4da2-8300-a5184da96483	0101000020E6100000AD469A7ED61254C099FDB5E536B43940	0101000020BC080000D1E0E197931D2B41C7436EBF73701E41
1613	5742	NE 10 AV	NE 175 ST	S	N	N	1	1	1	11/1/2016 13:05	25.93679	-80.18052	925475.961069975	583557.561578862	4dfe87f5-4a3a-4a76-a0d2-3721e85700bc	0101000020E61000001DAD3A9E8D0B54C0D6E36484D1EF3940	0101000020BC0800003A439F23463E2C41077CC18C0ECF2141
1614	6714	BISCAYNE BD	NE 11 ST	S	F	Y	1	0	1	11/8/2016	25.78487	-80.18963	922820.368282698	528320.730820298	aa70698f-7e9e-4e81-bba5-6f706e1cd221	0101000020E6100000E8FAB0FD220C54C010A2DE59EDC83940	0101000020BC0800001647F5F386292C4165B62FDC841F2041
1615	9792	SW 26 ST	SW 142 AV	W	N	N	1	1	1	9/14/2016 16:09	25.74334	-80.42384	845817.864123799	512822.595453486	c626eff7-3e15-4c4d-8cbf-b37836a2e4f1	0101000020E6100000F4EB533D201B54C07646B2F74BBE3940	0101000020BC080000A8DDE6E7F1CF2941BA5B5529E14C1F41
1616	735	COLLINS AV	176 ST	S	M	Y	1	1	1	10/11/2016 13:4	25.93945	-80.1216	944831.11392368	584652.443955421	a24aaea7-4fd0-4535-be80-420194bac752	0101000020E6100000B9EE1E63C80754C002C1424D80F03940	0101000020BC0800005C5B7F747CD52C4146BAA7509CD72141
1617	6321	NW 37 AV	NW 191 ST	S	F	N	1	0	1	11/10/2016 13:5	25.94721	-80.2618	898745.317686763	587188.304341234	e795abf7-4691-4078-8429-fb2f8f977315	0101000020E6100000E52E9B29C11054C06433A9CB7CF23940	0101000020BC080000E318CAD6706D2B41A73A70096CEB2141
1618	10505	SW 152 AV	SW 152 ST	S	N	\N	\N	\N	\N	 	25.62587	-80.43896	841026.291675135	470105.512243263	cb559937-0d0f-4fa4-b865-04ca9b391870	0101000020E6100000DB17B0C0171C54C0BDAF4D4139A03940	0101000020BC0800006B3B37C282AA29414FBB09C96CB11C41
1619	3141	HARRISON ST	GRAHAM DR	S	N	Y	0	0	0	10/9/2002	25.63157	-80.37249	862915.03204732	472275.056453437	f93123dc-73e9-446b-8d96-a61f017e15eb	0101000020E6100000C74AF7DAD61754C0D294B6BEAEA13940	0101000020BC08000098092D4084552A41A3E308F752D31C41
1620	6276	NW 32 AV	NW 163 ST	N	N	Y	0	0	0	8/31/2016	25.92231	-80.25249	901856.038129117	578153.764649495	c68218cf-83a5-4678-8055-1e77bef29814	0101000020E6100000A308D2A4281054C0D8A2C5AF1CEC3940	0101000020BC0800000BBE0448BE852B417FA5EDF3D6A42141
1621	2660	COLLINS AV	87 ST	N	N	N	0	0	0	10/11/2016 12:1	25.87192	-80.12141	945058.021971248	560105.414266452	de5e767e-d2aa-43fc-b254-a83d1dcb9e69	0101000020E610000093163246C50754C0BE3EB05336DF3940	0101000020BC080000F14A7F4542D72C41CB1F533ED6172141
1622	2025	E 4 AV	E 58 ST	N	N	Y	0	0	0	10/7/2002	25.87515	-80.2748	894614.264878523	560973.545101978	15d924da-0faa-4fe6-929c-46fec79a9a8f	0101000020E6100000C48DE659961154C05BEEB9660AE03940	0101000020BC080000AF793FBB2A4D2B41BABF59819E1E2141
1623	2539	NE 15 ST	NE 6 AV	E	N	N	0	0	0	10/4/2016 14:44	25.48449	-80.46929	831232.812633298	418681.43825832	c50db4ef-4956-4d9f-92e2-4adc46b4aa8d	0101000020E6100000979E0EF1081E54C059EC74E7077C3940	0101000020BC080000C1EFB4CBFF5D2941B45DFA6FEC8D1941
1624	4591	SW 24 ST	SW 62 AV	E	F	N	1	0	1	9/14/2016 12:50	25.74811	-80.29526	888132.755559206	514761.066957228	0f6240cb-f33d-40a4-818b-6dccfe33dbd9	0101000020E61000001B8F25A2E51254C0C2F2887184BF3940	0101000020BC080000A1D4C9B5871A2B410D7FE80C2B6B1F41
1625	1546	SW 42 AV	MARMORE AV	S	F	N	0	0	0	10/14/2016 16:2	25.71535	-80.26131	899378.136615071	502916.346223272	f3d925fb-dd2c-43d2-96bb-d3c4f43aad40	0101000020E610000082285837B91054C0865025AE21B73940	0101000020BC080000F169567A62722B414347F72718B21E41
1626	9899	SW 147 AV	SW 180 ST	S	N	N	0	0	1	1/6/2005	25.59997	-80.42981	844079.02279992	460704.718399778	5814b496-67e1-4288-b6cb-b77024a55d58	0101000020E61000006A5558F8811B54C0388785CE97993940	0101000020BC080000C91CEF385CC22941F7ED9F99891E1C41
1627	6298	NW 37 AV	NW 165 ST	N	F	Y	1	1	1	9/1/2016 13:15	25.92421	-80.26047	899226.617913637	578829.826935731	27753522-9273-4cff-b209-42f9fd11cb49	0101000020E6100000CAB9ED84AB1054C036EA454599EC3940	0101000020BC0800004E64957033712B414C60FB131FAA2141
1628	2556	NW 8 ST	NW 4 AV	E	F	N	0	0	0	10/4/2016 14:01	25.47709	-80.48307	826697.851825301	415972.654953144	5136e70c-d7c7-4489-a7c4-661f3b58feaa	0101000020E6100000DD6B63B2EA1E54C01791E5AC227A3940	0101000020BC080000F0E735DF913A29413987FC4C99631941
1629	7062	NW 7 AV	NW 22 ST	N	F	Y	0	0	0	9/21/2016 12:01	25.79857	-80.20705	917061.00613204	533265.717976548	7a8024d0-cb61-4bc0-a053-d694d939db5e	0101000020E61000006E24BD40400D54C06AFF8E426FCC3940	0101000020BC080000BD82B73988FC2B41B17948D626462041
1630	2419	W 60 ST	W 24 AV	W	F	N	1	1	1	10/19/2016 14:2	25.87708	-80.33164	875921.689776428	561575.83946985	ad988f20-57d5-4135-a21a-fca878dcfb4f	0101000020E61000009C89D195391554C0BC2FB9E288E03940	0101000020BC0800009A03799221BB2A412A6C021853232141
1631	4729	NW 7 AV	NW 101 ST	S	N	Y	1	1	1	9/21/2016 14:12	25.86753	-80.20997	915946.999135677	558325.458840884	3c41f435-0c5a-4b02-93e5-9b7dc78242ef	0101000020E61000002B65AC39700D54C0A19938C116DE3940	0101000020BC08000062F3F135D4F32B418339E754EE092141
1632	4861	NW 27 AV	NW 100 ST	S	F	N	1	1	1	9/19/2016 11:49	25.86554	-80.24255	905239.32897158	557538.313088968	55af280e-beef-4df3-b948-ace428d9f394	0101000020E6100000F2CC2AEF850F54C00A81FB3494DD3940	0101000020BC080000DDEE73DD2CA02B4148D8120AC8032141
1633	3160	SW 112 AV	SW 163 ST	S	F	Y	1	1	1	11/17/2016 13:3	25.61716	-80.37395	862458.740280576	467035.459028654	00ad3f7a-eefb-4f17-b769-f45beb3e836e	0101000020E61000002FC6A6C6EE1754C0ED74F95EFE9D3940	0101000020BC0800006081C4AAF3512A41901FEF9174811C41
1635	4270	SW 72 ST	SW 128 CT	E	N	N	1	0	0	9/26/2016 15:34	25.70022	-80.40168	853182.350382324	497182.198608063	c10eb270-860e-4072-95c4-9adc925174f7	0101000020E610000073331A38B51954C089066EEC41B33940	0101000020BC080000D8E3D1E17A092A419C28FA8E7F581E41
1636	8930	NE 135 ST	NE 6 AV	E	F	N	1	0	0	11/12/2002	25.89937	-80.18651	923588.815215733	569945.156713836	6fbfa345-f733-4b71-b461-4ed3cb109306	0101000020E610000079A2DBE7EF0B54C0A669225B3DE63940	0101000020BC0800000E6CBFD8872F2C4189119ABBB5642141
1637	3392	SW 157 AV	SW 296 ST	S	F	N	0	1	0	8/17/2016	25.49164	-80.44496	839249.608607344	421312.040953599	6b8c1985-8a4f-4be0-9375-e9c0788d9474	0101000020E610000091B2A33C7A1C54C057A9095BDC7D3940	0101000020BC080000BB025364A19C2941C246DED906B71941
1638	7855	NW 17 ST	NW 14 AV	E	F	Y	0	0	0	9/1/2016 12:27	25.79113	-80.21887	913184.315686349	530539.345111392	f9617eb6-589f-4069-bde2-55d4ef00321e	0101000020E61000001E909017020E54C03CFE5ADE87CA3940	0101000020BC0800008B25C9D73EDE2B416942EF16DA302041
1639	7128	NW 12 AV	NW 27 ST	S	N	Y	0	0	0	9/26/2016 14:52	25.80185	-80.21551	914267.693449102	534441.19593171	0457c790-3cb0-4151-8afc-a44efbe31895	0101000020E6100000864D1EFECA0D54C05646D43746CD3940	0101000020BC0800000A214099B5E62B41FD641ACB554F2041
1640	7987	NW 7 ST	NW 43 CT	E	N	Y	0	0	0	9/7/2016 12:31	25.77859	-80.26673	897466.765776914	525892.440051809	0cea0e28-6371-4b8c-b6e4-fb1d15dabf99	0101000020E610000087B0E6F7111154C0B8D61B4F52C73940	0101000020BC0800007CE836BC73632B41BA52FB468C0C2041
1641	5042	NW 87 AV	NW 12 ST	S	F	Y	1	0	1	11/9/2016 16:34	25.78277	-80.33682	874390.38542027	527285.801452756	6cc3267b-5290-4b07-b97f-bbb5683423c8	0101000020E6100000063FE4808E1554C0AA4C199863C83940	0101000020BC080000E21771F62AAF2A4166DA27006F172041
1642	3572	SW 176 ST	SW 107 AV	W	N	N	0	0	1	11/17/2016 10:0	25.60581	-80.36469	865530.188592374	462927.003674813	e594527f-319c-4398-a84a-36d2f3fc57bb	0101000020E6100000A8E3300B571754C0F1022EEE169B3940	0101000020BC080000188C9D90F2692A4126B25EBE42411C41
1643	5067	NW 103 ST	NW 24 AV	E	N	Y	0	0	0	10/14/2016 13:4	25.8681	-80.23862	906523.641051397	558477.705285102	c05c783d-b032-44da-9df9-914a2b5476ae	0101000020E610000000DA19AD450F54C06DF2C53D3CDE3940	0101000020BC08000075FE797D35AA2B41496BFBD21E0B2141
1644	1678	ANASTASIA AV	ANDERSON RD	E	N	N	0	0	0	10/12/2016 12:2	25.74167	-80.27071	896226.346355826	512462.490850903	ad1a5f0b-a2a6-4a95-9d73-1acccf30eefa	0101000020E6100000769B256C531154C06F375A10DEBD3940	0101000020BC080000163D44E5C2592B41373D4DBE40471F41
1645	124	NW 12 AV	NW 15 ST	N	F	Y	1	0	1	10/25/2016 11:4	25.78989	-80.21486	914508.453771319	530097.596311294	8c88e18f-5c95-489f-a145-2d07e4578d81	0101000020E61000004F3A3B4BC00D54C0F423F2CC36CA3940	0101000020BC0800002BD6B21E97E82B4157529897662D2041
1646	2014	E 4 AV	E 33 ST	N	F	Y	1	0	0	10/3/2002	25.85276	-80.27456	894737.152761109	552834.497713618	65429df4-a715-4cbc-b54c-104beae881a6	0101000020E61000008FF6D877921154C03C14A5C94EDA3940	0101000020BC0800003CE3EA81204E2B41DAA0EC6708DF2041
1647	132	NW 22 AV	NW 151 ST	S	N	Y	1	0	1	10/31/2016 16:2	25.91226	-80.23625	907210.877199296	574530.900493741	4ab73369-1bd0-491f-8c4d-5a8fbdd04116	0101000020E61000009572D3C71E0F54C099072AEB89E93940	0101000020BC08000011CF58F693AF2B416B3D0E3989882141
1648	3147	LINCOLN BD	OP 11461	E	F	Y	1	0	1	8/17/2016	25.63447	-80.37962	860559.249659311	473318.71546331	e6246a60-99d4-4c3d-9686-2a136422760c	0101000020E6100000A37455C14B1854C0F38033EE6CA23940	0101000020BC080000C69C43AF1C432A41171A069AA1E31C41
1649	9743	SW 216 ST	SW 87 PL	W	F	N	0	0	0	12/12/2016 15:3	25.56396	-80.33349	875885.331888027	447766.711492307	2089934a-0202-4431-b294-cdf1d8400e71	0101000020E610000003FFCD06581554C0640EBD2E60903940	0101000020BC08000007E755DBD8BA2A41E5FC498F61541B41
1650	9597	NW 10 AV	NW 65 ST	S	F	Y	0	0	0	9/23/2016 12:39	25.83424	-80.2127	915121.454179689	546218.711768098	b0c8246f-36eb-4c53-bf67-072d70356a9f	0101000020E61000006FFF51F89C0D54C0B22F6ECC90D53940	0101000020BC080000A562CE1E61ED2B411F95ADD458AB2041
1651	6746	BISCAYNE BD	NE 77 ST	NW	F	Y	1	0	0	9/8/2016	25.84628	-80.18448	924377.685055658	550652.575271197	66e7536c-441e-4a2b-b081-b5427bac5317	0101000020E61000007BBE7090CE0B54C0A21E810CA6D83940	0101000020BC080000596D4296B1352C412666638FFCCD2041
1652	3119	SW 107 AV	SW 179 ST	S	F	N	1	0	0	11/17/2016 11:2	25.60277	-80.36489	865468.587987289	461820.705002442	07d2d24c-8185-454b-bd9c-14edf6bd9e0f	0101000020E6100000EFEEA15E5A1754C0AB6F17814F9A3940	0101000020BC0800009421215D77692A41529F458CF92F1C41
1653	3838	SW 107 AV	SW 76 ST	S	N	Y	1	1	1	10/27/2016 8:54	25.69743	-80.36619	864874.751576975	496222.660159267	7b4570ec-b90e-4c22-8d3f-f23661e45ca5	0101000020E610000063F09FB36F1754C060E5FD138BB23940	0101000020BC0800009FE7CBB0D3642A41A9C68F6781491E41
1654	3120	SW 107 AV	SW 181 ST	S	F	N	1	1	1	11/17/2016 11:2	25.60095	-80.36469	865538.982523154	461160.639092557	c0c510b8-2812-42f0-8c01-363166494d60	0101000020E6100000F45EFE06571754C0422FE46CD8993940	0101000020BC08000003FB2727046A2A41EE699B48A9251C41
1655	7637	NE 62 ST	BISCAYNE BD	W	F	\N	1	0	1	 	25.83341	-80.1845	924399.128211498	545976.843759596	9fbeee43-98d9-4182-9509-b932e25bcb29	0101000020E6100000084EE9F0CE0B54C050945BFE5AD53940	0101000020BC0800006AC52C79DC352C410EA6541875A92041
1656	9214	COLLINS AV	172 ST	S	N	Y	1	1	1	11/3/2016 12:56	25.93586	-80.1218	944775.780058935	583346.761185803	0f03b39e-ac8a-42ff-8196-f4975e6eb42a	0101000020E6100000D6940295CB0754C077B543F694EF3940	0101000020BC080000184A7FC90DD52C41BFDDF0F268CD2141
1657	1953	E 8 AV	E 41 ST	N	F	Y	1	0	0	2/14/2017 16:34	25.86023	-80.26651	897370.100601051	555563.571008347	13a0d3c3-2060-44cf-b9b1-d282e0aea540	0101000020E610000081494D8B0E1154C004B2EC3538DC3940	0101000020BC080000A1738567B2622B41FE77DB8D5AF42041
1658	1144	NW 2 AV	NW 62 ST	S	F	Y	1	1	1	11/2/2016 12:39	25.83222	-80.20042	919169.438568421	545510.723974116	104cbdf9-06ca-47d9-a804-d938f2e1ddfd	0101000020E610000089EFB88FD30C54C002BB58BE0CD53940	0101000020BC0800005A767B17010D2C416742E7DAD0A52041
1659	9229	178 DR	178 ST	NE	N	N	1	1	1	11/3/2016 13:18	25.94102	-80.12355	944189.736264717	585217.74428115	ffc3927d-1848-42eb-ab62-207553942a21	0101000020E610000025EB122CE80754C070F828FFE6F03940	0101000020BC08000081D8FBB279D02C41881A7DEA06DC2141
1660	2658	COLLINS AV	83 ST	N	F	N	1	1	1	10/11/2016 12:1	25.86833	-80.12111	945167.70216215	558801.939195052	53579af8-2872-48fe-8139-97a67e1fbbe3	0101000020E6100000C2278C3EC00754C0E213082F4BDE3940	0101000020BC080000CA03ACA11DD82C418506F64AA70D2141
1661	3761	SW 280 ST	OP # 14850	W	F	N	0	0	0	10/4/2016 12:25	25.5069	-80.43229	843409.57958243	426875.079376444	01243625-7f7d-445b-b444-d3fc8de7e7ab	0101000020E61000004B444570AA1B54C06882DD4DC4813940	0101000020BC080000BAF1FA5521BD2941530C9802F30D1A41
1662	1552	SW 42 AV	SW 40 ST	N	N	Y	0	0	0	10/12/2016 12:0	25.73422	-80.26198	899121.496352829	509772.902115405	d79c780b-22ea-4aa5-b079-ee11567c93e1	0101000020E610000070BC2B14C41054C00049BA36F6BB3940	0101000020BC08000021C8783261702B41DA88B8623A1D1F41
1663	8815	NE 6 AV	NE 137 ST	S	F	Y	1	0	1	11/1/2016 14:27	25.90104	-80.18701	923423.314215939	570550.06401106	6be72b80-2937-49a1-b34e-633930779d9b	0101000020E61000009DAD75F7F70B54C0E5CBC59AAAE63940	0101000020BC08000086C531D83C2E2C412A234F8C6F692141
1664	3206	SW 117 AV SERVICE RD	SW 136 ST	S	F	N	1	1	1	8/17/2016	25.64131	-80.38273	859523.654635783	475801.387344174	2b7c3fd9-ff38-427b-ba2b-5ecd965060a5	0101000020E61000002F3A3CAD7E1854C0066D7D752DA43940	0101000020BC08000010F9807E053B2A41B5F5924A6C0A1D41
1665	4028	SW 152 AV	SW 80 ST	N	N	N	1	1	1	9/26/2016 13:48	25.69292	-80.4388	840970.045065317	494475.727296852	5036d7b2-97f1-4a5f-a213-fc7ce066135f	0101000020E610000060D1E868151C54C0D19A7B9363B13940	0101000020BC080000FA3CE64312AA2941D800B3AB352E1E41
1666	6967	NW 2 AV	NW 49 ST	N	F	Y	1	0	1	11/3/2016 16:22	25.82091	-80.19972	919421.415401582	541401.997312933	2c4c5253-f53d-44c3-b1aa-b242dce89a0e	0101000020E6100000F094A641C80C54C01BE18CA927D23940	0101000020BC080000E2AFA10BF90E2C4197845F66B7852041
1667	2855	HAWTHORNE AV	77 ST	N	F	Y	0	0	0	8/28/2002	25.86216	-80.12836	942797.839155965	556544.129076622	b9a35021-d38e-4aaf-a5d8-117660acba77	0101000020E6100000375FA40F370854C072791DF5B6DC3940	0101000020BC08000009499FE799C52C411ED4CCAB03FC2041
1668	5327	FOUNTAINEBLEAU BD	OP # 9110	W	N	N	1	1	2	9/6/2012 13:48	25.77359	-80.34379	872113.415581297	523938.120815173	fbf1cbc6-d579-4398-89c7-a38894d700db	0101000020E6100000B02933B3001654C0D032FB090AC63940	0101000020BC080000EA88A105619D2A41AB2C5D468FFA1F41
1669	7129	NW 12 AV	NW 26 ST	S	F	N	1	0	1	9/26/2016 14:57	25.80034	-80.21547	914285.099264886	533894.626128763	23542743-6e8c-4da1-9f07-8e56be2b5e20	0101000020E61000009CC5C349CA0D54C08A6FE5A6E3CC3940	0101000020BC080000862F0269D8E62B415C3F50A7104B2041
1670	2831	ALTON RD	21 ST	SE	N	Y	1	0	0	8/22/2002	25.79912	-80.13828	939688.71705541	533608.572892457	7dc650d0-fce6-4c24-b8e0-8adfc0c390f9	0101000020E6100000D7C66571D90854C0024B9B6F93CC3940	0101000020BC08000093AAC0A84FAD2C41D4EB178CD4482041
1671	3559	SW 172 ST	DUVAL ST	W	N	N	0	0	1	11/17/2016 14:0	25.60998	-80.35352	869203.238315489	464458.56782677	a415f25b-7a1f-48fa-9f48-7ecf1bedb5bb	0101000020E6100000E60B3111A01654C0FD354BE3279C3940	0101000020BC080000C6F087AAA4862A41FEA47A0031591C41
1672	9380	SW 4 ST	SW 107 AV	W	F	N	1	0	0	10/27/2016 19:2	25.76491	-80.36958	863642.577181533	520743.693786614	1308d69d-aa83-4ff7-8469-e3566739557c	0101000020E610000051A78D2DA71754C0ADB39983D1C33940	0101000020BC080000CE194C57335B2A4199E35390A5C81F41
1673	7084	NW 7 AV	NW 75 ST	N	F	Y	1	0	1	9/21/2016 13:43	25.84355	-80.2089	916350.687284019	549610.837177679	d9f25e55-3d05-49e5-86cf-00faad86d733	0101000020E6100000845127BA5E0D54C02633EB11F3D73940	0101000020BC0800007A6F6B96FBF62B410C177315D9C52041
1674	5820	NW 82 AV	NW 176 ST	N	N	N	0	0	0	10/19/2016 15:5	25.93297	-80.33448	874882.818495035	581885.566911124	909b1eff-cce8-49b6-8012-267926a88de0	0101000020E6100000BDFAD036681554C06AAD5AC2D7EE3940	0101000020BC08000009AC26D403B32A41E5F3228FFEC12141
1675	5900	NW 186 ST	NW 68 AV	SW	F	N	1	1	0	10/27/2016 15:3	25.94197	-80.31383	881652.326562695	585189.977330536	71f9d562-3433-4211-a28e-83942b105441	0101000020E610000060586BE2151454C03DCD734125F13940	0101000020BC0800006BDE1CD9E6E72A41D058BF61CFDB2141
1676	2258	W 24 AV	W 60 ST	S	F	N	1	0	1	10/19/2016 16:3	25.87624	-80.33136	876013.677432589	561268.80894883	b4945686-71af-4a9f-806f-2b036c39c626	0101000020E6100000481D6314351554C0CB58357151E03940	0101000020BC080000CAB6088CD9BB2A41B4915E08ED202141
1677	9637	N KROME AV	NE 8 ST	N	N	Y	1	1	1	10/21/2016 14:0	25.47686	-80.47733	828593.441231962	415899.004540496	1d748233-222c-460d-8138-da7c16bb9937	0101000020E6100000EB771A928C1E54C04BB0940F147A3940	0101000020BC080000859F410D614929411ED7D9B272621941
1678	6165	NW 12 AV	NW 170 TE	S	F	N	1	0	1	10/26/2016 14:4	25.9298	-80.22068	912290.681331862	580938.142621256	51156d11-3898-4770-9212-6a23780a5d5f	0101000020E61000009AB4AFB21F0E54C0880B80BF07EE3940	0101000020BC0800005F5FCE9243D72B4113BCECB597BA2141
1679	10020	W FLAGLER ST	NW 112 AV	W	F	N	2	0	0	11/15/2016 11:1	25.76847	-80.37736	861075.957978729	522026.15741612	dc54a518-0de5-47de-9cf1-a8891a83f524	0101000020E61000005F913FA5261854C050450CF4BAC43940	0101000020BC08000040FEDE1926472A41FE02556BAFDC1F41
1680	3360	SW 147 AV	SW 284 ST	N	F	N	1	1	1	8/16/2016	25.50346	-80.42878	844567.003804907	425630.495548099	3724018a-38f4-4689-8df2-572aad463ef9	0101000020E610000069F78E35711B54C0E00EC6FDE2803940	0101000020BC0800000126602F2CC6294167FA63AC80FA1941
1681	5571	NW 22 AV	NW 105 ST	S	F	Y	0	0	0	10/17/2016 15:5	25.87021	-80.23449	907879.566128284	559251.080664098	eb1899ce-7e83-49de-9c0a-71c73d4c3d19	0101000020E6100000894843E5010F54C0BF719A42C6DE3940	0101000020BC08000046173257CDB42B416135489329112141
1682	3990	SW 137 AV	SW 66 ST	N	F	Y	2	0	1	9/26/2016 12:41	25.70545	-80.41458	848926.086940855	499062.571780637	ba21b71e-dac5-466c-aca8-1f8ed6863c71	0101000020E61000008B40A492881A54C09AA02A6A98B43940	0101000020BC0800009E8C6D5A3AE82941ECE77D0DE1751E41
1683	9365	W FLAGLER ST	SW 115 AV	E	N	N	1	1	1	9/27/2016 13:11	25.76811	-80.38333	859110.842119046	521884.616383359	5f6f03e8-d300-4496-9dfd-b30638690d20	0101000020E6100000A032D681881854C0E0772319A3C43940	0101000020BC08000030D33EDECB372A41A4E0464179DA1F41
1684	8574	NE 19 AV	NE 167 ST	S	F	N	1	0	1	11/11/2002	25.92935	-80.16229	931483.174458649	580891.55148299	aa571e73-f8ef-48d0-af92-5843455ac0b0	0101000020E610000071D1D100630A54C0DE50A8FEE9ED3940	0101000020BC0800005508A891346D2C4168103F873ABA2141
1685	5438	NE 6 AV	NE 109 ST	S	N	Y	0	0	0	10/21/2002	25.87607	-80.18594	923831.036496207	561478.508008957	96111e80-18c2-449d-8660-5fb04ab92547	0101000020E61000004915BE73E60B54C0A1723B9046E03940	0101000020BC080000852B254A6C312C41902D666E90222141
1686	8022	NW 4 ST	NW 10 AV	W	N	N	0	0	0	9/6/2012 13:46	25.77758	-80.21139	915676.073500935	525628.689624973	934ff320-eda3-4f91-9519-f291cb196923	0101000020E61000003C1D937D870D54C054F83FCA0FC73940	0101000020BC080000DFD61F5CB6F12B41098BB0C67C0A2041
1687	599	NW 16 ST	NW 12 AV	W	F	Y	1	1	1	8/31/2016	25.79049	-80.21578	914209.04721928	530311.718945444	a2985cdd-d904-4252-8b3c-9250c076c846	0101000020E610000014B84523CF0D54C030879DBA5DCA3940	0101000020BC0800001DA3814E40E62B41472F61D6122F2041
1688	4672	SW 72 ST	SW 52 AV	E	N	Y	1	0	0	9/22/2016 12:31	25.70474	-80.27734	894119.641907532	499030.828444481	6d4c6a1e-bd82-4dd2-afc3-6e2b80a6295e	0101000020E6100000E2CA06EFBF1154C0DED5D5576AB43940	0101000020BC080000ADC2657C4D492B410425841462751E41
1689	8743	NE 16 AV	NE 127 ST	S	F	N	1	0	1	11/14/2002	25.89275	-80.16647	930195.562531758	567579.250404075	72f20d26-b3aa-45bd-b6f7-a6a1a5f88ccf	0101000020E6100000FB2E0A68A70A54C0317C9F4F8BE43940	0101000020BC0800004F00485825632C41869B65EB39522141
1690	3816	BUSWAY	SW 173 ST	NE	F	Y	4	1	1	9/29/2016 14:47	25.60963	-80.35028	870270.262089502	464335.120596893	4893100b-889e-4010-a644-c0e722b12680	0101000020E610000079456B0C6B1654C012812BB0109C3940	0101000020BC0800005192CFB6FA8E2A41E5BC873643571C41
1691	3986	SW 137 AV	SW 76 ST	N	N	N	1	1	1	1/5/2017 11:21	25.6948	-80.4152	848741.360233638	495194.180269793	b41a5245-c527-42fa-80af-468410ad8fa2	0101000020E61000005487BF9D921A54C01C08C60BDFB13940	0101000020BC0800002CE652E6C8E62941B0DAB67B6F391E41
1692	4587	SW 24 ST	SW 70 CT	E	F	N	1	1	1	9/14/2016 14:34	25.74794	-80.30938	883487.927922498	514675.796123482	50044d5b-425d-41b3-95f1-c91e09355a94	0101000020E6100000027B2ED8CC1354C0333CBD7F79BF3940	0101000020BC08000058AD790D3EF62A410E119AF7D5691F41
1693	3036	SW 87 AV	SW 198 ST	S	N	Y	0	0	0	10/4/2016 16:34	25.58341	-80.33194	876362.056689296	454837.659250081	3878ae54-3ba8-4f21-8692-4613af7d02db	0101000020E6100000B417DB903E1554C09F2D21BA5A953940	0101000020BC080000E5D6824E92BE2A4114C5DA5BDDC21B41
1694	9391	NW 37 ST	NW 62 AV	E	M	N	0	0	0	11/8/2016 14:35	25.80803	-80.2969	887477.022640783	536537.531948246	f482adb2-7163-411d-9f18-f14829319340	0101000020E61000002FDD9E7C001354C03AEF227EDBCE3940	0101000020BC080000FA4C4D3E68152B411AD26F77B65F2041
1695	5915	NE 191 ST	OP # 1201	E	M	N	0	0	0	11/13/2002	25.95107	-80.17638	926801.933829155	588757.975065276	c0f3fc2d-3174-4fb4-a376-cc4c20a0ad39	0101000020E61000000FCEF7E2490B54C0C36435A279F33940	0101000020BC080000A06FE415A2482C418B042D61AFF72141
1696	9043	OPA LOCKA BD	NW 19 AV	W	F	Y	0	0	0	10/31/2016 12:2	25.89838	-80.23221	908569.06904177	569493.681611665	62bef4f4-a457-41d3-a95b-bb9bb6c8b37a	0101000020E6100000E2E3708EDC0E54C0DF765547FCE53940	0101000020BC080000DFA5CE5830BA2B41037741C82E612141
1697	7024	NW 7 AV	NW 66 ST	S	N	Y	1	1	1	9/20/2016 11:49	25.8354	-80.20875	916421.801322166	546648.884431913	cb0112c4-f575-4992-bc7d-3029b2b18ef1	0101000020E6100000ABBBAC125C0D54C0EDDF91F3DCD53940	0101000020BC080000052FBFD089F72B41E93E2B2DB5AE2041
1698	3399	SW 157 AV	SW 296 ST	N	N	N	1	0	0	8/16/2016	25.49193	-80.44479	839305.23774606	421419.489857078	2230e6e7-a348-4e49-a633-21f5d51004fc	0101000020E610000090B79B73771C54C0C40C4FB0EF7D3940	0101000020BC08000087BA70A6109D2941147368A5B4B81941
1699	5651	NW 135 ST	NW 22 AV	E	F	Y	1	0	1	10/31/2016 16:3	25.89741	-80.23489	907689.725972813	569139.236405954	c76c0133-d0ea-493a-bc0a-49ca153e606b	0101000020E6100000E51E607B080F54C049C06D4CBDE53940	0101000020BC0800008DBDF9A851B32B41479343E4695E2141
1700	5500	NW 7 AV	NW 153 ST	N	N	N	0	0	0	9/21/2016 12:37	25.91472	-80.21162	915301.031960484	575473.327142641	fde8b61c-b86a-4f69-9b62-bbd98f81d5fb	0101000020E6100000924F79468B0D54C00FB8E6332BEA3940	0101000020BC080000CAA5B946C8EE2B41A1AD9413E68F2141
1701	3935	SW 131 AV	SW 17 ST	SE	F	N	0	0	0	10/13/2016 14:0	25.75215	-80.40681	851409.255830601	516048.392165162	ca4847fe-440c-4c5e-9421-cbe2039e0be5	0101000020E6100000B81B5038091A54C042BAB1248DC03940	0101000020BC0800002A8533B1A0FB2941CA71015A487F1F41
1702	4576	SW 24 ST	SW 79 AV	W	F	N	1	1	1	9/14/2016 12:52	25.7481	-80.32394	878695.02938294	514707.663570322	655a7427-eb7b-44de-bc87-6ad73c363e72	0101000020E610000070654465BB1454C040AAF8B883BF3940	0101000020BC08000082BCAC40CCD02A41221BB76F556A1F41
1703	8957	NW 22 AV	RUTLAND ST	S	F	N	1	0	1	10/31/2016 16:2	25.90638	-80.23598	907311.414716572	572396.020907193	b68bcdef-6f25-4e46-80a6-e3913cc1e769	0101000020E6100000B3E6BF631A0F54C036C2FDE408E83940	0101000020BC080000C6B2A4095DB02B41A95E6576DB772141
1704	5259	NW 21 ST	NW 37 AV	E	N	N	0	0	0	11/1/2002	25.7949	-80.25664	900751.105995271	531837.315279506	a02c3c5a-f596-454e-b6ca-68e4e2051a29	0101000020E61000002EC9EAC86C1054C02BFDAEDF7ECB3940	0101000020BC080000E780C46A1C7D2B410506C907FE3A2041
1705	5069	NW 103 ST	NW 22 AV	E	N	Y	1	0	1	10/14/2016 13:4	25.86818	-80.23456	907858.874241527	558513.45583003	f21422ff-30ed-4286-a2b2-bb9bb9a9f59e	0101000020E6100000B7E00624030F54C0A3FD9D4941DE3940	0101000020BC080000B3EC02F5A3B42B41856D3F53660B2141
1706	5000	NW 72 AV	NW 66 ST	S	N	N	0	0	1	10/10/2016 16:4	25.83374	-80.31409	881772.831243366	545852.315829486	9cc4aa17-8524-4c0a-aaec-b9e5451e421a	0101000020E6100000A41EBB201A1454C0CD08736C70D53940	0101000020BC080000E9A798DBD7E82A41C22CDD097CA82041
1707	5677	GOLDEN GLADES	NW 7 AV	E	N	N	0	0	0	9/21/2016 13:23	25.92108	-80.21364	914624.816124231	577781.762468353	8376e4ba-f6f2-44ef-bcc0-2022332259b8	0101000020E6100000504D004AAC0D54C00DF99424CCEB3940	0101000020BC0800000FA813D87FE92B4105D9E1F2EEA12141
1708	10563	WASHINGTON AVE	SOUTH POINTE DR	S	N	Y	2	0	1	11/2/2016 13:50	25.7685	-80.13562	940632.381854631	522482.993118539	2a6d63e1-668c-42f6-b5b3-d3afac8f52c8	0101000020E6100000A5B74217AE0854C02AE43B65BCC43940	0101000020BC080000A5A647FDAEB42C41037CA1C3D2E31F41
1709	9302	SW 72 ST	SW 68 CT	E	F	N	1	0	0	9/26/2016 14:41	25.70352	-80.30425	885260.988002528	498538.017753676	323b022f-3329-4d68-aef2-0fa009feec83	0101000020E6100000E3FBC7D3781354C0C4A8B90F1AB43940	0101000020BC0800007879682C18042B414BA12DD6AE6D1E41
1710	5230	NW 54 ST	NW 21 AV	W	N	Y	1	0	0	10/19/2016 13:2	25.82433	-80.23039	909323.776802547	542583.750500552	e6e41b44-00e4-4b05-81e9-c68fd3f2c6e9	0101000020E610000056C393CDBE0E54C0897F4D9907D33940	0101000020BC0800003A0455C315C02B41CFCD26E8F28E2041
1711	8660	NE 163 ST	NE 28 AV	W	N	Y	2	1	2	11/3/2016 13:54	25.92645	-80.14388	937539.855862446	579878.390173309	fcf37f83-339b-42ca-8f98-64fee5ed7f4f	0101000020E610000059F53D6C350954C0AA559E442CED3940	0101000020BC08000009B04EEF859C2C41A1B38C3450B22141
1712	7232	NW 17 AV	SR 836	S	F	N	0	0	0	8/22/2016	25.78222	-80.22278	911918.831002321	527292.173117898	e4171863-0557-46c0-b729-5f26c5a97116	0101000020E61000005EAF210E420E54C089B3FFBE3FC83940	0101000020BC080000869268DF5BD42B41C73A8FBE7B172041
1713	9692	SW 162 AV	SW 80 ST	N	N	N	1	0	1	9/26/2016 13:05	25.69109	-80.4542	835904.074273124	493787.565948784	b6adbd86-7436-4a1e-b735-2056ddc1404e	0101000020E61000001CCFA697111D54C0822D4651EBB03940	0101000020BC08000024233B527E8229419764210675231E41
1714	455	SW 107 AV	SW 24 ST	S	F	N	2	0	1	10/27/2016 19:4	25.74621	-80.36783	864250.120934404	513950.888451397	64b27aa7-c9ce-4390-8f87-cd36e4610707	0101000020E6100000853E198E8A1754C0820CE72F08BF3940	0101000020BC0800005EF8C76DF25F2A41C868EB55825E1F41
1715	5863	NE 185 ST	NE 13 AV	E	N	N	1	1	1	10/27/2016 17:1	25.94536	-80.17595	926957.933159035	586684.515296124	4db6ab92-def8-4e32-bc4b-c9647288cd47	0101000020E61000006EE771C2420B54C0FD249E9E03F23940	0101000020BC080000CEB79115DA492C41FC3A82757CE72141
1716	8346	NW 138 ST	OP # 830	W	F	N	0	0	0	10/10/2016 13:5	25.89873	-80.30065	886070.108453766	569496.891568132	9f2fce06-f46e-4e52-8a1a-cfb3e3fef818	0101000020E610000032D9E9CF3D1354C067413B8B13E63940	0101000020BC0800005602116A6A0A2B41BF23CA3335612141
1717	4170	SW 47 ST	SW 143 CT	NE	N	Y	1	0	0	10/13/2016 14:1	25.72331	-80.42665	844926.172324833	505538.233052321	0c33578e-643d-43b3-a948-9781a5d8a978	0101000020E6100000CDF95A324E1B54C0A46E36372BB93940	0101000020BC080000CCBF7C85FAC8294157F67CB40FDB1E41
1718	3252	SW 122 AV	SW 187 TE	S	F	Y	1	0	0	11/29/2016 13:5	25.59338	-80.38902	857533.038213648	458370.19485727	cb66567d-22e6-4596-aa48-bc0609905e67	0101000020E6100000EE1CA2AAE51854C0334C350EE8973940	0101000020BC0800004799AE42782B2A4106EFF5800FFA1B41
1719	84	SW 8 ST	SW 57 AV	W	N	Y	1	0	0	9/8/2016 14:15	25.76367	-80.28744	890676.575258184	520430.715765856	dc46ce5c-1245-48b5-b447-388d94aadf6d	0101000020E6100000A12F7D7E651254C06946E03F80C33940	0101000020BC0800001A19BD59672E2B4175DDD5A6C1C31F41
1720	4003	SW 137 AV	SW 26 ST	N	F	Y	2	0	0	9/28/2016 10:55	25.74426	-80.41611	848361.206503022	513168.163694404	92275289-f883-44a2-ad64-2c146c676481	0101000020E610000056CA2793A11A54C00624BF4288BE3940	0101000020BC080000A1618F97D0E329417DBC4D6F47521F41
1721	8168	SW 8 ST	SW 68 AV	W	F	Y	1	1	0	9/8/2016 10:54	25.76311	-80.30639	884440.49258377	520193.545280702	689e9cd4-aa5d-4c56-9202-6ef8f670c64f	0101000020E6100000B491C4FC9B1354C0246AD77B5BC33940	0101000020BC08000043DB8E2EAFFD2A413F0208F80CC01F41
1722	6832	BRICKELL AV	SE 15 RD	N	N	Y	1	1	1	11/14/2016 13:2	25.75749	-80.19329	921677.880369037	518364.17033942	e38949e5-2a93-4270-b0f9-32a1ffadf90d	0101000020E6100000500B43E85E0C54C033FA046FEBC13940	0101000020BC080000C17FECF999202C41F1E4FB7777A31F41
1723	8626	NE 10 AV	NE 177 TE	N	F	Y	0	0	0	11/1/2016 12:46	25.93831	-80.1805	925481.049293507	584110.097878717	94f78b79-9eeb-426c-8639-5eba77f2e0c1	0101000020E610000038742D318D0B54C0EA61C32135F03940	0101000020BC080000A40DC750503E2C419F9D569F5FD32141
1724	7966	NW 7 ST	NW 53 AV	W	N	Y	1	1	1	11/8/2016 11:29	25.77837	-80.28189	892476.05952822	525782.439928345	173832d1-c5a9-4258-b13d-8313ef5c6821	0101000020E61000002498ED760A1254C0615BAB6E43C73940	0101000020BC0800002EDAF951763C2B41AF5FCD46B00B2041
1725	2681	COLLINS AV	4900 BLK	S	N	Y	1	0	1	10/20/2016 13:1	25.82526	-80.12222	944905.616441417	543144.276307762	01e481a2-379f-46ac-a795-5be7420be742	0101000020E61000007B033183D20754C0E0EA5F7B44D33940	0101000020BC0800009211D67511D62C41D1E385F553932041
1726	3569	HIBISCUS ST	SW 102 AV	W	N	Y	1	1	1	11/17/2016 10:0	25.60622	-80.35631	868288.139417615	463089.689318404	14e30182-7e7d-459b-9ea3-ce35e28e369d	0101000020E6100000BCC6A8E4CD1654C096069FDD319B3940	0101000020BC080000814BD9777E7F2A41FEF1917CCD431C41
1727	5726	NE 14 AV	# 18901	N	F	Y	2	1	0	11/14/2002	25.94955	-80.17318	927858.283077851	588211.763566665	213b3053-fdcc-41a0-b4ea-585cd3addfde	0101000020E61000000B816A64150B54C0EA500CF415F33940	0101000020BC0800006D21C5C8E2502C41A00DB0F46AF32141
1728	6528	NW 183 ST	# 3285	W	F	N	1	0	1	10/27/2016 14:2	25.94065	-80.2556	900793.318158854	584815.810415	ebfc2641-2782-4c44-95fd-7164f3d25148	0101000020E6100000EA4EA9BA5B1054C02267E0F1CEF03940	0101000020BC0800003CE45FD7707D2B4182294D0CE3D82141
1729	5217	NW 54 ST	NW 37 AV	E	F	Y	1	0	0	10/19/2016 12:3	25.82333	-80.25666	900685.169756737	542170.222444512	2840d1b0-4bbe-43b2-8dc2-df8b5b219713	0101000020E6100000AA4F64296D1054C0B0064BFFC5D23940	0101000020BC0800003CF45C8B987C2B4118D4B6D9B78B2041
1730	5524	NW 17 AV	NW 108 ST	N	N	Y	0	0	0	10/16/2002	25.87282	-80.22622	910592.719161171	560217.853702694	ddd8dc37-98f7-45d5-af2b-34be7dc19edc	0101000020E61000006181BE6E7A0E54C04AD9CEB371DF3940	0101000020BC08000018C9F8A5FFC92B41A5F02E1FB7182141
1731	6521	NW 183 ST	NW 22 AV	W	N	N	1	1	1	10/27/2016 13:4	25.94136	-80.23709	906877.124257769	585105.985346369	26c50ac5-8f5c-42b7-b455-0b7258f6b500	0101000020E61000009E3CB7582C0F54C0B87B7EF3FCF03940	0101000020BC0800006A9DC774F8AC2B41FCF6E36527DB2141
1732	6102	NW 2 AV	NW 193 ST	N	F	N	1	0	1	9/21/2016 14:07	25.95204	-80.20537	917274.145756729	589052.03881906	643a2064-dc7f-4ea0-a073-40238d243d44	0101000020E610000002747DD3240D54C0F4D3DF44B9F33940	0101000020BC080000E0C81C8132FE2B41EC44C081FBF92141
1733	5422	NE 6 AV	NE 157 ST	N	N	N	1	1	1	11/1/2016 11:44	25.91897	-80.18771	923151.169428047	577066.439751811	aa8f7349-2b97-4a71-a369-4651036841b0	0101000020E6100000BE447184030C54C0B91AE0CB41EB3940	0101000020BC08000055331E8E1C2C2C4196BF734D589C2141
1734	5028	NW 79 AV	NW 2 ST	N	N	N	1	0	0	9/8/2012 12:54	25.77149	-80.32411	878595.476070311	523210.509065039	a863f703-1de8-4278-8d5d-5199a77ae85b	0101000020E610000072604C2EBE1454C066660EF080C53940	0101000020BC080000441A762505D02A41A11AD2D330EF1F41
1735	8003	NW 7 ST	NW 19 AV	E	F	N	0	0	0	9/6/2012 14:05	25.77977	-80.22642	910726.888849635	526395.726112105	1277dcae-982e-456e-99ef-1286567cbe86	0101000020E6100000264C04A97D0E54C009AD22619FC73940	0101000020BC0800001833D7FC0BCB2B41C7F586D97A102041
1736	7944	NW 7 ST	NW 21 AV	W	N	N	1	1	1	9/6/2012 13:48	25.77984	-80.22948	909719.107074473	526414.172935344	33f6b40d-e90e-4929-aa52-bb3463317f25	0101000020E6100000ABFBF8D3AF0E54C07B6C36C5A3C73940	0101000020BC0800000090916C2CC32B4106F941BE9F102041
1737	4516	SW 87 AV	SW 41 ST	N	N	Y	1	0	1	10/31/2016 11:4	25.73178	-80.33563	874877.992709305	508755.755173206	170e910f-4181-4179-aead-d91415102eed	0101000020E610000015181CE07A1554C0FDD92F0B56BB3940	0101000020BC080000F2B07B2DFAB22A417D88F5CB550D1F41
1738	3634	CARIBBEAN BD	HOLIDAY RD	SW	M	N	1	0	0	10/16/2002	25.58504	-80.34423	872313.449293867	455409.535429128	3b86cf57-2710-41ca-8baa-935da8067bbb	0101000020E610000019C6C2A9071654C0C9B4387CC5953940	0101000020BC080000253EFB16F19E2A41336910DDCCCB1B41
1739	709	LINCOLN RD	JAMES AV	\N	\N	\N	0	0	0	 	25.79076	-80.13058	942242.640798304	530587.339461543	49815df3-c322-4618-a434-079af030faa5	0101000020E610000039150D455B0854C0C0B498AF6FCA3940	0101000020BC08000031A1088243C12C4189EC39143A312041
1740	7146	SW 12 AV	SW 13 ST	S	N	Y	1	0	0	10/18/2016 13:5	25.76101	-80.21437	914731.956292164	519600.939535074	289e5cd0-afda-4b56-8ea7-57fccd334309	0101000020E610000067CF3648B80D54C0BE4944FDD1C23940	0101000020BC08000053C0FE1F56EA2B410D74CF8BCAB61F41
1741	3034	SW 87 AV	SW 190 ST	S	N	N	1	1	1	10/4/2016 16:21	25.5905	-80.33202	876323.708312105	457412.941856712	dc8df36b-c4ed-44cd-8285-e7df532886aa	0101000020E6100000822BD2D33F1554C0A359841D2B973940	0101000020BC080000A0AC139C45BE2A41AAC1F37D1AEB1B41
1742	3882	SW 112 AV	SW 50 TE	N	F	N	1	0	1	10/27/2016 19:1	25.72039	-80.37507	861914.051135063	504553.299028777	6d58bc5f-ab9e-4c7f-afe9-e9fc6b90b15c	0101000020E61000008A74500B011854C0A06633B86BB83940	0101000020BC080000515FA849B24D2A41FEABE9F7ABCB1E41
1743	4630	SW 56 ST	SW 68 AV	W	F	N	1	1	0	10/12/2016 11:0	25.71834	-80.30488	885025.186005939	503923.371445365	0c3e0f9a-c2af-4d4b-8d6a-0504e7a873cd	0101000020E61000008D7F3226831354C01F97204EE5B73940	0101000020BC0800007D7EBA9140022B4131D7C141D4C11E41
1744	7170	NW 12 AV	NW 27 ST	N	N	Y	1	1	1	11/8/2016 13:48	25.80147	-80.21526	914351.105012953	534302.843845293	76cf31e1-e409-45e1-9a09-858e8a8c4d33	0101000020E6100000A91058E1C60D54C0A0CFED2E2DCD3940	0101000020BC0800003FF30E6C5CE72B41883CC916414E2041
1745	8651	NE 163 ST	NE 19 CT	E	N	N	1	0	0	9/8/2016	25.92586	-80.16156	931729.906876277	579624.182681769	b5a70d01-a862-4815-a127-d2fcd46ca560	0101000020E61000004FC6C01B570A54C0CDD3633505ED3940	0101000020BC080000D1EDC108226F2C41539A49CA53B02141
1746	6203	E BUNCHE PARK DR	NW 160 ST	N	F	N	0	0	0	10/31/2016 12:4	25.92101	-80.23358	908071.911520507	577717.137286529	6ac93838-0e91-40b5-baed-41795b2da254	0101000020E610000060F3DCEFF20E54C0DFC6647DC7EB3940	0101000020BC080000E08B1E084EB62B4195BDAAB26DA12141
1747	1655	SW 24 ST	GRANADA BD	E	N	N	0	0	0	9/14/2016 10:25	25.74876	-80.27533	894691.686985303	515032.867594309	620c23a7-2150-464d-86f2-44b8a30b158c	0101000020E610000056B7A5199F1154C03F27BC0AAFBF3940	0101000020BC080000AA9F7193C54D2B4106DDCC406A6F1F41
1748	2835	ALTON RD	15 ST	S	N	Y	1	0	1	10/11/2016 13:3	25.78751	-80.14124	938738.365627952	529381.923530906	f252f4e7-000b-4c83-b79e-1852840191e5	0101000020E61000006D2FDF220A0954C0CC86497F9AC93940	0101000020BC080000B0E495F4E2A52C41845C053FCF272041
1749	4219	SW 56 ST	SW 97 AV	E	N	N	1	1	1	10/12/2016 17:1	25.71601	-80.35128	869753.088276386	503000.591461167	022385c6-44dc-45c5-9b38-9e21da339356	0101000020E610000063D390557B1654C00CE615EF4CB73940	0101000020BC08000077FACD5DF08A2A419114E42269B31E41
1750	8687	NE 167 ST	NE 4 AV	W	F	N	0	0	0	42660.45347	25.92853	-80.19264	921509.623520751	580530.87935552	adf47d98-4ccb-4204-9947-f6574d3bf48e	0101000020E6100000B4EF2C46540C54C0256F5341B4ED3940	0101000020BC08000040B66176491F2C4141DC1A2F69B72141
1751	2430	W 65 ST	W 2 AV	W	N	Y	1	0	0	9/23/2016 11:37	25.88144	-80.28688	890629.7905626	563237.266612925	6d07c22e-bdd6-4554-a0c9-129e629be95d	0101000020E6100000D7231C455C1254C0EF39DF7DA6E13940	0101000020BC080000CAB0DBC7092E2B4123B9EFF24D302141
1752	179	SW 24 ST	SW 74 AV	E	F	N	2	0	1	9/14/2016 14:28	25.74795	-80.31522	881562.637438919	514669.028096758	54d59391-b439-4590-a8c3-3eebefca8f1b	0101000020E61000006D49ADAC2C1454C0AE05B8167ABF3940	0101000020BC08000088DE667833E72A41A9E9F0E4BA691F41
1753	4811	NW 22 AV	NW 93 ST	S	F	N	0	0	0	10/17/2016 16:1	25.85836	-80.23415	908015.811918635	554947.165387779	2f7eedea-74fd-46a7-8d51-832988d77787	0101000020E61000002177955BFC0E54C04BD5FB1DBEDB3940	0101000020BC080000AD5826D5DDB52B4172AD17BE89EF2041
1754	1124	NW 67 AV	NEW BARN RD	S	N	N	2	1	1	10/10/2016 13:0	25.91168	-80.30939	883169.124751367	574187.462892957	667fed09-38aa-4305-9c3d-753e0e5b1b2b	0101000020E610000028AFE427CD1354C05B71E60964E93940	0101000020BC0800005B5FFE71C0F32A410BA4F458DA852141
1755	415	SW 92 AV	SW 152 ST	N	F	N	1	0	1	11/30/2016 15:4	25.62962	-80.34166	873074.811601557	471614.899017431	07f7dfba-914d-41b7-8740-2418a662eb58	0101000020E61000001AF581D1DD1554C073E892D12EA13940	0101000020BC080000BA3189D0E3A42A41BAFC815502C91C41
1756	7056	NW 7 AV	NW 14 ST	N	F	Y	1	0	1	9/21/2016 11:41	25.78807	-80.20683	917153.076444786	529452.275102966	dcd8cebe-92d8-4f15-9528-9036f56e1704	0101000020E6100000D74AEFCF3C0D54C080872D97BFC93940	0101000020BC080000E65FD25D40FD2B416FE5EDF25B282041
1757	9911	SW 180 ST	SW 146 CT	W	N	N	0	0	1	11/29/2016 13:5	25.59992	-80.42891	844373.074350215	460687.447765879	40f37663-a7e8-4945-ba0d-3ae79cbc817d	0101000020E6100000547D065B731B54C0F41AE57694993940	0101000020BC0800004BCD7253A8C429418B07B284441E1C41
1758	8946	OPA LOCKA BD	NW 3 CT	W	F	N	1	0	0	11/12/2002	25.90006	-80.20518	917450.853076935	570158.331187651	e1bbd097-f227-48f2-84b3-75ba6e0b115c	0101000020E61000009020C3BA210D54C0D0066A936AE63940	0101000020BC080000826E5FEB93FF2B4132A4F91460662141
1759	1365	NE 29 PL	NE 203 ST	S	F	N	1	0	1	10/28/2016 17:1	25.96325	-80.14204	938062.902067255	593258.01529102	1c8eeb56-0e87-4106-a7b1-326225b4563b	0101000020E61000007DBF3AFB160954C0384187ED97F63940	0101000020BC080000629500079CA02C418A964D76D71A2241
1760	10538	Ft Lauderdale	Tri-Rail Station	T	T	\N	\N	\N	\N	 	26.12116	-80.17013	928463.311717961	650594.700821035	0adaab44-f4b7-4d45-883e-b2a3b13ed314	0101000020E6100000FD5B3174E30A54C0D1E20786041F3A40	0101000020BC0800002C395BD79C552C410315A9DCC8DA2341
1761	4424	SW 67 AV	SW 40 ST	S	F	N	1	1	1	10/10/2016 14:3	25.73269	-80.30293	885637.3684664	509141.649762094	4eb987c6-2e2c-4a08-a7c0-05cff0125f4b	0101000020E6100000DCE2A850631354C045EEB29D91BB3940	0101000020BC080000EA143FEF08072B411DE155605D131F41
1762	5351	W FLAGLER ST	# 9501	W	N	N	2	0	1	9/8/2012 11:35	25.76917	-80.35104	869733.762173295	522322.353005223	73187ebc-edcd-4433-b39b-9e55ae4c082b	0101000020E61000005FF8E190771654C0FDF51BD4E8C43940	0101000020BC080000071FBDB6C98A2A416FD59B3350E11F41
1763	8415	NE 6 AV	NE 96 ST	S	F	Y	1	0	0	11/7/2002	25.86337	-80.18538	924047.764133725	556862.49097231	3549103b-7cdb-4eaa-9699-199162786c96	0101000020E6100000EA439914DD0B54C0266C360F06DD3940	0101000020BC0800009BA3BDBE1D332C41DB18156580FE2041
1764	1225	NE 2 AV	NE 63 TE	S	N	N	1	0	0	11/1/2016 12:30	25.8343	-80.19234	921818.657992139	546281.144034281	3dfd38e3-6d8b-4bd0-b327-1f2af69fa943	0101000020E61000003C8111604F0C54C0030B13BB94D53940	0101000020BC0800005BD81288B3212C4173EF05B2D5AB2041
1765	1960	E 8 AV	# 6101	N	N	N	1	0	0	2/15/2017 10:03	25.87671	-80.26691	897209.715439886	561553.897606708	d81e71ad-c6b3-4b36-b1cc-de801eb92d21	0101000020E6100000AC5E4EDE141154C0ED9DDC7070E03940	0101000020BC0800000C6A3EA271612B41D379EC3527232141
1766	1691	SW 40 ST	GRANADA BD	E	F	N	0	0	0	10/13/2016 13:2	25.73424	-80.27331	895387.306989197	509760.172749937	d2d8732c-bbc3-46e8-9e44-a9a54d43f7d0	0101000020E6100000044B2CEC7D1154C07D81D4A7F7BB3940	0101000020BC0800008AE107D134532B41B269F077071D1F41
1767	2653	COLLINS AV	72 ST	N	F	Y	1	1	1	10/11/2016 12:0	25.85786	-80.12064	945346.424566824	554997.014038354	824274a1-761c-49ba-bd96-9b1d9f3714eb	0101000020E61000008055FF9BB80754C0534FBFF49CDB3940	0101000020BC080000ACA4961383D92C413811CA70EDEF2041
1768	9465	HIALEAH DR	EUCALYPTUS DR	E	F	Y	1	0	0	9/22/2016 14:29	25.82272	-80.27707	893975.012261186	541911.098962113	5756f7c1-a9b0-4f0f-8713-5e1c766d7f5d	0101000020E610000049439B6DBB1154C044F32A059ED23940	0101000020BC0800004C91EA392C482B41ED67689AB1892041
1769	4977	NW 72 AV	NW 16 ST	NE	F	N	1	1	1	10/10/2016 13:3	25.79037	-80.31347	882063.292642072	530089.309265405	bc768198-a787-4a23-8d8a-b0ac7f819fea	0101000020E6100000B7FABAC10F1454C0E42BDCFE55CA3940	0101000020BC0800000AEBECC71CEB2A4199417A04562D2041
1770	248	NW 22 AV	NW 95 ST	N	F	Y	1	0	0	10/17/2016 11:2	25.86136	-80.23396	908070.637954917	556035.020507939	636a7b74-d192-4da5-8cbd-93d7f953ce83	0101000020E6100000E6BA714FF90E54C041646A3382DC3940	0101000020BC0800007D830D7C4BB62B411135067409F82041
1771	3659	SW 200 ST	SW 117 AV	W	N	N	1	0	0	11/17/2016 17:4	25.58096	-80.38027	860440.635763712	453868.105075359	fc26efae-77e9-429b-a051-68d119b96f3a	0101000020E61000000A54E82C561854C0F62D09D6B9943940	0101000020BC0800007AF7F2742F422A41891C1424B7B31B41
1772	9872	SE 8 AV	SE 11 PL	N	N	N	1	0	0	2/14/2017 12:46	25.81268	-80.26464	898082.392513301	538283.838847451	bac78c79-5ef4-4245-8cac-27916aa1dfc3	0101000020E61000002C898EDFEF1054C09C3153E80BD03940	0101000020BC080000771814FD42682B4142F5B9145B6D2041
1773	9019	NW 42 AV	NW 128 ST	S	F	N	0	0	0	2/15/2017 11:37	25.8895	-80.26758	896959.193966474	566201.765609205	8c4d9ea0-cdf8-4fc3-99cc-a4db0d803c34	0101000020E6100000F6EA030F201154C0551E44B6B6E33940	0101000020BC0800006D3D42977C5F2B41EAC4D2F276472141
1774	6726	BISCAYNE BD	NE 30 ST	N	F	Y	1	0	1	9/8/2016	25.80567	-80.18927	922891.615804307	535882.318369821	fd5a9d00-aa00-4c53-bf53-14a4194e68b8	0101000020E6100000162822201D0C54C077079BA140CE3940	0101000020BC0800001ED4A972152A2C415F780B0A985A2041
1775	7947	NW 7 ST	NW 25 AV	W	F	N	1	1	1	9/6/2012 13:48	25.77961	-80.23763	907039.567467213	526316.436935268	73ef3408-53b2-4d89-a1ce-123a874472f4	0101000020E6100000FEEF6542350F54C0145E8FF594C73940	0101000020BC08000044A9D1573DAE2B41A9527545DC0F2041
1776	2352	W 29 ST	W 8 AV	E	N	N	1	1	1	10/3/2016	25.84791	-80.29865	886827.593136061	551028.694240838	1dc3c9fa-0584-4790-a163-870c4ef0b5b8	0101000020E6100000D3E085FA1C1354C061001FF010D93940	0101000020BC080000EC615C6255102B410A5761CCECD02041
1777	1617	SW 57 AV	MATARO AV	N	N	Y	0	0	0	8/28/2002	25.71516	-80.28572	891338.460430656	502800.872082651	b78f7241-fc27-44ad-9dc5-b292aebbb1f2	0101000020E6100000C808154C491254C08EA0CDD514B73940	0101000020BC080000A436281F93332B4168903B424AB01E41
1778	5767	NE 2 AV	NE 183 ST	S	N	N	1	1	1	10/26/2016 13:1	25.94345	-80.19705	920027.598277345	585946.834351197	7da65971-e321-4e8a-84e4-ed08d531e3f8	0101000020E61000004AADAC7E9C0C54C023A4546186F13940	0101000020BC08000034193069B5132C41A67DA518B9E12141
1779	6527	NW 183 ST	NW 32 AV	W	N	N	1	0	1	10/27/2016 14:2	25.94075	-80.25312	901610.093087789	584856.445498519	4bd6fc0e-7525-4989-a9ed-6d101446f8a0	0101000020E6100000F2B09EFF321054C00759D26ED5F03940	0101000020BC080000B1722964D2832B41DE17605134D92141
1780	2061	E 1 AV	E 9 ST	N	M	Y	1	0	0	9/23/2016 13:38	25.82961	-80.27951	893155.010957699	544412.03788501	589a55b2-e492-426a-8f75-e4037282e89a	0101000020E61000006FB5D995E31154C004DB8CC261D43940	0101000020BC0800007EF70E39C4412B4125576B7B3B9D2041
1781	1698	SW 40 ST	GRANADA BD	W	N	N	0	0	0	10/13/2016 11:3	25.73447	-80.27326	895401.676402181	509840.942637064	af9307c2-a210-486f-93c6-cb48fcac5f1e	0101000020E61000008DA76E2F7D1154C024E85E3406BC3940	0101000020BC0800008688338E51532B41E8AF398C4A1E1F41
1782	7027	NW 7 AV	NW 58 ST	S	N	Y	1	0	0	9/20/2016 12:05	25.82831	-80.20841	916545.190176617	544074.720960192	3890218c-bb2c-4deb-a7f0-57a87c1591da	0101000020E6100000D958F1B2560D54C005ABBEB10CD43940	0101000020BC0800009A52F29780F82B4116402BD9989A2041
1783	3152	LINCOLN BD	APPROX # 11461	W	N	N	0	0	1	8/17/2016	25.63468	-80.37982	860492.01783859	473392.909560017	8700af94-eaa4-48ed-9bb6-e7fd4208b591	0101000020E6100000D576C7144F1854C03D98875D7AA23940	0101000020BC0800004FD6883896422A41CDB2CB60CAE41C41
1784	6954	NW 2 AV	NW 22 ST	N	F	Y	0	0	1	11/3/2016 16:11	25.79823	-80.1989	919741.697584577	533157.637448445	cb538f24-d6b1-4636-95f1-df1386870baf	0101000020E610000040991FCEBA0C54C0A0C0BED858CC3940	0101000020BC0800006F97169C79112C416EFB11AD4E452041
1785	9245	SW 59 PL	SW 68 ST	N	F	Y	1	0	1	9/22/2016 11:41	25.70813	-80.29057	889756.605346203	500240.063876703	5b56c336-e589-47e7-b990-be95152635f9	0101000020E61000005756AFB1981254C0D7372AA448B53940	0101000020BC0800008493126937272B4144ABEE0547881E41
1786	5860	NW 183 ST	NW MIAMI CT	E	F	N	1	0	0	10/26/2016 12:3	25.94258	-80.20163	918523.769246288	585619.22447966	9da049b9-5091-436a-ba98-fc7fbe014a29	0101000020E6100000F093FB90E70C54C080647DF84CF13940	0101000020BC0800003A3E7DC0F5072C415BB46AE029DF2141
1787	1895	E PALM DR	KROME AV	W	N	N	1	0	1	2/21/2017	25.44797	-80.47688	828783.441542428	405399.85460519	d370283f-a17f-4a55-a028-506d5910095d	0101000020E61000001ED9772E851E54C0F3FDB0B9AE723940	0101000020BC080000A71A730DDD4A2941CC3F901666BE1841
1788	7180	NW 12 AV	NW 52 ST	N	F	Y	0	0	1	11/8/2016 14:08	25.82353	-80.21609	914035.494436629	542322.24708727	35034b0e-6232-4b28-88f7-e4a2568cdd5b	0101000020E6100000F7348337D40D54C0F246A16ED3D23940	0101000020BC080000C43A5C33E5E42B41EC7B65E6E78C2041
1789	2887	17 ST	MICHIGAN AV	E	N	Y	0	0	0	8/20/2002	25.792	-80.139	939464.457666975	531019.808078662	b7dea469-7767-42c4-8ba4-0749a645417d	0101000020E610000057A9D273E50854C0CCF458F3C0CA3940	0101000020BC080000D8ECE4238FAB2C414FC435049B342041
1790	2225	W 16 AV	W 37 ST	N	N	Y	1	0	0	10/3/2016	25.85508	-80.31442	881625.798768882	553608.081809923	09e4d96c-52ba-4d78-8030-070a50f83862	0101000020E6100000554AB06F1F1454C090BF56F6E6DA3940	0101000020BC080000CCAFF2CAB1E72A410439209313E52041
1791	6748	BISCAYNE BD	NE 83 ST	N	N	Y	1	0	1	9/8/2016	25.85128	-80.18467	924303.920408335	552469.178889677	5008d15a-6ef6-4d5a-9a68-e29f55c0d193	0101000020E6100000B29F5CADD10B54C042B3D7A9EDD93940	0101000020BC080000B830B90E1E352C41E59EC6C42DDC2041
1792	7063	NW 7 AV	NW 24 ST	N	F	N	1	1	1	9/21/2016 12:04	25.80019	-80.20709	917045.598982636	533857.007758915	1ab96296-52c7-4bb2-be22-38c556e4beb4	0101000020E6100000F5D4BBD7400D54C0F08616E3D9CC3940	0101000020BC080000AAE0516969FC2B41F3D0B46AC54A2041
1793	5656	NW 135 ST	N MIAMI AV	E	N	N	0	0	0	10/18/2002	25.89871	-80.19931	919384.260323778	569678.293769687	6417818f-d4f9-44ad-8411-85d6ef82c798	0101000020E610000071B0CD85C10C54C0594DD7E711E63940	0101000020BC080000691C0DBCAE0E2C4120B5D701A0622141
1794	4610	SW 40 ST	SW 82 AV	W	F	Y	2	0	1	10/13/2016 12:2	25.73342	-80.32778	877455.602721516	509365.622054145	7fb9a932-954c-4143-ad60-768e86a18f25	0101000020E6100000F1EDF270FA1454C09B8964A7C1BB3940	0101000020BC080000670134661DC72A41B482FB43DD161F41
1795	2068	PALM AV	W 60 ST	S	F	Y	0	0	0	9/22/2016 11:27	25.87683	-80.28345	891765.057033509	561568.542919062	04539621-a707-400e-886f-5da1f5825ad8	0101000020E6100000FA099C27241254C068E5738078E03940	0101000020BC080000A1717D50E8362B41B86F498044232141
1796	136	EARLINGTON HGTS STA	2100 NW 41 ST	T	T	Y	1	1	0	8/18/2016	25.81271	-80.22988	909515.61795187	538360.151695333	aecf799f-e896-4671-8520-cad57bd5a349	0101000020E6100000ECEDDE7AB60E54C0E486A6DF0DD03940	0101000020BC080000FCBFF47195C12B41277BE9B4F36D2041
1797	1374	N COUNTRY CLUB DR	NE 34 AV	W	N	Y	1	1	1	11/3/2016 14:39	25.96641	-80.13306	941000.964481328	594427.114976071	0d913a4b-5688-4806-b690-15eac63236f6	0101000020E61000005BC64719840854C01958E23767F73940	0101000020BC0800004FBE512790B72C417BCD80A9F9232241
1798	8077	W FLAGLER ST	SW 61 AV	E	N	Y	1	1	1	9/8/2012 14:16	25.77057	-80.29541	888041.723926451	522924.505020097	2bf3c6fb-03ab-4cc4-a919-b9fcb94a7fa6	0101000020E6100000254821FEE71254C0844AAD7244C53940	0101000020BC080000BD508BA5D1192B413E3897CFB8EA1F41
1799	3174	SW 112 AV	SW 248 ST	N	F	N	1	1	1	10/4/2016 13:34	25.53743	-80.37192	863263.157672863	438062.342726544	6c3ad6aa-2040-490e-815a-191699ea7b78	0101000020E6100000DD592D99CD1754C096354C7295893940	0101000020BC080000375E7D803C582A414FA82E13C0BC1A41
1800	1231	NE 5 AV	NE 81 ST	N	N	N	1	1	0	11/2/2016 13:57	25.84868	-80.18636	923754.61476054	551521.076488726	dc16122d-4576-4977-991f-1116ac7049dd	0101000020E61000007CD15855ED0B54C0ACE0D55543D93940	0101000020BC0800002D183572D3302C4178362F90C5D42041
1801	8723	BISCAYNE BD	NE 125 ST	N	N	Y	2	0	0	10/8/2016	25.89143	-80.16297	931348.984074589	567107.515129089	6b3664a4-686c-439c-bd6b-5253efdc6e83	0101000020E61000007E9829146E0A54C0A5DF3DEF34E43940	0101000020BC080000E4084D30286C2C41546CE4728A4E2141
1802	1557	SW 42 AV	UNIVERSITY DR	N	F	Y	0	0	0	2/13/2017 9:23	25.74249	-80.26234	898983.876601219	512777.325185031	b61ff2f1-0cc3-465a-bd28-33d16993bd45	0101000020E61000001B797A17CA1054C0BB65CB1014BE3940	0101000020BC08000038612CF54D6F2B413A82B7142C4C1F41
1803	2052	E 4 AV	E 13 ST	S	F	Y	0	0	0	10/19/2016 11:5	25.83363	-80.2738	895027.828035302	545880.97061497	4c3ca7c1-a9d6-4527-a7c9-0f23cc2953a0	0101000020E6100000127FD0E6851154C0E13788C168D53940	0101000020BC0800005C7FA7DB65502B4117763159B5A82041
1804	879	SW 24 ST	SW 67 AV	E	N	N	1	0	0	9/14/2016 14:40	25.7479	-80.30395	885272.40171925	514669.911654115	97da50b1-f93e-4b45-9955-22e036cc76d1	0101000020E6100000D2BBD906741354C0AD5218BF76BF3940	0101000020BC080000A39145002F042B416EF9B56DBE691F41
1805	7017	NW 5 AV	NW 9 ST	N	N	Y	1	0	1	11/8/2016 13:38	25.78223	-80.20296	918442.014525473	527335.879453339	55e2ec4d-9cde-4a5e-af33-61e8742eab96	0101000020E61000008F6D6A46FD0C54C0366E1C9940C83940	0101000020BC08000030204A3E52072C412A0B3628D3172041
1806	4466	SW 82 AV	SW 13 ST	N	F	Y	0	0	1	9/8/2016 13:44	25.75814	-80.32775	877421.337038569	518349.284857482	559580e8-4900-44b9-b1c4-0ae53ad54e3d	0101000020E61000000AB927DEF91454C05026F18115C23940	0101000020BC080000D77301DED8C62A4141CCE5EC3BA31F41
1807	329	SW 42 ST	SW 127 AV	E	F	N	1	1	1	10/13/2016 14:1	25.72957	-80.39919	853953.42659989	507851.470574565	1b827b71-0bfa-4bc0-b22f-dd22908d0b57	0101000020E610000024EC7A708C1954C02272F213C5BA3940	0101000020BC080000772EF608810F2A412C3534A834FF1E41
1808	3612	SW 184 ST	HOMESTEAD AV	E	F	Y	0	0	0	8/17/2016	25.59844	-80.35631	868302.870028544	460259.144185059	24bbb9bf-106e-428c-9f7c-88579b3739e9	0101000020E6100000661D14D8CD1654C0E6B6A07833993940	0101000020BC0800002549D2ED9B7F2A41B785B64D93171C41
1809	4184	SW 56 ST	SW 104 AV	W	F	N	1	0	1	10/12/2016 12:1	25.71573	-80.36368	865667.925472263	502879.669471689	8020102a-7d58-481a-8cac-1e732236ba47	0101000020E6100000FA50B4A4461754C01FCD02B73AB73940	0101000020BC0800008C43D109066B2A419126C37285B11E41
1810	6755	NE 2 AV	NE 71 ST	S	F	N	1	0	1	11/1/2016 12:14	25.83994	-80.19259	921727.455133189	548330.268233322	5c7a23f7-8c59-42ce-b79e-cfdce84e44ee	0101000020E6100000F633824A530C54C00898D64906D73940	0101000020BC08000022BA2720FD202C4198EC04F2D7BB2041
1811	3068	SW 97 AV	SW 112 ST	N	F	N	1	0	1	9/29/2016 16:04	25.66623	-80.35103	869926.233563341	484906.047307931	bc496462-fb80-44fa-870b-756e06a35f8a	0101000020E6100000BADAD123771654C00CE866288EAA3940	0101000020BC080000C1BB34A84A8C2A41EA8BFCF0AE981D41
1812	1567	SEGOVIA ST	MALAGA AV	S	N	N	1	0	0	10/12/2016 13:2	25.74351	-80.2666	897577.210069429	513139.133242935	d12e80ec-a13a-401f-85f3-712b9a878c98	0101000020E6100000D9149500101154C0B86B3CB756BE3940	0101000020BC080000C649BF9F50642B418B958850D3511F41
1813	2320	W 18 ST	# 545	W	M	N	0	0	0	10/19/2016 12:1	25.8381	-80.29286	888749.383295756	547474.753220543	6b0139f9-2b11-46eb-896d-026ed12ddf4e	0101000020E61000004D0E7732BE1254C07BEAB14A8ED63940	0101000020BC080000E8962EF7581F2B41A51309EA28B52041
1814	4049	SW 18 ST	SW 131 PL	W	N	N	0	0	0	10/13/2016 14:5	25.75112	-80.40783	851076.528170396	515671.439835988	1392b85c-ad12-461b-a782-6bf769b36bc5	0101000020E6100000A3C6B9DD191A54C0102AD67149C03940	0101000020BC080000F6B5953C07F929419C17F58A64791F41
1815	4321	SW 88 ST	SW 147 AV	W	F	N	2	0	1	9/29/2016	25.68504	-80.43044	843736.733144335	491623.151667848	a441f601-0af8-4ac0-9171-6f39a3b46983	0101000020E6100000C082BD5F8C1B54C0624237165FAF3940	0101000020BC080000CAB886A4AFBF29410602795DA3011E41
1816	6801	NE 2 AV	NE 50 ST	N	F	Y	0	0	0	11/1/2016 14:42	25.82134	-80.1916	922093.310658775	541574.633450434	72f59796-ba3b-41bf-9c28-38a34c9a2109	0101000020E61000000BF9EB22430C54C0E4ADBFD743D23940	0101000020BC080000603457D6D8232C41226D0AAC10872041
1817	79	SW 1 ST	MIAMI AV	E	\N	\N	0	0	0	 	25.77363	-80.19364	921525.804584876	524229.4430627	8c1230e0-e732-4d38-a044-819cb445a5cf	0101000020E61000002E10DBB0640C54C0B78E901E0DC63940	0101000020BC080000ECD81CD3691F2C413CFAA4901CFF1F41
1818	9130	SW 152 ST	SW 78 CT	E	F	N	1	0	0	11/30/2016 15:5	25.62944	-80.31923	880466.527794521	471589.385245025	b53ca7c6-389a-47d7-a97d-70a26727c340	0101000020E61000007E42A8466E1454C0E33E207B23A13940	0101000020BC08000008224840A3DE2A4179AB71479CC81C41
1819	2186	W 12 AV	W 58 ST	N	F	Y	1	0	0	10/10/2016 14:0	25.8753	-80.30705	884008.797629755	560970.057547718	50f58e9d-3880-4ba6-bd34-8c9fdd9ee786	0101000020E610000073E5D2C8A61354C0279BBC1914E03940	0101000020BC080000EFC4B7CA4FFA2A41EEF2AA87971E2141
1820	5628	NE 119 ST	N MIAMI AV	E	M	Y	0	1	1	11/4/2016 13:59	25.88425	-80.1973	920076.541731395	564427.609039903	715da096-bd45-455b-bd06-8a61cf605410	0101000020E6100000138AA29FA00C54C05EF690735EE23940	0101000020BC0800000173414C17142C41B4027EA29A392141
1821	7243	SW 17 AV	SW 17 ST	S	N	Y	1	1	1	8/22/2016	25.75689	-80.22233	912120.580939826	518087.202030353	8f01a20b-b1fc-4df1-b648-362d66b3edca	0101000020E6100000D0B014B73A0E54C0233E8CD9C3C13940	0101000020BC0800002402785FEFD52B4112A21498239F1F41
1822	10213	SW 152 ST	BUSWAY	\N	\N	\N	\N	\N	\N	 	25.62981	-80.34115	873243.16720999	471684.430377014	b57ff0a6-95d8-4c71-af2d-dbdcdfd08833	0101000020E61000009AF1056ED51554C09D787B343BA13940	0101000020BC0800003E39AB8634A62A41055FD97518CA1C41
1823	3146	CARVER DR	HARRISON ST	NE	N	N	1	0	1	11/17/2016 15:3	25.63434	-80.37518	862022.660501748	473277.982311592	e623dbd6-28a8-428f-94b1-d94103ba41fb	0101000020E6100000C5A66CFE021854C0B1DF625864A23940	0101000020BC0800009F2DD9818B4E2A41051A39ABFEE21C41
1824	10491	BRICKELL AV	SE 8 ST	S	F	\N	\N	\N	\N	 	25.76568	-80.19094	922433.425137803	521345.337910116	a6041b2e-0811-4b2c-8d2a-86da796a1d4e	0101000020E610000099457363380C54C021D4AB1B04C43940	0101000020BC080000B4FCFC1081262C41E05C2E240CD21F41
1825	5929	CALIFORNIA DR	OP # 441	SE	F	N	1	1	1	10/28/2016 17:0	25.95653	-80.19218	921598.686995838	590709.845867977	e408b372-bb7f-4a54-a06d-c11a0bccfd52	0101000020E6100000563969B44C0C54C050780C65DFF43940	0101000020BC080000ABA3C496FB1F2C41A7B8431FEF062241
1826	5480	NW 6 AV	NW 157 ST	N	N	N	1	1	1	11/3/2016 13:23	25.91834	-80.2099	915860.122034162	576792.149289593	3b0ef7bc-2d53-4f52-8bbf-f002f7744d35	0101000020E610000075DF4C036F0D54C06680AD6018EB3940	0101000020BC08000079B0CD7426F32B414530CFB8339A2141
1827	5499	NW 7 AV	NW 151 ST	N	F	N	1	0	1	9/20/2016 13:13	25.91335	-80.21157	915321.106376145	574977.653225273	da5fb53c-f6c1-4754-9bc9-276c4b37f5d7	0101000020E6100000C8DD5E6C8A0D54C0DC65C7CFD1E93940	0101000020BC08000054F1C86CF0EE2B411B2E8ABA068C2141
1828	5948	HONEY HILL RD	NW 55 AV	SE	N	N	1	1	1	10/28/2016 12:2	25.95549	-80.29115	889080.287793286	590143.797103867	eb22bf91-15f0-44fc-97d9-280e30f06288	0101000020E6100000D85FCC3AA21254C0A6087A4D9BF43940	0101000020BC080000608E29C6EE212B412625260683022241
1829	6747	BISCAYNE BD	NE 82 ST	N	N	Y	1	0	1	9/8/2016	25.84984	-80.1846	924331.832416847	551946.29705447	b0f827b7-052f-4c71-a6ef-0f73c61f398c	0101000020E61000005F9EC972D00B54C0EDC1695B8FD93940	0101000020BC0800006B51C1E155352C413926250118D82041
1830	3462	SW 104 ST	SW 122 AV	E	F	N	1	1	1	9/29/2016 14:37	25.67149	-80.39166	856530.88998159	486754.910708956	08864fce-f43c-4a64-af52-c8e42c9b6636	0101000020E610000045959400111954C0FFD31E02E7AB3940	0101000020BC080000960A8BF6A3232A415D89996592B51D41
1831	3443	SW 104 ST	SW 148 AV	W	F	Y	2	1	1	9/29/2016 14:55	25.67034	-80.43542	842121.116934355	486274.853916392	491e8e54-d4c5-485a-be18-1582575e2d19	0101000020E6100000F75E68E2DD1B54C05FDE2BF89BAB3940	0101000020BC080000B20CCD6810B3294174630E2B12AE1D41
1832	8760	NE 12 AV	NE 137 ST	S	N	N	0	0	0	11/4/2016 13:15	25.90191	-80.17493	927393.227574512	570891.816587567	df31a0f6-d150-4148-90bb-d901bfe42466	0101000020E6100000FBFBDC03320B54C04C9E81C0E3E63940	0101000020BC080000170F65AC404D2C413DB5A70D1B6C2141
1833	7074	NW 7 AV	NW 53 ST	N	N	Y	1	1	1	9/21/2016 13:09	25.82389	-80.208	916690.719798412	542469.007939897	6bd3c7af-92a6-4a44-9d65-3e66735abcd4	0101000020E6100000127DB1EE4F0D54C02BFA6B06EBD23940	0101000020BC080000825F22A7A3F92B41EBDCD56B0D8E2041
1834	4070	SW 24 ST	SW 108 CT	E	N	N	1	1	1	9/14/2016 13:14	25.7465	-80.37083	863262.449996639	514051.934237465	ecf84a70-e7ed-471f-854a-8d39fcc836ba	0101000020E6100000C76DD1B0BB1754C0F09412421BBF3940	0101000020BC080000362F27163B582A418848AA8416601F41
1835	632	SW 104 ST	HAMMOCKS BD	E	F	N	1	1	1	9/29/2016 13:40	25.66982	-80.44234	839841.353755776	486074.367102325	3a25c416-78d6-4876-aaf6-23643ec837ad	0101000020E6100000882AC6534F1C54C025FD209079AB3940	0101000020BC08000023CCD8E140A12941B37DA338F0AA1D41
1836	7707	NW 54 ST	N MIAMI AV	E	N	Y	1	1	1	10/19/2016 14:3	25.82517	-80.1963	920541.641205017	542954.718593732	d9d15a6e-5118-48cd-ab22-b02a2d252f51	0101000020E61000000F7F68FE8F0C54C0502C0D633ED33940	0101000020BC0800004C78527FB9172C418E7FD2D7D8912041
1837	9483	SW 24 ST	SW 88 AV	E	F	Y	2	0	1	9/14/2016 14:00	25.74746	-80.33746	874243.621296614	514453.908110909	40f0a553-7c42-4ce3-8588-de53b2ec629e	0101000020E6100000FF5EA205991554C07D55AA0A5ABF3940	0101000020BC08000096A33E6F05AE2A41D05A2B6A5E661F41
1838	9904	SW 167 AV	SW 96 ST	S	N	N	0	0	0	2/13/2004	25.67666	-80.46552	832196.129255388	488528.109241903	44f8e65b-a6ad-4f1f-8d6a-0e9dc02d11b6	0101000020E610000030FCF51FCB1D54C0D175C2B239AD3940	0101000020BC080000CDE9F26D86652941067B423147D11D41
1839	1653	SW 24 ST	COLUMBUS BD	E	N	N	0	0	0	9/14/2016 10:22	25.74864	-80.27945	893335.129025705	514980.00090906	6a581f8d-54ff-4467-b0a0-4f2ad2a35104	0101000020E6100000521592A2E21154C0ED3998D9A6BF3940	0101000020BC0800006000AA752C432B4156BB6EC9966E1F41
1840	6315	NW 37 AV	NW 207 ST	S	F	N	1	1	1	9/19/2016 14:46	25.96353	-80.26239	898515.053052217	593119.058566034	d3129348-f6be-469e-8809-18fce133340d	0101000020E6100000DEBDFFF9CA1054C09F75E557AAF63940	0101000020BC0800009699374FA46B2B41C05E638CC1192241
1841	7632	NW 71 ST	NW 2 AV	W	N	N	0	0	0	11/2/2016 12:51	25.83996	-80.20036	919167.791286875	548323.34464363	c81453a5-fd2e-4574-8bcc-c804a972e560	0101000020E6100000933997CAD20C54C06B607BDC07D73940	0101000020BC080000E54F0FCCFD0C2C416FD81119CABB2041
1842	8850	NW 17 AV	NW 134 ST	N	N	N	0	0	0	10/31/2016 12:2	25.89621	-80.22726	910202.000799496	568717.419039465	92b2ef1b-7682-4746-91d3-d39552bfe5d2	0101000020E61000006F090D688B0E54C0A9EAFD966EE53940	0101000020BC080000FB780036F2C62B4114A9D5411E5B2141
1843	5365	SW 8 ST	SW 92 AV	W	F	N	0	0	0	9/8/2016 11:20	25.762	-80.34521	871668.994532857	519726.589556605	ec66b7e7-2864-4570-b9e8-703e2b3356c1	0101000020E61000000A86F1DD171654C0734AFD1013C33940	0101000020BC080000E1E8052EE8992A41BE593325C1B81F41
1844	4388	SW 57 AV	SW 48 ST	S	N	Y	1	0	0	12/1/2016 13:15	25.72686	-80.28634	891115.600291114	507054.80943954	3dd4fddb-71bc-4a91-9063-30a1dd31d3b7	0101000020E6100000E5FC063E531254C00029BA1014BA3940	0101000020BC080000AC96BA66D5312B418DCE3503C2F21E41
1845	8266	TIGERTAIL AV	BLAINE ST	SW	F	N	0	0	0	11/16/2016 13:0	25.73288	-80.23606	907653.320528571	509334.40491458	af23c917-088d-418f-a7d4-0bd60d120ced	0101000020E61000009B871C9A1B0F54C0A64B47659EBB3940	0101000020BC080000EA5B83D908B32B41770DC76560161F41
1846	3472	SW 112 ST	SW 104 PL	W	F	N	0	0	0	9/29/2016 13:25	25.66511	-80.36473	865411.974203594	484478.146882392	d5c14d17-9aea-4743-956a-192389d3fddd	0101000020E6100000FB74F0C7571754C0B0D33BF444AA3940	0101000020BC0800009B46D62206692A4146A7E456FF911D41
1847	8597	NE 15 AV	NE 167 ST	N	F	N	0	0	0	11/8/2016	25.92993	-80.17009	928917.242236476	581086.046889946	15f2de9a-e04d-459d-870a-2d68ca886f07	0101000020E61000001D54FBD8E20A54C00F78730110EE3940	0101000020BC080000F6C801B428592C41FC86F884BFBB2141
1848	7169	NW 12 AV	NW 24 ST	N	N	N	1	0	0	11/8/2016 13:47	25.79924	-80.2152	914375.334337283	533494.972741395	0bdddb8a-1bc6-489a-af24-fc911f338dbd	0101000020E610000082C7E1E9C50D54C049CC2A7F9BCC3940	0101000020BC0800009C0165E18CE72B4100EFA458F1472041
1849	826	NE 2 AV	NE 7 ST	S	F	N	0	0	0	11/1/2016 14:08	25.78054	-80.19057	922522.675942648	526747.571221001	bf2471b6-25c1-4e21-95a5-24ed22b097d2	0101000020E61000001FCD2B4B320C54C002C0EE09D2C73940	0101000020BC08000084395F9133272C41A652358A3A132041
1850	1210	NW 12 AV	NW 14 ST	N	F	Y	1	0	0	10/25/2016 11:4	25.78816	-80.21486	914511.232642878	529465.886012837	108e588e-50fb-4af1-993f-7da91c346572	0101000020E610000080D1D157C00D54C0A1C321E6C4C93940	0101000020BC080000103264AD9CE82B410A1FBC2B77282041
1851	2544	NE 8 ST	SW 157 AV	W	F	N	0	0	0	10/30/2002	25.47748	-80.44491	839286.896539565	416165.423944637	a204d20a-4ab4-4fd0-b016-01c0125a546d	0101000020E6100000E9774F73791C54C0ABD4D04C3C7A3940	0101000020BC08000074CFCBF7EB9C2941AC8780609C661941
1852	9630	NW 10 AV	NW 58 ST	N	F	Y	0	0	0	9/23/2016 13:46	25.82869	-80.21233	915255.900144953	544202.194144405	4821dcdb-d4f1-4671-a5cc-44d2fd22abe5	0101000020E6100000019009E0960D54C07046DD1225D43940	0101000020BC080000B89D31036EEE2B41E65177CB979B2041
1853	4946	NW 32 AV	NW 56 ST	S	M	Y	0	0	1	9/1/2016 13:36	25.82552	-80.24911	903163.595894761	542980.317601807	4c211461-9271-44ff-ab6f-39aef484f4c9	0101000020E6100000064AC67EF10F54C09190668555D33940	0101000020BC0800007BABE565F58F2B415CE8800A0C922041
1854	4582	SW 24 ST	SW 80 AV	E	F	Y	2	0	1	9/14/2016 14:18	25.74781	-80.32539	878217.950932276	514600.542022139	a0cf84ec-65b7-41b6-b574-80082f93e564	0101000020E6100000FAF6332BD31454C0A8ED25D970BF3940	0101000020BC0800004D7C7E1812CD2A41CFA053F3A8681F41
1855	5175	NW 71 ST	NW 14 AV	W	N	Y	1	1	1	11/8/2016 14:20	25.83936	-80.22093	912404.000299569	548063.184431285	fdf1cb82-ca3e-49e4-b9d8-2963cbf4edaf	0101000020E610000016F10FC7230E54C0531C0847E0D63940	0101000020BC08000022BE123626D82B410780F6C6C1B92041
1856	5442	NE 2 AV	NE 110 ST	N	F	N	0	0	1	11/4/2016 10:39	25.87629	-80.19389	921214.823594984	561542.693865389	fa01b54b-2478-4de6-904f-02ffcf8a81cc	0101000020E610000028B670C9680C54C001C7FD0B55E03940	0101000020BC080000AC97BCDCFB1C2C41E3AC90CD10232141
1857	3670	SW 207 ST	SW 85 PASSAGE	W	N	N	1	1	1	10/4/2016 12:05	25.57514	-80.32873	877435.980715405	451837.632453889	98cb16de-5758-43b5-953c-9fbe41522df2	0101000020E61000009B6EBFF0091554C0EC8A4ACF3C933940	0101000020BC080000838EB727F6C62A41F62A973FFD931B41
1858	5428	NE 6 AV	NE 166 ST	S	F	Y	1	0	1	11/1/2016 13:47	25.92743	-80.18831	922934.240433048	580141.660952926	96d023a2-5b08-44c0-9570-693ec97bbdcc	0101000020E6100000077D6A610D0C54C0DA3D417E6CED3940	0101000020BC08000087D260B26A2A2C41B52618BF5EB42141
1859	3829	SW 107 AV	SW 29 ST	S	N	Y	1	0	1	10/27/2016 19:4	25.74276	-80.36782	864258.440124519	512695.883791804	7cea5b3d-571f-4667-b787-e8e76d299fca	0101000020E61000002367BD708A1754C0278D29E425BE3940	0101000020BC0800005214191103602A416400CB50E64A1F41
1860	7258	NW 17 AV	NW 3 ST	N	F	Y	0	0	1	8/18/2016	25.77643	-80.22272	911949.340465657	525188.905396983	00fe08c9-01a7-442b-adf8-ee8b067fe838	0101000020E6100000559D7127410E54C0DBE8377DC4C63940	0101000020BC080000A0E452E498D42B41553524350D072041
1861	345	E 8 AV	E 49 ST	S	F	N	1	0	0	2/15/2017 12:12	25.86684	-80.26691	897225.473282177	557966.084245645	a56909ea-c31b-4b32-92c4-3a2c5b00d2ca	0101000020E6100000A67FD414151154C02164E988E9DD3940	0101000020BC080000E74B402691612B41BD61F1941F072141
1862	7519	SW 37 AV	SW 27 LN	N	F	Y	1	1	1	9/22/2016 14:28	25.74008	-80.25408	901703.898056503	511918.467361376	77824461-99b3-4f3f-ad52-34de44a0dd24	0101000020E6100000178FDAF4421054C024EB977376BD3940	0101000020BC0800008B0372008E842B419A4D49A6C03E1F41
1863	3402	SW 162 AV	SW 282 ST	S	N	N	0	0	1	10/4/2016 15:32	25.50491	-80.45322	836503.823711477	426124.348881878	68736517-861e-41df-81c4-69cfbe35a21d	0101000020E6100000AE4B61A2011D54C095F8472642813940	0101000020BC080000FB712DD22D872941E4262C1638021A41
1864	7838	NW 20 ST	NW 3 AV	E	N	Y	1	1	1	11/8/2016 13:42	25.79528	-80.20062	919181.270537522	532085.233447969	812919ed-9ada-4c02-9f05-4e8e1209d232	0101000020E6100000CBEDE808D70C54C0A137F11A98CB3940	0101000020BC0800008D157AC1180D2C417CFE0DDEED3C2041
1865	577	NW 215 ST	US 441	W	F	N	0	0	0	10/28/2016 11:5	25.97275	-80.2069	916727.071710877	596577.661885262	ab375d64-50b4-433c-afb1-0b1462c94c9d	0101000020E6100000DF0600D43D0D54C0E37971B706F93940	0101000020BC0800000F632C5BECF92B41FFA9D3C1C6342241
1866	482	W FLAGLER ST	# 7167	W	N	Y	1	1	1	9/6/2012 12:54	25.77039	-80.31101	882912.046170197	522831.229330294	627a669b-a6d9-4ab0-976e-2540a4f678ab	0101000020E6100000B270F562E71354C0B868398538C53940	0101000020BC080000F40FE449BEF12A41EA195FB543E91F41
1867	8464	NE 96 ST	NE 4 AV	E	F	N	0	0	0	10/14/2016 15:0	25.86358	-80.18894	922871.318958148	556932.632254444	d1cc2268-4798-4880-b548-ead897f692f7	0101000020E61000005A006FAB170C54C0E7F6C10414DD3940	0101000020BC08000005F3A6DAEC292C411DE662AD0CFF2041
1868	3169	SW 112 AV	# 22790	S	F	N	1	1	1	10/4/2016 14:48	25.55575	-80.37223	863131.466989953	444717.66865021	a8ca0ea0-b372-4105-b211-b400f9acfe62	0101000020E610000046963F94D21754C08CCC869B458E3940	0101000020BC080000AE27D51E35572A411C289F62BD241B41
1869	5455	N MIAMI AV	NE 151 ST	N	N	N	1	0	0	11/3/2016 17:16	25.91336	-80.19962	919253.773696925	575005.481948152	ffab4370-b4b0-4c1e-91fc-dae469b5b481	0101000020E610000053ACB467C60C54C080395488D2E93940	0101000020BC080000DA4CEAC2A90D2C41A5ABD1623E8C2141
1870	2606	HARBOR DR	FERNWOOD RD	W	F	Y	0	0	0	11/14/2016 13:4	25.69938	-80.16477	931198.058185667	497299.056271426	de7f7fca-e08b-4e83-8722-f54b9ba7f764	0101000020E6100000D1770FAB8B0A54C0A7E64FAD0AB33940	0101000020BC0800008C9C4556FA6A2C41674AA1FD525A1E41
1871	9039	NW 135 ST	OP # 4050	W	F	Y	0	0	0	12/6/2002	25.89657	-80.26458	897929.46034655	568778.088531345	20bf7492-e46d-4227-bbc2-2c1c85dede9c	0101000020E6100000BFE912FDEE1054C0AF9B8E3F86E53940	0101000020BC0800004114CE1F11672B4129618698975B2141
1872	3539	SW 168 ST	SW 102 AV	W	M	Y	0	0	0	11/17/2016 14:1	25.6135	-80.35909	867363.479216311	465731.189975969	447e6b97-65a3-473a-a00f-d2e61298e4d6	0101000020E61000007D084E3AFB1654C0DF57C9F70E9D3940	0101000020BC080000E8899E2545782A415318257E136D1C41
1873	5362	WALSH BD	SW 5 ST	SW	N	N	0	0	0	9/28/2016 11:59	25.76358	-80.3895	857086.253337894	520227.968791172	14bd3267-9507-4aff-af4c-a6bbe2218ea9	0101000020E6100000735AABADED1854C0C63BC4167AC33940	0101000020BC08000000CC9BB0FA272A41B596ACA996C01F41
1874	7825	NW 20 ST	NW 21 AV	E	F	Y	1	1	0	9/1/2016 11:52	25.79448	-80.22916	909791.61319039	531737.367681131	f57c2c69-ed53-464a-8a5d-e800253ba48e	0101000020E6100000B3A7C5AAAA0E54C04B27D27A63CB3940	0101000020BC080000D3BA996FBDC32B413D0DB322363A2041
1875	6902	S MIAMI AV	SE 26 RD	N	F	Y	1	0	0	10/18/2016 12:2	25.75152	-80.20428	918073.377737954	516172.297780521	5c2a7568-a8f1-453c-b0c5-2e682d3b1dcd	0101000020E6100000B010DFFB120D54C0BF86FF2E64C03940	0101000020BC080000F93B21F870042C4130DDACF937811F41
1876	10393	NW 73 AV	NW 186 ST	S	N	Y	2	0	1	11/11/2016 12:2	25.94094	-80.31965	879741.989560876	584807.08240819	8bf9e22d-2a17-4bdc-a02f-8c04da183a80	0101000020E610000007D21339751454C094400604E2F03940	0101000020BC080000C637662CFAD82A4191B46F97D1D82141
1877	9310	SW 72 ST	SW 62 AV	W	F	N	1	0	0	9/26/2016 11:55	25.70419	-80.29446	888483.383150466	498800.813792631	e4d08551-60f3-46a1-9b23-ad9e3f6742d7	0101000020E6100000D3C6886DD81254C04A69205D46B43940	0101000020BC080000346A18F7441D2B4103F47605CA711E41
1878	5169	NW 71 ST	NW 19 AV	E	N	Y	1	1	1	9/26/2016 13:01	25.83936	-80.22964	909540.789523505	548048.1270312	54ba8da1-4578-4e7e-abfe-ff3b2d795238	0101000020E61000007FC37C66B20E54C0F9F7E99AE0D63940	0101000020BC0800000332E6C9C7C12B410BE898A9A3B92041
1879	3251	SW 122 AV	SW 185 ST	S	F	N	0	0	0	11/29/2016 13:4	25.59627	-80.38902	857525.893891878	459420.186531447	af25f194-c0b7-4451-88bb-999c7671c362	0101000020E61000003DEBFEC7E51854C0D9599B63A5983940	0101000020BC0800009425B2F8692B2A4107DAE578770A1C41
1880	8861	NE 123 ST	NE 19 AV	E	N	N	1	0	0	10/31/2016 16:5	25.88921	-80.16029	932233.94590408	566306.224030212	9428dc7f-1056-48d6-984f-bab4ec711262	0101000020E61000003910343C420A54C07F5CD071A3E33940	0101000020BC080000FDCEDB1C12732C415CFEA9DD47482141
1881	6425	NW 173 DR	NW 43 RD	E	N	Y	1	0	1	10/26/2016 13:2	25.93191	-80.27186	895465.447277267	581609.390633292	ce4c06ee-54a1-4751-8ff0-6a40e16f9b31	0101000020E6100000DF3E3B3B661154C08009C03992EE3940	0101000020BC0800003628AA18D1532B41F269F534D6BF2141
1882	4824	NW 22 AV	NW 64 ST	S	F	N	1	0	1	10/17/2016 11:1	25.83307	-80.23322	908374.636036128	545755.382617325	4518402c-00f8-4b8d-a10f-fa6439447e5a	0101000020E610000094F74327ED0E54C016F9F97244D53940	0101000020BC080000A8D3167BABB82B414223212CBAA72041
1883	5668	NW 165 ST	NW 2 AV	W	F	N	1	1	1	11/3/2016 15:04	25.92613	-80.20496	917465.371762421	579636.688861877	e5b99bad-ec08-4b91-a317-d60ebc44cff7	0101000020E61000001D5D35241E0D54C07A8C377E17ED3940	0101000020BC0800004099F9F4B0FF2B41B34469CD6CB02141
1884	4856	NW 27 AV	NW 93 ST	N	N	N	1	1	1	9/16/2016 11:38	25.85836	-80.24202	905426.048746672	554928.872806504	3939336a-c9b7-4376-8095-b879ff5989db	0101000020E6100000C251BD617D0F54C0A160FB86BDDB3940	0101000020BC080000483CFC4DA2A12B41A9EE4E2865EF2041
1885	4846	NW 27 AV	NW 68 ST	N	N	Y	1	0	0	9/16/2016 11:05	25.83584	-80.24121	905744.936524428	546747.690690063	6b0ea5d8-7b1a-45d2-a68c-5b3e17f78d56	0101000020E6100000349A3DD96F0F54C09EE76B1DFAD53940	0101000020BC08000041A4931420A42B4152F108CA7AAF2041
1886	5864	NE 185 ST	NE 14 AV	E	N	N	1	1	1	10/27/2016 17:1	25.94473	-80.17372	927690.233562976	586460.494127236	afc1d5c2-18aa-4fc8-b8bc-56cc76e8efbc	0101000020E6100000D0944F521E0B54C0B33ABE65DAF13940	0101000020BC0800007AD884AF924F2C41B75F9F6ABCE52141
1887	4420	SW 67 AV	SW 32 TE	S	N	Y	1	0	1	10/10/2016 14:1	25.74024	-80.30332	885496.785469986	511886.554686159	e10368d2-a0f9-4057-b3c7-0eab36565a49	0101000020E6100000B4571497691354C0DC02CFAC80BD3940	0101000020BC08000049A8BBC4EF052B4198B68FFF403E1F41
1888	5413	NE 12 AV	NE 146 ST	N	N	Y	1	0	1	11/4/2016 12:19	25.90976	-80.17523	927273.686465792	573746.631429963	cb3f00d1-b1ac-4673-839e-8ceebbf1f86d	0101000020E610000037F4E713370B54C0B94F589AE6E83940	0101000020BC080000F4164397514C2C41440F45AF68822141
1889	10251	SW 72 ST	SW 158 PATH	E	N	N	1	0	1	9/26/2016 13:19	25.6987	-80.44998	837279.621356122	496561.721175738	0b490d12-c80d-49e4-83d1-9103aec5a4b2	0101000020E610000043333E95CC1C54C0A6BE5C81DEB23940	0101000020BC080000DA6B7B6A3D8D294134B1EEA5CD4E1E41
1890	10537	Ft Lauderdale	Tri-Rail Station	T	T	\N	\N	\N	\N	 	26.12132	-80.17004	928493.440923274	650655.597649977	b38f1f11-133f-440d-af2e-aa339bd6dfe9	0101000020E6100000DD7D1FEEE10A54C0E888D7770F1F3A40	0101000020BC0800000C4A8719D9552C41E01EECA742DB2341
1891	7304	NW 22 AV	NW 20 ST	S	F	Y	1	1	1	10/17/2016 12:1	25.79405	-80.23156	909004.812218331	531575.74594225	85672749-293c-47c7-a694-0f2aa1f4ee24	0101000020E610000053F5EFE3D10E54C068B80E2B47CB3940	0101000020BC080000594672D597BD2B419A6645E4F2382041
1892	7600	NE 79 ST	PELICAN HARBOR DR	W	N	Y	1	0	1	10/20/2016 15:2	25.84851	-80.16632	930344.668529041	551500.591243424	e7c7b3f9-75b2-4dbd-9e1b-3d2287959804	0101000020E6100000C80C3F10A50A54C067E8B83138D93940	0101000020BC0800005B09948E4F642C419914C3979CD42041
1893	2013	E 4 AV	E 31 ST	N	F	Y	1	1	0	10/3/2002	25.85069	-80.27447	894773.545121204	552080.846686438	fbc1afbe-b4f2-44b9-8235-1c9ff4c50c8d	0101000020E61000009B5CCEDC901154C066DCB3DDC6D93940	0101000020BC080000EFE2C44A694E2B41D646921A25D92041
1894	8952	NE 163 ST	NE 35 AV	NE	F	N	0	0	0	11/19/2002	25.92871	-80.13448	940624.663025577	580719.059711441	2e4c3a12-0d7b-42bd-a54a-631a49f29109	0101000020E6100000F7F062619B0854C0CAA5CA2EC0ED3940	0101000020BC0800008EDEFC8C9FB42C41BD196F8BE1B82141
1895	5574	NW 27 AV	NW 108 ST	N	N	Y	1	0	1	9/19/2016 11:22	25.87268	-80.24253	905231.268256273	560132.793158874	7ce4b77e-3df1-4481-b527-5b21abd48bd4	0101000020E6100000E74F1697850F54C078C8C50068DF3940	0101000020BC08000074C162BE1CA02B41FAAD25000D182141
1896	7603	NE 79 ST	NE 8 CT	W	N	N	1	0	0	10/20/2016 15:2	25.84808	-80.1793	926078.276447974	551317.072303638	5d8e6545-5fc0-496e-9d8c-76ee0eeec638	0101000020E6100000321B5CA5790B54C094C9BBF21BD93940	0101000020BC08000026274CC5FA422C41241AF58D2DD32041
1897	2441	W 68 ST	W 11 AV	W	N	Y	1	0	0	10/3/2016	25.88427	-80.30525	884582.755446289	564231.293175161	55c42473-09a3-4d12-b377-124593e0a0c8	0101000020E6100000978F7653891354C0B590BE905FE23940	0101000020BC0800004B852EB5CBFE2A41D0E4B50012382141
1898	3096	SW 104 AV	SW 178 ST	N	N	N	0	0	0	8/16/2016	25.60376	-80.36075	866831.894976445	462185.990361154	73c93be3-24ca-4d8e-85c6-d64e81cf934a	0101000020E6100000A9A1D281161754C0F94F3630909A3940	0101000020BC080000F53F6DFA1D742A410F59A4B0AE351C41
1899	5176	NW 71 ST	NW 15 AV	W	N	N	1	1	0	11/8/2016 14:20	25.83927	-80.22308	911698.665442232	548027.386896648	8aa8689f-6d9f-464d-8ae8-412e08a335bb	0101000020E61000005814D8EB460E54C0B9156893DAD63940	0101000020BC08000062ECA38AA3D22B41B1EF982E7AB92041
1900	6313	NW 37 AV	NW 209 TE	N	N	Y	1	0	1	9/19/2016 11:51	25.96615	-80.26228	898545.177980017	594070.10257262	4464c2a2-85d0-4ed8-9bf6-c78d2ef5e91e	0101000020E610000046AC0335C91054C0D45D1AC955F73940	0101000020BC080000B672348FE06B2B4135BE11A32F212241
1901	8905	NE 125 ST	NE 4 AV	W	N	Y	1	0	0	10/31/2016 12:5	25.89018	-80.1899	922496.938167129	566600.136184014	21b7b8ba-097f-4651-b8b2-ef5e13ed5ee8	0101000020E61000000A596359270C54C0D3B92579E3E33940	0101000020BC080000541B9D1700272C41EEA1B9B0934A2141
1902	2333	W 21 ST	W 1 AV	W	F	N	0	0	0	10/19/2016 11:4	25.84086	-80.28441	891523.925259907	548490.41681046	db685217-fc1b-4565-9e63-8f7231d14b9b	0101000020E6100000629D32B8331254C07B8365B642D73940	0101000020BC080000DD9BF20C06352B412221FC3D18BD2041
1903	5970	NE 202 ST	NE 26 AV	W	N	N	0	0	0	11/1/2016 13:45	25.96276	-80.14907	935747.615680795	593063.332302682	39cda942-09c8-404d-9f2e-fb1ddad7623e	0101000020E61000005F70147D8A0954C0CDC1978D77F63940	0101000020BC08000069DA1D74858E2C418E7C981852192241
1904	4452	SW 79 AV	SW 86 ST	N	F	N	1	0	0	10/31/2016 10:2	25.69042	-80.3214	879635.891973015	493748.07686042	b47543ee-35a3-4d0e-b0ff-1f7333031d14	0101000020E6100000353F79ED911454C05108B3ABBFB03940	0101000020BC08000009EA85FA25D82A4156D5A511D7221E41
1905	4592	SW 24 ST	SW 60 CT	E	N	N	1	0	1	9/14/2016 12:50	25.74816	-80.29352	888705.065087721	514783.756566793	7fd76938-5317-4b1f-9d00-0b1b025f32c8	0101000020E61000004E794024C91254C0081A85FB87BF3940	0101000020BC0800000A464A54001F2B417BC126CF856B1F41
1906	6768	NE 2 AV	NE 45 ST	S	F	Y	1	0	0	9/25/2002	25.81687	-80.19162	922095.730911475	539949.516577013	6340316a-7761-42c0-89f1-537e67692c15	0101000020E610000098886483430C54C0CDBBCCD41ED13940	0101000020BC080000394B73ADDD232C4109A108705E7A2041
1907	4315	SW 88 ST	SW 133 AV	W	F	N	1	1	0	10/3/2002	25.68573	-80.40901	850798.135702241	491903.845939428	ce609690-bd97-43e9-96d7-6770e643aff0	0101000020E6100000B12FDC042D1A54C0B7D0291C8CAF3940	0101000020BC080000C15C9F73DAF6294170118D2406061E41
1908	2334	W 21 ST	W 3 AV	W	N	N	1	0	0	10/4/2002	25.84075	-80.28793	890365.387249403	548446.686948717	ca3096cd-ff08-430e-8c46-2bedfe4faef8	0101000020E61000005863BB706D1254C0F80F57F63BD73940	0101000020BC080000ADF26BF9F82B2B41D2F359C8C0BC2041
1909	8073	W FLAGLER ST	SW 66 AV	E	F	Y	1	1	1	9/8/2012 14:05	25.77043	-80.30301	885539.505147506	522861.039294995	b9de5cbf-9bf8-43ad-bead-f8954a30b4f5	0101000020E610000094EDA093641354C01AE36B673BC53940	0101000020BC08000094902B3545062B411502B9F2BAE91F41
1910	3917	SW 122 AV	SW 18 ST	N	F	Y	1	0	0	9/27/2016 12:28	25.75252	-80.39025	856858.009071797	516206.63592951	071dd76c-a537-4bc0-8078-bfdee04c9994	0101000020E6100000FA8B65F7F91854C0AC9BF131A5C03940	0101000020BC0800004E887E3332262A41AC3FCC53C1811F41
1911	2982	US 1	SW 145 AV	SW	F	N	1	0	0	10/4/2016 11:40	25.51521	-80.43093	843839.599702705	429898.996189803	1ec5e370-5711-4d4b-9870-3b427f0e5863	0101000020E610000056C4516F941B54C0D41A753CE5833940	0101000020BC08000074395F607DC02941A5453CAE323D1A41
1912	5637	NW 119 ST	NW 22 AV	W	F	Y	1	0	0	9/30/2016 16:13	25.88288	-80.23539	907557.771153681	563856.701716796	43305bf6-ca45-43c7-b9da-39286d73398f	0101000020E61000006EDC8D97100F54C0E6F8A1FE04E23940	0101000020BC080000FD6B28C049B22B416087D1D124352141
1913	8914	NW 125 ST	NW 8 AV	W	F	N	0	0	0	10/31/2016 12:5	25.88914	-80.21309	914873.609546654	566174.264367424	45022013-ac18-42f8-8698-9960e86f636f	0101000020E61000009A421A5CA30D54C0BFB3B70D9FE33940	0101000020BC080000709F4B6E71EB2B4113FB54F23F472141
1914	3731	SW 268 ST	SW 138 AV	W	F	N	0	0	0	8/17/2016	25.51814	-80.41487	849132.126528583	430984.687959462	adb549cc-4056-4d20-ae24-7be4a50ec206	0101000020E61000005E6463468D1A54C02B6508DDA4843940	0101000020BC08000015C3BE6ED6E92941A537B072294E1A41
1915	7101	NW 8 ST RD	NW 11 ST	NW	N	Y	0	0	0	10/29/2002	25.78372	-80.20903	916439.653319947	527863.57619179	63da9ca0-20f4-4224-947d-afc5fe43d043	0101000020E6100000CED6D2CE600D54C0347F44EBA1C83940	0101000020BC08000095061C85ADF72B4184B9F38CF21B2041
1916	5388	BISCAYNE BD	11200 BLOCK	NE	F	N	1	1	1	9/8/2016	25.87997	-80.16707	930030.415873315	562932.819078676	00103540-e5c7-4b50-aeca-0d4c5ed291d3	0101000020E6100000B2F8101BB10A54C05DBBBCC245E13940	0101000020BC0800006C522E0DDB612C41112EEB0DED2D2141
1917	9089	SW 77 AV	SW 152 ST	S	N	N	1	0	0	11/30/2016 13:2	25.62979	-80.31741	881066.868472774	471717.869619936	68517d50-68f3-4c4b-a1fc-755d15e8c49e	0101000020E6100000ACAA3F64501454C051D746173AA13940	0101000020BC080000B003B0EE53E32A411093B4379ECA1C41
1918	7414	SW 27 AV	SW 19 TR	N	N	Y	1	0	0	9/16/2016 10:49	25.75317	-80.23822	906897.3446749	516703.851134248	dc533aba-3370-4616-9047-dde198f90984	0101000020E6100000A1AC2B1B3F0F54C074B1BAECCFC03940	0101000020BC0800008C29CCE520AD2B412A12573086891F41
1919	6800	NE 2 AV	NE 48 ST	N	N	N	0	0	0	11/1/2016 14:39	25.8191	-80.19152	922124.301090334	540760.985758476	779180a5-1fca-4281-b92f-0d336fa50a33	0101000020E6100000AFC991D7410C54C09E098F1BB1D13940	0101000020BC08000009F66AD116242C4159FF5E60B5802041
1920	352	SW 42 AV	CORAL WY	N	N	Y	2	0	1	2/13/2017 13:45	25.74907	-80.26261	898879.652059346	515168.395203367	6e5341e3-a750-4102-af44-32ef259649a2	0101000020E61000000F611C9DCE1054C048FAE74AC3BF3940	0101000020BC080000E0B721827D6E2B41A3F7155D88711F41
1921	4438	SW 67 AV	SW 40 ST	N	N	N	1	0	1	10/10/2016 12:1	25.73275	-80.30277	885690.582636405	509164.102473117	ab143a22-7acc-4ede-9c9e-c4aa1abe3dcf	0101000020E6100000FF4C2EA9601354C020751A9D95BB3940	0101000020BC0800006A56EF5C73072B415E0FD42FB7131F41
1922	8694	NW 168 ST	N MIAMI AV	E	N	N	0	0	0	11/3/2016 13:35	25.92895	-80.20079	918829.706297461	580668.205154151	ba883a09-0485-4458-9265-5d169a16fc5d	0101000020E610000064BBF5D1D90C54C0142415FACFED3940	0101000020BC08000002B152A0590A2C41C4BBD0D57BB82141
1923	2830	ALTON RD	23 ST	S	N	N	1	0	0	8/22/2002	25.80167	-80.13835	939657.65088677	534534.170497417	4b2ee828-16ef-4a20-9274-d76e5b31b1de	0101000020E6100000F0552AB0DA0854C033E22D5B3ACD3940	0101000020BC080000E204D28611AD2C4197281DBE0F502041
1924	8420	NE 2 AV	NE 94 ST	N	N	Y	1	0	1	11/4/2016 12:56	25.86124	-80.19326	921459.86375431	556073.020771332	ffc0c400-527d-4389-879e-23efd9260a00	0101000020E6100000821180405E0C54C0D6FD48997ADC3940	0101000020BC08000087835BF1E51E2C41BEFF3A7455F82041
1925	5930	NE 195 ST	# 626	E	F	N	0	1	0	10/28/2016 17:1	25.95504	-80.18988	922357.470216829	590172.935499556	52cf5a95-fd88-407e-8723-f53f9d91f6f1	0101000020E610000065E5B309270C54C01EFFFBBE7DF43940	0101000020BC0800007046EB27E9252C4149C8034DBD022241
1926	3767	SW 280 ST	OP # 15001	E	N	N	1	1	1	10/4/2016 16:18	25.50669	-80.43494	842530.933370117	426795.378048971	501cff82-02f8-4ab2-8468-b78b5321ecc9	0101000020E610000023C7171AD61B54C058F0689BB6813940	0101000020BC0800001489FC0A44B62941F4713A34B40C1A41
1927	1228	N MIAMI AV	NE 38 ST	N	F	N	0	0	0	11/2/2016 10:37	25.812	-80.19529	920897.887179382	538172.740976624	a0227e70-2f62-48f2-9b67-14c797b1be6d	0101000020E61000000ADF44B57F0C54C0FF7C4ACDDFCF3940	0101000020BC080000B7B855FD811A2C416479B4E27C6C2041
1928	3421	SW 167 AV	OP # 10300 CARROLL HS	N	F	N	0	0	1	11/14/2003	25.67105	-80.46551	832211.605599798	486491.732776463	344e002f-5f96-4c03-88b2-f3bcba78ac29	0101000020E610000046E8B0C3CA1D54C0A681FF7FCAAB3940	0101000020BC0800008E2BB861A5652941555842AF75B11D41
1929	8961	NW 27 AV	NW 136 ST	N	N	Y	0	0	1	9/19/2016 12:22	25.89844	-80.2435	904855.376623686	569494.276437126	7029befe-9908-47e8-b193-83ad6f449e4b	0101000020E610000083BC4FA1950F54C011A3BE4600E63940	0101000020BC0800003F06D2F52C9D2B410954CEF82F612141
1930	9101	SW 97 AV	INDIGO ST	S	N	N	0	0	0	11/15/2016 12:4	25.60247	-80.34842	870896.646636833	461738.369861312	f411ff19-deed-4e78-849c-ae46676f5de1	0101000020E6100000C9FC9D8A4C1654C01E21BAE83B9A3940	0101000020BC080000A731E87BDF932A41659E5335B02E1C41
1931	10336	NW 4 CT	NW 19 TE	N	N	N	0	0	1	11/8/2016 13:42	25.794	-80.20239	918606.637188986	531615.039145835	088f89f1-0368-4946-b493-d3197420a66b	0101000020E6100000C1BBEAC9F30C54C0DBFDFBF443CB3940	0101000020BC0800005FB5147D9B082C417E39727A41392041
1932	8947	OPA LOCKA BD	NW 5 AV	W	N	Y	0	0	0	11/12/2002	25.89998	-80.20714	916811.613229226	570125.746943422	25cdefd1-a151-46f7-ba19-d1e74474d98d	0101000020E6100000CBD8AF98410D54C04206036665E63940	0101000020BC080000E6096D7095FA2B41BCA9CCE91E662141
1933	591	S MIAMI AV	SE 9 ST	N	N	Y	0	0	0	9/13/2002	25.76525	-80.19321	921686.966680184	521181.921252705	242e438a-1b53-4b75-9d74-0e750b1a2552	0101000020E61000001845B8985D0C54C039BE0478E7C33940	0101000020BC080000E4432D26AC202C41B2BD71797ECF1F41
1934	2710	WASHINGTON AV	14 ST	SW	F	Y	1	0	0	11/2/2016 13:22	25.78564	-80.13179	941851.823991001	528722.981285065	5bcf0c05-e5b4-46a0-9d4c-224272d2fd54	0101000020E6100000F20B13576F0854C0B3FBAD0220C93940	0101000020BC08000072FBC7DF35BE2C41304E8D5CA9222041
1935	4288	SW 72 ST	SW 89 CT	E	N	N	1	1	1	9/26/2016 13:45	25.70197	-80.33939	873696.021997739	497917.090176366	3e81bd13-88a8-40e1-ac18-b20d3d60bde9	0101000020E61000005FB9B965B81554C0BBABEBCEB4B33940	0101000020BC080000B8ED483CBEA92A41E3504A20FB631E41
1936	9909	SW 152 ST	SW 133 AV	W	F	N	1	0	0	11/17/2016 11:5	25.62656	-80.40852	851050.679494146	470402.084504828	1c44f4dc-fa50-48f9-8fad-ca527a64e622	0101000020E6100000806A903C251A54C07F0F46DE66A03940	0101000020BC0800007776028AD3F82941833048130FB61C41
1937	5385	BISCAYNE BD	NE 108 ST	NE	N	N	1	1	1	9/8/2016	25.87463	-80.17032	928969.138115749	560984.709779575	dd86aae9-2ea2-48a2-aeb8-29d7dd369978	0101000020E610000059A17899E60A54C0861D9ABBE7DF3940	0101000020BC0800004538CB7E90592C4102F69ED5B41E2141
1938	1623	SW 57 AV	SW 48 ST	N	N	N	0	0	0	11/30/2016 13:3	25.72624	-80.28611	891188.275997709	506826.943103999	fdef5ad5-f1f8-443f-9db2-c8ff4ad07ed5	0101000020E6100000EC4BDDAF4F1254C081A4A0E8EAB93940	0101000020BC080000EEFDA9C066322B41CB73FB8B32EF1E41
1939	3127	SW 107 AV	SW 179 ST	N	N	N	1	1	1	11/17/2016 16:2	25.60279	-80.36469	865535.791878391	461826.478948511	933de95a-7e63-4a36-b268-696f1e610ee9	0101000020E6100000E155FF06571754C0697FC37C509A3940	0101000020BC080000EB877DC5FD692A4108AFFFA410301C41
1940	6169	NW 13 AV	NW 165 ST	N	N	N	1	0	1	10/17/2016 14:1	25.92428	-80.22143	912055.784154374	578928.851724297	ca16e28a-98bc-4def-8eaf-f6309ac285f7	0101000020E6100000BC619D002C0E54C0F6B120BA9DEC3940	0101000020BC080000575350C76DD52B4147079820E5AA2141
1941	3109	SW 107 AV	SW 93 ST	S	N	Y	1	1	1	10/27/2016 8:54	25.68296	-80.36805	864287.723515205	490962.003359318	e3cfd5bf-b06c-4078-add6-d6b66cc9fdc9	0101000020E6100000D098D7288E1754C057C6BA08D7AE3940	0101000020BC080000F8BD4CA23D602A418EAF82C54EF71D41
1942	1216	FIU UNIV CAMPUS	SW 107 AV-17 ST	T	N	Y	2	2	2	9/8/2016 13:16	25.75264	-80.36879	863924.256727133	516285.682043158	ed3f728d-4c6f-409b-b686-5fdf761053a3	0101000020E61000008112DB379A1754C09DFADF73ADC03940	0101000020BC080000D5603DB3665D2A416AA90183FD821F41
1943	4309	SW 88 St	113 Pl	W	F	N	1	1	0	10/3/2002	25.68671	-80.37817	860947.751201615	492306.964235418	d6e6d3c4-ac59-48d1-adbe-c15626ee529c	0101000020E6100000CB6798FF331854C0F06DA066CCAF3940	0101000020BC080000A5491BB025462A4132B4A09D520C1E41
1944	3317	SW 137 AV	SW 88 ST	N	N	N	2	0	1	11/29/2016 16:2	25.68413	-80.41635	848377.484377258	491313.374042064	b1cfeec5-0c88-4335-942d-317d0dfc6ab8	0101000020E6100000084B8F92A51A54C0B48A829423AF3940	0101000020BC080000F2DDCA25F1E32941AB213841CCFC1D41
1945	4963	NW 42 AV	NW 27 ST	N	N	N	1	0	0	9/23/2016 12:06	25.80003	-80.26422	898250.539152812	533688.625604764	cc74e7da-d412-47a3-a189-61dd191f07ee	0101000020E61000001BBE6BC7E81054C01AA26234CFCC3940	0101000020BC080000ACC6394893692B41DEEAF7A674492041
1946	2010	E 4 AV	E 25 ST	N	F	Y	1	0	0	10/3/2002	25.84517	-80.27416	894883.616075192	550075.787001371	db8ede81-9222-4c8d-9e72-7273cb5f89e4	0101000020E610000076C051EE8B1154C0F64AFB3C5DD83940	0101000020BC08000021CD246F454F2B414195ABFB7AC92041
1947	3350	SW 147 AV	SW 176 TE	S	N	N	0	1	0	11/29/2016 12:4	25.60351	-80.42992	844036.576379783	461991.889051221	770bc077-65d5-4e4b-84d1-aceb2d9378e3	0101000020E61000000C951BCE831B54C04E1A73EF7F9A3940	0101000020BC080000ACF76E5407C22941CBB3F048A6321C41
1948	3970	SW 137 AV	SW 42 ST	S	F	N	1	0	0	11/29/2016 14:0	25.72571	-80.41571	848521.089371327	506425.211287275	2ac0f918-0a10-4d05-b8dd-1bdc576ca663	0101000020E61000005BCB661A9B1A54C0C7A0344EC8B93940	0101000020BC0800004D57945B10E52941C6B0589EEBE81E41
1949	8357	MIAMI LAKES DR E	OP # 15000	NE	M	Y	1	0	1	10/10/2016 13:2	25.90948	-80.30613	884249.227577254	573393.151180103	8d2613b7-76d6-4058-b32f-f040dff4c053	0101000020E61000007FB3ED87971354C023343ECBD3E83940	0101000020BC080000F82BDCA630FC2A410A8037B9A57F2141
1950	10345	BUSWAY	SW 312 ST	S	F	N	1	1	0	10/10/2016 13:2	25.47679	-80.4699	831044.701409481	415882.887135774	8e46dd81-d096-478e-a4d6-c44116d90aac	0101000020E610000072F26AD6121E54C0BB0667680F7A3940	0101000020BC08000057F3D292875C2941B6CFC03A32621941
1951	8135	BEACOM BD	SW 2 TE	SW	N	N	0	0	0	10/3/2016 12:22	25.77004	-80.2336	908388.615315069	522846.881178409	a99d7e48-8abe-4d05-8d20-f41b31aee0ef	0101000020E6100000528FCA19F30E54C09D86E1F921C53940	0101000020BC0800006D009270C7B82B419AABC35082E91F41
1952	8897	NE 125 ST	NE 14 AV	NW	N	N	1	0	0	10/31/2016 11:3	25.89059	-80.17008	929012.682346158	566786.979629457	f8831c0c-fc9f-4f7a-af04-833653eecd94	0101000020E6100000BA29109AE20A54C0089B96D1FDE33940	0101000020BC0800000A978795E7592C4119D49B60094C2141
1953	4073	SW 24 ST	SW 102 AV	E	F	Y	1	1	1	9/8/2016 12:29	25.74692	-80.35925	867072.464320436	514219.297086231	fbc976d1-48a1-461c-976c-4690d8dc4662	0101000020E610000035DF5903FE1654C0363EBB2036BF3940	0101000020BC080000BA2FF01DFF752A410F694EF8B3621F41
1954	2418	W 60 ST	W 18 AV	W	N	Y	1	0	0	10/3/2016	25.87707	-80.31889	880112.015029319	561591.925422296	70107a4a-3862-4705-8bd3-30db7694434c	0101000020E6100000B5BF98C9681454C0055613E787E03940	0101000020BC080000CC606A39DEDB2A4157FE0B4473232141
1955	5020	NW 72 AV	NW 11 ST	S	F	N	0	1	0	11/4/2002	25.7809	-80.31262	882356.011559401	526648.401814856	73c4b701-ad15-40c1-9192-b15cd2a80a60	0101000020E61000004B597B13021454C0521BD24DE9C73940	0101000020BC080000890A193866ED2A41A0E77C3374122041
1956	649	NW 22 AV	OPA LOCKA BD	N	F	Y	1	0	1	10/31/2016 12:3	25.89852	-80.23541	907517.428073101	569538.426564194	423a3752-e372-4d66-b6ba-681764fc69f3	0101000020E610000044E7D3F3100F54C0E19A267405E63940	0101000020BC080000121A8310F9B12B419168AD4588612141
1957	3283	SW 132 AV	SW 276 TE	S	F	N	1	0	0	10/4/2016 12:09	25.51026	-80.40435	852618.956190377	428136.173322633	4ea22c27-3bf8-446f-a647-639bb0888c6b	0101000020E6100000765093AFE01954C0E5028E70A0823940	0101000020BC080000D2E4FA1714052A417EB42963A7211A41
1958	2956	US 1	SW # 17120	S	N	N	2	1	0	10/16/2002	25.61075	-80.34873	870778.379848558	464747.233300477	91d2e649-3717-4113-a792-e5c26b593e86	0101000020E6100000D7B0A1AF511654C0E282198C5A9C3940	0101000020BC08000001DC45F3F2922A410ABBFFA9B35D1C41
1959	7067	NW 7 AV	NW 32 ST	N	F	Y	1	0	1	9/21/2016 12:36	25.80667	-80.20732	916950.818993341	536209.247173756	9fcd8e3c-8020-4454-95c1-452ab6267d99	0101000020E61000004BD156DB440D54C06BAE0A1A82CE3940	0101000020BC0800002E94F5D9ABFB2B413C76A7E5255D2041
1960	6432	NW 175 ST	NW 39 AV	E	N	Y	1	0	1	10/26/2016 13:3	25.93285	-80.2652	897651.72441322	581962.906675845	91953515-2180-4f21-95bf-338a43d610ef	0101000020E6100000C4F58B25F91054C0F4EC8FC3CFEE3940	0101000020BC0800002396EBA6E5642B414111343D99C22141
1961	4915	NW 32 AV	NW 79 ST	N	F	Y	0	0	1	8/31/2016	25.84622	-80.24982	902887.767730732	550502.387567207	f91b7c7d-d5aa-4d3d-a959-db8431b7dc72	0101000020E61000005B785818FD0F54C0F4D6160DA2D83940	0101000020BC0800002D20E4BDCD8D2B417CF2562FD0CC2041
1962	3474	SW 112 ST	SW 108 CT	W	N	N	1	1	1	9/29/2016 13:33	25.66487	-80.37039	863548.05736547	484380.551285282	51a8322d-df25-4884-b9b2-a7bea914f5ce	0101000020E6100000F6EFB483B41754C0589598F634AA3940	0101000020BC0800008908304D765A2A418574F9F478901D41
1963	1442	96 ST	BAL BAY DR	W	N	Y	0	0	0	10/31/2016 11:1	25.88703	-80.12658	943324.060216498	565585.845234357	54ec1d31-b4ae-4242-96db-ba35cf231856	0101000020E6100000AC2A34D9190854C0DD48B48214E33940	0101000020BC08000016D2BF58B6C92C418693AD1BA7422141
1964	3531	SW 152 ST	SW 97 AV	E	N	Y	1	0	0	11/17/2016 16:1	25.62862	-80.35018	870270.340846002	471240.497216292	ea333f16-6278-40c6-b179-751f16a324e8	0101000020E6100000B5EF675C691654C0CBA694CEEDA03940	0101000020BC0800000C6121DFFA8E2A41094537BA28C31C41
1965	7573	SW 57 AV	SW 5 TR	N	N	Y	0	0	0	11/30/2016 15:0	25.76561	-80.28783	890543.75009165	521135.133286089	4ccb506e-6fbc-49c1-b83b-b11672e75e15	0101000020E6100000518EA8EA6B1254C0DFBFAC63FFC33940	0101000020BC080000164436B35D2D2B41D9FCA252C3CE1F41
1966	560	NW 199 ST	NW 47 AV	E	N	N	0	0	0	10/28/2016 12:3	25.95399	-80.2787	893172.595548224	589620.201679401	e1dd072c-7010-42e7-9076-79ef6a73e4fd	0101000020E6100000961FAC54D61154C09D6617DE38F43940	0101000020BC080000A20B4864E7412B416A352AD56BFE2141
1967	1682	ANASTASIA AV	TOLEDO ST	W	N	N	0	0	0	10/12/2016 13:3	25.74174	-80.27247	895647.498087682	512485.828062847	3eec4087-ff6b-4070-ae0a-ff0bd6e9d44e	0101000020E6100000BA12BC39701154C0AEAC19D9E2BD3940	0101000020BC080000D45DF4323D552B415BE5D6179E471F41
1968	2259	W 24 AV	W 56 ST	S	N	N	1	0	0	10/19/2016 16:3	25.8737	-80.3313	876039.429047115	560344.625060804	cde477f6-b228-4bff-91e3-fe8a75fbe03d	0101000020E61000006421F307341554C08473B9C8AADF3940	0101000020BC0800005A57F10C0DBC2A41EC7F1BAAB4192141
1969	5306	NW 6 ST	NW 132 AV	E	F	N	0	0	0	1/5/2017 11:02	25.77275	-80.40862	850780.564195864	523533.635414518	49c8bf64-3482-4f2a-84ad-0b0872e81bff	0101000020E61000003AE99DD7261A54C01314FF50D3C53940	0101000020BC0800002DEFFE4EB7F62941C59F4D553DF41F41
1970	5064	NW 103 ST	NW 30 CT	E	N	Y	1	0	1	10/14/2016 13:2	25.86782	-80.24748	903612.403403532	558358.422022142	93e9cc92-7fe5-4c90-a6fd-bdb6780e4dc5	0101000020E61000001DB8ABC1D60F54C02A4895C229DE3940	0101000020BC08000073C9680377932B414028E941300A2141
1971	3905	SW 122 AV	SW 20 TE	S	N	Y	1	0	0	9/28/2016 11:59	25.74967	-80.39046	856794.979338162	515173.380452141	68e24d21-c18e-4514-8bdf-59d60c924b9c	0101000020E610000082376C57FD1854C0CEA713F1EABF3940	0101000020BC08000037903C24B4252A4133D0DC4D9C711F41
1972	9138	SW 57 AV	SW 94 ST	S	N	N	1	0	0	12/1/2016 16:07	25.68369	-80.28469	891740.506204009	491365.043527849	342699b7-19f9-42f1-b01b-fa681fbf3c7a	0101000020E6100000EF175D5F381254C021DB727B06AF3940	0101000020BC08000073EC8736B7362B41CEA8C1EE9AFD1D41
1973	589	NW 36 ST	NW 87 AV	W	F	N	1	0	0	11/8/2016 15:18	25.8103	-80.33887	873664.882608201	537291.018605828	7308eece-de0f-41c8-890c-814ed190d846	0101000020E610000001729C1FB01554C06DFE664270CF3940	0101000020BC080000A6EBD5F47FA92A410817A07099652041
1974	4401	SW 57 AV	SW 80 ST	N	N	N	2	0	0	11/30/2016 11:3	25.6967	-80.28504	891598.343108114	496092.272607088	928219c5-96b0-4d87-8d2d-6a40e0a28928	0101000020E610000097B3252C3E1254C0F9358AF95AB23940	0101000020BC080000D4B713E39A352B4150D695DA77471E41
1975	460	SW 107 AV	SW 24 ST	N	N	Y	2	0	1	10/27/2016 19:1	25.7463	-80.3676	864325.351761062	513982.143648215	5edc0cd0-1940-4db8-b5d8-7decd33df3f4	0101000020E61000006E039ACD861754C0A058F6C10DBF3940	0101000020BC0800008071F7E388602A4172BB235BFF5E1F41
1976	1809	NW 41 ST	OP # 9405	E	N	N	2	0	2	11/8/2016 11:40	25.81149	-80.35001	869996.819077428	537704.910501808	61d7fe7c-3f08-4219-b252-8432ef1e9afb	0101000020E6100000A69EC0B0661654C0171D842EBECF3940	0101000020BC0800007B8EEFD3D78C2A41FED04A39D5682041
1977	4685	KINGS CREEK DR	SW 84 AV	SW	N	N	0	0	1	10/31/2016 10:4	25.69437	-80.33024	876717.425396755	495168.149799384	794400af-497a-468c-8849-7a22cbce2f11	0101000020E6100000DDE920C3221554C049A02968C2B13940	0101000020BC0800009122560B59C12A41A784B45C07391E41
1978	8457	NW 2 AV	NW 91 ST	S	N	N	0	0	0	11/4/2016 14:21	25.85862	-80.20145	918771.335337963	555105.353104174	ee91665a-a16c-4fe8-86f0-561ff1a153be	0101000020E610000054D7717CE40C54C0079F4917CFDB3940	0101000020BC080000BEEA83E2E4092C4187D1471EC6F02041
1979	8970	NW 27 AV	WILMINGTON ST	S	N	Y	0	0	1	11/10/2016 14:0	25.90171	-80.24389	904721.296511307	570682.454129703	95e1f512-cdf2-42c3-baa3-902f71b8e36f	0101000020E6100000555683F89B0F54C0C86B09A5D6E63940	0101000020BC080000B343B2CC209C2B41B8E2F653786A2141
1980	6558	NW 199 ST	NW 34 CT	E	N	N	1	1	1	10/28/2016 13:0	25.95479	-80.25929	899550.279329248	589948.055683509	93bbcd50-c57c-4b55-a4b3-9c3003d3605e	0101000020E6100000838B6D40981054C01E83FB8E6DF43940	0101000020BC0800006FDE2DC3BA732B416EB1698AFB002241
1981	8938	NE 135 ST	NE 17 AV	W	F	N	0	0	0	11/14/2002	25.90047	-80.16387	931032.47094373	570391.803136669	285d1aa8-30eb-4d9e-9aeb-2e37b1562882	0101000020E6100000E53ED8CE7C0A54C06A8B177285E63940	0101000020BC080000212B8A29AF692C419EC0B50633682141
1982	5577	NW 27 AV	NW 116 ST	N	F	Y	1	0	1	9/19/2016 11:37	25.88026	-80.24278	905130.207436018	562888.124953032	e3f422b3-58ed-4f2c-a7af-1cf3f2826ec8	0101000020E6100000EAF169D5890F54C068A4A9E558E13940	0101000020BC080000DD6A309F529F2B4116D877AA932D2141
1983	10006	OAK LN	MONTROSE RD	W	N	N	1	0	0	10/19/2016 15:2	25.90903	-80.33278	875487.46719164	573186.29163152	3b586d93-aa02-40f0-92ec-d5143214457f	0101000020E6100000048386474C1554C0C4AC22B2B6E83940	0101000020BC0800008C434E20BDB72A41E3B91201087E2141
1984	1370	E COUNTRY CLUB DR	THE YACHT CLUB	N	F	N	1	0	1	11/3/2016 14:29	25.95839	-80.13006	942005.057596374	591518.543411896	3af9e622-6a94-4416-8916-204a1b7544ee	0101000020E6100000A6B2F2FE520854C01098959E59F53940	0101000020BC080000BF2E325768BF2C411DE98884400D2241
1985	2305	E 9 ST	E 11 AV	W	F	N	1	0	0	10/18/2016 15:2	25.83077	-80.25974	899656.749563687	544870.511370391	c9059025-338a-4a5a-8b4d-c2f4cc9d851d	0101000020E6100000C5C0DA9F9F1054C06610B1E9ADD43940	0101000020BC080000EBE10BB48F742B418592E76DD0A02041
1986	10543	NW 2 AV	NW 28 ST	\N	\N	\N	\N	\N	\N	 	25.80313	-80.19908	919669.659352727	534938.620797329	893b7122-74b3-4b50-a801-7d935b668ba2	0101000020E6100000704C44DABD0C54C0D3A9E7099ACD3940	0101000020BC080000B4407F88E9102C410EE8BEA438532041
1987	3705	OLD CUTLER RD	SW 112 AV	SE	F	N	1	1	1	10/4/2016 14:13	25.56233	-80.37167	863308.073599968	447110.041170232	1b107f83-4b9f-4faa-af45-c03e52da76d9	0101000020E61000007AE07D3DC91754C0B990A6D5F48F3940	0101000020BC0800003A67905596582A416A85B8E01E4A1B41
1988	3060	FRANJO RD	FLAG DR	S	F	Y	1	1	1	11/15/2016 13:2	25.58906	-80.34481	872110.780383736	456868.547922269	e64f8ccb-cb0c-48f5-a0ce-0ed7eddeeb03	0101000020E61000008614FC60111654C014384FBECC963940	0101000020BC080000463674C05B9D2A41532B42EA98E21B41
1989	6323	NW 37 AV	NW 187 ST	S	F	Y	1	0	1	11/10/2016 13:5	25.94382	-80.26163	898803.531133253	585956.061065301	9db3b695-9f27-47a9-b529-b19fb61c34ea	0101000020E610000098D94B9BBE1054C025D61A909EF13940	0101000020BC0800002CB20444E56D2B413C7FCA8CCBE12141
1990	2461	NW 103 ST	NW 80 CT	W	N	N	1	0	0	10/14/2016 16:0	25.86917	-80.32921	876734.058241386	558705.265841603	f4aad8aa-ba0c-4e99-9b52-373e0868b8a0	0101000020E610000084B96FD6111554C08264B48F82DE3940	0101000020BC0800004D37234F7AC12A410F0002F2E50C2141
1991	4303	SW 88 ST	SW 103 AV	W	N	N	1	0	0	10/3/2002	25.68729	-80.36001	866926.67691578	492548.491301239	4a6431fd-f5ac-4c25-be22-d9fdec57639a	0101000020E610000002AD677F0A1754C062E615CEF2AF3940	0101000020BC0800009F5BCB8ADB742A4153486FB918101E41
1992	3658	SW 200 ST	SW 114 AV	W	N	N	1	1	1	11/17/2016 17:3	25.58101	-80.3764	861711.23326695	453891.867522091	2e145219-e655-4797-9c4e-f280089aaf78	0101000020E61000004F06DC03171854C0CD46200CBD943940	0101000020BC080000B22E0DA71C4C2A41295CCA3016B41B41
1993	2789	ALTON RD	N MICHIGAN AV	NE	F	N	0	0	0	8/22/2002	25.79672	-80.1394	939325.572464462	532734.556266569	401bc3ee-5595-4a4d-84db-75b99bc350cb	0101000020E610000003DA36CFEB0854C0CEFCD347F6CB3940	0101000020BC080000B143995E79AA2C410749708300422041
1994	144	NW 17 AV	NW 79 ST	N	N	Y	1	0	1	8/18/2016	25.84615	-80.22527	910961.63084159	550523.422975734	511a2855-a719-4e8d-9606-47da42304fdd	0101000020E610000085128AE66A0E54C017B4E7659DD83940	0101000020BC080000F575D378E1CC2B41C8A27641FACC2041
1995	10535	NW 7 AVE	NW 62 ST	S	T	Y	1	1	1	9/20/2016 13:13	25.83114	-80.20773	916763.342665184	545103.234629408	26495197-6c16-4643-87c4-7b60cd43756b	0101000020E6100000565A6D864B0D54C0A0062DE6C5D43940	0101000020BC080000AE4BEFE534FA2B4187EF5CE0A1A22041
1996	530	MIAMI LAKES DR E	NW 60 AV	W	F	Y	1	0	0	11/8/2002	25.91053	-80.29978	886330.595769789	573785.867893636	a35eee5c-411b-4515-aa73-87ea022b0869	0101000020E61000000C686CB02F1354C070A1519B18E93940	0101000020BC080000DCEC9463730C2B41FD714428B7822141
1997	3290	SW 132 AV	SW 268 ST	N	N	N	0	0	2	2/17/2004	25.51784	-80.40431	852618.150383048	430893.67268189	028ff2f8-d5a3-428f-bddb-630ac198ed7c	0101000020E6100000B82DC61CE01954C0BA1B52A991843940	0101000020BC080000581D857B12052A41B3241F63BD4C1A41
1998	8501	HAMMOND DR	NW 41 ST	S	N	N	0	0	0	11/8/2016 14:22	25.81182	-80.30135	886005.009789359	537907.619104713	0395386c-e670-4a0f-ac7d-a098a42c1b39	0101000020E610000079B0AA6D491354C013E58FF0D3CF3940	0101000020BC08000065179937E8092B41834F23A46A6A2041
1999	5240	NW 46 ST	NW 22 AV	E	F	Y	1	1	1	8/18/2016	25.81675	-80.23196	908823.071778987	539826.013236269	69f84ac9-dbf5-4a6b-8939-989bcd822b03	0101000020E610000097F0D48AD80E54C0C99FBEE616D13940	0101000020BC080000B27C3B5A2CBC2B41D860546E67792041
2000	9894	SW 112 AV	SW 238 ST	N	F	N	1	1	1	10/4/2016 13:48	25.54654	-80.37199	863225.088843513	441372.870928317	a6cbb413-9a92-46e3-8822-1693b5737a4c	0101000020E6100000E58C63B6CE1754C0042EFE69EA8B3940	0101000020BC08000087C33F5DF0572A416E2ACD307AF01A41
\.


--
-- Name: mdc_bus_stops_objectid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mdc_bus_stops_objectid_seq', 2000, true);


--
-- Name: mdc_bus_stops mdc_bus_stops_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdc_bus_stops
    ADD CONSTRAINT mdc_bus_stops_pkey PRIMARY KEY (objectid);


--
-- Name: mdc_bus_stops_geom_geom_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mdc_bus_stops_geom_geom_idx ON public.mdc_bus_stops USING gist (geom);


--
-- Name: mdc_bus_stops_geom_local_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mdc_bus_stops_geom_local_idx ON public.mdc_bus_stops USING gist (geom_local);


--
-- PostgreSQL database dump complete
--

